/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebeaninternal.server.deploy.BeanSqlSelect;

public class BeanSqlSelectFactory {
    public static BeanSqlSelect create(String sql) {
        sql = BeanSqlSelectFactory.trim(sql);
        BeanSqlSelect.PredicatesType predicatesType = BeanSqlSelectFactory.determinePredicatesType(sql);
        boolean hasOrderBy = BeanSqlSelectFactory.determineHasOrderBy(sql);
        return new BeanSqlSelect(sql, predicatesType, hasOrderBy);
    }

    private static boolean determineHasOrderBy(String sql) {
        return sql.indexOf("${ORDER_BY}") > 0;
    }

    private static BeanSqlSelect.PredicatesType determinePredicatesType(String sql) {
        if (sql.indexOf("${HAVING_PREDICATES}") > 0) {
            return BeanSqlSelect.PredicatesType.HAVING;
        }
        if (sql.indexOf("${WHERE_PREDICATES}") > 0) {
            return BeanSqlSelect.PredicatesType.WHERE;
        }
        if (sql.indexOf("${AND_PREDICATES}") > 0) {
            return BeanSqlSelect.PredicatesType.AND;
        }
        return BeanSqlSelect.PredicatesType.NONE;
    }

    private static String trim(String sql) {
        boolean removeWhitespace = false;
        int length = sql.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = sql.charAt(i);
            if (removeWhitespace) {
                if (Character.isWhitespace(c)) continue;
                sb.append(c);
                removeWhitespace = false;
                continue;
            }
            if (c == '\r' || c == '\n') {
                sb.append('\n');
                removeWhitespace = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

