/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.util.StringUtil;

@Deprecated
public class DifficultyCommand
extends VanillaCommand {
    private static final List<String> DIFFICULTY_NAMES = ImmutableList.of((Object)"peaceful", (Object)"easy", (Object)"normal", (Object)"hard");

    public DifficultyCommand() {
        super("difficulty");
        this.description = "Sets the game difficulty";
        this.usageMessage = "/difficulty <new difficulty> ";
        this.setPermission("bukkit.command.difficulty");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length != 1 || args[0].length() == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        Difficulty difficulty = Difficulty.getByValue(this.getDifficultyForString(sender, args[0]));
        if (Bukkit.isHardcore()) {
            difficulty = Difficulty.HARD;
        }
        Bukkit.getWorlds().get(0).setDifficulty(difficulty);
        int levelCount = 1;
        if (Bukkit.getAllowNether()) {
            Bukkit.getWorlds().get(levelCount).setDifficulty(difficulty);
            ++levelCount;
        }
        if (Bukkit.getAllowEnd()) {
            Bukkit.getWorlds().get(levelCount).setDifficulty(difficulty);
        }
        Command.broadcastCommandMessage(sender, "Set difficulty to " + difficulty.toString());
        return true;
    }

    protected int getDifficultyForString(CommandSender sender, String name) {
        if (name.equalsIgnoreCase("peaceful") || name.equalsIgnoreCase("p")) {
            return 0;
        }
        if (name.equalsIgnoreCase("easy") || name.equalsIgnoreCase("e")) {
            return 1;
        }
        if (name.equalsIgnoreCase("normal") || name.equalsIgnoreCase("n")) {
            return 2;
        }
        if (name.equalsIgnoreCase("hard") || name.equalsIgnoreCase("h")) {
            return 3;
        }
        return this.getInteger(sender, name, 0, 3);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], DIFFICULTY_NAMES, new ArrayList(DIFFICULTY_NAMES.size()));
        }
        return ImmutableList.of();
    }
}

