/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.loadcontext;

import com.avaje.ebeaninternal.server.loadcontext.DLoadList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLoadHardList<T>
implements DLoadList<T> {
    private static final Logger logger = Logger.getLogger(DLoadHardList.class.getName());
    protected final ArrayList<T> list = new ArrayList();
    protected int removedFromTop;

    protected DLoadHardList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(T e) {
        DLoadHardList dLoadHardList = this;
        synchronized (dLoadHardList) {
            int i = this.list.size();
            this.list.add(e);
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(int position) {
        DLoadHardList dLoadHardList = this;
        synchronized (dLoadHardList) {
            T object = this.list.get(position);
            if (object == null) {
                logger.log(Level.WARNING, "removeEntry found no Object for position[" + position + "]");
            } else {
                this.list.set(position, null);
            }
            if (position == this.removedFromTop) {
                ++this.removedFromTop;
            }
        }
    }

    @Override
    public List<T> getNextBatch(int batchSize) {
        if (this.removedFromTop >= this.list.size()) {
            return new ArrayList(0);
        }
        return this.getLoadBatch(this.removedFromTop, batchSize, true);
    }

    @Override
    public List<T> getLoadBatch(int position, int batchSize) {
        return this.getLoadBatch(position, batchSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> getLoadBatch(int position, int batchSize, boolean ignoreMissing) {
        DLoadHardList dLoadHardList = this;
        synchronized (dLoadHardList) {
            int i;
            if (batchSize < 1) {
                throw new RuntimeException("batchSize " + batchSize + " < 1 ??!!");
            }
            ArrayList batch = new ArrayList();
            if (!this.addObjectToBatchAt(batch, position) && !ignoreMissing) {
                String msg = "getLoadBatch position[" + position + "] didn't find a bean in the list?";
                throw new IllegalStateException(msg);
            }
            for (i = position; i < this.list.size(); ++i) {
                this.addObjectToBatchAt(batch, i);
                if (batch.size() != batchSize) continue;
                return batch;
            }
            for (i = this.removedFromTop; i < position; ++i) {
                this.addObjectToBatchAt(batch, i);
                if (batch.size() != batchSize) continue;
                return batch;
            }
            return batch;
        }
    }

    private boolean addObjectToBatchAt(ArrayList<T> batch, int i) {
        boolean found = false;
        T object = this.list.get(i);
        if (object != null) {
            found = true;
            batch.add(object);
            this.list.set(i, null);
        }
        if (i == this.removedFromTop) {
            ++this.removedFromTop;
        }
        return found;
    }
}

