/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.ldap;

import com.avaje.ebeaninternal.api.SpiExpressionList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.DeployPropertyParser;
import com.avaje.ebeaninternal.server.ldap.LdapOrmQueryRequest;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import com.avaje.ebeaninternal.util.DefaultExpressionRequest;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapQueryDeployHelper {
    private final LdapOrmQueryRequest<?> request;
    private final SpiQuery<?> query;
    private final BeanDescriptor<?> desc;
    private String filterExpr;
    private Object[] filterValues;

    public LdapQueryDeployHelper(LdapOrmQueryRequest<?> request) {
        this.request = request;
        this.query = request.getQuery();
        this.desc = request.getBeanDescriptor();
        this.parse();
    }

    public String[] getSelectedProperties() {
        OrmQueryProperties chunk = this.query.getDetail().getChunk(null, false);
        if (chunk.allProperties()) {
            return null;
        }
        ArrayList<String> ldapSelectProps = new ArrayList<String>();
        Iterator<String> selectProperties = chunk.getSelectProperties();
        while (selectProperties.hasNext()) {
            String propName = selectProperties.next();
            BeanProperty p = this.desc.getBeanProperty(propName);
            if (p != null) {
                propName = p.getDbColumn();
            }
            ldapSelectProps.add(propName);
        }
        return ldapSelectProps.toArray(new String[ldapSelectProps.size()]);
    }

    private void parse() {
        SpiExpressionList<?> whereExp;
        DeployPropertyParser deployParser = this.desc.createDeployPropertyParser();
        String baseWhere = this.query.getAdditionalWhere();
        if (baseWhere != null) {
            baseWhere = deployParser.parse(baseWhere);
        }
        if ((whereExp = this.query.getWhereExpressions()) != null) {
            DefaultExpressionRequest expReq = new DefaultExpressionRequest(this.request, deployParser);
            ArrayList<Object> bindValues = whereExp.buildBindValues(expReq);
            this.filterValues = bindValues.toArray(new Object[bindValues.size()]);
            String exprWhere = whereExp.buildSql(expReq);
            this.filterExpr = baseWhere != null ? "(&" + baseWhere + exprWhere + ")" : exprWhere;
        } else {
            this.filterExpr = baseWhere;
        }
    }

    public String getFilterExpr() {
        return this.filterExpr;
    }

    public Object[] getFilterValues() {
        return this.filterValues;
    }
}

