/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.config.dbplatform.AbstractDbEncrypt;
import com.avaje.ebean.config.dbplatform.DbEncryptFunction;

public class PostgresDbEncrypt
extends AbstractDbEncrypt {
    public PostgresDbEncrypt() {
        this.varcharEncryptFunction = new PgVarcharFunction();
        this.dateEncryptFunction = new PgDateFunction();
    }

    private static class PgDateFunction
    implements DbEncryptFunction {
        private PgDateFunction() {
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return "to_date(pgp_sym_decrypt(" + columnWithTableAlias + ",?),'YYYYMMDD')";
        }

        public String getEncryptBindSql() {
            return "pgp_sym_encrypt(to_char(?::date,'YYYYMMDD'),?)";
        }
    }

    private static class PgVarcharFunction
    implements DbEncryptFunction {
        private PgVarcharFunction() {
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return "pgp_sym_decrypt(" + columnWithTableAlias + ",?)";
        }

        public String getEncryptBindSql() {
            return "pgp_sym_encrypt(?,?)";
        }
    }
}

