/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.block.banner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PatternType
extends OldEnum<PatternType>,
Keyed {
    public static final PatternType BASE = PatternType.getType("base");
    public static final PatternType SQUARE_BOTTOM_LEFT = PatternType.getType("square_bottom_left");
    public static final PatternType SQUARE_BOTTOM_RIGHT = PatternType.getType("square_bottom_right");
    public static final PatternType SQUARE_TOP_LEFT = PatternType.getType("square_top_left");
    public static final PatternType SQUARE_TOP_RIGHT = PatternType.getType("square_top_right");
    public static final PatternType STRIPE_BOTTOM = PatternType.getType("stripe_bottom");
    public static final PatternType STRIPE_TOP = PatternType.getType("stripe_top");
    public static final PatternType STRIPE_LEFT = PatternType.getType("stripe_left");
    public static final PatternType STRIPE_RIGHT = PatternType.getType("stripe_right");
    public static final PatternType STRIPE_CENTER = PatternType.getType("stripe_center");
    public static final PatternType STRIPE_MIDDLE = PatternType.getType("stripe_middle");
    public static final PatternType STRIPE_DOWNRIGHT = PatternType.getType("stripe_downright");
    public static final PatternType STRIPE_DOWNLEFT = PatternType.getType("stripe_downleft");
    public static final PatternType SMALL_STRIPES = PatternType.getType("small_stripes");
    public static final PatternType CROSS = PatternType.getType("cross");
    public static final PatternType STRAIGHT_CROSS = PatternType.getType("straight_cross");
    public static final PatternType TRIANGLE_BOTTOM = PatternType.getType("triangle_bottom");
    public static final PatternType TRIANGLE_TOP = PatternType.getType("triangle_top");
    public static final PatternType TRIANGLES_BOTTOM = PatternType.getType("triangles_bottom");
    public static final PatternType TRIANGLES_TOP = PatternType.getType("triangles_top");
    public static final PatternType DIAGONAL_LEFT = PatternType.getType("diagonal_left");
    public static final PatternType DIAGONAL_UP_RIGHT = PatternType.getType("diagonal_up_right");
    public static final PatternType DIAGONAL_UP_LEFT = PatternType.getType("diagonal_up_left");
    public static final PatternType DIAGONAL_RIGHT = PatternType.getType("diagonal_right");
    public static final PatternType CIRCLE = PatternType.getType("circle");
    public static final PatternType RHOMBUS = PatternType.getType("rhombus");
    public static final PatternType HALF_VERTICAL = PatternType.getType("half_vertical");
    public static final PatternType HALF_HORIZONTAL = PatternType.getType("half_horizontal");
    public static final PatternType HALF_VERTICAL_RIGHT = PatternType.getType("half_vertical_right");
    public static final PatternType HALF_HORIZONTAL_BOTTOM = PatternType.getType("half_horizontal_bottom");
    public static final PatternType BORDER = PatternType.getType("border");
    public static final PatternType CURLY_BORDER = PatternType.getType("curly_border");
    public static final PatternType CREEPER = PatternType.getType("creeper");
    public static final PatternType GRADIENT = PatternType.getType("gradient");
    public static final PatternType GRADIENT_UP = PatternType.getType("gradient_up");
    public static final PatternType BRICKS = PatternType.getType("bricks");
    public static final PatternType SKULL = PatternType.getType("skull");
    public static final PatternType FLOWER = PatternType.getType("flower");
    public static final PatternType MOJANG = PatternType.getType("mojang");
    public static final PatternType GLOBE = PatternType.getType("globe");
    public static final PatternType PIGLIN = PatternType.getType("piglin");
    public static final PatternType FLOW = PatternType.getType("flow");
    public static final PatternType GUSTER = PatternType.getType("guster");

    @Override
    @NotNull
    public NamespacedKey getKey();

    @Deprecated(forRemoval=true)
    @NotNull
    public String getIdentifier();

    @Deprecated(forRemoval=true)
    @Contract(value="null -> null")
    @Nullable
    public static PatternType getByIdentifier(@Nullable String identifier) {
        if (identifier == null) {
            return null;
        }
        for (PatternType type : Registry.BANNER_PATTERN) {
            if (!identifier.equals(type.getIdentifier())) continue;
            return type;
        }
        return null;
    }

    @NotNull
    private static PatternType getType(@NotNull String key) {
        return Registry.BANNER_PATTERN.getOrThrow(NamespacedKey.minecraft(key));
    }

    @Deprecated(since="1.21")
    @NotNull
    public static PatternType valueOf(@NotNull String name) {
        PatternType type = Registry.BANNER_PATTERN.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
        Preconditions.checkArgument(type != null, "No pattern type found with the name %s", (Object)name);
        return type;
    }

    @Deprecated(since="1.21")
    @NotNull
    public static PatternType[] values() {
        return Lists.newArrayList(Registry.BANNER_PATTERN).toArray(new PatternType[0]);
    }
}

