/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.loot.LootTables;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Registry<T extends Keyed>
extends Iterable<T> {
    public static final Registry<Advancement> ADVANCEMENT = new Registry<Advancement>(){

        @Override
        @Nullable
        public Advancement get(@NotNull NamespacedKey key) {
            return Bukkit.getAdvancement(key);
        }

        @Override
        @NotNull
        public Stream<Advancement> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        @NotNull
        public Iterator<Advancement> iterator() {
            return Bukkit.advancementIterator();
        }
    };
    public static final Registry<Art> ART = new SimpleRegistry<Art>(Art.class);
    public static final Registry<Attribute> ATTRIBUTE = new SimpleRegistry<Attribute>(Attribute.class);
    public static final Registry<PatternType> BANNER_PATTERN = new SimpleRegistry<PatternType>(PatternType.class);
    public static final Registry<Biome> BIOME = new SimpleRegistry<Biome>(Biome.class);
    public static final Registry<KeyedBossBar> BOSS_BARS = new Registry<KeyedBossBar>(){

        @Override
        @Nullable
        public KeyedBossBar get(@NotNull NamespacedKey key) {
            return Bukkit.getBossBar(key);
        }

        @Override
        @NotNull
        public Stream<KeyedBossBar> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        @NotNull
        public Iterator<KeyedBossBar> iterator() {
            return Bukkit.getBossBars();
        }
    };
    public static final Registry<Cat.Type> CAT_VARIANT = new SimpleRegistry<Cat.Type>(Cat.Type.class);
    public static final Registry<Enchantment> ENCHANTMENT = Objects.requireNonNull(Bukkit.getRegistry(Enchantment.class), "No registry present for Enchantment. This is a bug.");
    public static final Registry<EntityType> ENTITY_TYPE = new SimpleRegistry<EntityType>(EntityType.class, entity -> entity != EntityType.UNKNOWN);
    public static final Registry<MusicInstrument> INSTRUMENT = Objects.requireNonNull(Bukkit.getRegistry(MusicInstrument.class), "No registry present for MusicInstrument. This is a bug.");
    public static final Registry<LootTables> LOOT_TABLES = new SimpleRegistry<LootTables>(LootTables.class);
    public static final Registry<Material> MATERIAL = new SimpleRegistry<Material>(Material.class, mat -> !mat.isLegacy());
    public static final Registry<PotionEffectType> EFFECT = Objects.requireNonNull(Bukkit.getRegistry(PotionEffectType.class), "No registry present for PotionEffectType. This is a bug.");
    public static final Registry<Particle> PARTICLE_TYPE = new SimpleRegistry<Particle>(Particle.class, par -> par.register);
    public static final Registry<PotionType> POTION = new SimpleRegistry<PotionType>(PotionType.class);
    public static final Registry<Statistic> STATISTIC = new SimpleRegistry<Statistic>(Statistic.class);
    public static final Registry<Structure> STRUCTURE = Bukkit.getRegistry(Structure.class);
    public static final Registry<StructureType> STRUCTURE_TYPE = Bukkit.getRegistry(StructureType.class);
    public static final Registry<Sound> SOUNDS = new SimpleRegistry<Sound>(Sound.class);
    @ApiStatus.Experimental
    public static final Registry<TrimMaterial> TRIM_MATERIAL = Bukkit.getRegistry(TrimMaterial.class);
    @ApiStatus.Experimental
    public static final Registry<TrimPattern> TRIM_PATTERN = Bukkit.getRegistry(TrimPattern.class);
    @ApiStatus.Experimental
    public static final Registry<DamageType> DAMAGE_TYPE = Objects.requireNonNull(Bukkit.getRegistry(DamageType.class), "No registry present for DamageType. This is a bug.");
    public static final Registry<Villager.Profession> VILLAGER_PROFESSION = new SimpleRegistry<Villager.Profession>(Villager.Profession.class);
    public static final Registry<Villager.Type> VILLAGER_TYPE = new SimpleRegistry<Villager.Type>(Villager.Type.class);
    public static final Registry<MemoryKey> MEMORY_MODULE_TYPE = new Registry<MemoryKey>(){

        @Override
        @NotNull
        public Iterator iterator() {
            return MemoryKey.values().iterator();
        }

        @Override
        @Nullable
        public MemoryKey get(@NotNull NamespacedKey key) {
            return MemoryKey.getByKey(key);
        }

        @Override
        @NotNull
        public Stream<MemoryKey> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    };
    public static final Registry<Fluid> FLUID = new SimpleRegistry<Fluid>(Fluid.class);
    public static final Registry<Frog.Variant> FROG_VARIANT = new SimpleRegistry<Frog.Variant>(Frog.Variant.class);
    public static final Registry<Wolf.Variant> WOLF_VARIANT = Objects.requireNonNull(Bukkit.getRegistry(Wolf.Variant.class), "No registry present for Wolf Variant. This is a bug.");
    @ApiStatus.Internal
    public static final Registry<MapCursor.Type> MAP_DECORATION_TYPE = new SimpleRegistry<MapCursor.Type>(MapCursor.Type.class);
    public static final Registry<GameEvent> GAME_EVENT = Objects.requireNonNull(Bukkit.getRegistry(GameEvent.class), "No registry present for GameEvent. This is a bug.");

    @Nullable
    public T get(@NotNull NamespacedKey var1);

    @NotNull
    public Stream<T> stream();

    @Nullable
    default public T match(@NotNull String input) {
        Preconditions.checkArgument(input != null, "input must not be null");
        String filtered = input.toLowerCase().replaceAll("\\s+", "_");
        NamespacedKey namespacedKey = NamespacedKey.fromString(filtered);
        return namespacedKey != null ? (T)this.get(namespacedKey) : null;
    }

    public static final class SimpleRegistry<T extends Enum<T>>
    implements Registry<T> {
        private final Map<NamespacedKey, T> map;

        protected SimpleRegistry(@NotNull Class<T> type) {
            this(type, Predicates.alwaysTrue());
        }

        protected SimpleRegistry(@NotNull Class<T> type, @NotNull Predicate<T> predicate) {
            ImmutableMap.Builder<NamespacedKey, Enum> builder = ImmutableMap.builder();
            Enum[] enumArray = (Enum[])type.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum entry = enumArray[n2];
                if (predicate.test(entry)) {
                    builder.put(((Keyed)((Object)entry)).getKey(), entry);
                }
                ++n2;
            }
            this.map = builder.build();
        }

        @Override
        @Nullable
        public T get(@NotNull NamespacedKey key) {
            return (T)((Enum)this.map.get(key));
        }

        @Override
        @NotNull
        public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.map.values().iterator();
        }
    }
}

