/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GameEvent
implements Keyed {
    private static final Map<NamespacedKey, GameEvent> GAME_EVENTS = new HashMap<NamespacedKey, GameEvent>();
    public static final GameEvent BLOCK_ACTIVATE = GameEvent.getEvent("block_activate");
    public static final GameEvent BLOCK_ATTACH = GameEvent.getEvent("block_attach");
    public static final GameEvent BLOCK_CHANGE = GameEvent.getEvent("block_change");
    public static final GameEvent BLOCK_CLOSE = GameEvent.getEvent("block_close");
    public static final GameEvent BLOCK_DEACTIVATE = GameEvent.getEvent("block_deactivate");
    public static final GameEvent BLOCK_DESTROY = GameEvent.getEvent("block_destroy");
    public static final GameEvent BLOCK_DETACH = GameEvent.getEvent("block_detach");
    public static final GameEvent BLOCK_OPEN = GameEvent.getEvent("block_open");
    public static final GameEvent BLOCK_PLACE = GameEvent.getEvent("block_place");
    @Deprecated
    public static final GameEvent BLOCK_PRESS = GameEvent.getEvent("block_activate");
    @Deprecated
    public static final GameEvent BLOCK_SWITCH = GameEvent.getEvent("block_activate");
    @Deprecated
    public static final GameEvent BLOCK_UNPRESS = GameEvent.getEvent("block_deactivate");
    @Deprecated
    public static final GameEvent BLOCK_UNSWITCH = GameEvent.getEvent("block_deactivate");
    public static final GameEvent CONTAINER_CLOSE = GameEvent.getEvent("container_close");
    public static final GameEvent CONTAINER_OPEN = GameEvent.getEvent("container_open");
    public static final GameEvent DISPENSE_FAIL = GameEvent.getEvent("dispense_fail");
    public static final GameEvent DRINK = GameEvent.getEvent("drink");
    @Deprecated
    public static final GameEvent DRINKING_FINISH = GameEvent.getEvent("drink");
    public static final GameEvent EAT = GameEvent.getEvent("eat");
    @Deprecated
    public static final GameEvent ELYTRA_FREE_FALL = GameEvent.getEvent("elytra_glide");
    public static final GameEvent ELYTRA_GLIDE = GameEvent.getEvent("elytra_glide");
    public static final GameEvent ENTITY_DAMAGE = GameEvent.getEvent("entity_damage");
    @Deprecated
    public static final GameEvent ENTITY_DAMAGED = GameEvent.getEvent("entity_damage");
    public static final GameEvent ENTITY_DIE = GameEvent.getEvent("entity_die");
    @Deprecated
    public static final GameEvent ENTITY_DYING = GameEvent.getEvent("entity_die");
    public static final GameEvent ENTITY_INTERACT = GameEvent.getEvent("entity_interact");
    @Deprecated
    public static final GameEvent ENTITY_KILLED = GameEvent.getEvent("entity_die");
    public static final GameEvent ENTITY_PLACE = GameEvent.getEvent("entity_place");
    public static final GameEvent ENTITY_ROAR = GameEvent.getEvent("entity_roar");
    public static final GameEvent ENTITY_SHAKE = GameEvent.getEvent("entity_shake");
    public static final GameEvent EQUIP = GameEvent.getEvent("equip");
    public static final GameEvent EXPLODE = GameEvent.getEvent("explode");
    public static final GameEvent FLAP = GameEvent.getEvent("flap");
    public static final GameEvent FLUID_PICKUP = GameEvent.getEvent("fluid_pickup");
    public static final GameEvent FLUID_PLACE = GameEvent.getEvent("fluid_place");
    public static final GameEvent HIT_GROUND = GameEvent.getEvent("hit_ground");
    public static final GameEvent INSTRUMENT_PLAY = GameEvent.getEvent("instrument_play");
    public static final GameEvent ITEM_INTERACT_FINISH = GameEvent.getEvent("item_interact_finish");
    public static final GameEvent ITEM_INTERACT_START = GameEvent.getEvent("item_interact_start");
    public static final GameEvent LIGHTNING_STRIKE = GameEvent.getEvent("lightning_strike");
    @Deprecated
    public static final GameEvent MOB_INTERACT = GameEvent.getEvent("entity_interact");
    public static final GameEvent NOTE_BLOCK_PLAY = GameEvent.getEvent("note_block_play");
    public static final GameEvent PISTON_CONTRACT = GameEvent.getEvent("piston_contract");
    public static final GameEvent PISTON_EXTEND = GameEvent.getEvent("piston_extend");
    public static final GameEvent PRIME_FUSE = GameEvent.getEvent("prime_fuse");
    public static final GameEvent PROJECTILE_LAND = GameEvent.getEvent("projectile_land");
    public static final GameEvent PROJECTILE_SHOOT = GameEvent.getEvent("projectile_shoot");
    @Deprecated
    public static final GameEvent RAVAGER_ROAR = GameEvent.getEvent("entity_roar");
    @Deprecated
    public static final GameEvent RING_BELL = GameEvent.getEvent("block_change");
    public static final GameEvent SCULK_SENSOR_TENDRILS_CLICKING = GameEvent.getEvent("sculk_sensor_tendrils_clicking");
    public static final GameEvent SHEAR = GameEvent.getEvent("shear");
    public static final GameEvent SHRIEK = GameEvent.getEvent("shriek");
    @Deprecated
    public static final GameEvent SHULKER_CLOSE = GameEvent.getEvent("container_close");
    @Deprecated
    public static final GameEvent SHULKER_OPEN = GameEvent.getEvent("container_open");
    public static final GameEvent SPLASH = GameEvent.getEvent("splash");
    public static final GameEvent STEP = GameEvent.getEvent("step");
    public static final GameEvent SWIM = GameEvent.getEvent("swim");
    public static final GameEvent TELEPORT = GameEvent.getEvent("teleport");
    @Deprecated
    public static final GameEvent WOLF_SHAKING = GameEvent.getEvent("entity_shake");
    private final NamespacedKey key;

    private GameEvent(NamespacedKey key) {
        this.key = key;
        GAME_EVENTS.put(key, this);
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Nullable
    public static GameEvent getByKey(@NotNull NamespacedKey namespacedKey) {
        return GAME_EVENTS.get(namespacedKey);
    }

    @NotNull
    public static Collection<GameEvent> values() {
        return Collections.unmodifiableCollection(GAME_EVENTS.values());
    }

    private static GameEvent getEvent(String vanilla) {
        return new GameEvent(NamespacedKey.minecraft(vanilla));
    }
}

