/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

final class PluginClassLoader
extends URLClassLoader {
    private final JavaPluginLoader loader;
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    final JavaPlugin plugin;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;

    static {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
            if (method != null) {
                boolean oldAccessible = method.isAccessible();
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
                method.setAccessible(oldAccessible);
                Bukkit.getLogger().log(Level.INFO, "Set PluginClassLoader as parallel capable");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.WARNING, "Error setting PluginClassLoader as parallel capable", ex);
        }
    }

    PluginClassLoader(JavaPluginLoader loader, ClassLoader parent, PluginDescriptionFile description, File dataFolder, File file) throws IOException, InvalidPluginException, MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Validate.notNull(loader, "Loader cannot be null");
        this.loader = loader;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        this.jar = new JarFile(file);
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        try {
            Class<JavaPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", ex);
            }
            try {
                pluginClass = jarClass.asSubclass(JavaPlugin.class);
            }
            catch (ClassCastException ex) {
                throw new InvalidPluginException("main class `" + description.getMain() + "' does not extend JavaPlugin", ex);
            }
            this.plugin = pluginClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPluginException("No public constructor", ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidPluginException("Abnormal plugin type", ex);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (name.startsWith("org.bukkit.") || name.startsWith("net.minecraft.")) {
            throw new ClassNotFoundException(name);
        }
        Class<?> result = this.classes.get(name);
        if (result == null) {
            if (checkGlobal) {
                result = this.loader.getClassByName(name);
            }
            if (result == null) {
                String path = name.replace('.', '/').concat(".class");
                JarEntry entry = this.jar.getJarEntry(path);
                if (entry != null) {
                    byte[] classBytes;
                    block24: {
                        String pkgName;
                        try {
                            Throwable throwable = null;
                            Object var8_10 = null;
                            try (InputStream is = this.jar.getInputStream(entry);){
                                classBytes = ByteStreams.toByteArray(is);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException ex) {
                            throw new ClassNotFoundException(name, ex);
                        }
                        classBytes = this.loader.server.getUnsafe().processClass(this.description, path, classBytes);
                        int dot = name.lastIndexOf(46);
                        if (dot != -1 && this.getPackage(pkgName = name.substring(0, dot)) == null) {
                            try {
                                if (this.manifest != null) {
                                    this.definePackage(pkgName, this.manifest, this.url);
                                } else {
                                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (this.getPackage(pkgName) != null) break block24;
                                throw new IllegalStateException("Cannot find package " + pkgName);
                            }
                        }
                    }
                    CodeSigner[] signers = entry.getCodeSigners();
                    CodeSource source = new CodeSource(this.url, signers);
                    result = this.defineClass(name, classBytes, 0, classBytes.length, source);
                }
                if (result == null) {
                    result = super.findClass(name);
                }
                if (result != null) {
                    this.loader.setClass(name, result);
                }
            }
            this.classes.put(name, result);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    Set<String> getClasses() {
        return this.classes.keySet();
    }

    synchronized void initialize(JavaPlugin javaPlugin) {
        Validate.notNull(javaPlugin, "Initializing plugin cannot be null");
        Validate.isTrue(javaPlugin.getClass().getClassLoader() == this, "Cannot initialize plugin outside of this class loader");
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(this.loader, this.loader.server, this.description, this.dataFolder, this.file, this);
    }
}

