/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.material.MaterialData;

public class ShapedRecipe
implements Recipe {
    private ItemStack output;
    private String[] rows;
    private Map<Character, ItemStack> ingredients = new HashMap<Character, ItemStack>();

    public ShapedRecipe(ItemStack result) {
        this.output = new ItemStack(result);
    }

    public ShapedRecipe shape(String ... shape) {
        Validate.notNull(shape, "Must provide a shape");
        Validate.isTrue(shape.length > 0 && shape.length < 4, "Crafting recipes should be 1, 2, 3 rows, not ", shape.length);
        int lastLen = -1;
        String[] stringArray = shape;
        int n = shape.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            Validate.notNull(row, "Shape cannot have null rows");
            Validate.isTrue(row.length() > 0 && row.length() < 4, "Crafting rows should be 1, 2, or 3 characters, not ", row.length());
            Validate.isTrue(lastLen == -1 || lastLen == row.length(), "Crafting recipes must be rectangular");
            lastLen = row.length();
            ++n2;
        }
        this.rows = new String[shape.length];
        int i = 0;
        while (i < shape.length) {
            this.rows[i] = shape[i];
            ++i;
        }
        HashMap<Character, ItemStack> newIngredients = new HashMap<Character, ItemStack>();
        String[] stringArray2 = shape;
        int n3 = shape.length;
        n = 0;
        while (n < n3) {
            String row = stringArray2[n];
            char[] cArray = row.toCharArray();
            int n4 = cArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Character c = Character.valueOf(cArray[n5]);
                newIngredients.put(c, this.ingredients.get(c));
                ++n5;
            }
            ++n;
        }
        this.ingredients = newIngredients;
        return this;
    }

    public ShapedRecipe setIngredient(char key, MaterialData ingredient) {
        return this.setIngredient(key, ingredient.getItemType(), ingredient.getData());
    }

    public ShapedRecipe setIngredient(char key, Material ingredient) {
        return this.setIngredient(key, ingredient, 0);
    }

    @Deprecated
    public ShapedRecipe setIngredient(char key, Material ingredient, int raw) {
        Validate.isTrue(this.ingredients.containsKey(Character.valueOf(key)), "Symbol does not appear in the shape:", key);
        if (raw == -1) {
            raw = Short.MAX_VALUE;
        }
        this.ingredients.put(Character.valueOf(key), new ItemStack(ingredient, 1, (short)raw));
        return this;
    }

    public Map<Character, ItemStack> getIngredientMap() {
        HashMap<Character, ItemStack> result = new HashMap<Character, ItemStack>();
        for (Map.Entry<Character, ItemStack> ingredient : this.ingredients.entrySet()) {
            if (ingredient.getValue() == null) {
                result.put(ingredient.getKey(), null);
                continue;
            }
            result.put(ingredient.getKey(), ingredient.getValue().clone());
        }
        return result;
    }

    public String[] getShape() {
        return (String[])this.rows.clone();
    }

    @Override
    public ItemStack getResult() {
        return this.output.clone();
    }
}

