/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;

@Deprecated
public class BanIpCommand
extends VanillaCommand {
    public static final Pattern ipValidity = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    public BanIpCommand() {
        super("ban-ip");
        this.description = "Prevents the specified IP address from using this server";
        this.usageMessage = "/ban-ip <address|player> [reason ...]";
        this.setPermission("bukkit.command.ban.ip");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        String reason;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        String string = reason = args.length > 0 ? StringUtils.join((Object[])args, (char)' ', (int)1, (int)args.length) : null;
        if (ipValidity.matcher(args[0]).matches()) {
            this.processIPBan(args[0], sender, reason);
        } else {
            Player player = Bukkit.getPlayer(args[0]);
            if (player == null) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
            this.processIPBan(player.getAddress().getAddress().getHostAddress(), sender, reason);
        }
        return true;
    }

    private void processIPBan(String ip, CommandSender sender, String reason) {
        Bukkit.getBanList(BanList.Type.IP).addBan(ip, reason, null, sender.getName());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getAddress().getAddress().getHostAddress().equals(ip)) continue;
            player.kickPlayer("You have been IP banned.");
        }
        Command.broadcastCommandMessage(sender, "Banned IP Address " + ip);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return super.tabComplete(sender, alias, args);
        }
        return ImmutableList.of();
    }
}

