/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.util.NumberConversions;

public class EntityDamageEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private static final DamageModifier[] MODIFIERS = DamageModifier.values();
    private static final Function<? super Double, Double> ZERO = Functions.constant(-0.0);
    private final Map<DamageModifier, Double> modifiers;
    private final Map<DamageModifier, ? extends Function<? super Double, Double>> modifierFunctions;
    private final Map<DamageModifier, Double> originals;
    private boolean cancelled;
    private final DamageCause cause;

    @Deprecated
    public EntityDamageEvent(Entity damagee, DamageCause cause, double damage) {
        this(damagee, cause, new EnumMap<DamageModifier, Double>(ImmutableMap.of(DamageModifier.BASE, damage)), new EnumMap<DamageModifier, Function<? super Double, Double>>(ImmutableMap.of(DamageModifier.BASE, ZERO)));
    }

    public EntityDamageEvent(Entity damagee, DamageCause cause, Map<DamageModifier, Double> modifiers, Map<DamageModifier, ? extends Function<? super Double, Double>> modifierFunctions) {
        super(damagee);
        Validate.isTrue(modifiers.containsKey((Object)DamageModifier.BASE), "BASE DamageModifier missing");
        Validate.isTrue(!modifiers.containsKey(null), "Cannot have null DamageModifier");
        Validate.noNullElements(modifiers.values(), "Cannot have null modifier values");
        Validate.isTrue(modifiers.keySet().equals(modifierFunctions.keySet()), "Must have a modifier function for each DamageModifier");
        Validate.noNullElements(modifierFunctions.values(), "Cannot have null modifier function");
        this.originals = new EnumMap<DamageModifier, Double>(modifiers);
        this.cause = cause;
        this.modifiers = modifiers;
        this.modifierFunctions = modifierFunctions;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public double getOriginalDamage(DamageModifier type) throws IllegalArgumentException {
        Double damage = this.originals.get((Object)type);
        if (damage != null) {
            return damage;
        }
        if (type == null) {
            throw new IllegalArgumentException("Cannot have null DamageModifier");
        }
        return 0.0;
    }

    public void setDamage(DamageModifier type, double damage) throws IllegalArgumentException, UnsupportedOperationException {
        if (!this.modifiers.containsKey((Object)type)) {
            throw type == null ? new IllegalArgumentException("Cannot have null DamageModifier") : new UnsupportedOperationException((Object)((Object)type) + " is not applicable to " + this.getEntity());
        }
        this.modifiers.put(type, damage);
    }

    public double getDamage(DamageModifier type) throws IllegalArgumentException {
        Validate.notNull((Object)type, "Cannot have null DamageModifier");
        Double damage = this.modifiers.get((Object)type);
        return damage == null ? 0.0 : damage;
    }

    public boolean isApplicable(DamageModifier type) throws IllegalArgumentException {
        Validate.notNull((Object)type, "Cannot have null DamageModifier");
        return this.modifiers.containsKey((Object)type);
    }

    public double getDamage() {
        return this.getDamage(DamageModifier.BASE);
    }

    public final double getFinalDamage() {
        double damage = 0.0;
        DamageModifier[] damageModifierArray = MODIFIERS;
        int n = MODIFIERS.length;
        int n2 = 0;
        while (n2 < n) {
            DamageModifier modifier = damageModifierArray[n2];
            damage += this.getDamage(modifier);
            ++n2;
        }
        return damage;
    }

    @Deprecated
    public int _INVALID_getDamage() {
        return NumberConversions.ceil(this.getDamage());
    }

    public void setDamage(double damage) {
        double remaining = damage;
        double oldRemaining = this.getDamage(DamageModifier.BASE);
        DamageModifier[] damageModifierArray = MODIFIERS;
        int n = MODIFIERS.length;
        int n2 = 0;
        while (n2 < n) {
            DamageModifier modifier = damageModifierArray[n2];
            if (this.isApplicable(modifier)) {
                Function<? super Double, Double> modifierFunction = this.modifierFunctions.get((Object)modifier);
                double newVanilla = modifierFunction.apply((Double)remaining);
                double oldVanilla = modifierFunction.apply((Double)oldRemaining);
                double difference = oldVanilla - newVanilla;
                double old = this.getDamage(modifier);
                if (old > 0.0) {
                    this.setDamage(modifier, Math.max(0.0, old - difference));
                } else {
                    this.setDamage(modifier, Math.min(0.0, old - difference));
                }
                remaining += newVanilla;
                oldRemaining += oldVanilla;
            }
            ++n2;
        }
        this.setDamage(DamageModifier.BASE, damage);
    }

    @Deprecated
    public void _INVALID_setDamage(int damage) {
        this.setDamage(damage);
    }

    public DamageCause getCause() {
        return this.cause;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum DamageCause {
        CONTACT,
        ENTITY_ATTACK,
        PROJECTILE,
        SUFFOCATION,
        FALL,
        FIRE,
        FIRE_TICK,
        MELTING,
        LAVA,
        DROWNING,
        BLOCK_EXPLOSION,
        ENTITY_EXPLOSION,
        VOID,
        LIGHTNING,
        SUICIDE,
        STARVATION,
        POISON,
        MAGIC,
        WITHER,
        FALLING_BLOCK,
        THORNS,
        DRAGON_BREATH,
        CUSTOM,
        FLY_INTO_WALL,
        HOT_FLOOR,
        CRAMMING;

    }

    public static enum DamageModifier {
        BASE,
        HARD_HAT,
        BLOCKING,
        ARMOR,
        RESISTANCE,
        MAGIC,
        ABSORPTION;

    }
}

