/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Map;

public enum WorldType {
    NORMAL("DEFAULT"),
    FLAT("FLAT"),
    VERSION_1_1("DEFAULT_1_1"),
    LARGE_BIOMES("LARGEBIOMES"),
    AMPLIFIED("AMPLIFIED"),
    CUSTOMIZED("CUSTOMIZED");

    private static final Map<String, WorldType> BY_NAME;
    private final String name;

    static {
        BY_NAME = Maps.newHashMap();
        WorldType[] worldTypeArray = WorldType.values();
        int n = worldTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorldType type = worldTypeArray[n2];
            BY_NAME.put(type.name, type);
            ++n2;
        }
    }

    private WorldType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static WorldType getByName(String name) {
        return BY_NAME.get(name.toUpperCase());
    }
}

