/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores.criteria;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.INamable;

public class IScoreboardCriteria {
    private static final Map<String, IScoreboardCriteria> CUSTOM_CRITERIA = Maps.newHashMap();
    public static final Map<String, IScoreboardCriteria> CRITERIA_CACHE = Maps.newHashMap();
    public static final Codec<IScoreboardCriteria> CODEC = Codec.STRING.comapFlatMap(var0 -> IScoreboardCriteria.byName(var0).map(DataResult::success).orElse(DataResult.error(() -> "No scoreboard criteria with name: " + var0)), IScoreboardCriteria::getName);
    public static final IScoreboardCriteria DUMMY = IScoreboardCriteria.registerCustom("dummy");
    public static final IScoreboardCriteria TRIGGER = IScoreboardCriteria.registerCustom("trigger");
    public static final IScoreboardCriteria DEATH_COUNT = IScoreboardCriteria.registerCustom("deathCount");
    public static final IScoreboardCriteria KILL_COUNT_PLAYERS = IScoreboardCriteria.registerCustom("playerKillCount");
    public static final IScoreboardCriteria KILL_COUNT_ALL = IScoreboardCriteria.registerCustom("totalKillCount");
    public static final IScoreboardCriteria HEALTH = IScoreboardCriteria.registerCustom("health", true, EnumScoreboardHealthDisplay.HEARTS);
    public static final IScoreboardCriteria FOOD = IScoreboardCriteria.registerCustom("food", true, EnumScoreboardHealthDisplay.INTEGER);
    public static final IScoreboardCriteria AIR = IScoreboardCriteria.registerCustom("air", true, EnumScoreboardHealthDisplay.INTEGER);
    public static final IScoreboardCriteria ARMOR = IScoreboardCriteria.registerCustom("armor", true, EnumScoreboardHealthDisplay.INTEGER);
    public static final IScoreboardCriteria EXPERIENCE = IScoreboardCriteria.registerCustom("xp", true, EnumScoreboardHealthDisplay.INTEGER);
    public static final IScoreboardCriteria LEVEL = IScoreboardCriteria.registerCustom("level", true, EnumScoreboardHealthDisplay.INTEGER);
    public static final IScoreboardCriteria[] TEAM_KILL = new IScoreboardCriteria[]{IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.BLACK.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.DARK_BLUE.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.DARK_GREEN.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.DARK_AQUA.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.DARK_RED.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.DARK_PURPLE.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.GOLD.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.GRAY.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.DARK_GRAY.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.BLUE.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.GREEN.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.AQUA.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.RED.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.LIGHT_PURPLE.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.YELLOW.getName()), IScoreboardCriteria.registerCustom("teamkill." + EnumChatFormat.WHITE.getName())};
    public static final IScoreboardCriteria[] KILLED_BY_TEAM = new IScoreboardCriteria[]{IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.BLACK.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.DARK_BLUE.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.DARK_GREEN.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.DARK_AQUA.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.DARK_RED.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.DARK_PURPLE.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.GOLD.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.GRAY.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.DARK_GRAY.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.BLUE.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.GREEN.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.AQUA.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.RED.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.LIGHT_PURPLE.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.YELLOW.getName()), IScoreboardCriteria.registerCustom("killedByTeam." + EnumChatFormat.WHITE.getName())};
    private final String name;
    private final boolean readOnly;
    private final EnumScoreboardHealthDisplay renderType;

    private static IScoreboardCriteria registerCustom(String var0, boolean var1, EnumScoreboardHealthDisplay var2) {
        IScoreboardCriteria var3 = new IScoreboardCriteria(var0, var1, var2);
        CUSTOM_CRITERIA.put(var0, var3);
        return var3;
    }

    private static IScoreboardCriteria registerCustom(String var0) {
        return IScoreboardCriteria.registerCustom(var0, false, EnumScoreboardHealthDisplay.INTEGER);
    }

    protected IScoreboardCriteria(String var0) {
        this(var0, false, EnumScoreboardHealthDisplay.INTEGER);
    }

    protected IScoreboardCriteria(String var0, boolean var1, EnumScoreboardHealthDisplay var2) {
        this.name = var0;
        this.readOnly = var1;
        this.renderType = var2;
        CRITERIA_CACHE.put(var0, this);
    }

    public static Set<String> getCustomCriteriaNames() {
        return ImmutableSet.copyOf(CUSTOM_CRITERIA.keySet());
    }

    public static Optional<IScoreboardCriteria> byName(String var0) {
        IScoreboardCriteria var1 = CRITERIA_CACHE.get(var0);
        if (var1 != null) {
            return Optional.of(var1);
        }
        int var22 = var0.indexOf(58);
        if (var22 < 0) {
            return Optional.empty();
        }
        return BuiltInRegistries.STAT_TYPE.getOptional(MinecraftKey.bySeparator(var0.substring(0, var22), '.')).flatMap(var2 -> IScoreboardCriteria.getStat(var2, MinecraftKey.bySeparator(var0.substring(var22 + 1), '.')));
    }

    private static <T> Optional<IScoreboardCriteria> getStat(StatisticWrapper<T> var0, MinecraftKey var1) {
        return var0.getRegistry().getOptional(var1).map(var0::get);
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public EnumScoreboardHealthDisplay getDefaultRenderType() {
        return this.renderType;
    }

    public static final class EnumScoreboardHealthDisplay
    extends Enum<EnumScoreboardHealthDisplay>
    implements INamable {
        public static final /* enum */ EnumScoreboardHealthDisplay INTEGER = new EnumScoreboardHealthDisplay("integer");
        public static final /* enum */ EnumScoreboardHealthDisplay HEARTS = new EnumScoreboardHealthDisplay("hearts");
        private final String id;
        public static final INamable.a<EnumScoreboardHealthDisplay> CODEC;
        private static final /* synthetic */ EnumScoreboardHealthDisplay[] e;

        public static EnumScoreboardHealthDisplay[] values() {
            return (EnumScoreboardHealthDisplay[])e.clone();
        }

        public static EnumScoreboardHealthDisplay valueOf(String var0) {
            return Enum.valueOf(EnumScoreboardHealthDisplay.class, var0);
        }

        private EnumScoreboardHealthDisplay(String var2) {
            this.id = var2;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        public static EnumScoreboardHealthDisplay byId(String var0) {
            return CODEC.byName(var0, INTEGER);
        }

        private static /* synthetic */ EnumScoreboardHealthDisplay[] b() {
            return new EnumScoreboardHealthDisplay[]{INTEGER, HEARTS};
        }

        static {
            e = EnumScoreboardHealthDisplay.b();
            CODEC = INamable.fromEnum(EnumScoreboardHealthDisplay::values);
        }
    }
}

