/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class WorldGenFeatureDefinedStructureJigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int UNSET_HEIGHT = Integer.MIN_VALUE;

    public static Optional<Structure.b> addPieces(Structure.a var02, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, Optional<MinecraftKey> var2, int var3, BlockPosition var4, boolean var5, Optional<HeightMap.Type> var6, JigsawStructure.a var7, PoolAliasLookup var8, DimensionPadding var9, LiquidSettings var10) {
        BlockPosition var20;
        Optional<BlockPosition> var22;
        Comparable<MinecraftKey> var21;
        IRegistryCustom var11 = var02.registryAccess();
        ChunkGenerator var12 = var02.chunkGenerator();
        StructureTemplateManager var13 = var02.structureTemplateManager();
        LevelHeightAccessor var14 = var02.heightAccessor();
        SeededRandom var15 = var02.random();
        HolderLookup.b var16 = var11.lookupOrThrow(Registries.TEMPLATE_POOL);
        EnumBlockRotation var17 = EnumBlockRotation.getRandom(var15);
        WorldGenFeatureDefinedStructurePoolTemplate var18 = var1.unwrapKey().flatMap(arg_0 -> WorldGenFeatureDefinedStructureJigsawPlacement.a((IRegistry)var16, var8, arg_0)).orElse(var1.value());
        WorldGenFeatureDefinedStructurePoolStructure var19 = var18.getRandomTemplate(var15);
        if (var19 == WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE) {
            return Optional.empty();
        }
        if (var2.isPresent()) {
            var21 = var2.get();
            var22 = WorldGenFeatureDefinedStructureJigsawPlacement.getRandomNamedJigsaw(var19, (MinecraftKey)var21, var4, var17, var13, var15);
            if (var22.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)var21, (Object)var1.unwrapKey().map(var0 -> var0.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            var20 = (BlockPosition)var22.get();
        } else {
            var20 = var4;
        }
        var21 = var20.subtract(var4);
        var22 = var4.subtract((BaseBlockPosition)var21);
        WorldGenFeaturePillagerOutpostPoolPiece var23 = new WorldGenFeaturePillagerOutpostPoolPiece(var13, var19, (BlockPosition)((Object)var22), var19.getGroundLevelDelta(), var17, var19.getBoundingBox(var13, (BlockPosition)((Object)var22), var17), var10);
        StructureBoundingBox var24 = var23.getBoundingBox();
        int var25 = (var24.maxX() + var24.minX()) / 2;
        int var26 = (var24.maxZ() + var24.minZ()) / 2;
        int var27 = var6.isEmpty() ? ((BaseBlockPosition)((Object)var22)).getY() : var4.getY() + var12.getFirstFreeHeight(var25, var26, var6.get(), var14, var02.randomState());
        int var28 = var24.minY() + var23.getGroundLevelDelta();
        var23.move(0, var27 - var28, 0);
        if (WorldGenFeatureDefinedStructureJigsawPlacement.isStartTooCloseToWorldHeightLimits(var14, var9, var23.getBoundingBox())) {
            LOGGER.debug("Center piece {} with bounding box {} does not fit dimension padding {}", new Object[]{var19, var23.getBoundingBox(), var9});
            return Optional.empty();
        }
        int var29 = var27 + ((BaseBlockPosition)var21).getY();
        return Optional.of(new Structure.b(new BlockPosition(var25, var29, var26), arg_0 -> WorldGenFeatureDefinedStructureJigsawPlacement.a(var23, var3, var25, var7, var29, var14, var9, var26, var24, var02, var5, var12, var13, var15, (IRegistry)var16, var8, var10, arg_0)));
    }

    private static boolean isStartTooCloseToWorldHeightLimits(LevelHeightAccessor var0, DimensionPadding var1, StructureBoundingBox var2) {
        if (var1 == DimensionPadding.ZERO) {
            return false;
        }
        int var3 = var0.getMinY() + var1.bottom();
        int var4 = var0.getMaxY() - var1.top();
        return var2.minY() < var3 || var2.maxY() > var4;
    }

    private static Optional<BlockPosition> getRandomNamedJigsaw(WorldGenFeatureDefinedStructurePoolStructure var0, MinecraftKey var1, BlockPosition var2, EnumBlockRotation var3, StructureTemplateManager var4, SeededRandom var5) {
        List<DefinedStructure.a> var6 = var0.getShuffledJigsawBlocks(var4, var2, var3, var5);
        for (DefinedStructure.a var8 : var6) {
            if (!var1.equals(var8.name())) continue;
            return Optional.of(var8.info().pos());
        }
        return Optional.empty();
    }

    private static void addPieces(RandomState var0, int var1, boolean var2, ChunkGenerator var3, StructureTemplateManager var4, LevelHeightAccessor var5, RandomSource var6, IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var7, WorldGenFeaturePillagerOutpostPoolPiece var8, List<WorldGenFeaturePillagerOutpostPoolPiece> var9, VoxelShape var10, PoolAliasLookup var11, LiquidSettings var12) {
        b var13 = new b(var7, var1, var3, var4, var9, var6);
        var13.tryPlacingChildren(var8, (MutableObject<VoxelShape>)new MutableObject((Object)var10), 0, var2, var5, var0, var11, var12);
        while (var13.placing.hasNext()) {
            a var14 = (a)var13.placing.next();
            var13.tryPlacingChildren(var14.piece, var14.free, var14.depth, var2, var5, var0, var11, var12);
        }
    }

    public static boolean generateJigsaw(WorldServer var02, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, MinecraftKey var2, int var3, BlockPosition var4, boolean var5) {
        ChunkGenerator var6 = var02.getChunkSource().getGenerator();
        StructureTemplateManager var7 = var02.getStructureManager();
        StructureManager var8 = var02.structureManager();
        RandomSource var9 = var02.getRandom();
        Structure.a var10 = new Structure.a(var02.registryAccess(), var6, var6.getBiomeSource(), var02.getChunkSource().randomState(), var7, var02.getSeed(), new ChunkCoordIntPair(var4), var02, var0 -> true);
        Optional<Structure.b> var11 = WorldGenFeatureDefinedStructureJigsawPlacement.addPieces(var10, var1, Optional.of(var2), var3, var4, false, Optional.empty(), new JigsawStructure.a(128), PoolAliasLookup.EMPTY, JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS);
        if (var11.isPresent()) {
            StructurePiecesBuilder var12 = var11.get().getPiecesBuilder();
            for (StructurePiece var14 : var12.build().pieces()) {
                if (!(var14 instanceof WorldGenFeaturePillagerOutpostPoolPiece)) continue;
                WorldGenFeaturePillagerOutpostPoolPiece var15 = (WorldGenFeaturePillagerOutpostPoolPiece)var14;
                var15.place(var02, var8, var6, var9, StructureBoundingBox.infinite(), var4, var5);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void a(WorldGenFeaturePillagerOutpostPoolPiece var0, int var1, int var2, JigsawStructure.a var3, int var4, LevelHeightAccessor var5, DimensionPadding var6, int var7, StructureBoundingBox var8, Structure.a var9, boolean var10, ChunkGenerator var11, StructureTemplateManager var12, SeededRandom var13, IRegistry var14, PoolAliasLookup var15, LiquidSettings var16, StructurePiecesBuilder var17) {
        ArrayList var18 = Lists.newArrayList();
        var18.add(var0);
        if (var1 <= 0) {
            return;
        }
        AxisAlignedBB var19 = new AxisAlignedBB(var2 - var3.horizontal(), Math.max(var4 - var3.vertical(), var5.getMinY() + var6.bottom()), var7 - var3.horizontal(), var2 + var3.horizontal() + 1, Math.min(var4 + var3.vertical() + 1, var5.getMaxY() + 1 - var6.top()), var7 + var3.horizontal() + 1);
        VoxelShape var20 = VoxelShapes.join(VoxelShapes.create(var19), VoxelShapes.create(AxisAlignedBB.of(var8)), OperatorBoolean.ONLY_FIRST);
        WorldGenFeatureDefinedStructureJigsawPlacement.addPieces(var9.randomState(), var1, var10, var11, var12, var5, var13, var14, var0, var18, var20, var15, var16);
        var18.forEach(var17::addPiece);
    }

    private static /* synthetic */ Optional a(IRegistry var0, PoolAliasLookup var1, ResourceKey var2) {
        return var0.getOptional(var1.lookup(var2));
    }

    static final class b {
        private final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super WorldGenFeaturePillagerOutpostPoolPiece> pieces;
        private final RandomSource random;
        final SequencedPriorityIterator<a> placing = new SequencedPriorityIterator();

        b(IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var0, int var1, ChunkGenerator var2, StructureTemplateManager var3, List<? super WorldGenFeaturePillagerOutpostPoolPiece> var4, RandomSource var5) {
            this.pools = var0;
            this.maxDepth = var1;
            this.chunkGenerator = var2;
            this.structureTemplateManager = var3;
            this.pieces = var4;
            this.random = var5;
        }

        void tryPlacingChildren(WorldGenFeaturePillagerOutpostPoolPiece var02, MutableObject<VoxelShape> var1, int var22, boolean var3, LevelHeightAccessor var4, RandomState var5, PoolAliasLookup var6, LiquidSettings var7) {
            WorldGenFeatureDefinedStructurePoolStructure var8 = var02.getElement();
            BlockPosition var9 = var02.getPosition();
            EnumBlockRotation var10 = var02.getRotation();
            WorldGenFeatureDefinedStructurePoolTemplate.Matching var11 = var8.getProjection();
            boolean var12 = var11 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID;
            MutableObject<VoxelShape> var13 = new MutableObject<VoxelShape>();
            StructureBoundingBox var14 = var02.getBoundingBox();
            int var15 = var14.minY();
            block0: for (DefinedStructure.a var17 : var8.getShuffledJigsawBlocks(this.structureTemplateManager, var9, var10, this.random)) {
                WorldGenFeatureDefinedStructurePoolStructure var33;
                MutableObject<VoxelShape> var28;
                DefinedStructure.BlockInfo var18 = var17.info();
                EnumDirection var19 = BlockJigsaw.getFrontFacing(var18.state());
                BlockPosition var20 = var18.pos();
                BlockPosition var21 = var20.relative(var19);
                int var222 = var20.getY() - var15;
                int var23 = Integer.MIN_VALUE;
                ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var24 = var6.lookup(var17.pool());
                Optional var25 = this.pools.get(var24);
                if (var25.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)var24.location());
                    continue;
                }
                Holder var26 = (Holder)var25.get();
                if (((WorldGenFeatureDefinedStructurePoolTemplate)var26.value()).size() == 0 && !var26.is(WorldGenFeaturePieces.EMPTY)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)var24.location());
                    continue;
                }
                Holder<WorldGenFeatureDefinedStructurePoolTemplate> var27 = ((WorldGenFeatureDefinedStructurePoolTemplate)var26.value()).getFallback();
                if (var27.value().size() == 0 && !var27.is(WorldGenFeaturePieces.EMPTY)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)var27.unwrapKey().map(var0 -> var0.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean var29 = var14.isInside(var21);
                if (var29) {
                    var28 = var13;
                    if (var13.getValue() == null) {
                        var13.setValue((Object)VoxelShapes.create(AxisAlignedBB.of(var14)));
                    }
                } else {
                    var28 = var1;
                }
                ArrayList var30 = Lists.newArrayList();
                if (var22 != this.maxDepth) {
                    var30.addAll(((WorldGenFeatureDefinedStructurePoolTemplate)var26.value()).getShuffledTemplates(this.random));
                }
                var30.addAll(var27.value().getShuffledTemplates(this.random));
                int var31 = var17.placementPriority();
                Iterator iterator = var30.iterator();
                while (iterator.hasNext() && (var33 = (WorldGenFeatureDefinedStructurePoolStructure)iterator.next()) != WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE) {
                    for (EnumBlockRotation var35 : EnumBlockRotation.getShuffled(this.random)) {
                        List<DefinedStructure.a> var36 = var33.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPosition.ZERO, var35, this.random);
                        StructureBoundingBox var37 = var33.getBoundingBox(this.structureTemplateManager, BlockPosition.ZERO, var35);
                        int var38 = !var3 || var37.getYSpan() > 16 ? 0 : var36.stream().mapToInt(var2 -> {
                            DefinedStructure.BlockInfo var3 = var2.info();
                            if (!var37.isInside(var3.pos().relative(BlockJigsaw.getFrontFacing(var3.state())))) {
                                return 0;
                            }
                            ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var4 = var6.lookup(var2.pool());
                            Optional var5 = this.pools.get(var4);
                            Optional<Holder> var6 = var5.map(var0 -> ((WorldGenFeatureDefinedStructurePoolTemplate)var0.value()).getFallback());
                            int var7 = var5.map(var0 -> ((WorldGenFeatureDefinedStructurePoolTemplate)var0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            int var8 = var6.map(var0 -> ((WorldGenFeatureDefinedStructurePoolTemplate)var0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            return Math.max(var7, var8);
                        }).max().orElse(0);
                        for (DefinedStructure.a var40 : var36) {
                            int var56;
                            int var53;
                            int var49;
                            if (!BlockJigsaw.canAttach(var17, var40)) continue;
                            BlockPosition var41 = var40.info().pos();
                            BlockPosition var42 = var21.subtract(var41);
                            StructureBoundingBox var43 = var33.getBoundingBox(this.structureTemplateManager, var42, var35);
                            int var44 = var43.minY();
                            WorldGenFeatureDefinedStructurePoolTemplate.Matching var45 = var33.getProjection();
                            boolean var46 = var45 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID;
                            int var47 = var41.getY();
                            int var48 = var222 - var47 + BlockJigsaw.getFrontFacing(var18.state()).getStepY();
                            if (var12 && var46) {
                                var49 = var15 + var48;
                            } else {
                                if (var23 == Integer.MIN_VALUE) {
                                    var23 = this.chunkGenerator.getFirstFreeHeight(var20.getX(), var20.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var4, var5);
                                }
                                var49 = var23 - var47;
                            }
                            int var50 = var49 - var44;
                            StructureBoundingBox var51 = var43.moved(0, var50, 0);
                            BlockPosition var52 = var42.offset(0, var50, 0);
                            if (var38 > 0) {
                                var53 = Math.max(var38 + 1, var51.maxY() - var51.minY());
                                var51.encapsulate(new BlockPosition(var51.minX(), var51.minY() + var53, var51.minZ()));
                            }
                            if (VoxelShapes.joinIsNotEmpty((VoxelShape)var28.getValue(), VoxelShapes.create(AxisAlignedBB.of(var51).deflate(0.25)), OperatorBoolean.ONLY_SECOND)) continue;
                            var28.setValue((Object)VoxelShapes.joinUnoptimized((VoxelShape)var28.getValue(), VoxelShapes.create(AxisAlignedBB.of(var51)), OperatorBoolean.ONLY_FIRST));
                            var53 = var02.getGroundLevelDelta();
                            int var54 = var46 ? var53 - var48 : var33.getGroundLevelDelta();
                            WorldGenFeaturePillagerOutpostPoolPiece var55 = new WorldGenFeaturePillagerOutpostPoolPiece(this.structureTemplateManager, var33, var52, var54, var35, var51, var7);
                            if (var12) {
                                var56 = var15 + var222;
                            } else if (var46) {
                                var56 = var49 + var47;
                            } else {
                                if (var23 == Integer.MIN_VALUE) {
                                    var23 = this.chunkGenerator.getFirstFreeHeight(var20.getX(), var20.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var4, var5);
                                }
                                var56 = var23 + var48 / 2;
                            }
                            var02.addJunction(new WorldGenFeatureDefinedStructureJigsawJunction(var21.getX(), var56 - var222 + var53, var21.getZ(), var48, var45));
                            var55.addJunction(new WorldGenFeatureDefinedStructureJigsawJunction(var20.getX(), var56 - var47 + var54, var20.getZ(), -var48, var11));
                            this.pieces.add(var55);
                            if (var22 + 1 > this.maxDepth) continue block0;
                            a var57 = new a(var55, var28, var22 + 1);
                            this.placing.add(var57, var31);
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    static final class a
    extends Record {
        final WorldGenFeaturePillagerOutpostPoolPiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        a(WorldGenFeaturePillagerOutpostPoolPiece var0, MutableObject<VoxelShape> var1, int var2) {
            this.piece = var0;
            this.free = var1;
            this.depth = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "piece;free;depth", "piece", "free", "depth"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "piece;free;depth", "piece", "free", "depth"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "piece;free;depth", "piece", "free", "depth"}, this, var0);
        }

        public WorldGenFeaturePillagerOutpostPoolPiece piece() {
            return this.piece;
        }

        public MutableObject<VoxelShape> free() {
            return this.free;
        }

        public int depth() {
            return this.depth;
        }
    }
}

