/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class FeatureCountTracker {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LoadingCache<WorldServer, b> data = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<WorldServer, b>(){

        public b load(WorldServer var0) {
            return new b((Object2IntMap<a>)Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap()), new MutableInt(0));
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((WorldServer)object);
        }
    });

    public static void chunkDecorated(WorldServer var0) {
        try {
            ((b)data.get((Object)var0)).chunksWithFeatures().increment();
        }
        catch (Exception var1) {
            LOGGER.error("Failed to increment chunk count", (Throwable)var1);
        }
    }

    public static void featurePlaced(WorldServer var02, WorldGenFeatureConfigured<?, ?> var12, Optional<PlacedFeature> var2) {
        try {
            ((b)data.get((Object)var02)).featureData().computeInt((Object)new a(var12, var2), (var0, var1) -> var1 == null ? 1 : var1 + 1);
        }
        catch (Exception var3) {
            LOGGER.error("Failed to increment feature count", (Throwable)var3);
        }
    }

    public static void clearCounts() {
        data.invalidateAll();
        LOGGER.debug("Cleared feature counts");
    }

    public static void logCounts() {
        LOGGER.debug("Logging feature counts:");
        data.asMap().forEach((var0, var1) -> {
            String var2 = var0.dimension().location().toString();
            boolean var3 = var0.getServer().isRunning();
            HolderLookup.b var4 = var0.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE);
            String var5 = (var3 ? "running" : "dead") + " " + var2;
            Integer var6 = var1.chunksWithFeatures().getValue();
            LOGGER.debug("{} total_chunks: {}", (Object)var5, (Object)var6);
            var1.featureData().forEach((arg_0, arg_1) -> FeatureCountTracker.a(var5, var6, (IRegistry)var4, arg_0, arg_1));
        });
    }

    private static /* synthetic */ void a(String var0, Integer var1, IRegistry var2, a var3, Integer var4) {
        Object[] objectArray = new Object[6];
        objectArray[0] = var0;
        objectArray[1] = String.format(Locale.ROOT, "%10d", var4);
        objectArray[2] = String.format(Locale.ROOT, "%10f", (double)var4.intValue() / (double)var1.intValue());
        objectArray[3] = var3.topFeature().flatMap(var2::getResourceKey).map(ResourceKey::location);
        objectArray[4] = var3.feature().feature();
        objectArray[5] = var3.feature();
        LOGGER.debug("{} {} {} {} {} {}", objectArray);
    }

    record b(Object2IntMap<a> featureData, MutableInt chunksWithFeatures) {
    }

    record a(WorldGenFeatureConfigured<?, ?> feature, Optional<PlacedFeature> topFeature) {
    }
}

