/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.CopperGolemStatueBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class WeatheringCopperGolemStatueBlock
extends CopperGolemStatueBlock
implements WeatheringCopper {
    public static final MapCodec<WeatheringCopperGolemStatueBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)WeatheringCopper.a.CODEC.fieldOf("weathering_state").forGetter(ChangeOverTimeBlock::getAge), WeatheringCopperGolemStatueBlock.propertiesCodec()).apply((Applicative)var0, WeatheringCopperGolemStatueBlock::new));

    public MapCodec<WeatheringCopperGolemStatueBlock> codec() {
        return CODEC;
    }

    public WeatheringCopperGolemStatueBlock(WeatheringCopper.a var0, BlockBase.Info var1) {
        super(var0, var1);
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData var0) {
        return WeatheringCopper.getNext(var0.getBlock()).isPresent();
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        this.changeOverTime(var0, var1, var2, var3);
    }

    @Override
    public WeatheringCopper.a getAge() {
        return this.getWeatheringState();
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        TileEntity tileEntity = var2.getBlockEntity(var3);
        if (tileEntity instanceof CopperGolemStatueBlockEntity) {
            CopperGolemStatueBlockEntity var7 = (CopperGolemStatueBlockEntity)tileEntity;
            if (var0.is(TagsItem.AXES)) {
                if (this.getAge().equals(WeatheringCopper.a.UNAFFECTED)) {
                    CopperGolem var8 = var7.removeStatue(var1);
                    var0.hurtAndBreak(1, (EntityLiving)var4, var5.asEquipmentSlot());
                    if (var8 != null) {
                        var2.addFreshEntity(var8);
                        var2.removeBlock(var3, false);
                        return EnumInteractionResult.SUCCESS;
                    }
                }
            } else {
                if (var0.is(Items.HONEYCOMB)) {
                    return EnumInteractionResult.PASS;
                }
                this.updatePose(var2, var1, var3, var4);
                return EnumInteractionResult.SUCCESS;
            }
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public /* synthetic */ Enum getAge() {
        return this.getAge();
    }
}

