/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.TestBlockMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class TestBlock
extends BlockTileEntity
implements GameMasterBlock {
    public static final MapCodec<TestBlock> CODEC = TestBlock.simpleCodec(TestBlock::new);
    public static final BlockStateEnum<TestBlockMode> MODE = BlockProperties.TEST_BLOCK_MODE;

    public TestBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TestBlockEntity(var0, var1);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        TestBlockMode var3;
        BlockItemStateProperties var1 = var0.getItemInHand().get(DataComponents.BLOCK_STATE);
        IBlockData var2 = this.defaultBlockState();
        if (var1 != null && (var3 = var1.get(MODE)) != null) {
            var2 = (IBlockData)var2.setValue(MODE, var3);
        }
        return var2;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(MODE);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity var5 = var1.getBlockEntity(var2);
        if (!(var5 instanceof TestBlockEntity)) {
            return EnumInteractionResult.PASS;
        }
        TestBlockEntity var6 = (TestBlockEntity)var5;
        if (!var3.canUseGameMasterBlocks()) {
            return EnumInteractionResult.PASS;
        }
        if (var1.isClientSide()) {
            var3.openTestBlock(var6);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        TestBlockEntity var4 = TestBlock.getServerTestBlockEntity(var1, var2);
        if (var4 == null) {
            return;
        }
        var4.reset();
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        TestBlockEntity var6 = TestBlock.getServerTestBlockEntity(var1, var2);
        if (var6 == null) {
            return;
        }
        if (var6.getMode() == TestBlockMode.START) {
            return;
        }
        boolean var7 = var1.hasNeighborSignal(var2);
        boolean var8 = var6.isPowered();
        if (var7 && !var8) {
            var6.setPowered(true);
            var6.trigger();
        } else if (!var7 && var8) {
            var6.setPowered(false);
        }
    }

    @Nullable
    private static TestBlockEntity getServerTestBlockEntity(World var0, BlockPosition var1) {
        WorldServer var2;
        TileEntity tileEntity;
        if (var0 instanceof WorldServer && (tileEntity = (var2 = (WorldServer)var0).getBlockEntity(var1)) instanceof TestBlockEntity) {
            TestBlockEntity var3 = (TestBlockEntity)tileEntity;
            return var3;
        }
        return null;
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(MODE) != TestBlockMode.START) {
            return 0;
        }
        TileEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TestBlockEntity) {
            TestBlockEntity var5 = (TestBlockEntity)var4;
            return var5.isPowered() ? 15 : 0;
        }
        return 0;
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        ItemStack var4 = super.getCloneItemStack(var0, var1, var2, var3);
        return TestBlock.setModeOnStack(var4, var2.getValue(MODE));
    }

    public static ItemStack setModeOnStack(ItemStack var0, TestBlockMode var1) {
        var0.set(DataComponents.BLOCK_STATE, var0.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY).with(MODE, var1));
        return var0;
    }

    protected MapCodec<TestBlock> codec() {
        return CODEC;
    }
}

