/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.references.Items;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAir;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockBamboo;
import net.minecraft.world.level.block.BlockBambooSapling;
import net.minecraft.world.level.block.BlockBanner;
import net.minecraft.world.level.block.BlockBannerWall;
import net.minecraft.world.level.block.BlockBarrel;
import net.minecraft.world.level.block.BlockBarrier;
import net.minecraft.world.level.block.BlockBeacon;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockBeetroot;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.BlockBlastFurnace;
import net.minecraft.world.level.block.BlockBrewingStand;
import net.minecraft.world.level.block.BlockBubbleColumn;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockCactus;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockCarpet;
import net.minecraft.world.level.block.BlockCarrots;
import net.minecraft.world.level.block.BlockCartographyTable;
import net.minecraft.world.level.block.BlockCauldron;
import net.minecraft.world.level.block.BlockChain;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockChestTrapped;
import net.minecraft.world.level.block.BlockChorusFlower;
import net.minecraft.world.level.block.BlockChorusFruit;
import net.minecraft.world.level.block.BlockCobbleWall;
import net.minecraft.world.level.block.BlockCocoa;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockConduit;
import net.minecraft.world.level.block.BlockCoral;
import net.minecraft.world.level.block.BlockCoralDead;
import net.minecraft.world.level.block.BlockCoralFan;
import net.minecraft.world.level.block.BlockCoralFanAbstract;
import net.minecraft.world.level.block.BlockCoralFanWall;
import net.minecraft.world.level.block.BlockCoralFanWallAbstract;
import net.minecraft.world.level.block.BlockCoralPlant;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockCryingObsidian;
import net.minecraft.world.level.block.BlockDaylightDetector;
import net.minecraft.world.level.block.BlockDirtSnow;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockDragonEgg;
import net.minecraft.world.level.block.BlockDropper;
import net.minecraft.world.level.block.BlockEnchantmentTable;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockEndRod;
import net.minecraft.world.level.block.BlockEnderChest;
import net.minecraft.world.level.block.BlockEnderPortal;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockFloorSign;
import net.minecraft.world.level.block.BlockFlowerPot;
import net.minecraft.world.level.block.BlockFlowers;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockFungi;
import net.minecraft.world.level.block.BlockFurnaceFurace;
import net.minecraft.world.level.block.BlockGlassAbstract;
import net.minecraft.world.level.block.BlockGlazedTerracotta;
import net.minecraft.world.level.block.BlockGrass;
import net.minecraft.world.level.block.BlockGrassPath;
import net.minecraft.world.level.block.BlockGrindstone;
import net.minecraft.world.level.block.BlockHalfTransparent;
import net.minecraft.world.level.block.BlockHay;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.BlockHugeMushroom;
import net.minecraft.world.level.block.BlockIce;
import net.minecraft.world.level.block.BlockIceFrost;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.BlockKelp;
import net.minecraft.world.level.block.BlockKelpPlant;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockLantern;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.BlockLongGrass;
import net.minecraft.world.level.block.BlockLoom;
import net.minecraft.world.level.block.BlockMagma;
import net.minecraft.world.level.block.BlockMinecartDetector;
import net.minecraft.world.level.block.BlockMinecartTrack;
import net.minecraft.world.level.block.BlockMobSpawner;
import net.minecraft.world.level.block.BlockMonsterEggs;
import net.minecraft.world.level.block.BlockMushroom;
import net.minecraft.world.level.block.BlockMycel;
import net.minecraft.world.level.block.BlockNetherSprouts;
import net.minecraft.world.level.block.BlockNetherWart;
import net.minecraft.world.level.block.BlockNetherrack;
import net.minecraft.world.level.block.BlockNote;
import net.minecraft.world.level.block.BlockNylium;
import net.minecraft.world.level.block.BlockObserver;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.BlockPotatoes;
import net.minecraft.world.level.block.BlockPowered;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.BlockPressurePlateBinary;
import net.minecraft.world.level.block.BlockPressurePlateWeighted;
import net.minecraft.world.level.block.BlockPumpkin;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockRedstoneComparator;
import net.minecraft.world.level.block.BlockRedstoneLamp;
import net.minecraft.world.level.block.BlockRedstoneOre;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.BlockRedstoneTorchWall;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.BlockReed;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.BlockRoots;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockScaffolding;
import net.minecraft.world.level.block.BlockSeaPickle;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockSkullPlayer;
import net.minecraft.world.level.block.BlockSkullPlayerWall;
import net.minecraft.world.level.block.BlockSkullWall;
import net.minecraft.world.level.block.BlockSlime;
import net.minecraft.world.level.block.BlockSlowSand;
import net.minecraft.world.level.block.BlockSmithingTable;
import net.minecraft.world.level.block.BlockSmoker;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.BlockSoulFire;
import net.minecraft.world.level.block.BlockSponge;
import net.minecraft.world.level.block.BlockStainedGlass;
import net.minecraft.world.level.block.BlockStainedGlassPane;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStemAttached;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.BlockStonecutter;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.BlockStructureVoid;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.BlockTallPlantFlower;
import net.minecraft.world.level.block.BlockTarget;
import net.minecraft.world.level.block.BlockTorch;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.BlockTripwire;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.BlockTwistingVines;
import net.minecraft.world.level.block.BlockTwistingVinesPlant;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.BlockWallSign;
import net.minecraft.world.level.block.BlockWaterLily;
import net.minecraft.world.level.block.BlockWeb;
import net.minecraft.world.level.block.BlockWeepingVines;
import net.minecraft.world.level.block.BlockWeepingVinesPlant;
import net.minecraft.world.level.block.BlockWetSponge;
import net.minecraft.world.level.block.BlockWitherRose;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.BlockWitherSkullWall;
import net.minecraft.world.level.block.BlockWorkbench;
import net.minecraft.world.level.block.BonemealableFeaturePlacerBlock;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.CactusFlowerBlock;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.CopperBulbBlock;
import net.minecraft.world.level.block.CopperChestBlock;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DriedGhastBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.DryVegetationBlock;
import net.minecraft.world.level.block.EyeblossomBlock;
import net.minecraft.world.level.block.FireflyBushBlock;
import net.minecraft.world.level.block.FlowerBedBlock;
import net.minecraft.world.level.block.FrogspawnBlock;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.HeavyCoreBlock;
import net.minecraft.world.level.block.InfestedRotatedPillarBlock;
import net.minecraft.world.level.block.LavaCauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.MangroveLeavesBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.MudBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PiglinWallSkullBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.RootedDirtBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SculkBlock;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.ShortDryGrassBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.TallDryGrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TestBlock;
import net.minecraft.world.level.block.TestInstanceBlock;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.WeatheringCopperBarsBlock;
import net.minecraft.world.level.block.WeatheringCopperBlocks;
import net.minecraft.world.level.block.WeatheringCopperBulbBlock;
import net.minecraft.world.level.block.WeatheringCopperChainBlock;
import net.minecraft.world.level.block.WeatheringCopperChestBlock;
import net.minecraft.world.level.block.WeatheringCopperDoorBlock;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.WeatheringCopperGolemStatueBlock;
import net.minecraft.world.level.block.WeatheringCopperGrateBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.WeatheringCopperTrapDoorBlock;
import net.minecraft.world.level.block.WeatheringLanternBlock;
import net.minecraft.world.level.block.WeatheringLightningRodBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.grower.WorldGenTreeProvider;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.MaterialMapColor;
import org.apache.commons.lang3.function.TriFunction;

public class Blocks {
    private static final BlockBase.f NOT_CLOSED_SHULKER = (var0, var1, var2) -> {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox var3 = (TileEntityShulkerBox)var4;
            return var3.isClosed();
        }
        return true;
    };
    private static final BlockBase.f NOT_EXTENDED_PISTON = (var0, var1, var2) -> var0.getValue(BlockPiston.EXTENDED) == false;
    public static final Block AIR = Blocks.register("air", BlockAir::new, BlockBase.Info.of().replaceable().noCollision().noLootTable().air());
    public static final Block STONE = Blocks.register("stone", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block GRANITE = Blocks.register("granite", BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block POLISHED_GRANITE = Blocks.register("polished_granite", BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DIORITE = Blocks.register("diorite", BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block POLISHED_DIORITE = Blocks.register("polished_diorite", BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block ANDESITE = Blocks.register("andesite", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block POLISHED_ANDESITE = Blocks.register("polished_andesite", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block GRASS_BLOCK = Blocks.register("grass_block", BlockGrass::new, BlockBase.Info.of().mapColor(MaterialMapColor.GRASS).randomTicks().strength(0.6f).sound(SoundEffectType.GRASS));
    public static final Block DIRT = Blocks.register("dirt", BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).strength(0.5f).sound(SoundEffectType.GRAVEL));
    public static final Block COARSE_DIRT = Blocks.register("coarse_dirt", BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).strength(0.5f).sound(SoundEffectType.GRAVEL));
    public static final Block PODZOL = Blocks.register("podzol", BlockDirtSnow::new, BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).strength(0.5f).sound(SoundEffectType.GRAVEL));
    public static final Block COBBLESTONE = Blocks.register("cobblestone", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block OAK_PLANKS = Blocks.register("oak_planks", BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block SPRUCE_PLANKS = Blocks.register("spruce_planks", BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BIRCH_PLANKS = Blocks.register("birch_planks", BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block JUNGLE_PLANKS = Blocks.register("jungle_planks", BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block ACACIA_PLANKS = Blocks.register("acacia_planks", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block CHERRY_PLANKS = Blocks.register("cherry_planks", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_WHITE).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.CHERRY_WOOD).ignitedByLava());
    public static final Block DARK_OAK_PLANKS = Blocks.register("dark_oak_planks", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block PALE_OAK_WOOD = Blocks.register("pale_oak_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block PALE_OAK_PLANKS = Blocks.register("pale_oak_planks", BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block MANGROVE_PLANKS = Blocks.register("mangrove_planks", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BAMBOO_PLANKS = Blocks.register("bamboo_planks", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.BAMBOO_WOOD).ignitedByLava());
    public static final Block BAMBOO_MOSAIC = Blocks.register("bamboo_mosaic", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.BAMBOO_WOOD).ignitedByLava());
    public static final Block OAK_SAPLING = Blocks.register("oak_sapling", (BlockBase.Info var0) -> new BlockSapling(WorldGenTreeProvider.OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SPRUCE_SAPLING = Blocks.register("spruce_sapling", (BlockBase.Info var0) -> new BlockSapling(WorldGenTreeProvider.SPRUCE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BIRCH_SAPLING = Blocks.register("birch_sapling", (BlockBase.Info var0) -> new BlockSapling(WorldGenTreeProvider.BIRCH, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block JUNGLE_SAPLING = Blocks.register("jungle_sapling", (BlockBase.Info var0) -> new BlockSapling(WorldGenTreeProvider.JUNGLE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ACACIA_SAPLING = Blocks.register("acacia_sapling", (BlockBase.Info var0) -> new BlockSapling(WorldGenTreeProvider.ACACIA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CHERRY_SAPLING = Blocks.register("cherry_sapling", (BlockBase.Info var0) -> new BlockSapling(WorldGenTreeProvider.CHERRY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PINK).noCollision().randomTicks().instabreak().sound(SoundEffectType.CHERRY_SAPLING).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DARK_OAK_SAPLING = Blocks.register("dark_oak_sapling", (BlockBase.Info var0) -> new BlockSapling(WorldGenTreeProvider.DARK_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PALE_OAK_SAPLING = Blocks.register("pale_oak_sapling", (BlockBase.Info var0) -> new BlockSapling(WorldGenTreeProvider.PALE_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.METAL).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block MANGROVE_PROPAGULE = Blocks.register("mangrove_propagule", (BlockBase.Info var0) -> new MangrovePropaguleBlock(WorldGenTreeProvider.MANGROVE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BEDROCK = Blocks.register("bedrock", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).strength(-1.0f, 3600000.0f).noLootTable().isValidSpawn(Blocks::never));
    public static final Block WATER = Blocks.register("water", (BlockBase.Info var0) -> new BlockFluids(FluidTypes.WATER, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WATER).replaceable().noCollision().strength(100.0f).pushReaction(EnumPistonReaction.DESTROY).noLootTable().liquid().sound(SoundEffectType.EMPTY));
    public static final Block LAVA = Blocks.register("lava", (BlockBase.Info var0) -> new BlockFluids(FluidTypes.LAVA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.FIRE).replaceable().noCollision().randomTicks().strength(100.0f).lightLevel(var0 -> 15).pushReaction(EnumPistonReaction.DESTROY).noLootTable().liquid().sound(SoundEffectType.EMPTY));
    public static final Block SAND = Blocks.register("sand", (BlockBase.Info var0) -> new SandBlock(new ColorRGBA(14406560), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block SUSPICIOUS_SAND = Blocks.register("suspicious_sand", (BlockBase.Info var0) -> new BrushableBlock(SAND, SoundEffects.BRUSH_SAND, SoundEffects.BRUSH_SAND, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.SNARE).strength(0.25f).sound(SoundEffectType.SUSPICIOUS_SAND).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block RED_SAND = Blocks.register("red_sand", (BlockBase.Info var0) -> new SandBlock(new ColorRGBA(11098145), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block GRAVEL = Blocks.register("gravel", (BlockBase.Info var0) -> new ColoredFallingBlock(new ColorRGBA(-8356741), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.SNARE).strength(0.6f).sound(SoundEffectType.GRAVEL));
    public static final Block SUSPICIOUS_GRAVEL = Blocks.register("suspicious_gravel", (BlockBase.Info var0) -> new BrushableBlock(GRAVEL, SoundEffects.BRUSH_GRAVEL, SoundEffects.BRUSH_GRAVEL, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.SNARE).strength(0.25f).sound(SoundEffectType.SUSPICIOUS_GRAVEL).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block GOLD_ORE = Blocks.register("gold_ore", (BlockBase.Info var0) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_GOLD_ORE = Blocks.register("deepslate_gold_ore", (BlockBase.Info var0) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(GOLD_ORE).mapColor(MaterialMapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundEffectType.DEEPSLATE));
    public static final Block IRON_ORE = Blocks.register("iron_ore", (BlockBase.Info var0) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_IRON_ORE = Blocks.register("deepslate_iron_ore", (BlockBase.Info var0) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(IRON_ORE).mapColor(MaterialMapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundEffectType.DEEPSLATE));
    public static final Block COAL_ORE = Blocks.register("coal_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(0, 2), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_COAL_ORE = Blocks.register("deepslate_coal_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(0, 2), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(COAL_ORE).mapColor(MaterialMapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundEffectType.DEEPSLATE));
    public static final Block NETHER_GOLD_ORE = Blocks.register("nether_gold_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(0, 1), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f).sound(SoundEffectType.NETHER_GOLD_ORE));
    public static final Block OAK_LOG = Blocks.register("oak_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.WOOD, MaterialMapColor.PODZOL, SoundEffectType.WOOD));
    public static final Block SPRUCE_LOG = Blocks.register("spruce_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.PODZOL, MaterialMapColor.COLOR_BROWN, SoundEffectType.WOOD));
    public static final Block BIRCH_LOG = Blocks.register("birch_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.SAND, MaterialMapColor.QUARTZ, SoundEffectType.WOOD));
    public static final Block JUNGLE_LOG = Blocks.register("jungle_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.DIRT, MaterialMapColor.PODZOL, SoundEffectType.WOOD));
    public static final Block ACACIA_LOG = Blocks.register("acacia_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.COLOR_ORANGE, MaterialMapColor.STONE, SoundEffectType.WOOD));
    public static final Block CHERRY_LOG = Blocks.register("cherry_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.TERRACOTTA_WHITE, MaterialMapColor.TERRACOTTA_GRAY, SoundEffectType.CHERRY_WOOD));
    public static final Block DARK_OAK_LOG = Blocks.register("dark_oak_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.COLOR_BROWN, MaterialMapColor.COLOR_BROWN, SoundEffectType.WOOD));
    public static final Block PALE_OAK_LOG = Blocks.register("pale_oak_log", BlockRotatable::new, Blocks.logProperties(PALE_OAK_PLANKS.defaultMapColor(), PALE_OAK_WOOD.defaultMapColor(), SoundEffectType.WOOD));
    public static final Block MANGROVE_LOG = Blocks.register("mangrove_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.COLOR_RED, MaterialMapColor.PODZOL, SoundEffectType.WOOD));
    public static final Block MANGROVE_ROOTS = Blocks.register("mangrove_roots", MangroveRootsBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).instrument(BlockPropertyInstrument.BASS).strength(0.7f).sound(SoundEffectType.MANGROVE_ROOTS).noOcclusion().isSuffocating(Blocks::never).isViewBlocking(Blocks::never).noOcclusion().ignitedByLava());
    public static final Block MUDDY_MANGROVE_ROOTS = Blocks.register("muddy_mangrove_roots", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).strength(0.7f).sound(SoundEffectType.MUDDY_MANGROVE_ROOTS));
    public static final Block BAMBOO_BLOCK = Blocks.register("bamboo_block", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.COLOR_YELLOW, MaterialMapColor.PLANT, SoundEffectType.BAMBOO_WOOD));
    public static final Block STRIPPED_SPRUCE_LOG = Blocks.register("stripped_spruce_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.PODZOL, MaterialMapColor.PODZOL, SoundEffectType.WOOD));
    public static final Block STRIPPED_BIRCH_LOG = Blocks.register("stripped_birch_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.SAND, MaterialMapColor.SAND, SoundEffectType.WOOD));
    public static final Block STRIPPED_JUNGLE_LOG = Blocks.register("stripped_jungle_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.DIRT, MaterialMapColor.DIRT, SoundEffectType.WOOD));
    public static final Block STRIPPED_ACACIA_LOG = Blocks.register("stripped_acacia_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.COLOR_ORANGE, MaterialMapColor.COLOR_ORANGE, SoundEffectType.WOOD));
    public static final Block STRIPPED_CHERRY_LOG = Blocks.register("stripped_cherry_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.TERRACOTTA_WHITE, MaterialMapColor.TERRACOTTA_PINK, SoundEffectType.CHERRY_WOOD));
    public static final Block STRIPPED_DARK_OAK_LOG = Blocks.register("stripped_dark_oak_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.COLOR_BROWN, MaterialMapColor.COLOR_BROWN, SoundEffectType.WOOD));
    public static final Block STRIPPED_PALE_OAK_LOG = Blocks.register("stripped_pale_oak_log", BlockRotatable::new, Blocks.logProperties(PALE_OAK_PLANKS.defaultMapColor(), PALE_OAK_PLANKS.defaultMapColor(), SoundEffectType.WOOD));
    public static final Block STRIPPED_OAK_LOG = Blocks.register("stripped_oak_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.WOOD, MaterialMapColor.WOOD, SoundEffectType.WOOD));
    public static final Block STRIPPED_MANGROVE_LOG = Blocks.register("stripped_mangrove_log", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.COLOR_RED, MaterialMapColor.COLOR_RED, SoundEffectType.WOOD));
    public static final Block STRIPPED_BAMBOO_BLOCK = Blocks.register("stripped_bamboo_block", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.COLOR_YELLOW, MaterialMapColor.COLOR_YELLOW, SoundEffectType.BAMBOO_WOOD));
    public static final Block OAK_WOOD = Blocks.register("oak_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block SPRUCE_WOOD = Blocks.register("spruce_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BIRCH_WOOD = Blocks.register("birch_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block JUNGLE_WOOD = Blocks.register("jungle_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block ACACIA_WOOD = Blocks.register("acacia_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block CHERRY_WOOD = Blocks.register("cherry_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_GRAY).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.CHERRY_WOOD).ignitedByLava());
    public static final Block DARK_OAK_WOOD = Blocks.register("dark_oak_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block MANGROVE_WOOD = Blocks.register("mangrove_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block STRIPPED_OAK_WOOD = Blocks.register("stripped_oak_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block STRIPPED_SPRUCE_WOOD = Blocks.register("stripped_spruce_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block STRIPPED_BIRCH_WOOD = Blocks.register("stripped_birch_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block STRIPPED_JUNGLE_WOOD = Blocks.register("stripped_jungle_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block STRIPPED_ACACIA_WOOD = Blocks.register("stripped_acacia_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block STRIPPED_CHERRY_WOOD = Blocks.register("stripped_cherry_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_PINK).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.CHERRY_WOOD).ignitedByLava());
    public static final Block STRIPPED_DARK_OAK_WOOD = Blocks.register("stripped_dark_oak_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block STRIPPED_PALE_OAK_WOOD = Blocks.register("stripped_pale_oak_wood", BlockRotatable::new, BlockBase.Info.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block STRIPPED_MANGROVE_WOOD = Blocks.register("stripped_mangrove_wood", BlockRotatable::new, Blocks.logProperties(MaterialMapColor.COLOR_RED, MaterialMapColor.COLOR_RED, SoundEffectType.WOOD));
    public static final Block OAK_LEAVES = Blocks.register("oak_leaves", (BlockBase.Info var0) -> new TintedParticleLeavesBlock(0.01f, (BlockBase.Info)var0), Blocks.leavesProperties(SoundEffectType.GRASS));
    public static final Block SPRUCE_LEAVES = Blocks.register("spruce_leaves", (BlockBase.Info var0) -> new TintedParticleLeavesBlock(0.01f, (BlockBase.Info)var0), Blocks.leavesProperties(SoundEffectType.GRASS));
    public static final Block BIRCH_LEAVES = Blocks.register("birch_leaves", (BlockBase.Info var0) -> new TintedParticleLeavesBlock(0.01f, (BlockBase.Info)var0), Blocks.leavesProperties(SoundEffectType.GRASS));
    public static final Block JUNGLE_LEAVES = Blocks.register("jungle_leaves", (BlockBase.Info var0) -> new TintedParticleLeavesBlock(0.01f, (BlockBase.Info)var0), Blocks.leavesProperties(SoundEffectType.GRASS));
    public static final Block ACACIA_LEAVES = Blocks.register("acacia_leaves", (BlockBase.Info var0) -> new TintedParticleLeavesBlock(0.01f, (BlockBase.Info)var0), Blocks.leavesProperties(SoundEffectType.GRASS));
    public static final Block CHERRY_LEAVES = Blocks.register("cherry_leaves", (BlockBase.Info var0) -> new UntintedParticleLeavesBlock(0.1f, Particles.CHERRY_LEAVES, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PINK).strength(0.2f).randomTicks().sound(SoundEffectType.CHERRY_LEAVES).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block DARK_OAK_LEAVES = Blocks.register("dark_oak_leaves", (BlockBase.Info var0) -> new TintedParticleLeavesBlock(0.01f, (BlockBase.Info)var0), Blocks.leavesProperties(SoundEffectType.GRASS));
    public static final Block PALE_OAK_LEAVES = Blocks.register("pale_oak_leaves", (BlockBase.Info var0) -> new UntintedParticleLeavesBlock(0.02f, Particles.PALE_OAK_LEAVES, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.METAL).strength(0.2f).randomTicks().sound(SoundEffectType.GRASS).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block MANGROVE_LEAVES = Blocks.register("mangrove_leaves", (BlockBase.Info var0) -> new MangroveLeavesBlock(0.01f, (BlockBase.Info)var0), Blocks.leavesProperties(SoundEffectType.GRASS));
    public static final Block AZALEA_LEAVES = Blocks.register("azalea_leaves", (BlockBase.Info var0) -> new UntintedParticleLeavesBlock(0.01f, ColorParticleOption.create(Particles.TINTED_LEAVES, -9399763), (BlockBase.Info)var0), Blocks.leavesProperties(SoundEffectType.AZALEA_LEAVES));
    public static final Block FLOWERING_AZALEA_LEAVES = Blocks.register("flowering_azalea_leaves", (BlockBase.Info var0) -> new UntintedParticleLeavesBlock(0.01f, ColorParticleOption.create(Particles.TINTED_LEAVES, -9399763), (BlockBase.Info)var0), Blocks.leavesProperties(SoundEffectType.AZALEA_LEAVES));
    public static final Block SPONGE = Blocks.register("sponge", BlockSponge::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).strength(0.6f).sound(SoundEffectType.SPONGE));
    public static final Block WET_SPONGE = Blocks.register("wet_sponge", BlockWetSponge::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).strength(0.6f).sound(SoundEffectType.WET_SPONGE));
    public static final Block GLASS = Blocks.register("glass", BlockGlassAbstract::new, BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never));
    public static final Block LAPIS_ORE = Blocks.register("lapis_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(2, 5), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_LAPIS_ORE = Blocks.register("deepslate_lapis_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(2, 5), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(LAPIS_ORE).mapColor(MaterialMapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundEffectType.DEEPSLATE));
    public static final Block LAPIS_BLOCK = Blocks.register("lapis_block", BlockBase.Info.of().mapColor(MaterialMapColor.LAPIS).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DISPENSER = Blocks.register("dispenser", BlockDispenser::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f));
    public static final Block SANDSTONE = Blocks.register("sandstone", BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CHISELED_SANDSTONE = Blocks.register("chiseled_sandstone", BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CUT_SANDSTONE = Blocks.register("cut_sandstone", BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block NOTE_BLOCK = Blocks.register("note_block", BlockNote::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.WOOD).strength(0.8f).ignitedByLava());
    public static final Block WHITE_BED = Blocks.registerBed("white_bed", EnumColor.WHITE);
    public static final Block ORANGE_BED = Blocks.registerBed("orange_bed", EnumColor.ORANGE);
    public static final Block MAGENTA_BED = Blocks.registerBed("magenta_bed", EnumColor.MAGENTA);
    public static final Block LIGHT_BLUE_BED = Blocks.registerBed("light_blue_bed", EnumColor.LIGHT_BLUE);
    public static final Block YELLOW_BED = Blocks.registerBed("yellow_bed", EnumColor.YELLOW);
    public static final Block LIME_BED = Blocks.registerBed("lime_bed", EnumColor.LIME);
    public static final Block PINK_BED = Blocks.registerBed("pink_bed", EnumColor.PINK);
    public static final Block GRAY_BED = Blocks.registerBed("gray_bed", EnumColor.GRAY);
    public static final Block LIGHT_GRAY_BED = Blocks.registerBed("light_gray_bed", EnumColor.LIGHT_GRAY);
    public static final Block CYAN_BED = Blocks.registerBed("cyan_bed", EnumColor.CYAN);
    public static final Block PURPLE_BED = Blocks.registerBed("purple_bed", EnumColor.PURPLE);
    public static final Block BLUE_BED = Blocks.registerBed("blue_bed", EnumColor.BLUE);
    public static final Block BROWN_BED = Blocks.registerBed("brown_bed", EnumColor.BROWN);
    public static final Block GREEN_BED = Blocks.registerBed("green_bed", EnumColor.GREEN);
    public static final Block RED_BED = Blocks.registerBed("red_bed", EnumColor.RED);
    public static final Block BLACK_BED = Blocks.registerBed("black_bed", EnumColor.BLACK);
    public static final Block POWERED_RAIL = Blocks.register("powered_rail", BlockPoweredRail::new, BlockBase.Info.of().noCollision().strength(0.7f).sound(SoundEffectType.METAL));
    public static final Block DETECTOR_RAIL = Blocks.register("detector_rail", BlockMinecartDetector::new, BlockBase.Info.of().noCollision().strength(0.7f).sound(SoundEffectType.METAL));
    public static final Block STICKY_PISTON = Blocks.register("sticky_piston", (BlockBase.Info var0) -> new BlockPiston(true, (BlockBase.Info)var0), Blocks.pistonProperties());
    public static final Block COBWEB = Blocks.register("cobweb", BlockWeb::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOL).sound(SoundEffectType.COBWEB).forceSolidOn().noCollision().requiresCorrectToolForDrops().strength(4.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SHORT_GRASS = Blocks.register("short_grass", BlockLongGrass::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XYZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block FERN = Blocks.register("fern", BlockLongGrass::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XYZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DEAD_BUSH = Blocks.register("dead_bush", DryVegetationBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).replaceable().noCollision().instabreak().sound(SoundEffectType.GRASS).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BUSH = Blocks.register("bush", BlockPlant::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundEffectType.GRASS).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SHORT_DRY_GRASS = Blocks.register("short_dry_grass", ShortDryGrassBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).replaceable().noCollision().instabreak().sound(SoundEffectType.GRASS).ignitedByLava().offsetType(BlockBase.EnumRandomOffset.XYZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block TALL_DRY_GRASS = Blocks.register("tall_dry_grass", TallDryGrassBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).replaceable().noCollision().instabreak().sound(SoundEffectType.GRASS).ignitedByLava().offsetType(BlockBase.EnumRandomOffset.XYZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SEAGRASS = Blocks.register("seagrass", SeagrassBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WATER).replaceable().noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block TALL_SEAGRASS = Blocks.register("tall_seagrass", TallSeagrassBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WATER).replaceable().noCollision().instabreak().sound(SoundEffectType.WET_GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PISTON = Blocks.register("piston", (BlockBase.Info var0) -> new BlockPiston(false, (BlockBase.Info)var0), Blocks.pistonProperties());
    public static final Block PISTON_HEAD = Blocks.register("piston_head", BlockPistonExtension::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).strength(1.5f).noLootTable().pushReaction(EnumPistonReaction.BLOCK));
    public static final Block WHITE_WOOL = Blocks.register("white_wool", BlockBase.Info.of().mapColor(MaterialMapColor.SNOW).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block ORANGE_WOOL = Blocks.register("orange_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block MAGENTA_WOOL = Blocks.register("magenta_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_MAGENTA).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block LIGHT_BLUE_WOOL = Blocks.register("light_blue_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_BLUE).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block YELLOW_WOOL = Blocks.register("yellow_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block LIME_WOOL = Blocks.register("lime_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_GREEN).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block PINK_WOOL = Blocks.register("pink_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PINK).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block GRAY_WOOL = Blocks.register("gray_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block LIGHT_GRAY_WOOL = Blocks.register("light_gray_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_GRAY).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block CYAN_WOOL = Blocks.register("cyan_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block PURPLE_WOOL = Blocks.register("purple_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block BLUE_WOOL = Blocks.register("blue_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLUE).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block BROWN_WOOL = Blocks.register("brown_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block GREEN_WOOL = Blocks.register("green_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GREEN).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block RED_WOOL = Blocks.register("red_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block BLACK_WOOL = Blocks.register("black_wool", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).instrument(BlockPropertyInstrument.GUITAR).strength(0.8f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block MOVING_PISTON = Blocks.register("moving_piston", BlockPistonMoving::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).forceSolidOn().strength(-1.0f).dynamicShape().noLootTable().noOcclusion().isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).pushReaction(EnumPistonReaction.BLOCK));
    public static final Block DANDELION = Blocks.register("dandelion", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.SATURATION, 0.35f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block TORCHFLOWER = Blocks.register("torchflower", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.NIGHT_VISION, 5.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block POPPY = Blocks.register("poppy", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.NIGHT_VISION, 5.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BLUE_ORCHID = Blocks.register("blue_orchid", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.SATURATION, 0.35f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ALLIUM = Blocks.register("allium", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.FIRE_RESISTANCE, 3.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block AZURE_BLUET = Blocks.register("azure_bluet", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.BLINDNESS, 11.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block RED_TULIP = Blocks.register("red_tulip", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.WEAKNESS, 7.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ORANGE_TULIP = Blocks.register("orange_tulip", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.WEAKNESS, 7.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WHITE_TULIP = Blocks.register("white_tulip", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.WEAKNESS, 7.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PINK_TULIP = Blocks.register("pink_tulip", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.WEAKNESS, 7.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block OXEYE_DAISY = Blocks.register("oxeye_daisy", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.REGENERATION, 7.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CORNFLOWER = Blocks.register("cornflower", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.JUMP_BOOST, 5.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WITHER_ROSE = Blocks.register("wither_rose", (BlockBase.Info var0) -> new BlockWitherRose(MobEffects.WITHER, 7.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block LILY_OF_THE_VALLEY = Blocks.register("lily_of_the_valley", (BlockBase.Info var0) -> new BlockFlowers(MobEffects.POISON, 11.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BROWN_MUSHROOM = Blocks.register("brown_mushroom", (BlockBase.Info var0) -> new BlockMushroom(TreeFeatures.HUGE_BROWN_MUSHROOM, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).lightLevel(var0 -> 1).hasPostProcess(Blocks::always).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block RED_MUSHROOM = Blocks.register("red_mushroom", (BlockBase.Info var0) -> new BlockMushroom(TreeFeatures.HUGE_RED_MUSHROOM, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).hasPostProcess(Blocks::always).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block GOLD_BLOCK = Blocks.register("gold_block", BlockBase.Info.of().mapColor(MaterialMapColor.GOLD).instrument(BlockPropertyInstrument.BELL).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundEffectType.METAL));
    public static final Block IRON_BLOCK = Blocks.register("iron_block", BlockBase.Info.of().mapColor(MaterialMapColor.METAL).instrument(BlockPropertyInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundEffectType.IRON));
    public static final Block BRICKS = Blocks.register("bricks", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block TNT = Blocks.register("tnt", BlockTNT::new, BlockBase.Info.of().mapColor(MaterialMapColor.FIRE).instabreak().sound(SoundEffectType.GRASS).ignitedByLava().isRedstoneConductor(Blocks::never));
    public static final Block BOOKSHELF = Blocks.register("bookshelf", BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(1.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block CHISELED_BOOKSHELF = Blocks.register("chiseled_bookshelf", ChiseledBookShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(1.5f).sound(SoundEffectType.CHISELED_BOOKSHELF).ignitedByLava());
    public static final Block ACACIA_SHELF = Blocks.register("acacia_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block BAMBOO_SHELF = Blocks.register("bamboo_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block BIRCH_SHELF = Blocks.register("birch_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block CHERRY_SHELF = Blocks.register("cherry_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block CRIMSON_SHELF = Blocks.register("crimson_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block DARK_OAK_SHELF = Blocks.register("dark_oak_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block JUNGLE_SHELF = Blocks.register("jungle_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block MANGROVE_SHELF = Blocks.register("mangrove_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block OAK_SHELF = Blocks.register("oak_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block PALE_OAK_SHELF = Blocks.register("pale_oak_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block SPRUCE_SHELF = Blocks.register("spruce_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block WARPED_SHELF = Blocks.register("warped_shelf", ShelfBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).sound(SoundEffectType.SHELF).ignitedByLava().strength(2.0f, 3.0f));
    public static final Block MOSSY_COBBLESTONE = Blocks.register("mossy_cobblestone", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block OBSIDIAN = Blocks.register("obsidian", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(50.0f, 1200.0f));
    public static final Block TORCH = Blocks.register("torch", (BlockBase.Info var0) -> new BlockTorch(Particles.FLAME, (BlockBase.Info)var0), BlockBase.Info.of().noCollision().instabreak().lightLevel(var0 -> 14).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WALL_TORCH = Blocks.register("wall_torch", (BlockBase.Info var0) -> new BlockTorchWall(Particles.FLAME, (BlockBase.Info)var0), Blocks.wallVariant(TORCH, true).noCollision().instabreak().lightLevel(var0 -> 14).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block FIRE = Blocks.register("fire", BlockFire::new, BlockBase.Info.of().mapColor(MaterialMapColor.FIRE).replaceable().noCollision().instabreak().lightLevel(var0 -> 15).sound(SoundEffectType.WOOL).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SOUL_FIRE = Blocks.register("soul_fire", BlockSoulFire::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_BLUE).replaceable().noCollision().instabreak().lightLevel(var0 -> 10).sound(SoundEffectType.WOOL).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SPAWNER = Blocks.register("spawner", BlockMobSpawner::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f).sound(SoundEffectType.SPAWNER).noOcclusion());
    public static final Block CREAKING_HEART = Blocks.register("creaking_heart", CreakingHeartBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).strength(10.0f).sound(SoundEffectType.CREAKING_HEART));
    public static final Block OAK_STAIRS = Blocks.registerLegacyStair("oak_stairs", OAK_PLANKS);
    public static final Block CHEST = Blocks.register("chest", (BlockBase.Info var0) -> new BlockChest(() -> TileEntityTypes.CHEST, SoundEffects.CHEST_OPEN, SoundEffects.CHEST_CLOSE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block REDSTONE_WIRE = Blocks.register("redstone_wire", BlockRedstoneWire::new, BlockBase.Info.of().noCollision().instabreak().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DIAMOND_ORE = Blocks.register("diamond_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(3, 7), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_DIAMOND_ORE = Blocks.register("deepslate_diamond_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(3, 7), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(DIAMOND_ORE).mapColor(MaterialMapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundEffectType.DEEPSLATE));
    public static final Block DIAMOND_BLOCK = Blocks.register("diamond_block", BlockBase.Info.of().mapColor(MaterialMapColor.DIAMOND).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundEffectType.METAL));
    public static final Block CRAFTING_TABLE = Blocks.register("crafting_table", BlockWorkbench::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block WHEAT = Blocks.register("wheat", BlockCrops::new, BlockBase.Info.of().mapColor(var0 -> var0.getValue(BlockCrops.AGE) >= 6 ? MaterialMapColor.COLOR_YELLOW : MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.CROP).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block FARMLAND = Blocks.register("farmland", BlockSoil::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).randomTicks().strength(0.6f).sound(SoundEffectType.GRAVEL).isViewBlocking(Blocks::always).isSuffocating(Blocks::always));
    public static final Block FURNACE = Blocks.register("furnace", BlockFurnaceFurace::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f).lightLevel(Blocks.litBlockEmission(13)));
    public static final Block OAK_SIGN = Blocks.register("oak_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block SPRUCE_SIGN = Blocks.register("spruce_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.SPRUCE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(SPRUCE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BIRCH_SIGN = Blocks.register("birch_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.BIRCH, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.SAND).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block ACACIA_SIGN = Blocks.register("acacia_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.ACACIA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CHERRY_SIGN = Blocks.register("cherry_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.CHERRY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CHERRY_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block JUNGLE_SIGN = Blocks.register("jungle_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.JUNGLE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(JUNGLE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block DARK_OAK_SIGN = Blocks.register("dark_oak_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.DARK_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(DARK_OAK_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block PALE_OAK_SIGN = Blocks.register("pale_oak_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.PALE_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block MANGROVE_SIGN = Blocks.register("mangrove_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.MANGROVE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MANGROVE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BAMBOO_SIGN = Blocks.register("bamboo_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.BAMBOO, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block OAK_DOOR = Blocks.register("oak_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(OAK_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block LADDER = Blocks.register("ladder", BlockLadder::new, BlockBase.Info.of().forceSolidOff().strength(0.4f).sound(SoundEffectType.LADDER).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block RAIL = Blocks.register("rail", BlockMinecartTrack::new, BlockBase.Info.of().noCollision().strength(0.7f).sound(SoundEffectType.METAL));
    public static final Block COBBLESTONE_STAIRS = Blocks.registerLegacyStair("cobblestone_stairs", COBBLESTONE);
    public static final Block OAK_WALL_SIGN = Blocks.register("oak_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.OAK, (BlockBase.Info)var0), Blocks.wallVariant(OAK_SIGN, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block SPRUCE_WALL_SIGN = Blocks.register("spruce_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.SPRUCE, (BlockBase.Info)var0), Blocks.wallVariant(SPRUCE_SIGN, true).mapColor(SPRUCE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BIRCH_WALL_SIGN = Blocks.register("birch_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.BIRCH, (BlockBase.Info)var0), Blocks.wallVariant(BIRCH_SIGN, true).mapColor(MaterialMapColor.SAND).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block ACACIA_WALL_SIGN = Blocks.register("acacia_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.ACACIA, (BlockBase.Info)var0), Blocks.wallVariant(ACACIA_SIGN, true).mapColor(MaterialMapColor.COLOR_ORANGE).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CHERRY_WALL_SIGN = Blocks.register("cherry_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.CHERRY, (BlockBase.Info)var0), Blocks.wallVariant(CHERRY_SIGN, true).mapColor(CHERRY_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block JUNGLE_WALL_SIGN = Blocks.register("jungle_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.JUNGLE, (BlockBase.Info)var0), Blocks.wallVariant(JUNGLE_SIGN, true).mapColor(JUNGLE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block DARK_OAK_WALL_SIGN = Blocks.register("dark_oak_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.DARK_OAK, (BlockBase.Info)var0), Blocks.wallVariant(DARK_OAK_SIGN, true).mapColor(DARK_OAK_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block PALE_OAK_WALL_SIGN = Blocks.register("pale_oak_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.PALE_OAK, (BlockBase.Info)var0), Blocks.wallVariant(PALE_OAK_SIGN, true).mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block MANGROVE_WALL_SIGN = Blocks.register("mangrove_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.MANGROVE, (BlockBase.Info)var0), Blocks.wallVariant(MANGROVE_SIGN, true).mapColor(MANGROVE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BAMBOO_WALL_SIGN = Blocks.register("bamboo_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.BAMBOO, (BlockBase.Info)var0), Blocks.wallVariant(BAMBOO_SIGN, true).mapColor(BAMBOO_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block OAK_HANGING_SIGN = Blocks.register("oak_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(OAK_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block SPRUCE_HANGING_SIGN = Blocks.register("spruce_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.SPRUCE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(SPRUCE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BIRCH_HANGING_SIGN = Blocks.register("birch_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.BIRCH, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.SAND).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block ACACIA_HANGING_SIGN = Blocks.register("acacia_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.ACACIA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CHERRY_HANGING_SIGN = Blocks.register("cherry_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.CHERRY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_PINK).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block JUNGLE_HANGING_SIGN = Blocks.register("jungle_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.JUNGLE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(JUNGLE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block DARK_OAK_HANGING_SIGN = Blocks.register("dark_oak_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.DARK_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(DARK_OAK_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block PALE_OAK_HANGING_SIGN = Blocks.register("pale_oak_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.PALE_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CRIMSON_HANGING_SIGN = Blocks.register("crimson_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.CRIMSON, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.CRIMSON_STEM).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f));
    public static final Block WARPED_HANGING_SIGN = Blocks.register("warped_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.WARPED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WARPED_STEM).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f));
    public static final Block MANGROVE_HANGING_SIGN = Blocks.register("mangrove_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.MANGROVE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MANGROVE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BAMBOO_HANGING_SIGN = Blocks.register("bamboo_hanging_sign", (BlockBase.Info var0) -> new CeilingHangingSignBlock(BlockPropertyWood.BAMBOO, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block OAK_WALL_HANGING_SIGN = Blocks.register("oak_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.OAK, (BlockBase.Info)var0), Blocks.wallVariant(OAK_HANGING_SIGN, true).mapColor(OAK_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block SPRUCE_WALL_HANGING_SIGN = Blocks.register("spruce_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.SPRUCE, (BlockBase.Info)var0), Blocks.wallVariant(SPRUCE_HANGING_SIGN, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block BIRCH_WALL_HANGING_SIGN = Blocks.register("birch_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.BIRCH, (BlockBase.Info)var0), Blocks.wallVariant(BIRCH_HANGING_SIGN, true).mapColor(MaterialMapColor.SAND).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block ACACIA_WALL_HANGING_SIGN = Blocks.register("acacia_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.ACACIA, (BlockBase.Info)var0), Blocks.wallVariant(ACACIA_HANGING_SIGN, true).mapColor(MaterialMapColor.COLOR_ORANGE).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CHERRY_WALL_HANGING_SIGN = Blocks.register("cherry_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.CHERRY, (BlockBase.Info)var0), Blocks.wallVariant(CHERRY_HANGING_SIGN, true).mapColor(MaterialMapColor.TERRACOTTA_PINK).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block JUNGLE_WALL_HANGING_SIGN = Blocks.register("jungle_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.JUNGLE, (BlockBase.Info)var0), Blocks.wallVariant(JUNGLE_HANGING_SIGN, true).mapColor(JUNGLE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block DARK_OAK_WALL_HANGING_SIGN = Blocks.register("dark_oak_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.DARK_OAK, (BlockBase.Info)var0), Blocks.wallVariant(DARK_OAK_HANGING_SIGN, true).mapColor(DARK_OAK_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block PALE_OAK_WALL_HANGING_SIGN = Blocks.register("pale_oak_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.PALE_OAK, (BlockBase.Info)var0), Blocks.wallVariant(PALE_OAK_HANGING_SIGN, true).mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block MANGROVE_WALL_HANGING_SIGN = Blocks.register("mangrove_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.MANGROVE, (BlockBase.Info)var0), Blocks.wallVariant(MANGROVE_HANGING_SIGN, true).mapColor(MANGROVE_LOG.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block CRIMSON_WALL_HANGING_SIGN = Blocks.register("crimson_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.CRIMSON, (BlockBase.Info)var0), Blocks.wallVariant(CRIMSON_HANGING_SIGN, true).mapColor(MaterialMapColor.CRIMSON_STEM).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f));
    public static final Block WARPED_WALL_HANGING_SIGN = Blocks.register("warped_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.WARPED, (BlockBase.Info)var0), Blocks.wallVariant(WARPED_HANGING_SIGN, true).mapColor(MaterialMapColor.WARPED_STEM).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f));
    public static final Block BAMBOO_WALL_HANGING_SIGN = Blocks.register("bamboo_wall_hanging_sign", (BlockBase.Info var0) -> new WallHangingSignBlock(BlockPropertyWood.BAMBOO, (BlockBase.Info)var0), Blocks.wallVariant(BAMBOO_HANGING_SIGN, true).mapColor(MaterialMapColor.COLOR_YELLOW).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).ignitedByLava());
    public static final Block LEVER = Blocks.register("lever", BlockLever::new, BlockBase.Info.of().noCollision().strength(0.5f).sound(SoundEffectType.STONE).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block STONE_PRESSURE_PLATE = Blocks.register("stone_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.STONE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.STONE).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).noCollision().strength(0.5f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block IRON_DOOR = Blocks.register("iron_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.IRON, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.METAL).strength(5.0f).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block OAK_PRESSURE_PLATE = Blocks.register("oak_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SPRUCE_PRESSURE_PLATE = Blocks.register("spruce_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.SPRUCE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(SPRUCE_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BIRCH_PRESSURE_PLATE = Blocks.register("birch_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.BIRCH, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(BIRCH_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block JUNGLE_PRESSURE_PLATE = Blocks.register("jungle_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.JUNGLE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(JUNGLE_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ACACIA_PRESSURE_PLATE = Blocks.register("acacia_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.ACACIA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(ACACIA_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CHERRY_PRESSURE_PLATE = Blocks.register("cherry_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.CHERRY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CHERRY_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DARK_OAK_PRESSURE_PLATE = Blocks.register("dark_oak_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.DARK_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(DARK_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PALE_OAK_PRESSURE_PLATE = Blocks.register("pale_oak_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.PALE_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block MANGROVE_PRESSURE_PLATE = Blocks.register("mangrove_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.MANGROVE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MANGROVE_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BAMBOO_PRESSURE_PLATE = Blocks.register("bamboo_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.BAMBOO, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block REDSTONE_ORE = Blocks.register("redstone_ore", BlockRedstoneOre::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().randomTicks().lightLevel(Blocks.litBlockEmission(9)).strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_REDSTONE_ORE = Blocks.register("deepslate_redstone_ore", BlockRedstoneOre::new, BlockBase.Info.ofLegacyCopy(REDSTONE_ORE).mapColor(MaterialMapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundEffectType.DEEPSLATE));
    public static final Block REDSTONE_TORCH = Blocks.register("redstone_torch", BlockRedstoneTorch::new, BlockBase.Info.of().noCollision().instabreak().lightLevel(Blocks.litBlockEmission(7)).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block REDSTONE_WALL_TORCH = Blocks.register("redstone_wall_torch", BlockRedstoneTorchWall::new, Blocks.wallVariant(REDSTONE_TORCH, true).noCollision().instabreak().lightLevel(Blocks.litBlockEmission(7)).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block STONE_BUTTON = Blocks.register("stone_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.STONE, 20, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block SNOW = Blocks.register("snow", BlockSnow::new, BlockBase.Info.of().mapColor(MaterialMapColor.SNOW).replaceable().forceSolidOff().randomTicks().strength(0.1f).requiresCorrectToolForDrops().sound(SoundEffectType.SNOW).isViewBlocking((var0, var1, var2) -> var0.getValue(BlockSnow.LAYERS) >= 8).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ICE = Blocks.register("ice", BlockIce::new, BlockBase.Info.of().mapColor(MaterialMapColor.ICE).friction(0.98f).randomTicks().strength(0.5f).sound(SoundEffectType.GLASS).noOcclusion().isValidSpawn((var0, var1, var2, var3) -> var3 == EntityTypes.POLAR_BEAR).isRedstoneConductor(Blocks::never));
    public static final Block SNOW_BLOCK = Blocks.register("snow_block", BlockBase.Info.of().mapColor(MaterialMapColor.SNOW).requiresCorrectToolForDrops().strength(0.2f).sound(SoundEffectType.SNOW));
    public static final Block CACTUS = Blocks.register("cactus", BlockCactus::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).randomTicks().strength(0.4f).sound(SoundEffectType.WOOL).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CACTUS_FLOWER = Blocks.register("cactus_flower", CactusFlowerBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PINK).noCollision().instabreak().ignitedByLava().sound(SoundEffectType.CACTUS_FLOWER).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CLAY = Blocks.register("clay", BlockBase.Info.of().mapColor(MaterialMapColor.CLAY).instrument(BlockPropertyInstrument.FLUTE).strength(0.6f).sound(SoundEffectType.GRAVEL));
    public static final Block SUGAR_CANE = Blocks.register("sugar_cane", BlockReed::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block JUKEBOX = Blocks.register("jukebox", BlockJukeBox::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 6.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block OAK_FENCE = Blocks.register("oak_fence", BlockFence::new, BlockBase.Info.of().mapColor(OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block NETHERRACK = Blocks.register("netherrack", BlockNetherrack::new, BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundEffectType.NETHERRACK));
    public static final Block SOUL_SAND = Blocks.register("soul_sand", BlockSlowSand::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).instrument(BlockPropertyInstrument.COW_BELL).strength(0.5f).speedFactor(0.4f).sound(SoundEffectType.SOUL_SAND).isValidSpawn(Blocks::always).isRedstoneConductor(Blocks::always).isViewBlocking(Blocks::always).isSuffocating(Blocks::always));
    public static final Block SOUL_SOIL = Blocks.register("soul_soil", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).strength(0.5f).sound(SoundEffectType.SOUL_SOIL));
    public static final Block BASALT = Blocks.register("basalt", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(SoundEffectType.BASALT));
    public static final Block POLISHED_BASALT = Blocks.register("polished_basalt", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f).sound(SoundEffectType.BASALT));
    public static final Block SOUL_TORCH = Blocks.register("soul_torch", (BlockBase.Info var0) -> new BlockTorch(Particles.SOUL_FIRE_FLAME, (BlockBase.Info)var0), BlockBase.Info.of().noCollision().instabreak().lightLevel(var0 -> 10).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SOUL_WALL_TORCH = Blocks.register("soul_wall_torch", (BlockBase.Info var0) -> new BlockTorchWall(Particles.SOUL_FIRE_FLAME, (BlockBase.Info)var0), Blocks.wallVariant(SOUL_TORCH, true).noCollision().instabreak().lightLevel(var0 -> 10).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block COPPER_TORCH = Blocks.register("copper_torch", (BlockBase.Info var0) -> new BlockTorch(Particles.COPPER_FIRE_FLAME, (BlockBase.Info)var0), BlockBase.Info.of().noCollision().instabreak().lightLevel(var0 -> 14).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block COPPER_WALL_TORCH = Blocks.register("copper_wall_torch", (BlockBase.Info var0) -> new BlockTorchWall(Particles.COPPER_FIRE_FLAME, (BlockBase.Info)var0), Blocks.wallVariant(COPPER_TORCH, true).noCollision().instabreak().lightLevel(var0 -> 14).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block GLOWSTONE = Blocks.register("glowstone", BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.PLING).strength(0.3f).sound(SoundEffectType.GLASS).lightLevel(var0 -> 15).isRedstoneConductor(Blocks::never));
    public static final Block NETHER_PORTAL = Blocks.register("nether_portal", BlockPortal::new, BlockBase.Info.of().noCollision().randomTicks().strength(-1.0f).sound(SoundEffectType.GLASS).lightLevel(var0 -> 11).pushReaction(EnumPistonReaction.BLOCK));
    public static final Block CARVED_PUMPKIN = Blocks.register("carved_pumpkin", BlockPumpkinCarved::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).strength(1.0f).sound(SoundEffectType.WOOD).isValidSpawn(Blocks::always).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block JACK_O_LANTERN = Blocks.register("jack_o_lantern", BlockPumpkinCarved::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).strength(1.0f).sound(SoundEffectType.WOOD).lightLevel(var0 -> 15).isValidSpawn(Blocks::always).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CAKE = Blocks.register("cake", BlockCake::new, BlockBase.Info.of().forceSolidOn().strength(0.5f).sound(SoundEffectType.WOOL).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block REPEATER = Blocks.register("repeater", BlockRepeater::new, BlockBase.Info.of().instabreak().sound(SoundEffectType.STONE).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WHITE_STAINED_GLASS = Blocks.registerStainedGlass("white_stained_glass", EnumColor.WHITE);
    public static final Block ORANGE_STAINED_GLASS = Blocks.registerStainedGlass("orange_stained_glass", EnumColor.ORANGE);
    public static final Block MAGENTA_STAINED_GLASS = Blocks.registerStainedGlass("magenta_stained_glass", EnumColor.MAGENTA);
    public static final Block LIGHT_BLUE_STAINED_GLASS = Blocks.registerStainedGlass("light_blue_stained_glass", EnumColor.LIGHT_BLUE);
    public static final Block YELLOW_STAINED_GLASS = Blocks.registerStainedGlass("yellow_stained_glass", EnumColor.YELLOW);
    public static final Block LIME_STAINED_GLASS = Blocks.registerStainedGlass("lime_stained_glass", EnumColor.LIME);
    public static final Block PINK_STAINED_GLASS = Blocks.registerStainedGlass("pink_stained_glass", EnumColor.PINK);
    public static final Block GRAY_STAINED_GLASS = Blocks.registerStainedGlass("gray_stained_glass", EnumColor.GRAY);
    public static final Block LIGHT_GRAY_STAINED_GLASS = Blocks.registerStainedGlass("light_gray_stained_glass", EnumColor.LIGHT_GRAY);
    public static final Block CYAN_STAINED_GLASS = Blocks.registerStainedGlass("cyan_stained_glass", EnumColor.CYAN);
    public static final Block PURPLE_STAINED_GLASS = Blocks.registerStainedGlass("purple_stained_glass", EnumColor.PURPLE);
    public static final Block BLUE_STAINED_GLASS = Blocks.registerStainedGlass("blue_stained_glass", EnumColor.BLUE);
    public static final Block BROWN_STAINED_GLASS = Blocks.registerStainedGlass("brown_stained_glass", EnumColor.BROWN);
    public static final Block GREEN_STAINED_GLASS = Blocks.registerStainedGlass("green_stained_glass", EnumColor.GREEN);
    public static final Block RED_STAINED_GLASS = Blocks.registerStainedGlass("red_stained_glass", EnumColor.RED);
    public static final Block BLACK_STAINED_GLASS = Blocks.registerStainedGlass("black_stained_glass", EnumColor.BLACK);
    public static final Block OAK_TRAPDOOR = Blocks.register("oak_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block SPRUCE_TRAPDOOR = Blocks.register("spruce_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.SPRUCE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block BIRCH_TRAPDOOR = Blocks.register("birch_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.BIRCH, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block JUNGLE_TRAPDOOR = Blocks.register("jungle_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.JUNGLE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block ACACIA_TRAPDOOR = Blocks.register("acacia_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.ACACIA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block CHERRY_TRAPDOOR = Blocks.register("cherry_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.CHERRY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_WHITE).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block DARK_OAK_TRAPDOOR = Blocks.register("dark_oak_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.DARK_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block PALE_OAK_TRAPDOOR = Blocks.register("pale_oak_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.PALE_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block MANGROVE_TRAPDOOR = Blocks.register("mangrove_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.MANGROVE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block BAMBOO_TRAPDOOR = Blocks.register("bamboo_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.BAMBOO, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never).ignitedByLava());
    public static final Block STONE_BRICKS = Blocks.register("stone_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block MOSSY_STONE_BRICKS = Blocks.register("mossy_stone_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block CRACKED_STONE_BRICKS = Blocks.register("cracked_stone_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block CHISELED_STONE_BRICKS = Blocks.register("chiseled_stone_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PACKED_MUD = Blocks.register("packed_mud", BlockBase.Info.ofLegacyCopy(DIRT).strength(1.0f, 3.0f).sound(SoundEffectType.PACKED_MUD));
    public static final Block MUD_BRICKS = Blocks.register("mud_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GRAY).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 3.0f).sound(SoundEffectType.MUD_BRICKS));
    public static final Block INFESTED_STONE = Blocks.register("infested_stone", (BlockBase.Info var0) -> new BlockMonsterEggs(STONE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.CLAY));
    public static final Block INFESTED_COBBLESTONE = Blocks.register("infested_cobblestone", (BlockBase.Info var0) -> new BlockMonsterEggs(COBBLESTONE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.CLAY));
    public static final Block INFESTED_STONE_BRICKS = Blocks.register("infested_stone_bricks", (BlockBase.Info var0) -> new BlockMonsterEggs(STONE_BRICKS, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.CLAY));
    public static final Block INFESTED_MOSSY_STONE_BRICKS = Blocks.register("infested_mossy_stone_bricks", (BlockBase.Info var0) -> new BlockMonsterEggs(MOSSY_STONE_BRICKS, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.CLAY));
    public static final Block INFESTED_CRACKED_STONE_BRICKS = Blocks.register("infested_cracked_stone_bricks", (BlockBase.Info var0) -> new BlockMonsterEggs(CRACKED_STONE_BRICKS, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.CLAY));
    public static final Block INFESTED_CHISELED_STONE_BRICKS = Blocks.register("infested_chiseled_stone_bricks", (BlockBase.Info var0) -> new BlockMonsterEggs(CHISELED_STONE_BRICKS, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.CLAY));
    public static final Block BROWN_MUSHROOM_BLOCK = Blocks.register("brown_mushroom_block", BlockHugeMushroom::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).instrument(BlockPropertyInstrument.BASS).strength(0.2f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block RED_MUSHROOM_BLOCK = Blocks.register("red_mushroom_block", BlockHugeMushroom::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.BASS).strength(0.2f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block MUSHROOM_STEM = Blocks.register("mushroom_stem", BlockHugeMushroom::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOL).instrument(BlockPropertyInstrument.BASS).strength(0.2f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block IRON_BARS = Blocks.register("iron_bars", BlockIronBars::new, BlockBase.Info.of().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundEffectType.IRON).noOcclusion());
    public static final WeatheringCopperBlocks COPPER_BARS = WeatheringCopperBlocks.create("copper_bars", (TriFunction<String, Function<BlockBase.Info, Block>, BlockBase.Info, Block>)((TriFunction)Blocks::register), BlockIronBars::new, WeatheringCopperBarsBlock::new, var0 -> BlockBase.Info.of().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundEffectType.COPPER).noOcclusion());
    public static final Block IRON_CHAIN = Blocks.register("iron_chain", BlockChain::new, BlockBase.Info.of().forceSolidOn().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundEffectType.CHAIN).noOcclusion());
    public static final WeatheringCopperBlocks COPPER_CHAIN = WeatheringCopperBlocks.create("copper_chain", (TriFunction<String, Function<BlockBase.Info, Block>, BlockBase.Info, Block>)((TriFunction)Blocks::register), BlockChain::new, WeatheringCopperChainBlock::new, var0 -> BlockBase.Info.of().forceSolidOn().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundEffectType.CHAIN).noOcclusion());
    public static final Block GLASS_PANE = Blocks.register("glass_pane", BlockIronBars::new, BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block PUMPKIN = Blocks.register(net.minecraft.references.Blocks.PUMPKIN, BlockPumpkin::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.DIDGERIDOO).strength(1.0f).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block MELON = Blocks.register(net.minecraft.references.Blocks.MELON, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_GREEN).strength(1.0f).sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ATTACHED_PUMPKIN_STEM = Blocks.register(net.minecraft.references.Blocks.ATTACHED_PUMPKIN_STEM, (BlockBase.Info var0) -> new BlockStemAttached(net.minecraft.references.Blocks.PUMPKIN_STEM, net.minecraft.references.Blocks.PUMPKIN, Items.PUMPKIN_SEEDS, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ATTACHED_MELON_STEM = Blocks.register(net.minecraft.references.Blocks.ATTACHED_MELON_STEM, (BlockBase.Info var0) -> new BlockStemAttached(net.minecraft.references.Blocks.MELON_STEM, net.minecraft.references.Blocks.MELON, Items.MELON_SEEDS, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PUMPKIN_STEM = Blocks.register(net.minecraft.references.Blocks.PUMPKIN_STEM, (BlockBase.Info var0) -> new BlockStem(net.minecraft.references.Blocks.PUMPKIN, net.minecraft.references.Blocks.ATTACHED_PUMPKIN_STEM, Items.PUMPKIN_SEEDS, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.HARD_CROP).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block MELON_STEM = Blocks.register(net.minecraft.references.Blocks.MELON_STEM, (BlockBase.Info var0) -> new BlockStem(net.minecraft.references.Blocks.MELON, net.minecraft.references.Blocks.ATTACHED_MELON_STEM, Items.MELON_SEEDS, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.HARD_CROP).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block VINE = Blocks.register("vine", BlockVine::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).replaceable().noCollision().randomTicks().strength(0.2f).sound(SoundEffectType.VINE).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block GLOW_LICHEN = Blocks.register("glow_lichen", GlowLichenBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.GLOW_LICHEN).replaceable().noCollision().strength(0.2f).sound(SoundEffectType.GLOW_LICHEN).lightLevel(GlowLichenBlock.emission(7)).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block RESIN_CLUMP = Blocks.register("resin_clump", MultifaceBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_ORANGE).replaceable().noCollision().sound(SoundEffectType.RESIN).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block OAK_FENCE_GATE = Blocks.register("oak_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block BRICK_STAIRS = Blocks.registerLegacyStair("brick_stairs", BRICKS);
    public static final Block STONE_BRICK_STAIRS = Blocks.registerLegacyStair("stone_brick_stairs", STONE_BRICKS);
    public static final Block MUD_BRICK_STAIRS = Blocks.registerLegacyStair("mud_brick_stairs", MUD_BRICKS);
    public static final Block MYCELIUM = Blocks.register("mycelium", BlockMycel::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).randomTicks().strength(0.6f).sound(SoundEffectType.GRASS));
    public static final Block LILY_PAD = Blocks.register("lily_pad", BlockWaterLily::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).instabreak().sound(SoundEffectType.LILY_PAD).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block RESIN_BLOCK = Blocks.register("resin_block", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).sound(SoundEffectType.RESIN));
    public static final Block RESIN_BRICKS = Blocks.register("resin_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundEffectType.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Block RESIN_BRICK_STAIRS = Blocks.registerLegacyStair("resin_brick_stairs", RESIN_BRICKS);
    public static final Block RESIN_BRICK_SLAB = Blocks.register("resin_brick_slab", (BlockBase.Info var0) -> new BlockStepAbstract((BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundEffectType.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Block RESIN_BRICK_WALL = Blocks.register("resin_brick_wall", (BlockBase.Info var0) -> new BlockCobbleWall((BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundEffectType.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Block CHISELED_RESIN_BRICKS = Blocks.register("chiseled_resin_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(SoundEffectType.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Block NETHER_BRICKS = Blocks.register("nether_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundEffectType.NETHER_BRICKS));
    public static final Block NETHER_BRICK_FENCE = Blocks.register("nether_brick_fence", BlockFence::new, BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundEffectType.NETHER_BRICKS));
    public static final Block NETHER_BRICK_STAIRS = Blocks.registerLegacyStair("nether_brick_stairs", NETHER_BRICKS);
    public static final Block NETHER_WART = Blocks.register("nether_wart", BlockNetherWart::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).noCollision().randomTicks().sound(SoundEffectType.NETHER_WART).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ENCHANTING_TABLE = Blocks.register("enchanting_table", BlockEnchantmentTable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().lightLevel(var0 -> 7).strength(5.0f, 1200.0f));
    public static final Block BREWING_STAND = Blocks.register("brewing_stand", BlockBrewingStand::new, BlockBase.Info.of().mapColor(MaterialMapColor.METAL).strength(0.5f).lightLevel(var0 -> 1).noOcclusion());
    public static final Block CAULDRON = Blocks.register("cauldron", BlockCauldron::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).requiresCorrectToolForDrops().strength(2.0f).noOcclusion());
    public static final Block WATER_CAULDRON = Blocks.register("water_cauldron", (BlockBase.Info var0) -> new LayeredCauldronBlock(BiomeBase.Precipitation.RAIN, CauldronInteraction.WATER, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CAULDRON));
    public static final Block LAVA_CAULDRON = Blocks.register("lava_cauldron", LavaCauldronBlock::new, BlockBase.Info.ofLegacyCopy(CAULDRON).lightLevel(var0 -> 15));
    public static final Block POWDER_SNOW_CAULDRON = Blocks.register("powder_snow_cauldron", (BlockBase.Info var0) -> new LayeredCauldronBlock(BiomeBase.Precipitation.SNOW, CauldronInteraction.POWDER_SNOW, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CAULDRON));
    public static final Block END_PORTAL = Blocks.register("end_portal", BlockEnderPortal::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).noCollision().lightLevel(var0 -> 15).strength(-1.0f, 3600000.0f).noLootTable().pushReaction(EnumPistonReaction.BLOCK));
    public static final Block END_PORTAL_FRAME = Blocks.register("end_portal_frame", BlockEnderPortalFrame::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GREEN).instrument(BlockPropertyInstrument.BASEDRUM).sound(SoundEffectType.GLASS).lightLevel(var0 -> 1).strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block END_STONE = Blocks.register("end_stone", BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 9.0f));
    public static final Block DRAGON_EGG = Blocks.register("dragon_egg", BlockDragonEgg::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).strength(3.0f, 9.0f).lightLevel(var0 -> 1).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block REDSTONE_LAMP = Blocks.register("redstone_lamp", BlockRedstoneLamp::new, BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_ORANGE).lightLevel(Blocks.litBlockEmission(15)).strength(0.3f).sound(SoundEffectType.GLASS).isValidSpawn(Blocks::always));
    public static final Block COCOA = Blocks.register("cocoa", BlockCocoa::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).randomTicks().strength(0.2f, 3.0f).sound(SoundEffectType.WOOD).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SANDSTONE_STAIRS = Blocks.registerLegacyStair("sandstone_stairs", SANDSTONE);
    public static final Block EMERALD_ORE = Blocks.register("emerald_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(3, 7), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final Block DEEPSLATE_EMERALD_ORE = Blocks.register("deepslate_emerald_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(3, 7), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(EMERALD_ORE).mapColor(MaterialMapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundEffectType.DEEPSLATE));
    public static final Block ENDER_CHEST = Blocks.register("ender_chest", BlockEnderChest::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).strength(22.5f, 600.0f).lightLevel(var0 -> 7));
    public static final Block TRIPWIRE_HOOK = Blocks.register("tripwire_hook", BlockTripwireHook::new, BlockBase.Info.of().noCollision().sound(SoundEffectType.WOOD).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block TRIPWIRE = Blocks.register("tripwire", (BlockBase.Info var0) -> new BlockTripwire(TRIPWIRE_HOOK, (BlockBase.Info)var0), BlockBase.Info.of().noCollision().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block EMERALD_BLOCK = Blocks.register("emerald_block", BlockBase.Info.of().mapColor(MaterialMapColor.EMERALD).instrument(BlockPropertyInstrument.BIT).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundEffectType.METAL));
    public static final Block SPRUCE_STAIRS = Blocks.registerLegacyStair("spruce_stairs", SPRUCE_PLANKS);
    public static final Block BIRCH_STAIRS = Blocks.registerLegacyStair("birch_stairs", BIRCH_PLANKS);
    public static final Block JUNGLE_STAIRS = Blocks.registerLegacyStair("jungle_stairs", JUNGLE_PLANKS);
    public static final Block COMMAND_BLOCK = Blocks.register("command_block", (BlockBase.Info var0) -> new BlockCommand(false, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block BEACON = Blocks.register("beacon", BlockBeacon::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIAMOND).instrument(BlockPropertyInstrument.HAT).strength(3.0f).lightLevel(var0 -> 15).noOcclusion().isRedstoneConductor(Blocks::never));
    public static final Block COBBLESTONE_WALL = Blocks.register("cobblestone_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(COBBLESTONE).forceSolidOn());
    public static final Block MOSSY_COBBLESTONE_WALL = Blocks.register("mossy_cobblestone_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(COBBLESTONE).forceSolidOn());
    public static final Block FLOWER_POT = Blocks.register("flower_pot", (BlockBase.Info var0) -> new BlockFlowerPot(AIR, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_TORCHFLOWER = Blocks.register("potted_torchflower", (BlockBase.Info var0) -> new BlockFlowerPot(TORCHFLOWER, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_OAK_SAPLING = Blocks.register("potted_oak_sapling", (BlockBase.Info var0) -> new BlockFlowerPot(OAK_SAPLING, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_SPRUCE_SAPLING = Blocks.register("potted_spruce_sapling", (BlockBase.Info var0) -> new BlockFlowerPot(SPRUCE_SAPLING, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_BIRCH_SAPLING = Blocks.register("potted_birch_sapling", (BlockBase.Info var0) -> new BlockFlowerPot(BIRCH_SAPLING, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_JUNGLE_SAPLING = Blocks.register("potted_jungle_sapling", (BlockBase.Info var0) -> new BlockFlowerPot(JUNGLE_SAPLING, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_ACACIA_SAPLING = Blocks.register("potted_acacia_sapling", (BlockBase.Info var0) -> new BlockFlowerPot(ACACIA_SAPLING, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_CHERRY_SAPLING = Blocks.register("potted_cherry_sapling", (BlockBase.Info var0) -> new BlockFlowerPot(CHERRY_SAPLING, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_DARK_OAK_SAPLING = Blocks.register("potted_dark_oak_sapling", (BlockBase.Info var0) -> new BlockFlowerPot(DARK_OAK_SAPLING, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_PALE_OAK_SAPLING = Blocks.register("potted_pale_oak_sapling", (BlockBase.Info var0) -> new BlockFlowerPot(PALE_OAK_SAPLING, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_MANGROVE_PROPAGULE = Blocks.register("potted_mangrove_propagule", (BlockBase.Info var0) -> new BlockFlowerPot(MANGROVE_PROPAGULE, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_FERN = Blocks.register("potted_fern", (BlockBase.Info var0) -> new BlockFlowerPot(FERN, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_DANDELION = Blocks.register("potted_dandelion", (BlockBase.Info var0) -> new BlockFlowerPot(DANDELION, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_POPPY = Blocks.register("potted_poppy", (BlockBase.Info var0) -> new BlockFlowerPot(POPPY, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_BLUE_ORCHID = Blocks.register("potted_blue_orchid", (BlockBase.Info var0) -> new BlockFlowerPot(BLUE_ORCHID, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_ALLIUM = Blocks.register("potted_allium", (BlockBase.Info var0) -> new BlockFlowerPot(ALLIUM, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_AZURE_BLUET = Blocks.register("potted_azure_bluet", (BlockBase.Info var0) -> new BlockFlowerPot(AZURE_BLUET, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_RED_TULIP = Blocks.register("potted_red_tulip", (BlockBase.Info var0) -> new BlockFlowerPot(RED_TULIP, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_ORANGE_TULIP = Blocks.register("potted_orange_tulip", (BlockBase.Info var0) -> new BlockFlowerPot(ORANGE_TULIP, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_WHITE_TULIP = Blocks.register("potted_white_tulip", (BlockBase.Info var0) -> new BlockFlowerPot(WHITE_TULIP, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_PINK_TULIP = Blocks.register("potted_pink_tulip", (BlockBase.Info var0) -> new BlockFlowerPot(PINK_TULIP, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_OXEYE_DAISY = Blocks.register("potted_oxeye_daisy", (BlockBase.Info var0) -> new BlockFlowerPot(OXEYE_DAISY, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_CORNFLOWER = Blocks.register("potted_cornflower", (BlockBase.Info var0) -> new BlockFlowerPot(CORNFLOWER, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_LILY_OF_THE_VALLEY = Blocks.register("potted_lily_of_the_valley", (BlockBase.Info var0) -> new BlockFlowerPot(LILY_OF_THE_VALLEY, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_WITHER_ROSE = Blocks.register("potted_wither_rose", (BlockBase.Info var0) -> new BlockFlowerPot(WITHER_ROSE, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_RED_MUSHROOM = Blocks.register("potted_red_mushroom", (BlockBase.Info var0) -> new BlockFlowerPot(RED_MUSHROOM, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_BROWN_MUSHROOM = Blocks.register("potted_brown_mushroom", (BlockBase.Info var0) -> new BlockFlowerPot(BROWN_MUSHROOM, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_DEAD_BUSH = Blocks.register("potted_dead_bush", (BlockBase.Info var0) -> new BlockFlowerPot(DEAD_BUSH, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_CACTUS = Blocks.register("potted_cactus", (BlockBase.Info var0) -> new BlockFlowerPot(CACTUS, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block CARROTS = Blocks.register("carrots", BlockCarrots::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.CROP).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block POTATOES = Blocks.register("potatoes", BlockPotatoes::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.CROP).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block OAK_BUTTON = Blocks.register("oak_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.OAK, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block SPRUCE_BUTTON = Blocks.register("spruce_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.SPRUCE, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block BIRCH_BUTTON = Blocks.register("birch_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.BIRCH, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block JUNGLE_BUTTON = Blocks.register("jungle_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.JUNGLE, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block ACACIA_BUTTON = Blocks.register("acacia_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.ACACIA, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block CHERRY_BUTTON = Blocks.register("cherry_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.CHERRY, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block DARK_OAK_BUTTON = Blocks.register("dark_oak_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.DARK_OAK, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block PALE_OAK_BUTTON = Blocks.register("pale_oak_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.PALE_OAK, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block MANGROVE_BUTTON = Blocks.register("mangrove_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.MANGROVE, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block BAMBOO_BUTTON = Blocks.register("bamboo_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.BAMBOO, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block SKELETON_SKULL = Blocks.register("skeleton_skull", (BlockBase.Info var0) -> new BlockSkull(BlockSkull.Type.SKELETON, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.SKELETON).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SKELETON_WALL_SKULL = Blocks.register("skeleton_wall_skull", (BlockBase.Info var0) -> new BlockSkullWall(BlockSkull.Type.SKELETON, (BlockBase.Info)var0), Blocks.wallVariant(SKELETON_SKULL, true).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WITHER_SKELETON_SKULL = Blocks.register("wither_skeleton_skull", BlockWitherSkull::new, BlockBase.Info.of().instrument(BlockPropertyInstrument.WITHER_SKELETON).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WITHER_SKELETON_WALL_SKULL = Blocks.register("wither_skeleton_wall_skull", BlockWitherSkullWall::new, Blocks.wallVariant(WITHER_SKELETON_SKULL, true).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ZOMBIE_HEAD = Blocks.register("zombie_head", (BlockBase.Info var0) -> new BlockSkull(BlockSkull.Type.ZOMBIE, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.ZOMBIE).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ZOMBIE_WALL_HEAD = Blocks.register("zombie_wall_head", (BlockBase.Info var0) -> new BlockSkullWall(BlockSkull.Type.ZOMBIE, (BlockBase.Info)var0), Blocks.wallVariant(ZOMBIE_HEAD, true).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PLAYER_HEAD = Blocks.register("player_head", BlockSkullPlayer::new, BlockBase.Info.of().instrument(BlockPropertyInstrument.CUSTOM_HEAD).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PLAYER_WALL_HEAD = Blocks.register("player_wall_head", BlockSkullPlayerWall::new, Blocks.wallVariant(PLAYER_HEAD, true).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CREEPER_HEAD = Blocks.register("creeper_head", (BlockBase.Info var0) -> new BlockSkull(BlockSkull.Type.CREEPER, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.CREEPER).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CREEPER_WALL_HEAD = Blocks.register("creeper_wall_head", (BlockBase.Info var0) -> new BlockSkullWall(BlockSkull.Type.CREEPER, (BlockBase.Info)var0), Blocks.wallVariant(CREEPER_HEAD, true).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DRAGON_HEAD = Blocks.register("dragon_head", (BlockBase.Info var0) -> new BlockSkull(BlockSkull.Type.DRAGON, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.DRAGON).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DRAGON_WALL_HEAD = Blocks.register("dragon_wall_head", (BlockBase.Info var0) -> new BlockSkullWall(BlockSkull.Type.DRAGON, (BlockBase.Info)var0), Blocks.wallVariant(DRAGON_HEAD, true).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PIGLIN_HEAD = Blocks.register("piglin_head", (BlockBase.Info var0) -> new BlockSkull(BlockSkull.Type.PIGLIN, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.PIGLIN).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PIGLIN_WALL_HEAD = Blocks.register("piglin_wall_head", PiglinWallSkullBlock::new, Blocks.wallVariant(PIGLIN_HEAD, true).strength(1.0f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ANVIL = Blocks.register("anvil", BlockAnvil::new, BlockBase.Info.of().mapColor(MaterialMapColor.METAL).requiresCorrectToolForDrops().strength(5.0f, 1200.0f).sound(SoundEffectType.ANVIL).pushReaction(EnumPistonReaction.BLOCK));
    public static final Block CHIPPED_ANVIL = Blocks.register("chipped_anvil", BlockAnvil::new, BlockBase.Info.of().mapColor(MaterialMapColor.METAL).requiresCorrectToolForDrops().strength(5.0f, 1200.0f).sound(SoundEffectType.ANVIL).pushReaction(EnumPistonReaction.BLOCK));
    public static final Block DAMAGED_ANVIL = Blocks.register("damaged_anvil", BlockAnvil::new, BlockBase.Info.of().mapColor(MaterialMapColor.METAL).requiresCorrectToolForDrops().strength(5.0f, 1200.0f).sound(SoundEffectType.ANVIL).pushReaction(EnumPistonReaction.BLOCK));
    public static final Block TRAPPED_CHEST = Blocks.register("trapped_chest", BlockChestTrapped::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block LIGHT_WEIGHTED_PRESSURE_PLATE = Blocks.register("light_weighted_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateWeighted(15, BlockSetType.GOLD, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.GOLD).forceSolidOn().noCollision().strength(0.5f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block HEAVY_WEIGHTED_PRESSURE_PLATE = Blocks.register("heavy_weighted_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateWeighted(150, BlockSetType.IRON, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.METAL).forceSolidOn().noCollision().strength(0.5f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block COMPARATOR = Blocks.register("comparator", BlockRedstoneComparator::new, BlockBase.Info.of().instabreak().sound(SoundEffectType.STONE).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DAYLIGHT_DETECTOR = Blocks.register("daylight_detector", BlockDaylightDetector::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(0.2f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block REDSTONE_BLOCK = Blocks.register("redstone_block", BlockPowered::new, BlockBase.Info.of().mapColor(MaterialMapColor.FIRE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundEffectType.METAL).isRedstoneConductor(Blocks::never));
    public static final Block NETHER_QUARTZ_ORE = Blocks.register("nether_quartz_ore", (BlockBase.Info var0) -> new DropExperienceBlock(UniformInt.of(2, 5), (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f).sound(SoundEffectType.NETHER_ORE));
    public static final Block HOPPER = Blocks.register("hopper", BlockHopper::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).requiresCorrectToolForDrops().strength(3.0f, 4.8f).sound(SoundEffectType.METAL).noOcclusion());
    public static final Block QUARTZ_BLOCK = Blocks.register("quartz_block", BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CHISELED_QUARTZ_BLOCK = Blocks.register("chiseled_quartz_block", BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block QUARTZ_PILLAR = Blocks.register("quartz_pillar", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block QUARTZ_STAIRS = Blocks.registerLegacyStair("quartz_stairs", QUARTZ_BLOCK);
    public static final Block ACTIVATOR_RAIL = Blocks.register("activator_rail", BlockPoweredRail::new, BlockBase.Info.of().noCollision().strength(0.7f).sound(SoundEffectType.METAL));
    public static final Block DROPPER = Blocks.register("dropper", BlockDropper::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f));
    public static final Block WHITE_TERRACOTTA = Blocks.register("white_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_WHITE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block ORANGE_TERRACOTTA = Blocks.register("orange_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block MAGENTA_TERRACOTTA = Blocks.register("magenta_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_MAGENTA).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block LIGHT_BLUE_TERRACOTTA = Blocks.register("light_blue_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_LIGHT_BLUE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block YELLOW_TERRACOTTA = Blocks.register("yellow_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_YELLOW).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block LIME_TERRACOTTA = Blocks.register("lime_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GREEN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block PINK_TERRACOTTA = Blocks.register("pink_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_PINK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block GRAY_TERRACOTTA = Blocks.register("gray_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_GRAY).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block LIGHT_GRAY_TERRACOTTA = Blocks.register("light_gray_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GRAY).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block CYAN_TERRACOTTA = Blocks.register("cyan_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_CYAN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block PURPLE_TERRACOTTA = Blocks.register("purple_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_PURPLE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block BLUE_TERRACOTTA = Blocks.register("blue_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_BLUE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block BROWN_TERRACOTTA = Blocks.register("brown_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_BROWN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block GREEN_TERRACOTTA = Blocks.register("green_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_GREEN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block RED_TERRACOTTA = Blocks.register("red_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_RED).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block BLACK_TERRACOTTA = Blocks.register("black_terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block WHITE_STAINED_GLASS_PANE = Blocks.register("white_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.WHITE, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block ORANGE_STAINED_GLASS_PANE = Blocks.register("orange_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.ORANGE, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block MAGENTA_STAINED_GLASS_PANE = Blocks.register("magenta_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.MAGENTA, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block LIGHT_BLUE_STAINED_GLASS_PANE = Blocks.register("light_blue_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.LIGHT_BLUE, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block YELLOW_STAINED_GLASS_PANE = Blocks.register("yellow_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.YELLOW, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block LIME_STAINED_GLASS_PANE = Blocks.register("lime_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.LIME, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block PINK_STAINED_GLASS_PANE = Blocks.register("pink_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.PINK, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block GRAY_STAINED_GLASS_PANE = Blocks.register("gray_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.GRAY, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block LIGHT_GRAY_STAINED_GLASS_PANE = Blocks.register("light_gray_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.LIGHT_GRAY, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block CYAN_STAINED_GLASS_PANE = Blocks.register("cyan_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.CYAN, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block PURPLE_STAINED_GLASS_PANE = Blocks.register("purple_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.PURPLE, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block BLUE_STAINED_GLASS_PANE = Blocks.register("blue_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.BLUE, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block BROWN_STAINED_GLASS_PANE = Blocks.register("brown_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.BROWN, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block GREEN_STAINED_GLASS_PANE = Blocks.register("green_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.GREEN, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block RED_STAINED_GLASS_PANE = Blocks.register("red_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.RED, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block BLACK_STAINED_GLASS_PANE = Blocks.register("black_stained_glass_pane", (BlockBase.Info var0) -> new BlockStainedGlassPane(EnumColor.BLACK, (BlockBase.Info)var0), BlockBase.Info.of().instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion());
    public static final Block ACACIA_STAIRS = Blocks.registerLegacyStair("acacia_stairs", ACACIA_PLANKS);
    public static final Block CHERRY_STAIRS = Blocks.registerLegacyStair("cherry_stairs", CHERRY_PLANKS);
    public static final Block DARK_OAK_STAIRS = Blocks.registerLegacyStair("dark_oak_stairs", DARK_OAK_PLANKS);
    public static final Block PALE_OAK_STAIRS = Blocks.registerLegacyStair("pale_oak_stairs", PALE_OAK_PLANKS);
    public static final Block MANGROVE_STAIRS = Blocks.registerLegacyStair("mangrove_stairs", MANGROVE_PLANKS);
    public static final Block BAMBOO_STAIRS = Blocks.registerLegacyStair("bamboo_stairs", BAMBOO_PLANKS);
    public static final Block BAMBOO_MOSAIC_STAIRS = Blocks.registerLegacyStair("bamboo_mosaic_stairs", BAMBOO_MOSAIC);
    public static final Block SLIME_BLOCK = Blocks.register("slime_block", BlockSlime::new, BlockBase.Info.of().mapColor(MaterialMapColor.GRASS).friction(0.8f).sound(SoundEffectType.SLIME_BLOCK).noOcclusion());
    public static final Block BARRIER = Blocks.register("barrier", BlockBarrier::new, BlockBase.Info.of().strength(-1.0f, 3600000.8f).mapColor(Blocks.waterloggedMapColor(MaterialMapColor.NONE)).noLootTable().noOcclusion().isValidSpawn(Blocks::never).noTerrainParticles().pushReaction(EnumPistonReaction.BLOCK));
    public static final Block LIGHT = Blocks.register("light", LightBlock::new, BlockBase.Info.of().replaceable().strength(-1.0f, 3600000.8f).mapColor(Blocks.waterloggedMapColor(MaterialMapColor.NONE)).noLootTable().noOcclusion().lightLevel(LightBlock.LIGHT_EMISSION));
    public static final Block IRON_TRAPDOOR = Blocks.register("iron_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.IRON, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.METAL).requiresCorrectToolForDrops().strength(5.0f).noOcclusion().isValidSpawn(Blocks::never));
    public static final Block PRISMARINE = Blocks.register("prismarine", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PRISMARINE_BRICKS = Blocks.register("prismarine_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.DIAMOND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DARK_PRISMARINE = Blocks.register("dark_prismarine", BlockBase.Info.of().mapColor(MaterialMapColor.DIAMOND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PRISMARINE_STAIRS = Blocks.registerLegacyStair("prismarine_stairs", PRISMARINE);
    public static final Block PRISMARINE_BRICK_STAIRS = Blocks.registerLegacyStair("prismarine_brick_stairs", PRISMARINE_BRICKS);
    public static final Block DARK_PRISMARINE_STAIRS = Blocks.registerLegacyStair("dark_prismarine_stairs", DARK_PRISMARINE);
    public static final Block PRISMARINE_SLAB = Blocks.register("prismarine_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PRISMARINE_BRICK_SLAB = Blocks.register("prismarine_brick_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIAMOND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DARK_PRISMARINE_SLAB = Blocks.register("dark_prismarine_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIAMOND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block SEA_LANTERN = Blocks.register("sea_lantern", BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).lightLevel(var0 -> 15).isRedstoneConductor(Blocks::never));
    public static final Block HAY_BLOCK = Blocks.register("hay_block", BlockHay::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).instrument(BlockPropertyInstrument.BANJO).strength(0.5f).sound(SoundEffectType.GRASS));
    public static final Block WHITE_CARPET = Blocks.register("white_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.WHITE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.SNOW).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block ORANGE_CARPET = Blocks.register("orange_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.ORANGE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block MAGENTA_CARPET = Blocks.register("magenta_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.MAGENTA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_MAGENTA).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block LIGHT_BLUE_CARPET = Blocks.register("light_blue_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.LIGHT_BLUE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_BLUE).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block YELLOW_CARPET = Blocks.register("yellow_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.YELLOW, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block LIME_CARPET = Blocks.register("lime_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.LIME, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_GREEN).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block PINK_CARPET = Blocks.register("pink_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.PINK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PINK).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block GRAY_CARPET = Blocks.register("gray_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.GRAY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block LIGHT_GRAY_CARPET = Blocks.register("light_gray_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.LIGHT_GRAY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_GRAY).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block CYAN_CARPET = Blocks.register("cyan_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.CYAN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block PURPLE_CARPET = Blocks.register("purple_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.PURPLE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block BLUE_CARPET = Blocks.register("blue_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.BLUE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLUE).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block BROWN_CARPET = Blocks.register("brown_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.BROWN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block GREEN_CARPET = Blocks.register("green_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.GREEN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GREEN).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block RED_CARPET = Blocks.register("red_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.RED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block BLACK_CARPET = Blocks.register("black_carpet", (BlockBase.Info var0) -> new BlockCarpet(EnumColor.BLACK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).strength(0.1f).sound(SoundEffectType.WOOL).ignitedByLava());
    public static final Block TERRACOTTA = Blocks.register("terracotta", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.25f, 4.2f));
    public static final Block COAL_BLOCK = Blocks.register("coal_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
    public static final Block PACKED_ICE = Blocks.register("packed_ice", BlockBase.Info.of().mapColor(MaterialMapColor.ICE).instrument(BlockPropertyInstrument.CHIME).friction(0.98f).strength(0.5f).sound(SoundEffectType.GLASS));
    public static final Block SUNFLOWER = Blocks.register("sunflower", BlockTallPlantFlower::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block LILAC = Blocks.register("lilac", BlockTallPlantFlower::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ROSE_BUSH = Blocks.register("rose_bush", BlockTallPlantFlower::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PEONY = Blocks.register("peony", BlockTallPlantFlower::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block TALL_GRASS = Blocks.register("tall_grass", BlockTallPlant::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block LARGE_FERN = Blocks.register("large_fern", BlockTallPlant::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WHITE_BANNER = Blocks.register("white_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.WHITE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block ORANGE_BANNER = Blocks.register("orange_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.ORANGE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block MAGENTA_BANNER = Blocks.register("magenta_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.MAGENTA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block LIGHT_BLUE_BANNER = Blocks.register("light_blue_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.LIGHT_BLUE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block YELLOW_BANNER = Blocks.register("yellow_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.YELLOW, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block LIME_BANNER = Blocks.register("lime_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.LIME, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block PINK_BANNER = Blocks.register("pink_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.PINK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block GRAY_BANNER = Blocks.register("gray_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.GRAY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block LIGHT_GRAY_BANNER = Blocks.register("light_gray_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.LIGHT_GRAY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block CYAN_BANNER = Blocks.register("cyan_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.CYAN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block PURPLE_BANNER = Blocks.register("purple_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.PURPLE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BLUE_BANNER = Blocks.register("blue_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.BLUE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BROWN_BANNER = Blocks.register("brown_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.BROWN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block GREEN_BANNER = Blocks.register("green_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.GREEN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block RED_BANNER = Blocks.register("red_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.RED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BLACK_BANNER = Blocks.register("black_banner", (BlockBase.Info var0) -> new BlockBanner(EnumColor.BLACK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block WHITE_WALL_BANNER = Blocks.register("white_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.WHITE, (BlockBase.Info)var0), Blocks.wallVariant(WHITE_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block ORANGE_WALL_BANNER = Blocks.register("orange_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.ORANGE, (BlockBase.Info)var0), Blocks.wallVariant(ORANGE_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block MAGENTA_WALL_BANNER = Blocks.register("magenta_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.MAGENTA, (BlockBase.Info)var0), Blocks.wallVariant(MAGENTA_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block LIGHT_BLUE_WALL_BANNER = Blocks.register("light_blue_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.LIGHT_BLUE, (BlockBase.Info)var0), Blocks.wallVariant(LIGHT_BLUE_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block YELLOW_WALL_BANNER = Blocks.register("yellow_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.YELLOW, (BlockBase.Info)var0), Blocks.wallVariant(YELLOW_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block LIME_WALL_BANNER = Blocks.register("lime_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.LIME, (BlockBase.Info)var0), Blocks.wallVariant(LIME_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block PINK_WALL_BANNER = Blocks.register("pink_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.PINK, (BlockBase.Info)var0), Blocks.wallVariant(PINK_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block GRAY_WALL_BANNER = Blocks.register("gray_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.GRAY, (BlockBase.Info)var0), Blocks.wallVariant(GRAY_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block LIGHT_GRAY_WALL_BANNER = Blocks.register("light_gray_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.LIGHT_GRAY, (BlockBase.Info)var0), Blocks.wallVariant(LIGHT_GRAY_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block CYAN_WALL_BANNER = Blocks.register("cyan_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.CYAN, (BlockBase.Info)var0), Blocks.wallVariant(CYAN_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block PURPLE_WALL_BANNER = Blocks.register("purple_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.PURPLE, (BlockBase.Info)var0), Blocks.wallVariant(PURPLE_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BLUE_WALL_BANNER = Blocks.register("blue_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.BLUE, (BlockBase.Info)var0), Blocks.wallVariant(BLUE_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BROWN_WALL_BANNER = Blocks.register("brown_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.BROWN, (BlockBase.Info)var0), Blocks.wallVariant(BROWN_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block GREEN_WALL_BANNER = Blocks.register("green_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.GREEN, (BlockBase.Info)var0), Blocks.wallVariant(GREEN_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block RED_WALL_BANNER = Blocks.register("red_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.RED, (BlockBase.Info)var0), Blocks.wallVariant(RED_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BLACK_WALL_BANNER = Blocks.register("black_wall_banner", (BlockBase.Info var0) -> new BlockBannerWall(EnumColor.BLACK, (BlockBase.Info)var0), Blocks.wallVariant(BLACK_BANNER, true).mapColor(MaterialMapColor.WOOD).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(1.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block RED_SANDSTONE = Blocks.register("red_sandstone", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CHISELED_RED_SANDSTONE = Blocks.register("chiseled_red_sandstone", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block CUT_RED_SANDSTONE = Blocks.register("cut_red_sandstone", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.8f));
    public static final Block RED_SANDSTONE_STAIRS = Blocks.registerLegacyStair("red_sandstone_stairs", RED_SANDSTONE);
    public static final Block OAK_SLAB = Blocks.register("oak_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block SPRUCE_SLAB = Blocks.register("spruce_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BIRCH_SLAB = Blocks.register("birch_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block JUNGLE_SLAB = Blocks.register("jungle_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block ACACIA_SLAB = Blocks.register("acacia_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block CHERRY_SLAB = Blocks.register("cherry_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_WHITE).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.CHERRY_WOOD).ignitedByLava());
    public static final Block DARK_OAK_SLAB = Blocks.register("dark_oak_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block PALE_OAK_SLAB = Blocks.register("pale_oak_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block MANGROVE_SLAB = Blocks.register("mangrove_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BAMBOO_SLAB = Blocks.register("bamboo_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.BAMBOO_WOOD).ignitedByLava());
    public static final Block BAMBOO_MOSAIC_SLAB = Blocks.register("bamboo_mosaic_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.BAMBOO_WOOD).ignitedByLava());
    public static final Block STONE_SLAB = Blocks.register("stone_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_STONE_SLAB = Blocks.register("smooth_stone_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SANDSTONE_SLAB = Blocks.register("sandstone_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block CUT_SANDSTONE_SLAB = Blocks.register("cut_sandstone_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block PETRIFIED_OAK_SLAB = Blocks.register("petrified_oak_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block COBBLESTONE_SLAB = Blocks.register("cobblestone_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block BRICK_SLAB = Blocks.register("brick_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block STONE_BRICK_SLAB = Blocks.register("stone_brick_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block MUD_BRICK_SLAB = Blocks.register("mud_brick_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GRAY).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 3.0f).sound(SoundEffectType.MUD_BRICKS));
    public static final Block NETHER_BRICK_SLAB = Blocks.register("nether_brick_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundEffectType.NETHER_BRICKS));
    public static final Block QUARTZ_SLAB = Blocks.register("quartz_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block RED_SANDSTONE_SLAB = Blocks.register("red_sandstone_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block CUT_RED_SANDSTONE_SLAB = Blocks.register("cut_red_sandstone_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block PURPUR_SLAB = Blocks.register("purpur_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_MAGENTA).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_STONE = Blocks.register("smooth_stone", BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_SANDSTONE = Blocks.register("smooth_sandstone", BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_QUARTZ = Blocks.register("smooth_quartz", BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SMOOTH_RED_SANDSTONE = Blocks.register("smooth_red_sandstone", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
    public static final Block SPRUCE_FENCE_GATE = Blocks.register("spruce_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.SPRUCE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(SPRUCE_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block BIRCH_FENCE_GATE = Blocks.register("birch_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.BIRCH, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(BIRCH_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block JUNGLE_FENCE_GATE = Blocks.register("jungle_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.JUNGLE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(JUNGLE_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block ACACIA_FENCE_GATE = Blocks.register("acacia_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.ACACIA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(ACACIA_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block CHERRY_FENCE_GATE = Blocks.register("cherry_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.CHERRY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CHERRY_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block DARK_OAK_FENCE_GATE = Blocks.register("dark_oak_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.DARK_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(DARK_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block PALE_OAK_FENCE_GATE = Blocks.register("pale_oak_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.PALE_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block MANGROVE_FENCE_GATE = Blocks.register("mangrove_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.MANGROVE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MANGROVE_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block BAMBOO_FENCE_GATE = Blocks.register("bamboo_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.BAMBOO, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Block SPRUCE_FENCE = Blocks.register("spruce_fence", BlockFence::new, BlockBase.Info.of().mapColor(SPRUCE_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundEffectType.WOOD));
    public static final Block BIRCH_FENCE = Blocks.register("birch_fence", BlockFence::new, BlockBase.Info.of().mapColor(BIRCH_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundEffectType.WOOD));
    public static final Block JUNGLE_FENCE = Blocks.register("jungle_fence", BlockFence::new, BlockBase.Info.of().mapColor(JUNGLE_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundEffectType.WOOD));
    public static final Block ACACIA_FENCE = Blocks.register("acacia_fence", BlockFence::new, BlockBase.Info.of().mapColor(ACACIA_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundEffectType.WOOD));
    public static final Block CHERRY_FENCE = Blocks.register("cherry_fence", BlockFence::new, BlockBase.Info.of().mapColor(CHERRY_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundEffectType.CHERRY_WOOD));
    public static final Block DARK_OAK_FENCE = Blocks.register("dark_oak_fence", BlockFence::new, BlockBase.Info.of().mapColor(DARK_OAK_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundEffectType.WOOD));
    public static final Block PALE_OAK_FENCE = Blocks.register("pale_oak_fence", BlockFence::new, BlockBase.Info.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundEffectType.WOOD));
    public static final Block MANGROVE_FENCE = Blocks.register("mangrove_fence", BlockFence::new, BlockBase.Info.of().mapColor(MANGROVE_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundEffectType.WOOD));
    public static final Block BAMBOO_FENCE = Blocks.register("bamboo_fence", BlockFence::new, BlockBase.Info.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.BAMBOO_WOOD).ignitedByLava());
    public static final Block SPRUCE_DOOR = Blocks.register("spruce_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.SPRUCE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(SPRUCE_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BIRCH_DOOR = Blocks.register("birch_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.BIRCH, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(BIRCH_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block JUNGLE_DOOR = Blocks.register("jungle_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.JUNGLE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(JUNGLE_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ACACIA_DOOR = Blocks.register("acacia_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.ACACIA, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(ACACIA_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CHERRY_DOOR = Blocks.register("cherry_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.CHERRY, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CHERRY_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DARK_OAK_DOOR = Blocks.register("dark_oak_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.DARK_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(DARK_OAK_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PALE_OAK_DOOR = Blocks.register("pale_oak_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.PALE_OAK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(PALE_OAK_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block MANGROVE_DOOR = Blocks.register("mangrove_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.MANGROVE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MANGROVE_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BAMBOO_DOOR = Blocks.register("bamboo_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.BAMBOO, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(BAMBOO_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block END_ROD = Blocks.register("end_rod", BlockEndRod::new, BlockBase.Info.of().forceSolidOff().instabreak().lightLevel(var0 -> 14).sound(SoundEffectType.WOOD).noOcclusion());
    public static final Block CHORUS_PLANT = Blocks.register("chorus_plant", BlockChorusFruit::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).forceSolidOff().strength(0.4f).sound(SoundEffectType.WOOD).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CHORUS_FLOWER = Blocks.register("chorus_flower", (BlockBase.Info var0) -> new BlockChorusFlower(CHORUS_PLANT, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).forceSolidOff().randomTicks().strength(0.4f).sound(SoundEffectType.WOOD).noOcclusion().isValidSpawn(Blocks::never).pushReaction(EnumPistonReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block PURPUR_BLOCK = Blocks.register("purpur_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_MAGENTA).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PURPUR_PILLAR = Blocks.register("purpur_pillar", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_MAGENTA).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block PURPUR_STAIRS = Blocks.registerLegacyStair("purpur_stairs", PURPUR_BLOCK);
    public static final Block END_STONE_BRICKS = Blocks.register("end_stone_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 9.0f));
    public static final Block TORCHFLOWER_CROP = Blocks.register("torchflower_crop", TorchflowerCropBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.CROP).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PITCHER_CROP = Blocks.register("pitcher_crop", PitcherCropBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.CROP).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PITCHER_PLANT = Blocks.register("pitcher_plant", BlockTallPlant::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.CROP).offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BEETROOTS = Blocks.register("beetroots", BlockBeetroot::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().randomTicks().instabreak().sound(SoundEffectType.CROP).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DIRT_PATH = Blocks.register("dirt_path", BlockGrassPath::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).strength(0.65f).sound(SoundEffectType.GRASS).isViewBlocking(Blocks::always).isSuffocating(Blocks::always));
    public static final Block END_GATEWAY = Blocks.register("end_gateway", BlockEndGateway::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).noCollision().lightLevel(var0 -> 15).strength(-1.0f, 3600000.0f).noLootTable().pushReaction(EnumPistonReaction.BLOCK));
    public static final Block REPEATING_COMMAND_BLOCK = Blocks.register("repeating_command_block", (BlockBase.Info var0) -> new BlockCommand(false, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block CHAIN_COMMAND_BLOCK = Blocks.register("chain_command_block", (BlockBase.Info var0) -> new BlockCommand(true, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GREEN).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block FROSTED_ICE = Blocks.register("frosted_ice", BlockIceFrost::new, BlockBase.Info.of().mapColor(MaterialMapColor.ICE).friction(0.98f).strength(0.5f).sound(SoundEffectType.GLASS).noOcclusion().isValidSpawn((var0, var1, var2, var3) -> var3 == EntityTypes.POLAR_BEAR).isRedstoneConductor(Blocks::never));
    public static final Block MAGMA_BLOCK = Blocks.register("magma_block", BlockMagma::new, BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().lightLevel(var0 -> 3).strength(0.5f).isValidSpawn((var0, var1, var2, var3) -> var3.fireImmune()).hasPostProcess(Blocks::always).emissiveRendering(Blocks::always));
    public static final Block NETHER_WART_BLOCK = Blocks.register("nether_wart_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).strength(1.0f).sound(SoundEffectType.WART_BLOCK));
    public static final Block RED_NETHER_BRICKS = Blocks.register("red_nether_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundEffectType.NETHER_BRICKS));
    public static final Block BONE_BLOCK = Blocks.register("bone_block", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.SAND).instrument(BlockPropertyInstrument.XYLOPHONE).requiresCorrectToolForDrops().strength(2.0f).sound(SoundEffectType.BONE_BLOCK));
    public static final Block STRUCTURE_VOID = Blocks.register("structure_void", BlockStructureVoid::new, BlockBase.Info.of().replaceable().noCollision().noLootTable().noTerrainParticles().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block OBSERVER = Blocks.register("observer", BlockObserver::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).strength(3.0f).requiresCorrectToolForDrops().isRedstoneConductor(Blocks::never));
    public static final Block SHULKER_BOX = Blocks.register("shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(null, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_PURPLE));
    public static final Block WHITE_SHULKER_BOX = Blocks.register("white_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.WHITE, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.SNOW));
    public static final Block ORANGE_SHULKER_BOX = Blocks.register("orange_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.ORANGE, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_ORANGE));
    public static final Block MAGENTA_SHULKER_BOX = Blocks.register("magenta_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.MAGENTA, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_MAGENTA));
    public static final Block LIGHT_BLUE_SHULKER_BOX = Blocks.register("light_blue_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.LIGHT_BLUE, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_LIGHT_BLUE));
    public static final Block YELLOW_SHULKER_BOX = Blocks.register("yellow_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.YELLOW, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_YELLOW));
    public static final Block LIME_SHULKER_BOX = Blocks.register("lime_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.LIME, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_LIGHT_GREEN));
    public static final Block PINK_SHULKER_BOX = Blocks.register("pink_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.PINK, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_PINK));
    public static final Block GRAY_SHULKER_BOX = Blocks.register("gray_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.GRAY, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_GRAY));
    public static final Block LIGHT_GRAY_SHULKER_BOX = Blocks.register("light_gray_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.LIGHT_GRAY, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_LIGHT_GRAY));
    public static final Block CYAN_SHULKER_BOX = Blocks.register("cyan_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.CYAN, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_CYAN));
    public static final Block PURPLE_SHULKER_BOX = Blocks.register("purple_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.PURPLE, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.TERRACOTTA_PURPLE));
    public static final Block BLUE_SHULKER_BOX = Blocks.register("blue_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.BLUE, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_BLUE));
    public static final Block BROWN_SHULKER_BOX = Blocks.register("brown_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.BROWN, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_BROWN));
    public static final Block GREEN_SHULKER_BOX = Blocks.register("green_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.GREEN, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_GREEN));
    public static final Block RED_SHULKER_BOX = Blocks.register("red_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.RED, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_RED));
    public static final Block BLACK_SHULKER_BOX = Blocks.register("black_shulker_box", (BlockBase.Info var0) -> new BlockShulkerBox(EnumColor.BLACK, (BlockBase.Info)var0), Blocks.shulkerBoxProperties(MaterialMapColor.COLOR_BLACK));
    public static final Block WHITE_GLAZED_TERRACOTTA = Blocks.register("white_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.WHITE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block ORANGE_GLAZED_TERRACOTTA = Blocks.register("orange_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block MAGENTA_GLAZED_TERRACOTTA = Blocks.register("magenta_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.MAGENTA).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block LIGHT_BLUE_GLAZED_TERRACOTTA = Blocks.register("light_blue_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.LIGHT_BLUE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block YELLOW_GLAZED_TERRACOTTA = Blocks.register("yellow_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.YELLOW).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block LIME_GLAZED_TERRACOTTA = Blocks.register("lime_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.LIME).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block PINK_GLAZED_TERRACOTTA = Blocks.register("pink_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.PINK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block GRAY_GLAZED_TERRACOTTA = Blocks.register("gray_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.GRAY).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block LIGHT_GRAY_GLAZED_TERRACOTTA = Blocks.register("light_gray_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.LIGHT_GRAY).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block CYAN_GLAZED_TERRACOTTA = Blocks.register("cyan_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.CYAN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block PURPLE_GLAZED_TERRACOTTA = Blocks.register("purple_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.PURPLE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block BLUE_GLAZED_TERRACOTTA = Blocks.register("blue_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.BLUE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block BROWN_GLAZED_TERRACOTTA = Blocks.register("brown_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.BROWN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block GREEN_GLAZED_TERRACOTTA = Blocks.register("green_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.GREEN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block RED_GLAZED_TERRACOTTA = Blocks.register("red_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.RED).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block BLACK_GLAZED_TERRACOTTA = Blocks.register("black_glazed_terracotta", BlockGlazedTerracotta::new, BlockBase.Info.of().mapColor(EnumColor.BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.4f).pushReaction(EnumPistonReaction.PUSH_ONLY));
    public static final Block WHITE_CONCRETE = Blocks.register("white_concrete", BlockBase.Info.of().mapColor(EnumColor.WHITE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block ORANGE_CONCRETE = Blocks.register("orange_concrete", BlockBase.Info.of().mapColor(EnumColor.ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block MAGENTA_CONCRETE = Blocks.register("magenta_concrete", BlockBase.Info.of().mapColor(EnumColor.MAGENTA).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block LIGHT_BLUE_CONCRETE = Blocks.register("light_blue_concrete", BlockBase.Info.of().mapColor(EnumColor.LIGHT_BLUE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block YELLOW_CONCRETE = Blocks.register("yellow_concrete", BlockBase.Info.of().mapColor(EnumColor.YELLOW).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block LIME_CONCRETE = Blocks.register("lime_concrete", BlockBase.Info.of().mapColor(EnumColor.LIME).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block PINK_CONCRETE = Blocks.register("pink_concrete", BlockBase.Info.of().mapColor(EnumColor.PINK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block GRAY_CONCRETE = Blocks.register("gray_concrete", BlockBase.Info.of().mapColor(EnumColor.GRAY).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block LIGHT_GRAY_CONCRETE = Blocks.register("light_gray_concrete", BlockBase.Info.of().mapColor(EnumColor.LIGHT_GRAY).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block CYAN_CONCRETE = Blocks.register("cyan_concrete", BlockBase.Info.of().mapColor(EnumColor.CYAN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block PURPLE_CONCRETE = Blocks.register("purple_concrete", BlockBase.Info.of().mapColor(EnumColor.PURPLE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block BLUE_CONCRETE = Blocks.register("blue_concrete", BlockBase.Info.of().mapColor(EnumColor.BLUE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block BROWN_CONCRETE = Blocks.register("brown_concrete", BlockBase.Info.of().mapColor(EnumColor.BROWN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block GREEN_CONCRETE = Blocks.register("green_concrete", BlockBase.Info.of().mapColor(EnumColor.GREEN).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block RED_CONCRETE = Blocks.register("red_concrete", BlockBase.Info.of().mapColor(EnumColor.RED).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block BLACK_CONCRETE = Blocks.register("black_concrete", BlockBase.Info.of().mapColor(EnumColor.BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.8f));
    public static final Block WHITE_CONCRETE_POWDER = Blocks.register("white_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(WHITE_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.WHITE).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block ORANGE_CONCRETE_POWDER = Blocks.register("orange_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(ORANGE_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.ORANGE).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block MAGENTA_CONCRETE_POWDER = Blocks.register("magenta_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(MAGENTA_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.MAGENTA).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block LIGHT_BLUE_CONCRETE_POWDER = Blocks.register("light_blue_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(LIGHT_BLUE_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.LIGHT_BLUE).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block YELLOW_CONCRETE_POWDER = Blocks.register("yellow_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(YELLOW_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.YELLOW).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block LIME_CONCRETE_POWDER = Blocks.register("lime_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(LIME_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.LIME).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block PINK_CONCRETE_POWDER = Blocks.register("pink_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(PINK_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.PINK).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block GRAY_CONCRETE_POWDER = Blocks.register("gray_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(GRAY_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.GRAY).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block LIGHT_GRAY_CONCRETE_POWDER = Blocks.register("light_gray_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(LIGHT_GRAY_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.LIGHT_GRAY).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block CYAN_CONCRETE_POWDER = Blocks.register("cyan_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(CYAN_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.CYAN).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block PURPLE_CONCRETE_POWDER = Blocks.register("purple_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(PURPLE_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.PURPLE).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block BLUE_CONCRETE_POWDER = Blocks.register("blue_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(BLUE_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.BLUE).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block BROWN_CONCRETE_POWDER = Blocks.register("brown_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(BROWN_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.BROWN).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block GREEN_CONCRETE_POWDER = Blocks.register("green_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(GREEN_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.GREEN).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block RED_CONCRETE_POWDER = Blocks.register("red_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(RED_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.RED).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block BLACK_CONCRETE_POWDER = Blocks.register("black_concrete_powder", (BlockBase.Info var0) -> new BlockConcretePowder(BLACK_CONCRETE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(EnumColor.BLACK).instrument(BlockPropertyInstrument.SNARE).strength(0.5f).sound(SoundEffectType.SAND));
    public static final Block KELP = Blocks.register("kelp", BlockKelp::new, BlockBase.Info.of().mapColor(MaterialMapColor.WATER).noCollision().randomTicks().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block KELP_PLANT = Blocks.register("kelp_plant", BlockKelpPlant::new, BlockBase.Info.of().mapColor(MaterialMapColor.WATER).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DRIED_KELP_BLOCK = Blocks.register("dried_kelp_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GREEN).strength(0.5f, 2.5f).sound(SoundEffectType.GRASS));
    public static final Block TURTLE_EGG = Blocks.register("turtle_egg", BlockTurtleEgg::new, BlockBase.Info.of().mapColor(MaterialMapColor.SAND).forceSolidOn().strength(0.5f).sound(SoundEffectType.METAL).randomTicks().noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SNIFFER_EGG = Blocks.register("sniffer_egg", SnifferEggBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).strength(0.5f).sound(SoundEffectType.METAL).noOcclusion());
    public static final Block DRIED_GHAST = Blocks.register("dried_ghast", DriedGhastBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instabreak().sound(SoundEffectType.DRIED_GHAST).noOcclusion().randomTicks());
    public static final Block DEAD_TUBE_CORAL_BLOCK = Blocks.register("dead_tube_coral_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DEAD_BRAIN_CORAL_BLOCK = Blocks.register("dead_brain_coral_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DEAD_BUBBLE_CORAL_BLOCK = Blocks.register("dead_bubble_coral_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DEAD_FIRE_CORAL_BLOCK = Blocks.register("dead_fire_coral_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block DEAD_HORN_CORAL_BLOCK = Blocks.register("dead_horn_coral_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block TUBE_CORAL_BLOCK = Blocks.register("tube_coral_block", (BlockBase.Info var0) -> new BlockCoral(DEAD_TUBE_CORAL_BLOCK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLUE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundEffectType.CORAL_BLOCK));
    public static final Block BRAIN_CORAL_BLOCK = Blocks.register("brain_coral_block", (BlockBase.Info var0) -> new BlockCoral(DEAD_BRAIN_CORAL_BLOCK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PINK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundEffectType.CORAL_BLOCK));
    public static final Block BUBBLE_CORAL_BLOCK = Blocks.register("bubble_coral_block", (BlockBase.Info var0) -> new BlockCoral(DEAD_BUBBLE_CORAL_BLOCK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundEffectType.CORAL_BLOCK));
    public static final Block FIRE_CORAL_BLOCK = Blocks.register("fire_coral_block", (BlockBase.Info var0) -> new BlockCoral(DEAD_FIRE_CORAL_BLOCK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundEffectType.CORAL_BLOCK));
    public static final Block HORN_CORAL_BLOCK = Blocks.register("horn_coral_block", (BlockBase.Info var0) -> new BlockCoral(DEAD_HORN_CORAL_BLOCK, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundEffectType.CORAL_BLOCK));
    public static final Block DEAD_TUBE_CORAL = Blocks.register("dead_tube_coral", BlockCoralDead::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BRAIN_CORAL = Blocks.register("dead_brain_coral", BlockCoralDead::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BUBBLE_CORAL = Blocks.register("dead_bubble_coral", BlockCoralDead::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_FIRE_CORAL = Blocks.register("dead_fire_coral", BlockCoralDead::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_HORN_CORAL = Blocks.register("dead_horn_coral", BlockCoralDead::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block TUBE_CORAL = Blocks.register("tube_coral", (BlockBase.Info var0) -> new BlockCoralPlant(DEAD_TUBE_CORAL, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLUE).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BRAIN_CORAL = Blocks.register("brain_coral", (BlockBase.Info var0) -> new BlockCoralPlant(DEAD_BRAIN_CORAL, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PINK).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BUBBLE_CORAL = Blocks.register("bubble_coral", (BlockBase.Info var0) -> new BlockCoralPlant(DEAD_BUBBLE_CORAL, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block FIRE_CORAL = Blocks.register("fire_coral", (BlockBase.Info var0) -> new BlockCoralPlant(DEAD_FIRE_CORAL, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block HORN_CORAL = Blocks.register("horn_coral", (BlockBase.Info var0) -> new BlockCoralPlant(DEAD_HORN_CORAL, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DEAD_TUBE_CORAL_FAN = Blocks.register("dead_tube_coral_fan", BlockCoralFanAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BRAIN_CORAL_FAN = Blocks.register("dead_brain_coral_fan", BlockCoralFanAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BUBBLE_CORAL_FAN = Blocks.register("dead_bubble_coral_fan", BlockCoralFanAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_FIRE_CORAL_FAN = Blocks.register("dead_fire_coral_fan", BlockCoralFanAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_HORN_CORAL_FAN = Blocks.register("dead_horn_coral_fan", BlockCoralFanAbstract::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block TUBE_CORAL_FAN = Blocks.register("tube_coral_fan", (BlockBase.Info var0) -> new BlockCoralFan(DEAD_TUBE_CORAL_FAN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLUE).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BRAIN_CORAL_FAN = Blocks.register("brain_coral_fan", (BlockBase.Info var0) -> new BlockCoralFan(DEAD_BRAIN_CORAL_FAN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PINK).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BUBBLE_CORAL_FAN = Blocks.register("bubble_coral_fan", (BlockBase.Info var0) -> new BlockCoralFan(DEAD_BUBBLE_CORAL_FAN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block FIRE_CORAL_FAN = Blocks.register("fire_coral_fan", (BlockBase.Info var0) -> new BlockCoralFan(DEAD_FIRE_CORAL_FAN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block HORN_CORAL_FAN = Blocks.register("horn_coral_fan", (BlockBase.Info var0) -> new BlockCoralFan(DEAD_HORN_CORAL_FAN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block DEAD_TUBE_CORAL_WALL_FAN = Blocks.register("dead_tube_coral_wall_fan", BlockCoralFanWallAbstract::new, Blocks.wallVariant(DEAD_TUBE_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BRAIN_CORAL_WALL_FAN = Blocks.register("dead_brain_coral_wall_fan", BlockCoralFanWallAbstract::new, Blocks.wallVariant(DEAD_BRAIN_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_BUBBLE_CORAL_WALL_FAN = Blocks.register("dead_bubble_coral_wall_fan", BlockCoralFanWallAbstract::new, Blocks.wallVariant(DEAD_BUBBLE_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_FIRE_CORAL_WALL_FAN = Blocks.register("dead_fire_coral_wall_fan", BlockCoralFanWallAbstract::new, Blocks.wallVariant(DEAD_FIRE_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block DEAD_HORN_CORAL_WALL_FAN = Blocks.register("dead_horn_coral_wall_fan", BlockCoralFanWallAbstract::new, Blocks.wallVariant(DEAD_HORN_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_GRAY).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().noCollision().instabreak());
    public static final Block TUBE_CORAL_WALL_FAN = Blocks.register("tube_coral_wall_fan", (BlockBase.Info var0) -> new BlockCoralFanWall(DEAD_TUBE_CORAL_WALL_FAN, (BlockBase.Info)var0), Blocks.wallVariant(TUBE_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_BLUE).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BRAIN_CORAL_WALL_FAN = Blocks.register("brain_coral_wall_fan", (BlockBase.Info var0) -> new BlockCoralFanWall(DEAD_BRAIN_CORAL_WALL_FAN, (BlockBase.Info)var0), Blocks.wallVariant(BRAIN_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_PINK).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BUBBLE_CORAL_WALL_FAN = Blocks.register("bubble_coral_wall_fan", (BlockBase.Info var0) -> new BlockCoralFanWall(DEAD_BUBBLE_CORAL_WALL_FAN, (BlockBase.Info)var0), Blocks.wallVariant(BUBBLE_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_PURPLE).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block FIRE_CORAL_WALL_FAN = Blocks.register("fire_coral_wall_fan", (BlockBase.Info var0) -> new BlockCoralFanWall(DEAD_FIRE_CORAL_WALL_FAN, (BlockBase.Info)var0), Blocks.wallVariant(FIRE_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_RED).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block HORN_CORAL_WALL_FAN = Blocks.register("horn_coral_wall_fan", (BlockBase.Info var0) -> new BlockCoralFanWall(DEAD_HORN_CORAL_WALL_FAN, (BlockBase.Info)var0), Blocks.wallVariant(HORN_CORAL_FAN, false).mapColor(MaterialMapColor.COLOR_YELLOW).noCollision().instabreak().sound(SoundEffectType.WET_GRASS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SEA_PICKLE = Blocks.register("sea_pickle", BlockSeaPickle::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GREEN).lightLevel(var0 -> BlockSeaPickle.isDead(var0) ? 0 : 3 + 3 * var0.getValue(BlockSeaPickle.PICKLES)).sound(SoundEffectType.SLIME_BLOCK).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BLUE_ICE = Blocks.register("blue_ice", BlockHalfTransparent::new, BlockBase.Info.of().mapColor(MaterialMapColor.ICE).strength(2.8f).friction(0.989f).sound(SoundEffectType.GLASS));
    public static final Block CONDUIT = Blocks.register("conduit", BlockConduit::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIAMOND).forceSolidOn().instrument(BlockPropertyInstrument.HAT).strength(3.0f).lightLevel(var0 -> 15).noOcclusion());
    public static final Block BAMBOO_SAPLING = Blocks.register("bamboo_sapling", BlockBambooSapling::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).forceSolidOn().randomTicks().instabreak().noCollision().strength(1.0f).sound(SoundEffectType.BAMBOO_SAPLING).offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BAMBOO = Blocks.register("bamboo", BlockBamboo::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).forceSolidOn().randomTicks().instabreak().strength(1.0f).sound(SoundEffectType.BAMBOO).noOcclusion().dynamicShape().offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block POTTED_BAMBOO = Blocks.register("potted_bamboo", (BlockBase.Info var0) -> new BlockFlowerPot(BAMBOO, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block VOID_AIR = Blocks.register("void_air", BlockAir::new, BlockBase.Info.of().replaceable().noCollision().noLootTable().air());
    public static final Block CAVE_AIR = Blocks.register("cave_air", BlockAir::new, BlockBase.Info.of().replaceable().noCollision().noLootTable().air());
    public static final Block BUBBLE_COLUMN = Blocks.register("bubble_column", BlockBubbleColumn::new, BlockBase.Info.of().mapColor(MaterialMapColor.WATER).replaceable().noCollision().noLootTable().pushReaction(EnumPistonReaction.DESTROY).liquid().sound(SoundEffectType.EMPTY));
    public static final Block POLISHED_GRANITE_STAIRS = Blocks.registerLegacyStair("polished_granite_stairs", POLISHED_GRANITE);
    public static final Block SMOOTH_RED_SANDSTONE_STAIRS = Blocks.registerLegacyStair("smooth_red_sandstone_stairs", SMOOTH_RED_SANDSTONE);
    public static final Block MOSSY_STONE_BRICK_STAIRS = Blocks.registerLegacyStair("mossy_stone_brick_stairs", MOSSY_STONE_BRICKS);
    public static final Block POLISHED_DIORITE_STAIRS = Blocks.registerLegacyStair("polished_diorite_stairs", POLISHED_DIORITE);
    public static final Block MOSSY_COBBLESTONE_STAIRS = Blocks.registerLegacyStair("mossy_cobblestone_stairs", MOSSY_COBBLESTONE);
    public static final Block END_STONE_BRICK_STAIRS = Blocks.registerLegacyStair("end_stone_brick_stairs", END_STONE_BRICKS);
    public static final Block STONE_STAIRS = Blocks.registerLegacyStair("stone_stairs", STONE);
    public static final Block SMOOTH_SANDSTONE_STAIRS = Blocks.registerLegacyStair("smooth_sandstone_stairs", SMOOTH_SANDSTONE);
    public static final Block SMOOTH_QUARTZ_STAIRS = Blocks.registerLegacyStair("smooth_quartz_stairs", SMOOTH_QUARTZ);
    public static final Block GRANITE_STAIRS = Blocks.registerLegacyStair("granite_stairs", GRANITE);
    public static final Block ANDESITE_STAIRS = Blocks.registerLegacyStair("andesite_stairs", ANDESITE);
    public static final Block RED_NETHER_BRICK_STAIRS = Blocks.registerLegacyStair("red_nether_brick_stairs", RED_NETHER_BRICKS);
    public static final Block POLISHED_ANDESITE_STAIRS = Blocks.registerLegacyStair("polished_andesite_stairs", POLISHED_ANDESITE);
    public static final Block DIORITE_STAIRS = Blocks.registerLegacyStair("diorite_stairs", DIORITE);
    public static final Block POLISHED_GRANITE_SLAB = Blocks.register("polished_granite_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(POLISHED_GRANITE));
    public static final Block SMOOTH_RED_SANDSTONE_SLAB = Blocks.register("smooth_red_sandstone_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(SMOOTH_RED_SANDSTONE));
    public static final Block MOSSY_STONE_BRICK_SLAB = Blocks.register("mossy_stone_brick_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(MOSSY_STONE_BRICKS));
    public static final Block POLISHED_DIORITE_SLAB = Blocks.register("polished_diorite_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(POLISHED_DIORITE));
    public static final Block MOSSY_COBBLESTONE_SLAB = Blocks.register("mossy_cobblestone_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(MOSSY_COBBLESTONE));
    public static final Block END_STONE_BRICK_SLAB = Blocks.register("end_stone_brick_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(END_STONE_BRICKS));
    public static final Block SMOOTH_SANDSTONE_SLAB = Blocks.register("smooth_sandstone_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(SMOOTH_SANDSTONE));
    public static final Block SMOOTH_QUARTZ_SLAB = Blocks.register("smooth_quartz_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(SMOOTH_QUARTZ));
    public static final Block GRANITE_SLAB = Blocks.register("granite_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(GRANITE));
    public static final Block ANDESITE_SLAB = Blocks.register("andesite_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(ANDESITE));
    public static final Block RED_NETHER_BRICK_SLAB = Blocks.register("red_nether_brick_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(RED_NETHER_BRICKS));
    public static final Block POLISHED_ANDESITE_SLAB = Blocks.register("polished_andesite_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(POLISHED_ANDESITE));
    public static final Block DIORITE_SLAB = Blocks.register("diorite_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(DIORITE));
    public static final Block BRICK_WALL = Blocks.register("brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(BRICKS).forceSolidOn());
    public static final Block PRISMARINE_WALL = Blocks.register("prismarine_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(PRISMARINE).forceSolidOn());
    public static final Block RED_SANDSTONE_WALL = Blocks.register("red_sandstone_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(RED_SANDSTONE).forceSolidOn());
    public static final Block MOSSY_STONE_BRICK_WALL = Blocks.register("mossy_stone_brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(MOSSY_STONE_BRICKS).forceSolidOn());
    public static final Block GRANITE_WALL = Blocks.register("granite_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(GRANITE).forceSolidOn());
    public static final Block STONE_BRICK_WALL = Blocks.register("stone_brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(STONE_BRICKS).forceSolidOn());
    public static final Block MUD_BRICK_WALL = Blocks.register("mud_brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(MUD_BRICKS).forceSolidOn());
    public static final Block NETHER_BRICK_WALL = Blocks.register("nether_brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(NETHER_BRICKS).forceSolidOn());
    public static final Block ANDESITE_WALL = Blocks.register("andesite_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(ANDESITE).forceSolidOn());
    public static final Block RED_NETHER_BRICK_WALL = Blocks.register("red_nether_brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(RED_NETHER_BRICKS).forceSolidOn());
    public static final Block SANDSTONE_WALL = Blocks.register("sandstone_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(SANDSTONE).forceSolidOn());
    public static final Block END_STONE_BRICK_WALL = Blocks.register("end_stone_brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(END_STONE_BRICKS).forceSolidOn());
    public static final Block DIORITE_WALL = Blocks.register("diorite_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(DIORITE).forceSolidOn());
    public static final Block SCAFFOLDING = Blocks.register("scaffolding", BlockScaffolding::new, BlockBase.Info.of().mapColor(MaterialMapColor.SAND).noCollision().sound(SoundEffectType.SCAFFOLDING).dynamicShape().isValidSpawn(Blocks::never).pushReaction(EnumPistonReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block LOOM = Blocks.register("loom", BlockLoom::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BARREL = Blocks.register("barrel", BlockBarrel::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block SMOKER = Blocks.register("smoker", BlockSmoker::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f).lightLevel(Blocks.litBlockEmission(13)));
    public static final Block BLAST_FURNACE = Blocks.register("blast_furnace", BlockBlastFurnace::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f).lightLevel(Blocks.litBlockEmission(13)));
    public static final Block CARTOGRAPHY_TABLE = Blocks.register("cartography_table", BlockCartographyTable::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block FLETCHING_TABLE = Blocks.register("fletching_table", BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block GRINDSTONE = Blocks.register("grindstone", BlockGrindstone::new, BlockBase.Info.of().mapColor(MaterialMapColor.METAL).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundEffectType.STONE).pushReaction(EnumPistonReaction.BLOCK));
    public static final Block LECTERN = Blocks.register("lectern", BlockLectern::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block SMITHING_TABLE = Blocks.register("smithing_table", BlockSmithingTable::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(2.5f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block STONECUTTER = Blocks.register("stonecutter", BlockStonecutter::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f));
    public static final Block BELL = Blocks.register("bell", BlockBell::new, BlockBase.Info.of().mapColor(MaterialMapColor.GOLD).forceSolidOn().strength(5.0f).sound(SoundEffectType.ANVIL).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block LANTERN = Blocks.register("lantern", BlockLantern::new, BlockBase.Info.of().mapColor(MaterialMapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundEffectType.LANTERN).lightLevel(var0 -> 15).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SOUL_LANTERN = Blocks.register("soul_lantern", BlockLantern::new, BlockBase.Info.of().mapColor(MaterialMapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundEffectType.LANTERN).lightLevel(var0 -> 10).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final WeatheringCopperBlocks COPPER_LANTERN = WeatheringCopperBlocks.create("copper_lantern", (TriFunction<String, Function<BlockBase.Info, Block>, BlockBase.Info, Block>)((TriFunction)Blocks::register), BlockLantern::new, WeatheringLanternBlock::new, var02 -> BlockBase.Info.of().mapColor(MaterialMapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundEffectType.LANTERN).lightLevel(var0 -> 15).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CAMPFIRE = Blocks.register("campfire", (BlockBase.Info var0) -> new BlockCampfire(true, 1, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).lightLevel(Blocks.litBlockEmission(15)).noOcclusion().ignitedByLava());
    public static final Block SOUL_CAMPFIRE = Blocks.register("soul_campfire", (BlockBase.Info var0) -> new BlockCampfire(false, 2, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.PODZOL).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.WOOD).lightLevel(Blocks.litBlockEmission(10)).noOcclusion().ignitedByLava());
    public static final Block SWEET_BERRY_BUSH = Blocks.register("sweet_berry_bush", BlockSweetBerryBush::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).randomTicks().noCollision().sound(SoundEffectType.SWEET_BERRY_BUSH).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WARPED_STEM = Blocks.register("warped_stem", BlockRotatable::new, Blocks.netherStemProperties(MaterialMapColor.WARPED_STEM));
    public static final Block STRIPPED_WARPED_STEM = Blocks.register("stripped_warped_stem", BlockRotatable::new, Blocks.netherStemProperties(MaterialMapColor.WARPED_STEM));
    public static final Block WARPED_HYPHAE = Blocks.register("warped_hyphae", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.WARPED_HYPHAE).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.STEM));
    public static final Block STRIPPED_WARPED_HYPHAE = Blocks.register("stripped_warped_hyphae", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.WARPED_HYPHAE).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.STEM));
    public static final Block WARPED_NYLIUM = Blocks.register("warped_nylium", BlockNylium::new, BlockBase.Info.of().mapColor(MaterialMapColor.WARPED_NYLIUM).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundEffectType.NYLIUM).randomTicks());
    public static final Block WARPED_FUNGUS = Blocks.register("warped_fungus", (BlockBase.Info var0) -> new BlockFungi(TreeFeatures.WARPED_FUNGUS_PLANTED, WARPED_NYLIUM, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).instabreak().noCollision().sound(SoundEffectType.FUNGUS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WARPED_WART_BLOCK = Blocks.register("warped_wart_block", BlockBase.Info.of().mapColor(MaterialMapColor.WARPED_WART_BLOCK).strength(1.0f).sound(SoundEffectType.WART_BLOCK));
    public static final Block WARPED_ROOTS = Blocks.register("warped_roots", BlockRoots::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).replaceable().noCollision().instabreak().sound(SoundEffectType.ROOTS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block NETHER_SPROUTS = Blocks.register("nether_sprouts", BlockNetherSprouts::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).replaceable().noCollision().instabreak().sound(SoundEffectType.NETHER_SPROUTS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CRIMSON_STEM = Blocks.register("crimson_stem", BlockRotatable::new, Blocks.netherStemProperties(MaterialMapColor.CRIMSON_STEM));
    public static final Block STRIPPED_CRIMSON_STEM = Blocks.register("stripped_crimson_stem", BlockRotatable::new, Blocks.netherStemProperties(MaterialMapColor.CRIMSON_STEM));
    public static final Block CRIMSON_HYPHAE = Blocks.register("crimson_hyphae", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.CRIMSON_HYPHAE).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.STEM));
    public static final Block STRIPPED_CRIMSON_HYPHAE = Blocks.register("stripped_crimson_hyphae", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.CRIMSON_HYPHAE).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.STEM));
    public static final Block CRIMSON_NYLIUM = Blocks.register("crimson_nylium", BlockNylium::new, BlockBase.Info.of().mapColor(MaterialMapColor.CRIMSON_NYLIUM).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.4f).sound(SoundEffectType.NYLIUM).randomTicks());
    public static final Block CRIMSON_FUNGUS = Blocks.register("crimson_fungus", (BlockBase.Info var0) -> new BlockFungi(TreeFeatures.CRIMSON_FUNGUS_PLANTED, CRIMSON_NYLIUM, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instabreak().noCollision().sound(SoundEffectType.FUNGUS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SHROOMLIGHT = Blocks.register("shroomlight", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_RED).strength(1.0f).sound(SoundEffectType.SHROOMLIGHT).lightLevel(var0 -> 15));
    public static final Block WEEPING_VINES = Blocks.register("weeping_vines", BlockWeepingVines::new, BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).randomTicks().noCollision().instabreak().sound(SoundEffectType.WEEPING_VINES).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WEEPING_VINES_PLANT = Blocks.register("weeping_vines_plant", BlockWeepingVinesPlant::new, BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).noCollision().instabreak().sound(SoundEffectType.WEEPING_VINES).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block TWISTING_VINES = Blocks.register("twisting_vines", BlockTwistingVines::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).randomTicks().noCollision().instabreak().sound(SoundEffectType.WEEPING_VINES).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block TWISTING_VINES_PLANT = Blocks.register("twisting_vines_plant", BlockTwistingVinesPlant::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).noCollision().instabreak().sound(SoundEffectType.WEEPING_VINES).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CRIMSON_ROOTS = Blocks.register("crimson_roots", BlockRoots::new, BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).replaceable().noCollision().instabreak().sound(SoundEffectType.ROOTS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CRIMSON_PLANKS = Blocks.register("crimson_planks", BlockBase.Info.of().mapColor(MaterialMapColor.CRIMSON_STEM).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.NETHER_WOOD));
    public static final Block WARPED_PLANKS = Blocks.register("warped_planks", BlockBase.Info.of().mapColor(MaterialMapColor.WARPED_STEM).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.NETHER_WOOD));
    public static final Block CRIMSON_SLAB = Blocks.register("crimson_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.NETHER_WOOD));
    public static final Block WARPED_SLAB = Blocks.register("warped_slab", BlockStepAbstract::new, BlockBase.Info.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.NETHER_WOOD));
    public static final Block CRIMSON_PRESSURE_PLATE = Blocks.register("crimson_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.CRIMSON, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WARPED_PRESSURE_PLATE = Blocks.register("warped_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.WARPED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(WARPED_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).noCollision().strength(0.5f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CRIMSON_FENCE = Blocks.register("crimson_fence", BlockFence::new, BlockBase.Info.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.NETHER_WOOD));
    public static final Block WARPED_FENCE = Blocks.register("warped_fence", BlockFence::new, BlockBase.Info.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f).sound(SoundEffectType.NETHER_WOOD));
    public static final Block CRIMSON_TRAPDOOR = Blocks.register("crimson_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.CRIMSON, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never));
    public static final Block WARPED_TRAPDOOR = Blocks.register("warped_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.WARPED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never));
    public static final Block CRIMSON_FENCE_GATE = Blocks.register("crimson_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.CRIMSON, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f));
    public static final Block WARPED_FENCE_GATE = Blocks.register("warped_fence_gate", (BlockBase.Info var0) -> new BlockFenceGate(BlockPropertyWood.WARPED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(WARPED_PLANKS.defaultMapColor()).forceSolidOn().instrument(BlockPropertyInstrument.BASS).strength(2.0f, 3.0f));
    public static final Block CRIMSON_STAIRS = Blocks.registerLegacyStair("crimson_stairs", CRIMSON_PLANKS);
    public static final Block WARPED_STAIRS = Blocks.registerLegacyStair("warped_stairs", WARPED_PLANKS);
    public static final Block CRIMSON_BUTTON = Blocks.register("crimson_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.CRIMSON, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block WARPED_BUTTON = Blocks.register("warped_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.WARPED, 30, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block CRIMSON_DOOR = Blocks.register("crimson_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.CRIMSON, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WARPED_DOOR = Blocks.register("warped_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.WARPED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).strength(3.0f).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CRIMSON_SIGN = Blocks.register("crimson_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.CRIMSON, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).forceSolidOn().noCollision().strength(1.0f));
    public static final Block WARPED_SIGN = Blocks.register("warped_sign", (BlockBase.Info var0) -> new BlockFloorSign(BlockPropertyWood.WARPED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(WARPED_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).forceSolidOn().noCollision().strength(1.0f));
    public static final Block CRIMSON_WALL_SIGN = Blocks.register("crimson_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.CRIMSON, (BlockBase.Info)var0), Blocks.wallVariant(CRIMSON_SIGN, true).mapColor(CRIMSON_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).forceSolidOn().noCollision().strength(1.0f));
    public static final Block WARPED_WALL_SIGN = Blocks.register("warped_wall_sign", (BlockBase.Info var0) -> new BlockWallSign(BlockPropertyWood.WARPED, (BlockBase.Info)var0), Blocks.wallVariant(WARPED_SIGN, true).mapColor(WARPED_PLANKS.defaultMapColor()).instrument(BlockPropertyInstrument.BASS).forceSolidOn().noCollision().strength(1.0f));
    public static final Block STRUCTURE_BLOCK = Blocks.register("structure_block", BlockStructure::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_GRAY).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block JIGSAW = Blocks.register("jigsaw", BlockJigsaw::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_GRAY).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block TEST_BLOCK = Blocks.register("test_block", TestBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_LIGHT_GRAY).strength(-1.0f, 3600000.0f).noLootTable());
    public static final Block TEST_INSTANCE_BLOCK = Blocks.register("test_instance_block", TestInstanceBlock::new, BlockBase.Info.of().noOcclusion().strength(-1.0f, 3600000.0f).noLootTable().isViewBlocking(Blocks::never));
    public static final Block COMPOSTER = Blocks.register("composter", BlockComposter::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(0.6f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block TARGET = Blocks.register("target", BlockTarget::new, BlockBase.Info.of().mapColor(MaterialMapColor.QUARTZ).strength(0.5f).sound(SoundEffectType.GRASS));
    public static final Block BEE_NEST = Blocks.register("bee_nest", BlockBeehive::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_YELLOW).instrument(BlockPropertyInstrument.BASS).strength(0.3f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block BEEHIVE = Blocks.register("beehive", BlockBeehive::new, BlockBase.Info.of().mapColor(MaterialMapColor.WOOD).instrument(BlockPropertyInstrument.BASS).strength(0.6f).sound(SoundEffectType.WOOD).ignitedByLava());
    public static final Block HONEY_BLOCK = Blocks.register("honey_block", BlockHoney::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).speedFactor(0.4f).jumpFactor(0.5f).noOcclusion().sound(SoundEffectType.HONEY_BLOCK));
    public static final Block HONEYCOMB_BLOCK = Blocks.register("honeycomb_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).strength(0.6f).sound(SoundEffectType.CORAL_BLOCK));
    public static final Block NETHERITE_BLOCK = Blocks.register("netherite_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).sound(SoundEffectType.NETHERITE_BLOCK));
    public static final Block ANCIENT_DEBRIS = Blocks.register("ancient_debris", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(30.0f, 1200.0f).sound(SoundEffectType.ANCIENT_DEBRIS));
    public static final Block CRYING_OBSIDIAN = Blocks.register("crying_obsidian", BlockCryingObsidian::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).lightLevel(var0 -> 10));
    public static final Block RESPAWN_ANCHOR = Blocks.register("respawn_anchor", BlockRespawnAnchor::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).lightLevel(var0 -> BlockRespawnAnchor.getScaledChargeLevel(var0, 15)));
    public static final Block POTTED_CRIMSON_FUNGUS = Blocks.register("potted_crimson_fungus", (BlockBase.Info var0) -> new BlockFlowerPot(CRIMSON_FUNGUS, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_WARPED_FUNGUS = Blocks.register("potted_warped_fungus", (BlockBase.Info var0) -> new BlockFlowerPot(WARPED_FUNGUS, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_CRIMSON_ROOTS = Blocks.register("potted_crimson_roots", (BlockBase.Info var0) -> new BlockFlowerPot(CRIMSON_ROOTS, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_WARPED_ROOTS = Blocks.register("potted_warped_roots", (BlockBase.Info var0) -> new BlockFlowerPot(WARPED_ROOTS, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block LODESTONE = Blocks.register("lodestone", BlockBase.Info.of().mapColor(MaterialMapColor.METAL).requiresCorrectToolForDrops().strength(3.5f).sound(SoundEffectType.LODESTONE).pushReaction(EnumPistonReaction.BLOCK));
    public static final Block BLACKSTONE = Blocks.register("blackstone", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block BLACKSTONE_STAIRS = Blocks.registerLegacyStair("blackstone_stairs", BLACKSTONE);
    public static final Block BLACKSTONE_WALL = Blocks.register("blackstone_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(BLACKSTONE).forceSolidOn());
    public static final Block BLACKSTONE_SLAB = Blocks.register("blackstone_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(BLACKSTONE).strength(2.0f, 6.0f));
    public static final Block POLISHED_BLACKSTONE = Blocks.register("polished_blackstone", BlockBase.Info.ofLegacyCopy(BLACKSTONE).strength(2.0f, 6.0f));
    public static final Block POLISHED_BLACKSTONE_BRICKS = Blocks.register("polished_blackstone_bricks", BlockBase.Info.ofLegacyCopy(POLISHED_BLACKSTONE).strength(1.5f, 6.0f));
    public static final Block CRACKED_POLISHED_BLACKSTONE_BRICKS = Blocks.register("cracked_polished_blackstone_bricks", BlockBase.Info.ofLegacyCopy(POLISHED_BLACKSTONE_BRICKS));
    public static final Block CHISELED_POLISHED_BLACKSTONE = Blocks.register("chiseled_polished_blackstone", BlockBase.Info.ofLegacyCopy(POLISHED_BLACKSTONE).strength(1.5f, 6.0f));
    public static final Block POLISHED_BLACKSTONE_BRICK_SLAB = Blocks.register("polished_blackstone_brick_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(POLISHED_BLACKSTONE_BRICKS).strength(2.0f, 6.0f));
    public static final Block POLISHED_BLACKSTONE_BRICK_STAIRS = Blocks.registerLegacyStair("polished_blackstone_brick_stairs", POLISHED_BLACKSTONE_BRICKS);
    public static final Block POLISHED_BLACKSTONE_BRICK_WALL = Blocks.register("polished_blackstone_brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(POLISHED_BLACKSTONE_BRICKS).forceSolidOn());
    public static final Block GILDED_BLACKSTONE = Blocks.register("gilded_blackstone", BlockBase.Info.ofLegacyCopy(BLACKSTONE).sound(SoundEffectType.GILDED_BLACKSTONE));
    public static final Block POLISHED_BLACKSTONE_STAIRS = Blocks.registerLegacyStair("polished_blackstone_stairs", POLISHED_BLACKSTONE);
    public static final Block POLISHED_BLACKSTONE_SLAB = Blocks.register("polished_blackstone_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(POLISHED_BLACKSTONE));
    public static final Block POLISHED_BLACKSTONE_PRESSURE_PLATE = Blocks.register("polished_blackstone_pressure_plate", (BlockBase.Info var0) -> new BlockPressurePlateBinary(BlockSetType.POLISHED_BLACKSTONE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).noCollision().strength(0.5f).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block POLISHED_BLACKSTONE_BUTTON = Blocks.register("polished_blackstone_button", (BlockBase.Info var0) -> new BlockButtonAbstract(BlockSetType.STONE, 20, (BlockBase.Info)var0), Blocks.buttonProperties());
    public static final Block POLISHED_BLACKSTONE_WALL = Blocks.register("polished_blackstone_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(POLISHED_BLACKSTONE).forceSolidOn());
    public static final Block CHISELED_NETHER_BRICKS = Blocks.register("chiseled_nether_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundEffectType.NETHER_BRICKS));
    public static final Block CRACKED_NETHER_BRICKS = Blocks.register("cracked_nether_bricks", BlockBase.Info.of().mapColor(MaterialMapColor.NETHER).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 6.0f).sound(SoundEffectType.NETHER_BRICKS));
    public static final Block QUARTZ_BRICKS = Blocks.register("quartz_bricks", BlockBase.Info.ofLegacyCopy(QUARTZ_BLOCK));
    public static final Block CANDLE = Blocks.register("candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.SAND));
    public static final Block WHITE_CANDLE = Blocks.register("white_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.WOOL));
    public static final Block ORANGE_CANDLE = Blocks.register("orange_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_ORANGE));
    public static final Block MAGENTA_CANDLE = Blocks.register("magenta_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_MAGENTA));
    public static final Block LIGHT_BLUE_CANDLE = Blocks.register("light_blue_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_LIGHT_BLUE));
    public static final Block YELLOW_CANDLE = Blocks.register("yellow_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_YELLOW));
    public static final Block LIME_CANDLE = Blocks.register("lime_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_LIGHT_GREEN));
    public static final Block PINK_CANDLE = Blocks.register("pink_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_PINK));
    public static final Block GRAY_CANDLE = Blocks.register("gray_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_GRAY));
    public static final Block LIGHT_GRAY_CANDLE = Blocks.register("light_gray_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_LIGHT_GRAY));
    public static final Block CYAN_CANDLE = Blocks.register("cyan_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_CYAN));
    public static final Block PURPLE_CANDLE = Blocks.register("purple_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_PURPLE));
    public static final Block BLUE_CANDLE = Blocks.register("blue_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_BLUE));
    public static final Block BROWN_CANDLE = Blocks.register("brown_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_BROWN));
    public static final Block GREEN_CANDLE = Blocks.register("green_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_GREEN));
    public static final Block RED_CANDLE = Blocks.register("red_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_RED));
    public static final Block BLACK_CANDLE = Blocks.register("black_candle", CandleBlock::new, Blocks.candleProperties(MaterialMapColor.COLOR_BLACK));
    public static final Block CANDLE_CAKE = Blocks.register("candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CAKE).lightLevel(Blocks.litBlockEmission(3)));
    public static final Block WHITE_CANDLE_CAKE = Blocks.register("white_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(WHITE_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block ORANGE_CANDLE_CAKE = Blocks.register("orange_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(ORANGE_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block MAGENTA_CANDLE_CAKE = Blocks.register("magenta_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(MAGENTA_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block LIGHT_BLUE_CANDLE_CAKE = Blocks.register("light_blue_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(LIGHT_BLUE_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block YELLOW_CANDLE_CAKE = Blocks.register("yellow_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(YELLOW_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block LIME_CANDLE_CAKE = Blocks.register("lime_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(LIME_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block PINK_CANDLE_CAKE = Blocks.register("pink_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(PINK_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block GRAY_CANDLE_CAKE = Blocks.register("gray_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(GRAY_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block LIGHT_GRAY_CANDLE_CAKE = Blocks.register("light_gray_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(LIGHT_GRAY_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block CYAN_CANDLE_CAKE = Blocks.register("cyan_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(CYAN_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block PURPLE_CANDLE_CAKE = Blocks.register("purple_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(PURPLE_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block BLUE_CANDLE_CAKE = Blocks.register("blue_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(BLUE_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block BROWN_CANDLE_CAKE = Blocks.register("brown_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(BROWN_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block GREEN_CANDLE_CAKE = Blocks.register("green_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(GREEN_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block RED_CANDLE_CAKE = Blocks.register("red_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(RED_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block BLACK_CANDLE_CAKE = Blocks.register("black_candle_cake", (BlockBase.Info var0) -> new CandleCakeBlock(BLACK_CANDLE, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(CANDLE_CAKE));
    public static final Block AMETHYST_BLOCK = Blocks.register("amethyst_block", AmethystBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).strength(1.5f).sound(SoundEffectType.AMETHYST).requiresCorrectToolForDrops());
    public static final Block BUDDING_AMETHYST = Blocks.register("budding_amethyst", BuddingAmethystBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).randomTicks().strength(1.5f).sound(SoundEffectType.AMETHYST).requiresCorrectToolForDrops().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block AMETHYST_CLUSTER = Blocks.register("amethyst_cluster", (BlockBase.Info var0) -> new AmethystClusterBlock(7.0f, 10.0f, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PURPLE).forceSolidOn().noOcclusion().sound(SoundEffectType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(var0 -> 5).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block LARGE_AMETHYST_BUD = Blocks.register("large_amethyst_bud", (BlockBase.Info var0) -> new AmethystClusterBlock(5.0f, 10.0f, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(AMETHYST_CLUSTER).sound(SoundEffectType.MEDIUM_AMETHYST_BUD).lightLevel(var0 -> 4));
    public static final Block MEDIUM_AMETHYST_BUD = Blocks.register("medium_amethyst_bud", (BlockBase.Info var0) -> new AmethystClusterBlock(4.0f, 10.0f, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(AMETHYST_CLUSTER).sound(SoundEffectType.LARGE_AMETHYST_BUD).lightLevel(var0 -> 2));
    public static final Block SMALL_AMETHYST_BUD = Blocks.register("small_amethyst_bud", (BlockBase.Info var0) -> new AmethystClusterBlock(3.0f, 8.0f, (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(AMETHYST_CLUSTER).sound(SoundEffectType.SMALL_AMETHYST_BUD).lightLevel(var0 -> 1));
    public static final Block TUFF = Blocks.register("tuff", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_GRAY).instrument(BlockPropertyInstrument.BASEDRUM).sound(SoundEffectType.TUFF).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    public static final Block TUFF_SLAB = Blocks.register("tuff_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(TUFF));
    public static final Block TUFF_STAIRS = Blocks.register("tuff_stairs", (BlockBase.Info var0) -> new BlockStairs(TUFF.defaultBlockState(), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(TUFF));
    public static final Block TUFF_WALL = Blocks.register("tuff_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(TUFF).forceSolidOn());
    public static final Block POLISHED_TUFF = Blocks.register("polished_tuff", BlockBase.Info.ofLegacyCopy(TUFF).sound(SoundEffectType.POLISHED_TUFF));
    public static final Block POLISHED_TUFF_SLAB = Blocks.register("polished_tuff_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(POLISHED_TUFF));
    public static final Block POLISHED_TUFF_STAIRS = Blocks.register("polished_tuff_stairs", (BlockBase.Info var0) -> new BlockStairs(POLISHED_TUFF.defaultBlockState(), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(POLISHED_TUFF));
    public static final Block POLISHED_TUFF_WALL = Blocks.register("polished_tuff_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(POLISHED_TUFF).forceSolidOn());
    public static final Block CHISELED_TUFF = Blocks.register("chiseled_tuff", BlockBase.Info.ofLegacyCopy(TUFF));
    public static final Block TUFF_BRICKS = Blocks.register("tuff_bricks", BlockBase.Info.ofLegacyCopy(TUFF).sound(SoundEffectType.TUFF_BRICKS));
    public static final Block TUFF_BRICK_SLAB = Blocks.register("tuff_brick_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(TUFF_BRICKS));
    public static final Block TUFF_BRICK_STAIRS = Blocks.register("tuff_brick_stairs", (BlockBase.Info var0) -> new BlockStairs(TUFF_BRICKS.defaultBlockState(), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(TUFF_BRICKS));
    public static final Block TUFF_BRICK_WALL = Blocks.register("tuff_brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(TUFF_BRICKS).forceSolidOn());
    public static final Block CHISELED_TUFF_BRICKS = Blocks.register("chiseled_tuff_bricks", BlockBase.Info.ofLegacyCopy(TUFF_BRICKS));
    public static final Block CALCITE = Blocks.register("calcite", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_WHITE).instrument(BlockPropertyInstrument.BASEDRUM).sound(SoundEffectType.CALCITE).requiresCorrectToolForDrops().strength(0.75f));
    public static final Block TINTED_GLASS = Blocks.register("tinted_glass", TintedGlassBlock::new, BlockBase.Info.ofLegacyCopy(GLASS).mapColor(MaterialMapColor.COLOR_GRAY).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never));
    public static final Block POWDER_SNOW = Blocks.register("powder_snow", PowderSnowBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.SNOW).strength(0.25f).sound(SoundEffectType.POWDER_SNOW).dynamicShape().noOcclusion().isRedstoneConductor(Blocks::never));
    public static final Block SCULK_SENSOR = Blocks.register("sculk_sensor", SculkSensorBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_CYAN).strength(1.5f).sound(SoundEffectType.SCULK_SENSOR).lightLevel(var0 -> 1).emissiveRendering((var0, var1, var2) -> SculkSensorBlock.getPhase(var0) == SculkSensorPhase.ACTIVE));
    public static final Block CALIBRATED_SCULK_SENSOR = Blocks.register("calibrated_sculk_sensor", CalibratedSculkSensorBlock::new, BlockBase.Info.ofLegacyCopy(SCULK_SENSOR));
    public static final Block SCULK = Blocks.register("sculk", SculkBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).strength(0.2f).sound(SoundEffectType.SCULK));
    public static final Block SCULK_VEIN = Blocks.register("sculk_vein", SculkVeinBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).forceSolidOn().noCollision().strength(0.2f).sound(SoundEffectType.SCULK_VEIN).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SCULK_CATALYST = Blocks.register("sculk_catalyst", SculkCatalystBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).strength(3.0f, 3.0f).sound(SoundEffectType.SCULK_CATALYST).lightLevel(var0 -> 6));
    public static final Block SCULK_SHRIEKER = Blocks.register("sculk_shrieker", SculkShriekerBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BLACK).strength(3.0f, 3.0f).sound(SoundEffectType.SCULK_SHRIEKER));
    public static final Block COPPER_BLOCK = Blocks.register("copper_block", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundEffectType.COPPER));
    public static final Block EXPOSED_COPPER = Blocks.register("exposed_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_BLOCK).mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_COPPER = Blocks.register("weathered_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_BLOCK).mapColor(MaterialMapColor.WARPED_STEM));
    public static final Block OXIDIZED_COPPER = Blocks.register("oxidized_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_BLOCK).mapColor(MaterialMapColor.WARPED_NYLIUM));
    public static final Block COPPER_ORE = Blocks.register("copper_ore", (BlockBase.Info var0) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(IRON_ORE));
    public static final Block DEEPSLATE_COPPER_ORE = Blocks.register("deepslate_copper_ore", (BlockBase.Info var0) -> new DropExperienceBlock(ConstantInt.of(0), (BlockBase.Info)var0), BlockBase.Info.ofLegacyCopy(COPPER_ORE).mapColor(MaterialMapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundEffectType.DEEPSLATE));
    public static final Block OXIDIZED_CUT_COPPER = Blocks.register("oxidized_cut_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(OXIDIZED_COPPER));
    public static final Block WEATHERED_CUT_COPPER = Blocks.register("weathered_cut_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(WEATHERED_COPPER));
    public static final Block EXPOSED_CUT_COPPER = Blocks.register("exposed_cut_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(EXPOSED_COPPER));
    public static final Block CUT_COPPER = Blocks.register("cut_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_BLOCK));
    public static final Block OXIDIZED_CHISELED_COPPER = Blocks.register("oxidized_chiseled_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(OXIDIZED_COPPER));
    public static final Block WEATHERED_CHISELED_COPPER = Blocks.register("weathered_chiseled_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(WEATHERED_COPPER));
    public static final Block EXPOSED_CHISELED_COPPER = Blocks.register("exposed_chiseled_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(EXPOSED_COPPER));
    public static final Block CHISELED_COPPER = Blocks.register("chiseled_copper", (BlockBase.Info var0) -> new WeatheringCopperFullBlock(WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_BLOCK));
    public static final Block WAXED_OXIDIZED_CHISELED_COPPER = Blocks.register("waxed_oxidized_chiseled_copper", BlockBase.Info.ofFullCopy(OXIDIZED_CHISELED_COPPER));
    public static final Block WAXED_WEATHERED_CHISELED_COPPER = Blocks.register("waxed_weathered_chiseled_copper", BlockBase.Info.ofFullCopy(WEATHERED_CHISELED_COPPER));
    public static final Block WAXED_EXPOSED_CHISELED_COPPER = Blocks.register("waxed_exposed_chiseled_copper", BlockBase.Info.ofFullCopy(EXPOSED_CHISELED_COPPER));
    public static final Block WAXED_CHISELED_COPPER = Blocks.register("waxed_chiseled_copper", BlockBase.Info.ofFullCopy(CHISELED_COPPER));
    public static final Block OXIDIZED_CUT_COPPER_STAIRS = Blocks.register("oxidized_cut_copper_stairs", (BlockBase.Info var0) -> new WeatheringCopperStairBlock(WeatheringCopper.a.OXIDIZED, OXIDIZED_CUT_COPPER.defaultBlockState(), (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(OXIDIZED_CUT_COPPER));
    public static final Block WEATHERED_CUT_COPPER_STAIRS = Blocks.register("weathered_cut_copper_stairs", (BlockBase.Info var0) -> new WeatheringCopperStairBlock(WeatheringCopper.a.WEATHERED, WEATHERED_CUT_COPPER.defaultBlockState(), (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(WEATHERED_COPPER));
    public static final Block EXPOSED_CUT_COPPER_STAIRS = Blocks.register("exposed_cut_copper_stairs", (BlockBase.Info var0) -> new WeatheringCopperStairBlock(WeatheringCopper.a.EXPOSED, EXPOSED_CUT_COPPER.defaultBlockState(), (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(EXPOSED_COPPER));
    public static final Block CUT_COPPER_STAIRS = Blocks.register("cut_copper_stairs", (BlockBase.Info var0) -> new WeatheringCopperStairBlock(WeatheringCopper.a.UNAFFECTED, CUT_COPPER.defaultBlockState(), (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_BLOCK));
    public static final Block OXIDIZED_CUT_COPPER_SLAB = Blocks.register("oxidized_cut_copper_slab", (BlockBase.Info var0) -> new WeatheringCopperSlabBlock(WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(OXIDIZED_CUT_COPPER));
    public static final Block WEATHERED_CUT_COPPER_SLAB = Blocks.register("weathered_cut_copper_slab", (BlockBase.Info var0) -> new WeatheringCopperSlabBlock(WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(WEATHERED_CUT_COPPER));
    public static final Block EXPOSED_CUT_COPPER_SLAB = Blocks.register("exposed_cut_copper_slab", (BlockBase.Info var0) -> new WeatheringCopperSlabBlock(WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(EXPOSED_CUT_COPPER));
    public static final Block CUT_COPPER_SLAB = Blocks.register("cut_copper_slab", (BlockBase.Info var0) -> new WeatheringCopperSlabBlock(WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(CUT_COPPER));
    public static final Block WAXED_COPPER_BLOCK = Blocks.register("waxed_copper_block", BlockBase.Info.ofFullCopy(COPPER_BLOCK));
    public static final Block WAXED_WEATHERED_COPPER = Blocks.register("waxed_weathered_copper", BlockBase.Info.ofFullCopy(WEATHERED_COPPER));
    public static final Block WAXED_EXPOSED_COPPER = Blocks.register("waxed_exposed_copper", BlockBase.Info.ofFullCopy(EXPOSED_COPPER));
    public static final Block WAXED_OXIDIZED_COPPER = Blocks.register("waxed_oxidized_copper", BlockBase.Info.ofFullCopy(OXIDIZED_COPPER));
    public static final Block WAXED_OXIDIZED_CUT_COPPER = Blocks.register("waxed_oxidized_cut_copper", BlockBase.Info.ofFullCopy(OXIDIZED_COPPER));
    public static final Block WAXED_WEATHERED_CUT_COPPER = Blocks.register("waxed_weathered_cut_copper", BlockBase.Info.ofFullCopy(WEATHERED_COPPER));
    public static final Block WAXED_EXPOSED_CUT_COPPER = Blocks.register("waxed_exposed_cut_copper", BlockBase.Info.ofFullCopy(EXPOSED_COPPER));
    public static final Block WAXED_CUT_COPPER = Blocks.register("waxed_cut_copper", BlockBase.Info.ofFullCopy(COPPER_BLOCK));
    public static final Block WAXED_OXIDIZED_CUT_COPPER_STAIRS = Blocks.registerStair("waxed_oxidized_cut_copper_stairs", WAXED_OXIDIZED_CUT_COPPER);
    public static final Block WAXED_WEATHERED_CUT_COPPER_STAIRS = Blocks.registerStair("waxed_weathered_cut_copper_stairs", WAXED_WEATHERED_CUT_COPPER);
    public static final Block WAXED_EXPOSED_CUT_COPPER_STAIRS = Blocks.registerStair("waxed_exposed_cut_copper_stairs", WAXED_EXPOSED_CUT_COPPER);
    public static final Block WAXED_CUT_COPPER_STAIRS = Blocks.registerStair("waxed_cut_copper_stairs", WAXED_CUT_COPPER);
    public static final Block WAXED_OXIDIZED_CUT_COPPER_SLAB = Blocks.register("waxed_oxidized_cut_copper_slab", BlockStepAbstract::new, BlockBase.Info.ofFullCopy(WAXED_OXIDIZED_CUT_COPPER).requiresCorrectToolForDrops());
    public static final Block WAXED_WEATHERED_CUT_COPPER_SLAB = Blocks.register("waxed_weathered_cut_copper_slab", BlockStepAbstract::new, BlockBase.Info.ofFullCopy(WAXED_WEATHERED_CUT_COPPER).requiresCorrectToolForDrops());
    public static final Block WAXED_EXPOSED_CUT_COPPER_SLAB = Blocks.register("waxed_exposed_cut_copper_slab", BlockStepAbstract::new, BlockBase.Info.ofFullCopy(WAXED_EXPOSED_CUT_COPPER).requiresCorrectToolForDrops());
    public static final Block WAXED_CUT_COPPER_SLAB = Blocks.register("waxed_cut_copper_slab", BlockStepAbstract::new, BlockBase.Info.ofFullCopy(WAXED_CUT_COPPER).requiresCorrectToolForDrops());
    public static final Block COPPER_DOOR = Blocks.register("copper_door", (BlockBase.Info var0) -> new WeatheringCopperDoorBlock(BlockSetType.COPPER, WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block EXPOSED_COPPER_DOOR = Blocks.register("exposed_copper_door", (BlockBase.Info var0) -> new WeatheringCopperDoorBlock(BlockSetType.COPPER, WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_DOOR).mapColor(EXPOSED_COPPER.defaultMapColor()));
    public static final Block OXIDIZED_COPPER_DOOR = Blocks.register("oxidized_copper_door", (BlockBase.Info var0) -> new WeatheringCopperDoorBlock(BlockSetType.COPPER, WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_DOOR).mapColor(OXIDIZED_COPPER.defaultMapColor()));
    public static final Block WEATHERED_COPPER_DOOR = Blocks.register("weathered_copper_door", (BlockBase.Info var0) -> new WeatheringCopperDoorBlock(BlockSetType.COPPER, WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_DOOR).mapColor(WEATHERED_COPPER.defaultMapColor()));
    public static final Block WAXED_COPPER_DOOR = Blocks.register("waxed_copper_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.COPPER, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_DOOR));
    public static final Block WAXED_EXPOSED_COPPER_DOOR = Blocks.register("waxed_exposed_copper_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.COPPER, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(EXPOSED_COPPER_DOOR));
    public static final Block WAXED_OXIDIZED_COPPER_DOOR = Blocks.register("waxed_oxidized_copper_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.COPPER, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(OXIDIZED_COPPER_DOOR));
    public static final Block WAXED_WEATHERED_COPPER_DOOR = Blocks.register("waxed_weathered_copper_door", (BlockBase.Info var0) -> new BlockDoor(BlockSetType.COPPER, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(WEATHERED_COPPER_DOOR));
    public static final Block COPPER_TRAPDOOR = Blocks.register("copper_trapdoor", (BlockBase.Info var0) -> new WeatheringCopperTrapDoorBlock(BlockSetType.COPPER, WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion().isValidSpawn(Blocks::never));
    public static final Block EXPOSED_COPPER_TRAPDOOR = Blocks.register("exposed_copper_trapdoor", (BlockBase.Info var0) -> new WeatheringCopperTrapDoorBlock(BlockSetType.COPPER, WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_TRAPDOOR).mapColor(EXPOSED_COPPER.defaultMapColor()));
    public static final Block OXIDIZED_COPPER_TRAPDOOR = Blocks.register("oxidized_copper_trapdoor", (BlockBase.Info var0) -> new WeatheringCopperTrapDoorBlock(BlockSetType.COPPER, WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_TRAPDOOR).mapColor(OXIDIZED_COPPER.defaultMapColor()));
    public static final Block WEATHERED_COPPER_TRAPDOOR = Blocks.register("weathered_copper_trapdoor", (BlockBase.Info var0) -> new WeatheringCopperTrapDoorBlock(BlockSetType.COPPER, WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_TRAPDOOR).mapColor(WEATHERED_COPPER.defaultMapColor()));
    public static final Block WAXED_COPPER_TRAPDOOR = Blocks.register("waxed_copper_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.COPPER, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_TRAPDOOR));
    public static final Block WAXED_EXPOSED_COPPER_TRAPDOOR = Blocks.register("waxed_exposed_copper_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.COPPER, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(EXPOSED_COPPER_TRAPDOOR));
    public static final Block WAXED_OXIDIZED_COPPER_TRAPDOOR = Blocks.register("waxed_oxidized_copper_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.COPPER, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(OXIDIZED_COPPER_TRAPDOOR));
    public static final Block WAXED_WEATHERED_COPPER_TRAPDOOR = Blocks.register("waxed_weathered_copper_trapdoor", (BlockBase.Info var0) -> new BlockTrapdoor(BlockSetType.COPPER, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(WEATHERED_COPPER_TRAPDOOR));
    public static final Block COPPER_GRATE = Blocks.register("copper_grate", (BlockBase.Info var0) -> new WeatheringCopperGrateBlock(WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.of().strength(3.0f, 6.0f).sound(SoundEffectType.COPPER_GRATE).mapColor(MaterialMapColor.COLOR_ORANGE).noOcclusion().requiresCorrectToolForDrops().isValidSpawn(Blocks::never).isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never));
    public static final Block EXPOSED_COPPER_GRATE = Blocks.register("exposed_copper_grate", (BlockBase.Info var0) -> new WeatheringCopperGrateBlock(WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_GRATE).mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_COPPER_GRATE = Blocks.register("weathered_copper_grate", (BlockBase.Info var0) -> new WeatheringCopperGrateBlock(WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_GRATE).mapColor(MaterialMapColor.WARPED_STEM));
    public static final Block OXIDIZED_COPPER_GRATE = Blocks.register("oxidized_copper_grate", (BlockBase.Info var0) -> new WeatheringCopperGrateBlock(WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_GRATE).mapColor(MaterialMapColor.WARPED_NYLIUM));
    public static final Block WAXED_COPPER_GRATE = Blocks.register("waxed_copper_grate", WaterloggedTransparentBlock::new, BlockBase.Info.ofFullCopy(COPPER_GRATE));
    public static final Block WAXED_EXPOSED_COPPER_GRATE = Blocks.register("waxed_exposed_copper_grate", WaterloggedTransparentBlock::new, BlockBase.Info.ofFullCopy(EXPOSED_COPPER_GRATE));
    public static final Block WAXED_WEATHERED_COPPER_GRATE = Blocks.register("waxed_weathered_copper_grate", WaterloggedTransparentBlock::new, BlockBase.Info.ofFullCopy(WEATHERED_COPPER_GRATE));
    public static final Block WAXED_OXIDIZED_COPPER_GRATE = Blocks.register("waxed_oxidized_copper_grate", WaterloggedTransparentBlock::new, BlockBase.Info.ofFullCopy(OXIDIZED_COPPER_GRATE));
    public static final Block COPPER_BULB = Blocks.register("copper_bulb", (BlockBase.Info var0) -> new WeatheringCopperBulbBlock(WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).sound(SoundEffectType.COPPER_BULB).requiresCorrectToolForDrops().isRedstoneConductor(Blocks::never).lightLevel(Blocks.litBlockEmission(15)));
    public static final Block EXPOSED_COPPER_BULB = Blocks.register("exposed_copper_bulb", (BlockBase.Info var0) -> new WeatheringCopperBulbBlock(WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_BULB).mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GRAY).lightLevel(Blocks.litBlockEmission(12)));
    public static final Block WEATHERED_COPPER_BULB = Blocks.register("weathered_copper_bulb", (BlockBase.Info var0) -> new WeatheringCopperBulbBlock(WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_BULB).mapColor(MaterialMapColor.WARPED_STEM).lightLevel(Blocks.litBlockEmission(8)));
    public static final Block OXIDIZED_COPPER_BULB = Blocks.register("oxidized_copper_bulb", (BlockBase.Info var0) -> new WeatheringCopperBulbBlock(WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_BULB).mapColor(MaterialMapColor.WARPED_NYLIUM).lightLevel(Blocks.litBlockEmission(4)));
    public static final Block WAXED_COPPER_BULB = Blocks.register("waxed_copper_bulb", CopperBulbBlock::new, BlockBase.Info.ofFullCopy(COPPER_BULB));
    public static final Block WAXED_EXPOSED_COPPER_BULB = Blocks.register("waxed_exposed_copper_bulb", CopperBulbBlock::new, BlockBase.Info.ofFullCopy(EXPOSED_COPPER_BULB));
    public static final Block WAXED_WEATHERED_COPPER_BULB = Blocks.register("waxed_weathered_copper_bulb", CopperBulbBlock::new, BlockBase.Info.ofFullCopy(WEATHERED_COPPER_BULB));
    public static final Block WAXED_OXIDIZED_COPPER_BULB = Blocks.register("waxed_oxidized_copper_bulb", CopperBulbBlock::new, BlockBase.Info.ofFullCopy(OXIDIZED_COPPER_BULB));
    public static final Block COPPER_CHEST = Blocks.register("copper_chest", (BlockBase.Info var0) -> new WeatheringCopperChestBlock(WeatheringCopper.a.UNAFFECTED, SoundEffects.COPPER_CHEST_OPEN, SoundEffects.COPPER_CHEST_CLOSE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).sound(SoundEffectType.COPPER).requiresCorrectToolForDrops());
    public static final Block EXPOSED_COPPER_CHEST = Blocks.register("exposed_copper_chest", (BlockBase.Info var0) -> new WeatheringCopperChestBlock(WeatheringCopper.a.EXPOSED, SoundEffects.COPPER_CHEST_OPEN, SoundEffects.COPPER_CHEST_CLOSE, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_CHEST).mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_COPPER_CHEST = Blocks.register("weathered_copper_chest", (BlockBase.Info var0) -> new WeatheringCopperChestBlock(WeatheringCopper.a.WEATHERED, SoundEffects.COPPER_CHEST_WEATHERED_OPEN, SoundEffects.COPPER_CHEST_WEATHERED_CLOSE, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_CHEST).mapColor(MaterialMapColor.WARPED_STEM));
    public static final Block OXIDIZED_COPPER_CHEST = Blocks.register("oxidized_copper_chest", (BlockBase.Info var0) -> new WeatheringCopperChestBlock(WeatheringCopper.a.OXIDIZED, SoundEffects.COPPER_CHEST_OXIDIZED_OPEN, SoundEffects.COPPER_CHEST_OXIDIZED_CLOSE, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_CHEST).mapColor(MaterialMapColor.WARPED_NYLIUM));
    public static final Block WAXED_COPPER_CHEST = Blocks.register("waxed_copper_chest", (BlockBase.Info var0) -> new CopperChestBlock(WeatheringCopper.a.UNAFFECTED, SoundEffects.COPPER_CHEST_OPEN, SoundEffects.COPPER_CHEST_CLOSE, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_CHEST));
    public static final Block WAXED_EXPOSED_COPPER_CHEST = Blocks.register("waxed_exposed_copper_chest", (BlockBase.Info var0) -> new CopperChestBlock(WeatheringCopper.a.EXPOSED, SoundEffects.COPPER_CHEST_OPEN, SoundEffects.COPPER_CHEST_CLOSE, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(EXPOSED_COPPER_CHEST));
    public static final Block WAXED_WEATHERED_COPPER_CHEST = Blocks.register("waxed_weathered_copper_chest", (BlockBase.Info var0) -> new CopperChestBlock(WeatheringCopper.a.WEATHERED, SoundEffects.COPPER_CHEST_WEATHERED_OPEN, SoundEffects.COPPER_CHEST_WEATHERED_CLOSE, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(WEATHERED_COPPER_CHEST));
    public static final Block WAXED_OXIDIZED_COPPER_CHEST = Blocks.register("waxed_oxidized_copper_chest", (BlockBase.Info var0) -> new CopperChestBlock(WeatheringCopper.a.OXIDIZED, SoundEffects.COPPER_CHEST_OXIDIZED_OPEN, SoundEffects.COPPER_CHEST_OXIDIZED_CLOSE, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(OXIDIZED_COPPER_CHEST));
    public static final Block COPPER_GOLEM_STATUE = Blocks.register("copper_golem_statue", (BlockBase.Info var0) -> new WeatheringCopperGolemStatueBlock(WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(COPPER_BLOCK.defaultMapColor()).strength(3.0f, 6.0f).sound(SoundEffectType.COPPER_GOLEM_STATUE).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block EXPOSED_COPPER_GOLEM_STATUE = Blocks.register("exposed_copper_golem_statue", (BlockBase.Info var0) -> new WeatheringCopperGolemStatueBlock(WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_GOLEM_STATUE).mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_COPPER_GOLEM_STATUE = Blocks.register("weathered_copper_golem_statue", (BlockBase.Info var0) -> new WeatheringCopperGolemStatueBlock(WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_GOLEM_STATUE).mapColor(MaterialMapColor.WARPED_STEM));
    public static final Block OXIDIZED_COPPER_GOLEM_STATUE = Blocks.register("oxidized_copper_golem_statue", (BlockBase.Info var0) -> new WeatheringCopperGolemStatueBlock(WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_GOLEM_STATUE).mapColor(MaterialMapColor.WARPED_NYLIUM));
    public static final Block WAXED_COPPER_GOLEM_STATUE = Blocks.register("waxed_copper_golem_statue", (BlockBase.Info var0) -> new CopperGolemStatueBlock(WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(COPPER_GOLEM_STATUE));
    public static final Block WAXED_EXPOSED_COPPER_GOLEM_STATUE = Blocks.register("waxed_exposed_copper_golem_statue", (BlockBase.Info var0) -> new CopperGolemStatueBlock(WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(EXPOSED_COPPER_GOLEM_STATUE));
    public static final Block WAXED_WEATHERED_COPPER_GOLEM_STATUE = Blocks.register("waxed_weathered_copper_golem_statue", (BlockBase.Info var0) -> new CopperGolemStatueBlock(WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(WEATHERED_COPPER_GOLEM_STATUE));
    public static final Block WAXED_OXIDIZED_COPPER_GOLEM_STATUE = Blocks.register("waxed_oxidized_copper_golem_statue", (BlockBase.Info var0) -> new CopperGolemStatueBlock(WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(OXIDIZED_COPPER_GOLEM_STATUE));
    public static final Block LIGHTNING_ROD = Blocks.register("lightning_rod", (BlockBase.Info var0) -> new WeatheringLightningRodBlock(WeatheringCopper.a.UNAFFECTED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).forceSolidOn().requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundEffectType.COPPER).noOcclusion());
    public static final Block EXPOSED_LIGHTNING_ROD = Blocks.register("exposed_lightning_rod", (BlockBase.Info var0) -> new WeatheringLightningRodBlock(WeatheringCopper.a.EXPOSED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(LIGHTNING_ROD).mapColor(MaterialMapColor.TERRACOTTA_LIGHT_GRAY));
    public static final Block WEATHERED_LIGHTNING_ROD = Blocks.register("weathered_lightning_rod", (BlockBase.Info var0) -> new WeatheringLightningRodBlock(WeatheringCopper.a.WEATHERED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(LIGHTNING_ROD).mapColor(MaterialMapColor.WARPED_STEM));
    public static final Block OXIDIZED_LIGHTNING_ROD = Blocks.register("oxidized_lightning_rod", (BlockBase.Info var0) -> new WeatheringLightningRodBlock(WeatheringCopper.a.OXIDIZED, (BlockBase.Info)var0), BlockBase.Info.ofFullCopy(LIGHTNING_ROD).mapColor(MaterialMapColor.WARPED_NYLIUM));
    public static final Block WAXED_LIGHTNING_ROD = Blocks.register("waxed_lightning_rod", LightningRodBlock::new, BlockBase.Info.ofFullCopy(LIGHTNING_ROD));
    public static final Block WAXED_EXPOSED_LIGHTNING_ROD = Blocks.register("waxed_exposed_lightning_rod", LightningRodBlock::new, BlockBase.Info.ofFullCopy(EXPOSED_LIGHTNING_ROD));
    public static final Block WAXED_WEATHERED_LIGHTNING_ROD = Blocks.register("waxed_weathered_lightning_rod", LightningRodBlock::new, BlockBase.Info.ofFullCopy(WEATHERED_LIGHTNING_ROD));
    public static final Block WAXED_OXIDIZED_LIGHTNING_ROD = Blocks.register("waxed_oxidized_lightning_rod", LightningRodBlock::new, BlockBase.Info.ofFullCopy(OXIDIZED_LIGHTNING_ROD));
    public static final Block POINTED_DRIPSTONE = Blocks.register("pointed_dripstone", PointedDripstoneBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_BROWN).forceSolidOn().instrument(BlockPropertyInstrument.BASEDRUM).noOcclusion().sound(SoundEffectType.POINTED_DRIPSTONE).randomTicks().strength(1.5f, 3.0f).dynamicShape().offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY).isRedstoneConductor(Blocks::never));
    public static final Block DRIPSTONE_BLOCK = Blocks.register("dripstone_block", BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_BROWN).instrument(BlockPropertyInstrument.BASEDRUM).sound(SoundEffectType.DRIPSTONE_BLOCK).requiresCorrectToolForDrops().strength(1.5f, 1.0f));
    public static final Block CAVE_VINES = Blocks.register("cave_vines", CaveVinesBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).randomTicks().noCollision().lightLevel(CaveVines.emission(14)).instabreak().sound(SoundEffectType.CAVE_VINES).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block CAVE_VINES_PLANT = Blocks.register("cave_vines_plant", CaveVinesPlantBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().lightLevel(CaveVines.emission(14)).instabreak().sound(SoundEffectType.CAVE_VINES).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SPORE_BLOSSOM = Blocks.register("spore_blossom", SporeBlossomBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).instabreak().noCollision().sound(SoundEffectType.SPORE_BLOSSOM).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block AZALEA = Blocks.register("azalea", AzaleaBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).forceSolidOff().instabreak().sound(SoundEffectType.AZALEA).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block FLOWERING_AZALEA = Blocks.register("flowering_azalea", AzaleaBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).forceSolidOff().instabreak().sound(SoundEffectType.FLOWERING_AZALEA).noOcclusion().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block MOSS_CARPET = Blocks.register("moss_carpet", CarpetBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GREEN).strength(0.1f).sound(SoundEffectType.MOSS_CARPET).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PINK_PETALS = Blocks.register("pink_petals", FlowerBedBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().sound(SoundEffectType.PINK_PETALS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block WILDFLOWERS = Blocks.register("wildflowers", FlowerBedBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().sound(SoundEffectType.PINK_PETALS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block LEAF_LITTER = Blocks.register("leaf_litter", LeafLitterBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_BROWN).replaceable().noCollision().sound(SoundEffectType.LEAF_LITTER).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block MOSS_BLOCK = Blocks.register("moss_block", (BlockBase.Info var0) -> new BonemealableFeaturePlacerBlock(CaveFeatures.MOSS_PATCH_BONEMEAL, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_GREEN).strength(0.1f).sound(SoundEffectType.MOSS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BIG_DRIPLEAF = Blocks.register("big_dripleaf", BigDripleafBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).forceSolidOff().strength(0.1f).sound(SoundEffectType.BIG_DRIPLEAF).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block BIG_DRIPLEAF_STEM = Blocks.register("big_dripleaf_stem", BigDripleafStemBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().strength(0.1f).sound(SoundEffectType.BIG_DRIPLEAF).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block SMALL_DRIPLEAF = Blocks.register("small_dripleaf", SmallDripleafBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).noCollision().instabreak().sound(SoundEffectType.SMALL_DRIPLEAF).offsetType(BlockBase.EnumRandomOffset.XYZ).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block HANGING_ROOTS = Blocks.register("hanging_roots", HangingRootsBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).replaceable().noCollision().instabreak().sound(SoundEffectType.HANGING_ROOTS).offsetType(BlockBase.EnumRandomOffset.XZ).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    public static final Block ROOTED_DIRT = Blocks.register("rooted_dirt", RootedDirtBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.DIRT).strength(0.5f).sound(SoundEffectType.ROOTED_DIRT));
    public static final Block MUD = Blocks.register("mud", MudBlock::new, BlockBase.Info.ofLegacyCopy(DIRT).mapColor(MaterialMapColor.TERRACOTTA_CYAN).isValidSpawn(Blocks::always).isRedstoneConductor(Blocks::always).isViewBlocking(Blocks::always).isSuffocating(Blocks::always).sound(SoundEffectType.MUD));
    public static final Block DEEPSLATE = Blocks.register("deepslate", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.DEEPSLATE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 6.0f).sound(SoundEffectType.DEEPSLATE));
    public static final Block COBBLED_DEEPSLATE = Blocks.register("cobbled_deepslate", BlockBase.Info.ofLegacyCopy(DEEPSLATE).strength(3.5f, 6.0f));
    public static final Block COBBLED_DEEPSLATE_STAIRS = Blocks.registerLegacyStair("cobbled_deepslate_stairs", COBBLED_DEEPSLATE);
    public static final Block COBBLED_DEEPSLATE_SLAB = Blocks.register("cobbled_deepslate_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(COBBLED_DEEPSLATE));
    public static final Block COBBLED_DEEPSLATE_WALL = Blocks.register("cobbled_deepslate_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(COBBLED_DEEPSLATE).forceSolidOn());
    public static final Block POLISHED_DEEPSLATE = Blocks.register("polished_deepslate", BlockBase.Info.ofLegacyCopy(COBBLED_DEEPSLATE).sound(SoundEffectType.POLISHED_DEEPSLATE));
    public static final Block POLISHED_DEEPSLATE_STAIRS = Blocks.registerLegacyStair("polished_deepslate_stairs", POLISHED_DEEPSLATE);
    public static final Block POLISHED_DEEPSLATE_SLAB = Blocks.register("polished_deepslate_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(POLISHED_DEEPSLATE));
    public static final Block POLISHED_DEEPSLATE_WALL = Blocks.register("polished_deepslate_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(POLISHED_DEEPSLATE).forceSolidOn());
    public static final Block DEEPSLATE_TILES = Blocks.register("deepslate_tiles", BlockBase.Info.ofLegacyCopy(COBBLED_DEEPSLATE).sound(SoundEffectType.DEEPSLATE_TILES));
    public static final Block DEEPSLATE_TILE_STAIRS = Blocks.registerLegacyStair("deepslate_tile_stairs", DEEPSLATE_TILES);
    public static final Block DEEPSLATE_TILE_SLAB = Blocks.register("deepslate_tile_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(DEEPSLATE_TILES));
    public static final Block DEEPSLATE_TILE_WALL = Blocks.register("deepslate_tile_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(DEEPSLATE_TILES).forceSolidOn());
    public static final Block DEEPSLATE_BRICKS = Blocks.register("deepslate_bricks", BlockBase.Info.ofLegacyCopy(COBBLED_DEEPSLATE).sound(SoundEffectType.DEEPSLATE_BRICKS));
    public static final Block DEEPSLATE_BRICK_STAIRS = Blocks.registerLegacyStair("deepslate_brick_stairs", DEEPSLATE_BRICKS);
    public static final Block DEEPSLATE_BRICK_SLAB = Blocks.register("deepslate_brick_slab", BlockStepAbstract::new, BlockBase.Info.ofLegacyCopy(DEEPSLATE_BRICKS));
    public static final Block DEEPSLATE_BRICK_WALL = Blocks.register("deepslate_brick_wall", BlockCobbleWall::new, BlockBase.Info.ofLegacyCopy(DEEPSLATE_BRICKS).forceSolidOn());
    public static final Block CHISELED_DEEPSLATE = Blocks.register("chiseled_deepslate", BlockBase.Info.ofLegacyCopy(COBBLED_DEEPSLATE).sound(SoundEffectType.DEEPSLATE_BRICKS));
    public static final Block CRACKED_DEEPSLATE_BRICKS = Blocks.register("cracked_deepslate_bricks", BlockBase.Info.ofLegacyCopy(DEEPSLATE_BRICKS));
    public static final Block CRACKED_DEEPSLATE_TILES = Blocks.register("cracked_deepslate_tiles", BlockBase.Info.ofLegacyCopy(DEEPSLATE_TILES));
    public static final Block INFESTED_DEEPSLATE = Blocks.register("infested_deepslate", (BlockBase.Info var0) -> new InfestedRotatedPillarBlock(DEEPSLATE, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(MaterialMapColor.DEEPSLATE).sound(SoundEffectType.DEEPSLATE));
    public static final Block SMOOTH_BASALT = Blocks.register("smooth_basalt", BlockBase.Info.ofLegacyCopy(BASALT));
    public static final Block RAW_IRON_BLOCK = Blocks.register("raw_iron_block", BlockBase.Info.of().mapColor(MaterialMapColor.RAW_IRON).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
    public static final Block RAW_COPPER_BLOCK = Blocks.register("raw_copper_block", BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_ORANGE).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
    public static final Block RAW_GOLD_BLOCK = Blocks.register("raw_gold_block", BlockBase.Info.of().mapColor(MaterialMapColor.GOLD).instrument(BlockPropertyInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
    public static final Block POTTED_AZALEA = Blocks.register("potted_azalea_bush", (BlockBase.Info var0) -> new BlockFlowerPot(AZALEA, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block POTTED_FLOWERING_AZALEA = Blocks.register("potted_flowering_azalea_bush", (BlockBase.Info var0) -> new BlockFlowerPot(FLOWERING_AZALEA, (BlockBase.Info)var0), Blocks.flowerPotProperties());
    public static final Block OCHRE_FROGLIGHT = Blocks.register("ochre_froglight", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.SAND).strength(0.3f).lightLevel(var0 -> 15).sound(SoundEffectType.FROGLIGHT));
    public static final Block VERDANT_FROGLIGHT = Blocks.register("verdant_froglight", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.GLOW_LICHEN).strength(0.3f).lightLevel(var0 -> 15).sound(SoundEffectType.FROGLIGHT));
    public static final Block PEARLESCENT_FROGLIGHT = Blocks.register("pearlescent_froglight", BlockRotatable::new, BlockBase.Info.of().mapColor(MaterialMapColor.COLOR_PINK).strength(0.3f).lightLevel(var0 -> 15).sound(SoundEffectType.FROGLIGHT));
    public static final Block FROGSPAWN = Blocks.register("frogspawn", FrogspawnBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.WATER).instabreak().noOcclusion().noCollision().sound(SoundEffectType.FROGSPAWN).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block REINFORCED_DEEPSLATE = Blocks.register("reinforced_deepslate", BlockBase.Info.of().mapColor(MaterialMapColor.DEEPSLATE).instrument(BlockPropertyInstrument.BASEDRUM).sound(SoundEffectType.DEEPSLATE).strength(55.0f, 1200.0f));
    public static final Block DECORATED_POT = Blocks.register("decorated_pot", DecoratedPotBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.TERRACOTTA_RED).strength(0.0f, 0.0f).pushReaction(EnumPistonReaction.DESTROY).noOcclusion());
    public static final Block CRAFTER = Blocks.register("crafter", CrafterBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).strength(1.5f, 3.5f));
    public static final Block TRIAL_SPAWNER = Blocks.register("trial_spawner", TrialSpawnerBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).lightLevel(var0 -> var0.getValue(TrialSpawnerBlock.STATE).lightLevel()).strength(50.0f).sound(SoundEffectType.TRIAL_SPAWNER).isViewBlocking(Blocks::never).noOcclusion());
    public static final Block VAULT = Blocks.register("vault", VaultBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.STONE).instrument(BlockPropertyInstrument.BASEDRUM).noOcclusion().sound(SoundEffectType.VAULT).lightLevel(var0 -> var0.getValue(VaultBlock.STATE).lightLevel()).strength(50.0f).isViewBlocking(Blocks::never));
    public static final Block HEAVY_CORE = Blocks.register("heavy_core", HeavyCoreBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.METAL).instrument(BlockPropertyInstrument.SNARE).sound(SoundEffectType.HEAVY_CORE).strength(10.0f).pushReaction(EnumPistonReaction.NORMAL).explosionResistance(1200.0f));
    public static final Block PALE_MOSS_BLOCK = Blocks.register("pale_moss_block", (BlockBase.Info var0) -> new BonemealableFeaturePlacerBlock(VegetationFeatures.PALE_MOSS_PATCH_BONEMEAL, (BlockBase.Info)var0), BlockBase.Info.of().ignitedByLava().mapColor(MaterialMapColor.COLOR_LIGHT_GRAY).strength(0.1f).sound(SoundEffectType.MOSS).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PALE_MOSS_CARPET = Blocks.register("pale_moss_carpet", MossyCarpetBlock::new, BlockBase.Info.of().ignitedByLava().mapColor(PALE_MOSS_BLOCK.defaultMapColor()).strength(0.1f).sound(SoundEffectType.MOSS_CARPET).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block PALE_HANGING_MOSS = Blocks.register("pale_hanging_moss", HangingMossBlock::new, BlockBase.Info.of().ignitedByLava().mapColor(PALE_MOSS_BLOCK.defaultMapColor()).noCollision().sound(SoundEffectType.MOSS_CARPET).pushReaction(EnumPistonReaction.DESTROY));
    public static final Block OPEN_EYEBLOSSOM = Blocks.register("open_eyeblossom", (BlockBase.Info var0) -> new EyeblossomBlock(EyeblossomBlock.a.OPEN, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(CREAKING_HEART.defaultMapColor()).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY).randomTicks());
    public static final Block CLOSED_EYEBLOSSOM = Blocks.register("closed_eyeblossom", (BlockBase.Info var0) -> new EyeblossomBlock(EyeblossomBlock.a.CLOSED, (BlockBase.Info)var0), BlockBase.Info.of().mapColor(PALE_OAK_LEAVES.defaultMapColor()).noCollision().instabreak().sound(SoundEffectType.GRASS).offsetType(BlockBase.EnumRandomOffset.XZ).pushReaction(EnumPistonReaction.DESTROY).randomTicks());
    public static final Block POTTED_OPEN_EYEBLOSSOM = Blocks.register("potted_open_eyeblossom", (BlockBase.Info var0) -> new BlockFlowerPot(OPEN_EYEBLOSSOM, (BlockBase.Info)var0), Blocks.flowerPotProperties().randomTicks());
    public static final Block POTTED_CLOSED_EYEBLOSSOM = Blocks.register("potted_closed_eyeblossom", (BlockBase.Info var0) -> new BlockFlowerPot(CLOSED_EYEBLOSSOM, (BlockBase.Info)var0), Blocks.flowerPotProperties().randomTicks());
    public static final Block FIREFLY_BUSH = Blocks.register("firefly_bush", FireflyBushBlock::new, BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).ignitedByLava().lightLevel(var0 -> 2).noCollision().instabreak().sound(SoundEffectType.SWEET_BERRY_BUSH).pushReaction(EnumPistonReaction.DESTROY));

    private static ToIntFunction<IBlockData> litBlockEmission(int var0) {
        return var1 -> var1.getValue(BlockProperties.LIT) != false ? var0 : 0;
    }

    private static Function<IBlockData, MaterialMapColor> waterloggedMapColor(MaterialMapColor var0) {
        return var1 -> var1.getValue(BlockProperties.WATERLOGGED) != false ? MaterialMapColor.WATER : var0;
    }

    private static Boolean never(IBlockData var0, IBlockAccess var1, BlockPosition var2, EntityTypes<?> var3) {
        return false;
    }

    private static Boolean always(IBlockData var0, IBlockAccess var1, BlockPosition var2, EntityTypes<?> var3) {
        return true;
    }

    private static Boolean ocelotOrParrot(IBlockData var0, IBlockAccess var1, BlockPosition var2, EntityTypes<?> var3) {
        return var3 == EntityTypes.OCELOT || var3 == EntityTypes.PARROT;
    }

    private static Block registerBed(String var0, EnumColor var12) {
        return Blocks.register(var0, (BlockBase.Info var1) -> new BlockBed(var12, (BlockBase.Info)var1), BlockBase.Info.of().mapColor(var1 -> var1.getValue(BlockBed.PART) == BlockPropertyBedPart.FOOT ? var12.getMapColor() : MaterialMapColor.WOOL).sound(SoundEffectType.WOOD).strength(0.2f).noOcclusion().ignitedByLava().pushReaction(EnumPistonReaction.DESTROY));
    }

    private static BlockBase.Info logProperties(MaterialMapColor var0, MaterialMapColor var1, SoundEffectType var22) {
        return BlockBase.Info.of().mapColor(var2 -> var2.getValue(BlockRotatable.AXIS) == EnumDirection.EnumAxis.Y ? var0 : var1).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(var22).ignitedByLava();
    }

    private static BlockBase.Info netherStemProperties(MaterialMapColor var0) {
        return BlockBase.Info.of().mapColor(var1 -> var0).instrument(BlockPropertyInstrument.BASS).strength(2.0f).sound(SoundEffectType.STEM);
    }

    private static boolean always(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return true;
    }

    private static boolean never(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return false;
    }

    private static Block registerStainedGlass(String var0, EnumColor var12) {
        return Blocks.register(var0, (BlockBase.Info var1) -> new BlockStainedGlass(var12, (BlockBase.Info)var1), BlockBase.Info.of().mapColor(var12).instrument(BlockPropertyInstrument.HAT).strength(0.3f).sound(SoundEffectType.GLASS).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never));
    }

    private static BlockBase.Info leavesProperties(SoundEffectType var0) {
        return BlockBase.Info.of().mapColor(MaterialMapColor.PLANT).strength(0.2f).randomTicks().sound(var0).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).ignitedByLava().pushReaction(EnumPistonReaction.DESTROY).isRedstoneConductor(Blocks::never);
    }

    private static BlockBase.Info shulkerBoxProperties(MaterialMapColor var0) {
        return BlockBase.Info.of().mapColor(var0).forceSolidOn().strength(2.0f).dynamicShape().noOcclusion().isSuffocating(NOT_CLOSED_SHULKER).isViewBlocking(NOT_CLOSED_SHULKER).pushReaction(EnumPistonReaction.DESTROY);
    }

    private static BlockBase.Info pistonProperties() {
        return BlockBase.Info.of().mapColor(MaterialMapColor.STONE).strength(1.5f).isRedstoneConductor(Blocks::never).isSuffocating(NOT_EXTENDED_PISTON).isViewBlocking(NOT_EXTENDED_PISTON).pushReaction(EnumPistonReaction.BLOCK);
    }

    private static BlockBase.Info buttonProperties() {
        return BlockBase.Info.of().noCollision().strength(0.5f).pushReaction(EnumPistonReaction.DESTROY);
    }

    private static BlockBase.Info flowerPotProperties() {
        return BlockBase.Info.of().instabreak().noOcclusion().pushReaction(EnumPistonReaction.DESTROY);
    }

    private static BlockBase.Info candleProperties(MaterialMapColor var0) {
        return BlockBase.Info.of().mapColor(var0).noOcclusion().strength(0.1f).sound(SoundEffectType.CANDLE).lightLevel(CandleBlock.LIGHT_EMISSION).pushReaction(EnumPistonReaction.DESTROY);
    }

    @Deprecated
    private static Block registerLegacyStair(String var0, Block var12) {
        return Blocks.register(var0, (BlockBase.Info var1) -> new BlockStairs(var12.defaultBlockState(), (BlockBase.Info)var1), BlockBase.Info.ofLegacyCopy(var12));
    }

    private static Block registerStair(String var0, Block var12) {
        return Blocks.register(var0, (BlockBase.Info var1) -> new BlockStairs(var12.defaultBlockState(), (BlockBase.Info)var1), BlockBase.Info.ofFullCopy(var12));
    }

    private static BlockBase.Info wallVariant(Block var0, boolean var1) {
        BlockBase.Info var2 = var0.properties();
        BlockBase.Info var3 = BlockBase.Info.of().overrideLootTable(var0.getLootTable());
        if (var1) {
            var3 = var3.overrideDescription(var0.getDescriptionId());
        }
        return var3;
    }

    private static Block register(ResourceKey<Block> var0, Function<BlockBase.Info, Block> var1, BlockBase.Info var2) {
        Block var3 = var1.apply(var2.setId(var0));
        return IRegistry.register(BuiltInRegistries.BLOCK, var0, var3);
    }

    private static Block register(ResourceKey<Block> var0, BlockBase.Info var1) {
        return Blocks.register(var0, Block::new, var1);
    }

    private static ResourceKey<Block> vanillaBlockId(String var0) {
        return ResourceKey.create(Registries.BLOCK, MinecraftKey.withDefaultNamespace(var0));
    }

    private static Block register(String var0, Function<BlockBase.Info, Block> var1, BlockBase.Info var2) {
        return Blocks.register(Blocks.vanillaBlockId(var0), var1, var2);
    }

    private static Block register(String var0, BlockBase.Info var1) {
        return Blocks.register(var0, Block::new, var1);
    }

    static {
        for (Block var12 : BuiltInRegistries.BLOCK) {
            for (IBlockData var32 : var12.getStateDefinition().getPossibleStates()) {
                Block.BLOCK_STATE_REGISTRY.add(var32);
                var32.initCache();
            }
        }
    }
}

