/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockTripwire
extends Block {
    public static final MapCodec<BlockTripwire> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("hook").forGetter(var0 -> var0.hook), BlockTripwire.propertiesCodec()).apply((Applicative)var02, BlockTripwire::new));
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean ATTACHED = BlockProperties.ATTACHED;
    public static final BlockStateBoolean DISARMED = BlockProperties.DISARMED;
    public static final BlockStateBoolean NORTH = BlockSprawling.NORTH;
    public static final BlockStateBoolean EAST = BlockSprawling.EAST;
    public static final BlockStateBoolean SOUTH = BlockSprawling.SOUTH;
    public static final BlockStateBoolean WEST = BlockSprawling.WEST;
    private static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockTall.PROPERTY_BY_DIRECTION;
    private static final VoxelShape SHAPE_ATTACHED = Block.column(16.0, 1.0, 2.5);
    private static final VoxelShape SHAPE_NOT_ATTACHED = Block.column(16.0, 0.0, 8.0);
    private static final int RECHECK_PERIOD = 10;
    private final Block hook;

    public MapCodec<BlockTripwire> codec() {
        return CODEC;
    }

    public BlockTripwire(Block var0, BlockBase.Info var1) {
        super(var1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWERED, false)).setValue(ATTACHED, false)).setValue(DISARMED, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.hook = var0;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return var0.getValue(ATTACHED) != false ? SHAPE_ATTACHED : SHAPE_NOT_ATTACHED;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(NORTH, this.shouldConnectTo(var1.getBlockState(var2.north()), EnumDirection.NORTH))).setValue(EAST, this.shouldConnectTo(var1.getBlockState(var2.east()), EnumDirection.EAST))).setValue(SOUTH, this.shouldConnectTo(var1.getBlockState(var2.south()), EnumDirection.SOUTH))).setValue(WEST, this.shouldConnectTo(var1.getBlockState(var2.west()), EnumDirection.WEST));
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4.getAxis().isHorizontal()) {
            return (IBlockData)var0.setValue(PROPERTY_BY_DIRECTION.get(var4), this.shouldConnectTo(var6, var4));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.updateSource(var1, var2, var0);
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        if (!var3) {
            this.updateSource(var1, var2, (IBlockData)var0.setValue(POWERED, true));
        }
    }

    @Override
    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        if (!var0.isClientSide() && !var3.getMainHandItem().isEmpty() && var3.getMainHandItem().is(Items.SHEARS)) {
            var0.setBlock(var1, (IBlockData)var2.setValue(DISARMED, true), 260);
            var0.gameEvent((Entity)var3, GameEvent.SHEAR, var1);
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    private void updateSource(World var0, BlockPosition var1, IBlockData var2) {
        block0: for (EnumDirection var6 : new EnumDirection[]{EnumDirection.SOUTH, EnumDirection.WEST}) {
            for (int var7 = 1; var7 < 42; ++var7) {
                BlockPosition var8 = var1.relative(var6, var7);
                IBlockData var9 = var0.getBlockState(var8);
                if (var9.is(this.hook)) {
                    if (var9.getValue(BlockTripwireHook.FACING) != var6.getOpposite()) continue block0;
                    BlockTripwireHook.calculateState(var0, var8, var9, false, true, var7, var2);
                    continue block0;
                }
                if (!var9.is(this)) continue block0;
            }
        }
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, Entity var3) {
        return var0.getShape(var1, var2);
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4) {
        if (var1.isClientSide()) {
            return;
        }
        if (var0.getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(var1, var2, List.of(var3));
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var1.getBlockState(var2).getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(var1, var2);
    }

    private void checkPressed(World var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        List<Entity> var3 = var0.getEntities(null, var2.getShape(var0, var1).bounds().move(var1));
        this.checkPressed(var0, var1, var3);
    }

    private void checkPressed(World var0, BlockPosition var1, List<? extends Entity> var2) {
        IBlockData var3 = var0.getBlockState(var1);
        boolean var4 = var3.getValue(POWERED);
        boolean var5 = false;
        if (!var2.isEmpty()) {
            for (Entity entity : var2) {
                if (entity.isIgnoringBlockTriggers()) continue;
                var5 = true;
                break;
            }
        }
        if (var5 != var4) {
            var3 = (IBlockData)var3.setValue(POWERED, var5);
            var0.setBlock(var1, var3, 3);
            this.updateSource(var0, var1, var3);
        }
        if (var5) {
            var0.scheduleTick(new BlockPosition(var1), this, 10);
        }
    }

    public boolean shouldConnectTo(IBlockData var0, EnumDirection var1) {
        if (var0.is(this.hook)) {
            return var0.getValue(BlockTripwireHook.FACING) == var1.getOpposite();
        }
        return var0.is(this);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            }
        }
        return var0;
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH);
    }
}

