/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockStepAbstract
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockStepAbstract> CODEC = BlockStepAbstract.simpleCodec(BlockStepAbstract::new);
    public static final BlockStateEnum<BlockPropertySlabType> TYPE = BlockProperties.SLAB_TYPE;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_BOTTOM = Block.column(16.0, 0.0, 8.0);
    private static final VoxelShape SHAPE_TOP = Block.column(16.0, 8.0, 16.0);

    public MapCodec<? extends BlockStepAbstract> codec() {
        return CODEC;
    }

    public BlockStepAbstract(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.defaultBlockState().setValue(TYPE, BlockPropertySlabType.BOTTOM)).setValue(WATERLOGGED, false));
    }

    @Override
    protected boolean useShapeForLightOcclusion(IBlockData var0) {
        return var0.getValue(TYPE) != BlockPropertySlabType.DOUBLE;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(TYPE, WATERLOGGED);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return switch (var0.getValue(TYPE)) {
            default -> throw new MatchException(null, null);
            case BlockPropertySlabType.TOP -> SHAPE_TOP;
            case BlockPropertySlabType.BOTTOM -> SHAPE_BOTTOM;
            case BlockPropertySlabType.DOUBLE -> VoxelShapes.block();
        };
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        BlockPosition var1 = var0.getClickedPos();
        IBlockData var2 = var0.getLevel().getBlockState(var1);
        if (var2.is(this)) {
            return (IBlockData)((IBlockData)var2.setValue(TYPE, BlockPropertySlabType.DOUBLE)).setValue(WATERLOGGED, false);
        }
        Fluid var3 = var0.getLevel().getFluidState(var1);
        IBlockData var4 = (IBlockData)((IBlockData)this.defaultBlockState().setValue(TYPE, BlockPropertySlabType.BOTTOM)).setValue(WATERLOGGED, var3.getType() == FluidTypes.WATER);
        EnumDirection var5 = var0.getClickedFace();
        if (var5 == EnumDirection.DOWN || var5 != EnumDirection.UP && var0.getClickLocation().y - (double)var1.getY() > 0.5) {
            return (IBlockData)var4.setValue(TYPE, BlockPropertySlabType.TOP);
        }
        return var4;
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        ItemStack var2 = var1.getItemInHand();
        BlockPropertySlabType var3 = var0.getValue(TYPE);
        if (var3 == BlockPropertySlabType.DOUBLE || !var2.is(this.asItem())) {
            return false;
        }
        if (var1.replacingClickedOnBlock()) {
            boolean var4 = var1.getClickLocation().y - (double)var1.getClickedPos().getY() > 0.5;
            EnumDirection var5 = var1.getClickedFace();
            if (var3 == BlockPropertySlabType.BOTTOM) {
                return var5 == EnumDirection.UP || var4 && var5.getAxis().isHorizontal();
            }
            return var5 == EnumDirection.DOWN || !var4 && var5.getAxis().isHorizontal();
        }
        return true;
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public boolean placeLiquid(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        if (var2.getValue(TYPE) != BlockPropertySlabType.DOUBLE) {
            return IBlockWaterlogged.super.placeLiquid(var0, var1, var2, var3);
        }
        return false;
    }

    @Override
    public boolean canPlaceLiquid(@Nullable EntityLiving var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, FluidType var4) {
        if (var3.getValue(TYPE) != BlockPropertySlabType.DOUBLE) {
            return IBlockWaterlogged.super.canPlaceLiquid(var0, var1, var2, var3, var4);
        }
        return false;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        switch (var1) {
            case LAND: {
                return false;
            }
            case WATER: {
                return var0.getFluidState().is(TagsFluid.WATER);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

