/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityChestTrapped;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockChestTrapped
extends BlockChest {
    public static final MapCodec<BlockChestTrapped> CODEC = BlockChestTrapped.simpleCodec(BlockChestTrapped::new);

    @Override
    public MapCodec<BlockChestTrapped> codec() {
        return CODEC;
    }

    public BlockChestTrapped(BlockBase.Info var0) {
        super(() -> TileEntityTypes.TRAPPED_CHEST, SoundEffects.CHEST_OPEN, SoundEffects.CHEST_CLOSE, var0);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityChestTrapped(var0, var1);
    }

    @Override
    protected Statistic<MinecraftKey> getOpenChestStat() {
        return StatisticList.CUSTOM.get(StatisticList.TRIGGER_TRAPPED_CHEST);
    }

    @Override
    protected boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    protected int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return MathHelper.clamp(TileEntityChest.getOpenCount(var1, var2), 0, 15);
    }

    @Override
    protected int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var3 == EnumDirection.UP) {
            return var0.getSignal(var1, var2, var3);
        }
        return 0;
    }
}

