/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockBell
extends BlockTileEntity {
    public static final MapCodec<BlockBell> CODEC = BlockBell.simpleCodec(BlockBell::new);
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateEnum<BlockPropertyBellAttach> ATTACHMENT = BlockProperties.BELL_ATTACHMENT;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private static final VoxelShape BELL_SHAPE = VoxelShapes.or(Block.column(6.0, 6.0, 13.0), Block.column(8.0, 4.0, 6.0));
    private static final VoxelShape SHAPE_CEILING = VoxelShapes.or(BELL_SHAPE, Block.column(2.0, 13.0, 16.0));
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPE_FLOOR = VoxelShapes.rotateHorizontalAxis(Block.cube(16.0, 16.0, 8.0));
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPE_DOUBLE_WALL = VoxelShapes.rotateHorizontalAxis(VoxelShapes.or(BELL_SHAPE, Block.column(2.0, 16.0, 13.0, 15.0)));
    private static final Map<EnumDirection, VoxelShape> SHAPE_SINGLE_WALL = VoxelShapes.rotateHorizontal(VoxelShapes.or(BELL_SHAPE, Block.boxZ(2.0, 13.0, 15.0, 0.0, 13.0)));
    public static final int EVENT_BELL_RING = 1;

    public MapCodec<BlockBell> codec() {
        return CODEC;
    }

    public BlockBell(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(ATTACHMENT, BlockPropertyBellAttach.FLOOR)).setValue(POWERED, false));
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var6 != var0.getValue(POWERED)) {
            if (var6) {
                this.attemptToRing(var1, var2, null);
            }
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, var6), 3);
        }
    }

    @Override
    protected void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        EntityHuman var6;
        Entity var4 = var3.getOwner();
        EntityHuman var5 = var4 instanceof EntityHuman ? (var6 = (EntityHuman)var4) : null;
        this.onHit(var0, var1, var2, var5, true);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        return this.onHit(var1, var0, var4, var3, true) ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
    }

    public boolean onHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, @Nullable EntityHuman var3, boolean var4) {
        boolean var7;
        EnumDirection var5 = var2.getDirection();
        BlockPosition var6 = var2.getBlockPos();
        boolean bl = var7 = !var4 || this.isProperHit(var1, var5, var2.getLocation().y - (double)var6.getY());
        if (var7) {
            boolean var8 = this.attemptToRing(var3, var0, var6, var5);
            if (var8 && var3 != null) {
                var3.awardStat(StatisticList.BELL_RING);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(IBlockData var0, EnumDirection var1, double var2) {
        if (var1.getAxis() == EnumDirection.EnumAxis.Y || var2 > (double)0.8124f) {
            return false;
        }
        EnumDirection var4 = var0.getValue(FACING);
        BlockPropertyBellAttach var5 = var0.getValue(ATTACHMENT);
        switch (var5) {
            case FLOOR: {
                return var4.getAxis() == var1.getAxis();
            }
            case SINGLE_WALL: 
            case DOUBLE_WALL: {
                return var4.getAxis() != var1.getAxis();
            }
            case CEILING: {
                return true;
            }
        }
        return false;
    }

    public boolean attemptToRing(World var0, BlockPosition var1, @Nullable EnumDirection var2) {
        return this.attemptToRing(null, var0, var1, var2);
    }

    public boolean attemptToRing(@Nullable Entity var0, World var1, BlockPosition var2, @Nullable EnumDirection var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (!var1.isClientSide() && var4 instanceof TileEntityBell) {
            if (var3 == null) {
                var3 = var1.getBlockState(var2).getValue(FACING);
            }
            ((TileEntityBell)var4).onHit(var3);
            var1.playSound(null, var2, SoundEffects.BELL_BLOCK, SoundCategory.BLOCKS, 2.0f, 1.0f);
            var1.gameEvent(var0, GameEvent.BLOCK_CHANGE, var2);
            return true;
        }
        return false;
    }

    private VoxelShape getVoxelShape(IBlockData var0) {
        EnumDirection var1 = var0.getValue(FACING);
        return switch (var0.getValue(ATTACHMENT)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyBellAttach.FLOOR -> SHAPE_FLOOR.get(var1.getAxis());
            case BlockPropertyBellAttach.CEILING -> SHAPE_CEILING;
            case BlockPropertyBellAttach.SINGLE_WALL -> SHAPE_SINGLE_WALL.get(var1);
            case BlockPropertyBellAttach.DOUBLE_WALL -> SHAPE_DOUBLE_WALL.get(var1.getAxis());
        };
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.getVoxelShape(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.getVoxelShape(var0);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var2 = var0.getClickedFace();
        BlockPosition var3 = var0.getClickedPos();
        World var4 = var0.getLevel();
        EnumDirection.EnumAxis var5 = var2.getAxis();
        if (var5 == EnumDirection.EnumAxis.Y) {
            IBlockData var1 = (IBlockData)((IBlockData)this.defaultBlockState().setValue(ATTACHMENT, var2 == EnumDirection.DOWN ? BlockPropertyBellAttach.CEILING : BlockPropertyBellAttach.FLOOR)).setValue(FACING, var0.getHorizontalDirection());
            if (var1.canSurvive(var0.getLevel(), var3)) {
                return var1;
            }
        } else {
            boolean var6 = var5 == EnumDirection.EnumAxis.X && var4.getBlockState(var3.west()).isFaceSturdy(var4, var3.west(), EnumDirection.EAST) && var4.getBlockState(var3.east()).isFaceSturdy(var4, var3.east(), EnumDirection.WEST) || var5 == EnumDirection.EnumAxis.Z && var4.getBlockState(var3.north()).isFaceSturdy(var4, var3.north(), EnumDirection.SOUTH) && var4.getBlockState(var3.south()).isFaceSturdy(var4, var3.south(), EnumDirection.NORTH);
            IBlockData var1 = (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var2.getOpposite())).setValue(ATTACHMENT, var6 ? BlockPropertyBellAttach.DOUBLE_WALL : BlockPropertyBellAttach.SINGLE_WALL);
            if (var1.canSurvive(var0.getLevel(), var0.getClickedPos())) {
                return var1;
            }
            boolean var7 = var4.getBlockState(var3.below()).isFaceSturdy(var4, var3.below(), EnumDirection.UP);
            if ((var1 = (IBlockData)var1.setValue(ATTACHMENT, var7 ? BlockPropertyBellAttach.FLOOR : BlockPropertyBellAttach.CEILING)).canSurvive(var0.getLevel(), var0.getClickedPos())) {
                return var1;
            }
        }
        return null;
    }

    @Override
    protected void onExplosionHit(IBlockData var0, WorldServer var1, BlockPosition var2, Explosion var3, BiConsumer<ItemStack, BlockPosition> var4) {
        if (var3.canTriggerBlocks()) {
            this.attemptToRing(var1, var2, null);
        }
        super.onExplosionHit(var0, var1, var2, var3, var4);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        BlockPropertyBellAttach var8 = var0.getValue(ATTACHMENT);
        EnumDirection var9 = BlockBell.getConnectedDirection(var0).getOpposite();
        if (var9 == var4 && !var0.canSurvive(var1, var3) && var8 != BlockPropertyBellAttach.DOUBLE_WALL) {
            return Blocks.AIR.defaultBlockState();
        }
        if (var4.getAxis() == var0.getValue(FACING).getAxis()) {
            if (var8 == BlockPropertyBellAttach.DOUBLE_WALL && !var6.isFaceSturdy(var1, var5, var4)) {
                return (IBlockData)((IBlockData)var0.setValue(ATTACHMENT, BlockPropertyBellAttach.SINGLE_WALL)).setValue(FACING, var4.getOpposite());
            }
            if (var8 == BlockPropertyBellAttach.SINGLE_WALL && var9.getOpposite() == var4 && var6.isFaceSturdy(var1, var5, var0.getValue(FACING))) {
                return (IBlockData)var0.setValue(ATTACHMENT, BlockPropertyBellAttach.DOUBLE_WALL);
            }
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        EnumDirection var3 = BlockBell.getConnectedDirection(var0).getOpposite();
        if (var3 == EnumDirection.UP) {
            return Block.canSupportCenter(var1, var2.above(), EnumDirection.DOWN);
        }
        return BlockAttachable.canAttach(var1, var2, var3);
    }

    private static EnumDirection getConnectedDirection(IBlockData var0) {
        switch (var0.getValue(ATTACHMENT)) {
            case CEILING: {
                return EnumDirection.DOWN;
            }
            case FLOOR: {
                return EnumDirection.UP;
            }
        }
        return var0.getValue(FACING).getOpposite();
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, ATTACHMENT, POWERED);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityBell(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockBell.createTickerHelper(var2, TileEntityTypes.BELL, var0.isClientSide() ? TileEntityBell::clientTick : TileEntityBell::serverTick);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }
}

