/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBeaconBeam;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockBeacon
extends BlockTileEntity
implements IBeaconBeam {
    public static final MapCodec<BlockBeacon> CODEC = BlockBeacon.simpleCodec(BlockBeacon::new);

    public MapCodec<BlockBeacon> codec() {
        return CODEC;
    }

    public BlockBeacon(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public EnumColor getColor() {
        return EnumColor.WHITE;
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityBeacon(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockBeacon.createTickerHelper(var2, TileEntityTypes.BEACON, TileEntityBeacon::tick);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity tileEntity;
        if (!var1.isClientSide() && (tileEntity = var1.getBlockEntity(var2)) instanceof TileEntityBeacon) {
            TileEntityBeacon var5 = (TileEntityBeacon)tileEntity;
            var3.openMenu(var5);
            var3.awardStat(StatisticList.INTERACT_WITH_BEACON);
        }
        return EnumInteractionResult.SUCCESS;
    }
}

