/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.DecoratedPotRecipe;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeArmorDye;
import net.minecraft.world.item.crafting.RecipeBannerDuplicate;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeBookClone;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeFireworks;
import net.minecraft.world.item.crafting.RecipeFireworksFade;
import net.minecraft.world.item.crafting.RecipeFireworksStar;
import net.minecraft.world.item.crafting.RecipeMapClone;
import net.minecraft.world.item.crafting.RecipeMapExtend;
import net.minecraft.world.item.crafting.RecipeRepair;
import net.minecraft.world.item.crafting.RecipeSingleItem;
import net.minecraft.world.item.crafting.RecipeSmoking;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.RecipeTippedArrow;
import net.minecraft.world.item.crafting.RecipiesShield;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.item.crafting.ShapelessRecipes;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.TransmuteRecipe;

public interface RecipeSerializer<T extends IRecipe<?>> {
    public static final RecipeSerializer<ShapedRecipes> SHAPED_RECIPE = RecipeSerializer.register("crafting_shaped", new ShapedRecipes.Serializer());
    public static final RecipeSerializer<ShapelessRecipes> SHAPELESS_RECIPE = RecipeSerializer.register("crafting_shapeless", new ShapelessRecipes.a());
    public static final RecipeSerializer<RecipeArmorDye> ARMOR_DYE = RecipeSerializer.register("crafting_special_armordye", new IRecipeComplex.Serializer<RecipeArmorDye>(RecipeArmorDye::new));
    public static final RecipeSerializer<RecipeBookClone> BOOK_CLONING = RecipeSerializer.register("crafting_special_bookcloning", new IRecipeComplex.Serializer<RecipeBookClone>(RecipeBookClone::new));
    public static final RecipeSerializer<RecipeMapClone> MAP_CLONING = RecipeSerializer.register("crafting_special_mapcloning", new IRecipeComplex.Serializer<RecipeMapClone>(RecipeMapClone::new));
    public static final RecipeSerializer<RecipeMapExtend> MAP_EXTENDING = RecipeSerializer.register("crafting_special_mapextending", new IRecipeComplex.Serializer<RecipeMapExtend>(RecipeMapExtend::new));
    public static final RecipeSerializer<RecipeFireworks> FIREWORK_ROCKET = RecipeSerializer.register("crafting_special_firework_rocket", new IRecipeComplex.Serializer<RecipeFireworks>(RecipeFireworks::new));
    public static final RecipeSerializer<RecipeFireworksStar> FIREWORK_STAR = RecipeSerializer.register("crafting_special_firework_star", new IRecipeComplex.Serializer<RecipeFireworksStar>(RecipeFireworksStar::new));
    public static final RecipeSerializer<RecipeFireworksFade> FIREWORK_STAR_FADE = RecipeSerializer.register("crafting_special_firework_star_fade", new IRecipeComplex.Serializer<RecipeFireworksFade>(RecipeFireworksFade::new));
    public static final RecipeSerializer<RecipeTippedArrow> TIPPED_ARROW = RecipeSerializer.register("crafting_special_tippedarrow", new IRecipeComplex.Serializer<RecipeTippedArrow>(RecipeTippedArrow::new));
    public static final RecipeSerializer<RecipeBannerDuplicate> BANNER_DUPLICATE = RecipeSerializer.register("crafting_special_bannerduplicate", new IRecipeComplex.Serializer<RecipeBannerDuplicate>(RecipeBannerDuplicate::new));
    public static final RecipeSerializer<RecipiesShield> SHIELD_DECORATION = RecipeSerializer.register("crafting_special_shielddecoration", new IRecipeComplex.Serializer<RecipiesShield>(RecipiesShield::new));
    public static final RecipeSerializer<TransmuteRecipe> TRANSMUTE = RecipeSerializer.register("crafting_transmute", new TransmuteRecipe.a());
    public static final RecipeSerializer<RecipeRepair> REPAIR_ITEM = RecipeSerializer.register("crafting_special_repairitem", new IRecipeComplex.Serializer<RecipeRepair>(RecipeRepair::new));
    public static final RecipeSerializer<FurnaceRecipe> SMELTING_RECIPE = RecipeSerializer.register("smelting", new RecipeCooking.b<FurnaceRecipe>(FurnaceRecipe::new, 200));
    public static final RecipeSerializer<RecipeBlasting> BLASTING_RECIPE = RecipeSerializer.register("blasting", new RecipeCooking.b<RecipeBlasting>(RecipeBlasting::new, 100));
    public static final RecipeSerializer<RecipeSmoking> SMOKING_RECIPE = RecipeSerializer.register("smoking", new RecipeCooking.b<RecipeSmoking>(RecipeSmoking::new, 100));
    public static final RecipeSerializer<RecipeCampfire> CAMPFIRE_COOKING_RECIPE = RecipeSerializer.register("campfire_cooking", new RecipeCooking.b<RecipeCampfire>(RecipeCampfire::new, 100));
    public static final RecipeSerializer<RecipeStonecutting> STONECUTTER = RecipeSerializer.register("stonecutting", new RecipeSingleItem.b<RecipeStonecutting>(RecipeStonecutting::new));
    public static final RecipeSerializer<SmithingTransformRecipe> SMITHING_TRANSFORM = RecipeSerializer.register("smithing_transform", new SmithingTransformRecipe.a());
    public static final RecipeSerializer<SmithingTrimRecipe> SMITHING_TRIM = RecipeSerializer.register("smithing_trim", new SmithingTrimRecipe.a());
    public static final RecipeSerializer<DecoratedPotRecipe> DECORATED_POT_RECIPE = RecipeSerializer.register("crafting_decorated_pot", new IRecipeComplex.Serializer<DecoratedPotRecipe>(DecoratedPotRecipe::new));

    public MapCodec<T> codec();

    @Deprecated
    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec();

    public static <S extends RecipeSerializer<T>, T extends IRecipe<?>> S register(String var0, S var1) {
        return (S)IRegistry.register(BuiltInRegistries.RECIPE_SERIALIZER, var0, var1);
    }
}

