/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public final class TypedEntityData<IdType>
implements TooltipProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TYPE_TAG = "id";
    final IdType type;
    final NBTTagCompound tag;

    public static <T> Codec<TypedEntityData<T>> codec(final Codec<T> var0) {
        return new Codec<TypedEntityData<T>>(){

            public <V> DataResult<Pair<TypedEntityData<T>, V>> decode(DynamicOps<V> var02, V var12) {
                DataResult var22 = var02.get(var12, TypedEntityData.TYPE_TAG).flatMap(var2 -> var0.parse(var02, var2).mapError(var0 -> "Failed to parse 'id': " + var0));
                DataResult var3 = CustomData.COMPOUND_TAG_CODEC.decode(var02, var02.remove(var12, TypedEntityData.TYPE_TAG));
                return var22.apply2stable((var0, var1) -> new Pair(new TypedEntityData<Object>(var0, (NBTTagCompound)var1.getFirst()), var1.getSecond()), var3);
            }

            public <V> DataResult<V> encode(TypedEntityData<T> var02, DynamicOps<V> var1, V var2) {
                return var0.encodeStart(1.asNbtOps(var1), var02.type).flatMap(var3 -> {
                    NBTTagCompound var4 = var02.tag.copy();
                    var4.put(TypedEntityData.TYPE_TAG, (NBTBase)var3);
                    return CustomData.COMPOUND_TAG_CODEC.encode((Object)var4, var1, var2);
                });
            }

            private static <T> DynamicOps<NBTBase> asNbtOps(DynamicOps<T> var02) {
                if (var02 instanceof RegistryOps) {
                    RegistryOps var1 = (RegistryOps)var02;
                    return var1.withParent(DynamicOpsNBT.INSTANCE);
                }
                return DynamicOpsNBT.INSTANCE;
            }

            public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                return this.encode((TypedEntityData)object, dynamicOps, object2);
            }
        };
    }

    public static <B extends ByteBuf, T> StreamCodec<B, TypedEntityData<T>> streamCodec(StreamCodec<B, T> var0) {
        return StreamCodec.composite(var0, TypedEntityData::type, ByteBufCodecs.COMPOUND_TAG, TypedEntityData::tag, TypedEntityData::new);
    }

    TypedEntityData(IdType var0, NBTTagCompound var1) {
        this.type = var0;
        this.tag = TypedEntityData.stripId(var1);
    }

    public static <T> TypedEntityData<T> of(T var0, NBTTagCompound var1) {
        return new TypedEntityData<T>(var0, var1);
    }

    private static NBTTagCompound stripId(NBTTagCompound var0) {
        if (var0.contains(TYPE_TAG)) {
            NBTTagCompound var1 = var0.copy();
            var1.remove(TYPE_TAG);
            return var1;
        }
        return var0;
    }

    public IdType type() {
        return this.type;
    }

    public boolean contains(String var0) {
        return this.tag.contains(var0);
    }

    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (var0 instanceof TypedEntityData) {
            TypedEntityData var1 = (TypedEntityData)var0;
            return this.type == var1.type && this.tag.equals(var1.tag);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.tag.hashCode();
    }

    public String toString() {
        return String.valueOf(this.type) + " " + String.valueOf(this.tag);
    }

    public void loadInto(Entity var0) {
        try (ProblemReporter.j var1 = new ProblemReporter.j(var0.problemPath(), LOGGER);){
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0.registryAccess());
            var0.saveWithoutId(var2);
            NBTTagCompound var3 = var2.buildResult();
            UUID var4 = var0.getUUID();
            var3.merge(this.getUnsafe());
            var0.load(TagValueInput.create((ProblemReporter)var1, (HolderLookup.a)var0.registryAccess(), var3));
            var0.setUUID(var4);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean loadInto(TileEntity var0, HolderLookup.a var1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private NBTTagCompound tag() {
        return this.tag;
    }

    @Deprecated
    public NBTTagCompound getUnsafe() {
        return this.tag;
    }

    public NBTTagCompound copyTagWithoutId() {
        return this.tag.copy();
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        if (this.type.getClass() == EntityTypes.class) {
            EntityTypes var4 = (EntityTypes)this.type;
            if (var0.isPeaceful() && !var4.isAllowedInPeaceful()) {
                var1.accept(IChatBaseComponent.translatable("item.spawn_egg.peaceful").withStyle(EnumChatFormat.RED));
            }
        }
    }

    private static /* synthetic */ String e() {
        return "(rollback)";
    }
}

