/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.sheep.EntitySheep;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntitySign;

public class ItemDye
extends Item
implements SignApplicator {
    private static final Map<EnumColor, ItemDye> ITEM_BY_COLOR = Maps.newEnumMap(EnumColor.class);
    private final EnumColor dyeColor;

    public ItemDye(EnumColor var0, Item.Info var1) {
        super(var1);
        this.dyeColor = var0;
        ITEM_BY_COLOR.put(var0, this);
    }

    @Override
    public EnumInteractionResult interactLivingEntity(ItemStack var0, EntityHuman var1, EntityLiving var2, EnumHand var3) {
        EntitySheep var4;
        if (var2 instanceof EntitySheep && (var4 = (EntitySheep)var2).isAlive() && !var4.isSheared() && var4.getColor() != this.dyeColor) {
            var4.level().playSound((Entity)var1, var4, SoundEffects.DYE_USE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (!var1.level().isClientSide()) {
                var4.setColor(this.dyeColor);
                var0.shrink(1);
            }
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    public EnumColor getDyeColor() {
        return this.dyeColor;
    }

    public static ItemDye byColor(EnumColor var0) {
        return ITEM_BY_COLOR.get(var0);
    }

    @Override
    public boolean tryApplyToSign(World var02, TileEntitySign var1, boolean var2, EntityHuman var3) {
        if (var1.updateText(var0 -> var0.setColor(this.getDyeColor()), var2)) {
            var02.playSound(null, var1.getBlockPos(), SoundEffects.DYE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

