/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public abstract class IProjectile
extends Entity
implements TraceableEntity {
    private static final boolean DEFAULT_LEFT_OWNER = false;
    private static final boolean DEFAULT_HAS_BEEN_SHOT = false;
    @Nullable
    protected EntityReference<Entity> owner;
    private boolean leftOwner = false;
    private boolean leftOwnerChecked;
    private boolean hasBeenShot = false;
    @Nullable
    private Entity lastDeflectedBy;

    IProjectile(EntityTypes<? extends IProjectile> var0, World var1) {
        super(var0, var1);
    }

    protected void setOwner(@Nullable EntityReference<Entity> var0) {
        this.owner = var0;
    }

    public void setOwner(@Nullable Entity var0) {
        this.setOwner(EntityReference.of(var0));
    }

    @Override
    @Nullable
    public Entity getOwner() {
        return EntityReference.getEntity(this.owner, this.level());
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)this);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        EntityReference.store(this.owner, var0, "Owner");
        if (this.leftOwner) {
            var0.putBoolean("LeftOwner", true);
        }
        var0.putBoolean("HasBeenShot", this.hasBeenShot);
    }

    protected boolean ownedBy(Entity var0) {
        return this.owner != null && this.owner.matches(var0);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        this.setOwner(EntityReference.read(var0, "Owner"));
        this.leftOwner = var0.getBooleanOr("LeftOwner", false);
        this.hasBeenShot = var0.getBooleanOr("HasBeenShot", false);
    }

    @Override
    public void restoreFrom(Entity var0) {
        super.restoreFrom(var0);
        if (var0 instanceof IProjectile) {
            IProjectile var1 = (IProjectile)var0;
            this.owner = var1.owner;
        }
    }

    @Override
    public void tick() {
        if (!this.hasBeenShot) {
            this.gameEvent(GameEvent.PROJECTILE_SHOOT, this.getOwner());
            this.hasBeenShot = true;
        }
        this.checkLeftOwner();
        super.tick();
        this.leftOwnerChecked = false;
    }

    protected void checkLeftOwner() {
        if (!this.leftOwner && !this.leftOwnerChecked) {
            this.leftOwner = this.isOutsideOwnerCollisionRange();
            this.leftOwnerChecked = true;
        }
    }

    private boolean isOutsideOwnerCollisionRange() {
        Entity var0 = this.getOwner();
        if (var0 != null) {
            AxisAlignedBB var12 = this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0);
            return var0.getRootVehicle().getSelfAndPassengers().filter(IEntitySelector.CAN_BE_PICKED).noneMatch(var1 -> var12.intersects(var1.getBoundingBox()));
        }
        return true;
    }

    public Vec3D getMovementToShoot(double var0, double var2, double var4, float var6, float var7) {
        return new Vec3D(var0, var2, var4).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)var7), this.random.triangle(0.0, 0.0172275 * (double)var7), this.random.triangle(0.0, 0.0172275 * (double)var7)).scale(var6);
    }

    public void shoot(double var0, double var2, double var4, float var6, float var7) {
        Vec3D var8 = this.getMovementToShoot(var0, var2, var4, var6, var7);
        this.setDeltaMovement(var8);
        this.hasImpulse = true;
        double var9 = var8.horizontalDistance();
        this.setYRot((float)(MathHelper.atan2(var8.x, var8.z) * 57.2957763671875));
        this.setXRot((float)(MathHelper.atan2(var8.y, var9) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity var0, float var1, float var2, float var3, float var4, float var5) {
        float var6 = -MathHelper.sin(var2 * ((float)Math.PI / 180)) * MathHelper.cos(var1 * ((float)Math.PI / 180));
        float var7 = -MathHelper.sin((var1 + var3) * ((float)Math.PI / 180));
        float var8 = MathHelper.cos(var2 * ((float)Math.PI / 180)) * MathHelper.cos(var1 * ((float)Math.PI / 180));
        this.shoot(var6, var7, var8, var4, var5);
        Vec3D var9 = var0.getKnownMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(var9.x, var0.onGround() ? 0.0 : var9.y, var9.z));
    }

    @Override
    public void onAboveBubbleColumn(boolean var0, BlockPosition var1) {
        double var2 = var0 ? -0.03 : 0.1;
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, var2, 0.0));
        IProjectile.sendBubbleColumnParticles(this.level(), var1);
    }

    @Override
    public void onInsideBubbleColumn(boolean var0) {
        double var1 = var0 ? -0.03 : 0.06;
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, var1, 0.0));
        this.resetFallDistance();
    }

    public static <T extends IProjectile> T spawnProjectileFromRotation(a<T> var0, WorldServer var1, ItemStack var2, EntityLiving var3, float var42, float var5, float var6) {
        return (T)IProjectile.spawnProjectile(var0.create(var1, var3, var2), var1, var2, var4 -> var4.shootFromRotation(var3, var3.getXRot(), var3.getYRot(), var42, var5, var6));
    }

    public static <T extends IProjectile> T spawnProjectileUsingShoot(a<T> var0, WorldServer var1, ItemStack var2, EntityLiving var3, double var4, double var6, double var82, float var10, float var11) {
        return (T)IProjectile.spawnProjectile(var0.create(var1, var3, var2), var1, var2, var8 -> var8.shoot(var4, var6, var82, var10, var11));
    }

    public static <T extends IProjectile> T spawnProjectileUsingShoot(T var0, WorldServer var1, ItemStack var2, double var3, double var5, double var7, float var92, float var10) {
        return (T)IProjectile.spawnProjectile(var0, var1, var2, var9 -> var0.shoot(var3, var5, var7, var92, var10));
    }

    public static <T extends IProjectile> T spawnProjectile(T var02, WorldServer var1, ItemStack var2) {
        return (T)IProjectile.spawnProjectile(var02, var1, var2, var0 -> {});
    }

    public static <T extends IProjectile> T spawnProjectile(T var0, WorldServer var1, ItemStack var2, Consumer<T> var3) {
        var3.accept(var0);
        var1.addFreshEntity(var0);
        var0.applyOnProjectileSpawned(var1, var2);
        return var0;
    }

    public void applyOnProjectileSpawned(WorldServer var02, ItemStack var1) {
        EntityArrow var2;
        ItemStack var3;
        EnchantmentManager.onProjectileSpawned(var02, var1, this, var0 -> {});
        IProjectile iProjectile = this;
        if (iProjectile instanceof EntityArrow && (var3 = (var2 = (EntityArrow)iProjectile).getWeaponItem()) != null && !var3.isEmpty() && !var1.getItem().equals(var3.getItem())) {
            EnchantmentManager.onProjectileSpawned(var02, var3, this, var2::onItemBreak);
        }
    }

    protected ProjectileDeflection hitTargetOrDeflectSelf(MovingObjectPosition var0) {
        ProjectileDeflection var2;
        MovingObjectPositionBlock var1;
        if (var0.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY) {
            MovingObjectPositionEntity var22 = (MovingObjectPositionEntity)var0;
            Entity var3 = var22.getEntity();
            ProjectileDeflection var4 = var3.deflection(this);
            if (var4 != ProjectileDeflection.NONE) {
                if (var3 != this.lastDeflectedBy && this.deflect(var4, var3, this.owner, false)) {
                    this.lastDeflectedBy = var3;
                }
                return var4;
            }
        } else if (this.shouldBounceOnWorldBorder() && var0 instanceof MovingObjectPositionBlock && (var1 = (MovingObjectPositionBlock)var0).isWorldBorderHit() && this.deflect(var2 = ProjectileDeflection.REVERSE, null, this.owner, false)) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            return var2;
        }
        this.onHit(var0);
        return ProjectileDeflection.NONE;
    }

    protected boolean shouldBounceOnWorldBorder() {
        return false;
    }

    public boolean deflect(ProjectileDeflection var0, @Nullable Entity var1, @Nullable EntityReference<Entity> var2, boolean var3) {
        var0.deflect(this, var1, this.random);
        if (!this.level().isClientSide()) {
            this.setOwner(var2);
            this.onDeflection(var3);
        }
        return true;
    }

    protected void onDeflection(boolean var0) {
    }

    protected void onItemBreak(Item var0) {
    }

    protected void onHit(MovingObjectPosition var0) {
        MovingObjectPosition.EnumMovingObjectType var1 = var0.getType();
        if (var1 == MovingObjectPosition.EnumMovingObjectType.ENTITY) {
            MovingObjectPositionEntity var2 = (MovingObjectPositionEntity)var0;
            Entity var3 = var2.getEntity();
            if (var3.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE) && var3 instanceof IProjectile) {
                IProjectile var4 = (IProjectile)var3;
                var4.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.owner, true);
            }
            this.onHitEntity(var2);
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, var0.getLocation(), GameEvent.a.of(this, null));
        } else if (var1 == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            MovingObjectPositionBlock var2 = (MovingObjectPositionBlock)var0;
            this.onHitBlock(var2);
            BlockPosition var3 = var2.getBlockPos();
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, var3, GameEvent.a.of(this, this.level().getBlockState(var3)));
        }
    }

    protected void onHitEntity(MovingObjectPositionEntity var0) {
    }

    protected void onHitBlock(MovingObjectPositionBlock var0) {
        IBlockData var1 = this.level().getBlockState(var0.getBlockPos());
        var1.onProjectileHit(this.level(), var1, var0, this);
    }

    protected boolean canHitEntity(Entity var0) {
        if (!var0.canBeHitByProjectile()) {
            return false;
        }
        Entity var1 = this.getOwner();
        return var1 == null || this.leftOwner || !var1.isPassengerOfSameVehicle(var0);
    }

    protected void updateRotation() {
        Vec3D var0 = this.getDeltaMovement();
        double var1 = var0.horizontalDistance();
        this.setXRot(IProjectile.lerpRotation(this.xRotO, (float)(MathHelper.atan2(var0.y, var1) * 57.2957763671875)));
        this.setYRot(IProjectile.lerpRotation(this.yRotO, (float)(MathHelper.atan2(var0.x, var0.z) * 57.2957763671875)));
    }

    protected static float lerpRotation(float var0, float var1) {
        while (var1 - var0 < -180.0f) {
            var0 -= 360.0f;
        }
        while (var1 - var0 >= 180.0f) {
            var0 += 360.0f;
        }
        return MathHelper.lerp(0.2f, var0, var1);
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket(EntityTrackerEntry var0) {
        Entity var1 = this.getOwner();
        return new PacketPlayOutSpawnEntity((Entity)this, var0, var1 == null ? 0 : var1.getId());
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        Entity var1 = this.level().getEntity(var0.getData());
        if (var1 != null) {
            this.setOwner(var1);
        }
    }

    @Override
    public boolean mayInteract(WorldServer var0, BlockPosition var1) {
        Entity var2 = this.getOwner();
        if (var2 instanceof EntityHuman) {
            return var2.mayInteract(var0, var1);
        }
        return var2 == null || var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    public boolean mayBreak(WorldServer var0) {
        return this.getType().is(TagsEntity.IMPACT_PROJECTILES) && var0.getGameRules().getBoolean(GameRules.RULE_PROJECTILESCANBREAKBLOCKS);
    }

    @Override
    public boolean isPickable() {
        return this.getType().is(TagsEntity.REDIRECTABLE_PROJECTILE);
    }

    @Override
    public float getPickRadius() {
        return this.isPickable() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(EntityLiving var0, DamageSource var1) {
        double var2 = this.getDeltaMovement().x;
        double var4 = this.getDeltaMovement().z;
        return DoubleDoubleImmutablePair.of((double)var2, (double)var4);
    }

    @Override
    public int getDimensionChangingDelay() {
        return 2;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (!this.isInvulnerableToBase(var1)) {
            this.markHurt();
        }
        return false;
    }

    @FunctionalInterface
    public static interface a<T extends IProjectile> {
        public T create(WorldServer var1, EntityLiving var2, ItemStack var3);
    }
}

