/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.phys.AxisAlignedBB;

public class MobSpawnerCat
implements MobSpawner {
    private static final int TICK_DELAY = 1200;
    private int nextTick;

    @Override
    public void tick(WorldServer var0, boolean var1) {
        --this.nextTick;
        if (this.nextTick > 0) {
            return;
        }
        this.nextTick = 1200;
        EntityPlayer var2 = var0.getRandomPlayer();
        if (var2 == null) {
            return;
        }
        RandomSource var3 = var0.random;
        int var4 = (8 + var3.nextInt(24)) * (var3.nextBoolean() ? -1 : 1);
        int var5 = (8 + var3.nextInt(24)) * (var3.nextBoolean() ? -1 : 1);
        BlockPosition var6 = var2.blockPosition().offset(var4, 0, var5);
        int var7 = 10;
        if (!var0.hasChunksAt(var6.getX() - 10, var6.getZ() - 10, var6.getX() + 10, var6.getZ() + 10)) {
            return;
        }
        if (EntityPositionTypes.isSpawnPositionOk(EntityTypes.CAT, var0, var6)) {
            if (var0.isCloseToVillage(var6, 2)) {
                this.spawnInVillage(var0, var6);
            } else if (var0.structureManager().getStructureWithPieceAt(var6, StructureTags.CATS_SPAWN_IN).isValid()) {
                this.spawnInHut(var0, var6);
            }
        }
    }

    private void spawnInVillage(WorldServer var02, BlockPosition var1) {
        List<EntityCat> var3;
        int var2 = 48;
        if (var02.getPoiManager().getCountInRange(var0 -> var0.is(PoiTypes.HOME), var1, 48, VillagePlace.Occupancy.IS_OCCUPIED) > 4L && (var3 = var02.getEntitiesOfClass(EntityCat.class, new AxisAlignedBB(var1).inflate(48.0, 8.0, 48.0))).size() < 5) {
            this.spawnCat(var1, var02, false);
        }
    }

    private void spawnInHut(WorldServer var0, BlockPosition var1) {
        int var2 = 16;
        List<EntityCat> var3 = var0.getEntitiesOfClass(EntityCat.class, new AxisAlignedBB(var1).inflate(16.0, 8.0, 16.0));
        if (var3.isEmpty()) {
            this.spawnCat(var1, var0, true);
        }
    }

    private void spawnCat(BlockPosition var0, WorldServer var1, boolean var2) {
        EntityCat var3 = EntityTypes.CAT.create(var1, EntitySpawnReason.NATURAL);
        if (var3 == null) {
            return;
        }
        var3.finalizeSpawn(var1, var1.getCurrentDifficultyAt(var0), EntitySpawnReason.NATURAL, null);
        if (var2) {
            var3.setPersistenceRequired();
        }
        var3.snapTo(var0, 0.0f, 0.0f);
        var1.addFreshEntityWithPassengers(var3);
    }
}

