/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.coppergolem;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorInteractDoor;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.TransportItemsBetweenContainers;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.animal.coppergolem.CopperGolemState;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;

public class CopperGolemAi {
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 1.5f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final int TRANSPORT_ITEM_HORIZONTAL_SEARCH_RADIUS = 32;
    private static final int TRANSPORT_ITEM_VERTICAL_SEARCH_RADIUS = 8;
    private static final int TICK_TO_START_ON_REACHED_INTERACTION = 1;
    private static final int TICK_TO_PLAY_ON_REACHED_SOUND = 9;
    private static final Predicate<IBlockData> TRANSPORT_ITEM_SOURCE_BLOCK = var0 -> var0.is(TagsBlock.COPPER_CHESTS);
    private static final Predicate<IBlockData> TRANSPORT_ITEM_DESTINATION_BLOCK = var0 -> var0.is(Blocks.CHEST) || var0.is(Blocks.TRAPPED_CHEST);
    private static final ImmutableList<SensorType<? extends Sensor<? super CopperGolem>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.HURT_BY);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.IS_PANICKING, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.GAZE_COOLDOWN_TICKS, MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, MemoryModuleType.VISITED_BLOCK_POSITIONS, (Object[])new MemoryModuleType[]{MemoryModuleType.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS, MemoryModuleType.DOORS_TO_CLOSE});

    public static BehaviorController.b<CopperGolem> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static BehaviorController<?> makeBrain(BehaviorController<CopperGolem> var0) {
        CopperGolemAi.initCoreActivity(var0);
        CopperGolemAi.initIdleActivity(var0);
        var0.setCoreActivities(Set.of(Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    public static void updateActivity(CopperGolem var0) {
        var0.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.IDLE));
    }

    private static void initCoreActivity(BehaviorController<CopperGolem> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<CopperGolem>>)ImmutableList.of(new AnimalPanic(1.5f), (Object)new BehaviorLook(45, 90), (Object)new BehavorMove(), BehaviorInteractDoor.create(), (Object)new CountDownCooldownTicks(MemoryModuleType.GAZE_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(BehaviorController<CopperGolem> var0) {
        var0.addActivity(Activity.IDLE, (ImmutableList<Pair<Integer, BehaviorControl<CopperGolem>>>)ImmutableList.of((Object)Pair.of((Object)0, (Object)new TransportItemsBetweenContainers(1.0f, TRANSPORT_ITEM_SOURCE_BLOCK, TRANSPORT_ITEM_DESTINATION_BLOCK, 32, 8, CopperGolemAi.getTargetReachedInteractions(), CopperGolemAi.onTravelling(), CopperGolemAi.shouldQueueForTarget())), (Object)Pair.of((Object)1, SetEntityLookTargetSometimes.create(EntityTypes.PLAYER, 6.0f, UniformInt.of(40, 80))), (Object)Pair.of((Object)2, new BehaviorGateSingle((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_PRESENT)), ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(1.0f, 2, 2), (Object)1), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1))))));
    }

    private static Map<TransportItemsBetweenContainers.a, TransportItemsBetweenContainers.b> getTargetReachedInteractions() {
        return Map.of(TransportItemsBetweenContainers.a.PICKUP_ITEM, CopperGolemAi.onReachedTargetInteraction(CopperGolemState.GETTING_ITEM, SoundEffects.COPPER_GOLEM_ITEM_GET), TransportItemsBetweenContainers.a.PICKUP_NO_ITEM, CopperGolemAi.onReachedTargetInteraction(CopperGolemState.GETTING_NO_ITEM, SoundEffects.COPPER_GOLEM_ITEM_NO_GET), TransportItemsBetweenContainers.a.PLACE_ITEM, CopperGolemAi.onReachedTargetInteraction(CopperGolemState.DROPPING_ITEM, SoundEffects.COPPER_GOLEM_ITEM_DROP), TransportItemsBetweenContainers.a.PLACE_NO_ITEM, CopperGolemAi.onReachedTargetInteraction(CopperGolemState.DROPPING_NO_ITEM, SoundEffects.COPPER_GOLEM_ITEM_NO_DROP));
    }

    private static TransportItemsBetweenContainers.b onReachedTargetInteraction(CopperGolemState var0, @Nullable SoundEffect var1) {
        return (var2, var3, var4) -> {
            if (var2 instanceof CopperGolem) {
                CopperGolem var5 = (CopperGolem)var2;
                IInventory var6 = var3.container();
                if (var4 == 1) {
                    var6.startOpen(var5);
                    var5.setOpenedChestPos(var3.pos());
                    var5.setState(var0);
                }
                if (var4 == 9 && var1 != null) {
                    var5.playSound(var1);
                }
                if (var4 == 60) {
                    if (var6.getEntitiesWithContainerOpen().contains(var2)) {
                        var6.stopOpen(var5);
                    }
                    var5.clearOpenedChestPos();
                }
            }
        };
    }

    private static Consumer<EntityCreature> onTravelling() {
        return var0 -> {
            if (var0 instanceof CopperGolem) {
                CopperGolem var1 = (CopperGolem)var0;
                var1.clearOpenedChestPos();
                var1.setState(CopperGolemState.IDLE);
            }
        };
    }

    private static Predicate<TransportItemsBetweenContainers.d> shouldQueueForTarget() {
        return var0 -> {
            TileEntity var2 = var0.blockEntity();
            if (var2 instanceof TileEntityChest) {
                TileEntityChest var1 = (TileEntityChest)var2;
                return !var1.getEntitiesWithContainerOpen().isEmpty();
            }
            return false;
        };
    }
}

