/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Dynamic;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.HappyGhastAi;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Nullable;

public class HappyGhast
extends EntityAnimal {
    public static final float BABY_SCALE = 0.2375f;
    public static final int WANDER_GROUND_DISTANCE = 16;
    public static final int SMALL_RESTRICTION_RADIUS = 32;
    public static final int LARGE_RESTRICTION_RADIUS = 64;
    public static final int RESTRICTION_RADIUS_BUFFER = 16;
    public static final int FAST_HEALING_TICKS = 20;
    public static final int SLOW_HEALING_TICKS = 600;
    public static final int MAX_PASSANGERS = 4;
    private static final int STILL_TIMEOUT_ON_LOAD_GRACE_PERIOD = 60;
    private static final int MAX_STILL_TIMEOUT = 10;
    public static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    public static final Predicate<ItemStack> IS_FOOD = var0 -> var0.is(TagsItem.HAPPY_GHAST_FOOD);
    private int leashHolderTime = 0;
    private int serverStillTimeout;
    private static final DataWatcherObject<Boolean> IS_LEASH_HOLDER = DataWatcher.defineId(HappyGhast.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> STAYS_STILL = DataWatcher.defineId(HappyGhast.class, DataWatcherRegistry.BOOLEAN);
    private static final float MAX_SCALE = 1.0f;

    public HappyGhast(EntityTypes<? extends HappyGhast> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.moveControl = new EntityGhast.ControllerGhast(this, true, this::isOnStillTimeout);
        this.lookControl = new d();
    }

    private void setServerStillTimeout(int var0) {
        World world;
        if (this.serverStillTimeout <= 0 && var0 > 0 && (world = this.level()) instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
            var1.getChunkSource().chunkMap.sendToTrackingPlayers(this, ClientboundEntityPositionSyncPacket.of(this));
        }
        this.serverStillTimeout = var0;
        this.syncStayStillFlag();
    }

    private NavigationAbstract createBabyNavigation(World var0) {
        return new a(this, var0);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(3, new c());
        this.goalSelector.addGoal(4, new PathfinderGoalTempt.a((EntityInsentient)this, 1.0, var0 -> this.isWearingBodyArmor() || this.isBaby() ? IS_FOOD.test((ItemStack)var0) : var0.is(TagsItem.HAPPY_GHAST_TEMPT_ITEMS), false, 7.0));
        this.goalSelector.addGoal(5, new EntityGhast.PathfinderGoalGhastIdleMove(this, 16));
    }

    private void adultGhastSetup() {
        this.moveControl = new EntityGhast.ControllerGhast(this, true, this::isOnStillTimeout);
        this.lookControl = new d();
        this.navigation = this.createNavigation(this.level());
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var02 = (WorldServer)world;
            this.removeAllGoals(var0 -> true);
            this.registerGoals();
            this.brain.stopAll(var02, this);
            this.brain.clearMemories();
        }
    }

    private void babyGhastSetup() {
        this.moveControl = new ControllerMoveFlying(this, 180, true);
        this.lookControl = new ControllerLook(this);
        this.navigation = this.createBabyNavigation(this.level());
        this.setServerStillTimeout(0);
        this.removeAllGoals(var0 -> true);
    }

    @Override
    protected void ageBoundaryReached() {
        if (this.isBaby()) {
            this.babyGhastSetup();
        } else {
            this.adultGhastSetup();
        }
        super.ageBoundaryReached();
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 20.0).add(GenericAttributes.TEMPT_RANGE, 16.0).add(GenericAttributes.FLYING_SPEED, 0.05).add(GenericAttributes.MOVEMENT_SPEED, 0.05).add(GenericAttributes.FOLLOW_RANGE, 16.0).add(GenericAttributes.CAMERA_DISTANCE, 8.0);
    }

    @Override
    protected float sanitizeScale(float var0) {
        return Math.min(var0, 1.0f);
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
    }

    @Override
    public boolean onClimbable() {
        return false;
    }

    @Override
    public void travel(Vec3D var0) {
        float var1 = (float)this.getAttributeValue(GenericAttributes.FLYING_SPEED) * 5.0f / 3.0f;
        this.travelFlying(var0, var1, var1, var1);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (!var1.isEmptyBlock(var0)) {
            return 0.0f;
        }
        if (var1.isEmptyBlock(var0.below()) && !var1.isEmptyBlock(var0.below(2))) {
            return 10.0f;
        }
        return 5.0f;
    }

    @Override
    public boolean canBreatheUnderwater() {
        if (this.isBaby()) {
            return true;
        }
        return super.canBreatheUnderwater();
    }

    @Override
    protected boolean shouldStayCloseToLeashHolder() {
        return false;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
    }

    @Override
    public float getVoicePitch() {
        return 1.0f;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.NEUTRAL;
    }

    @Override
    public int getAmbientSoundInterval() {
        int var0 = super.getAmbientSoundInterval();
        if (this.isVehicle()) {
            return var0 * 6;
        }
        return var0;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return this.isBaby() ? SoundEffects.GHASTLING_AMBIENT : SoundEffects.HAPPY_GHAST_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return this.isBaby() ? SoundEffects.GHASTLING_HURT : SoundEffects.HAPPY_GHAST_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return this.isBaby() ? SoundEffects.GHASTLING_DEATH : SoundEffects.HAPPY_GHAST_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return this.isBaby() ? 1.0f : 4.0f;
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.HAPPY_GHAST.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    public boolean canFallInLove() {
        return false;
    }

    @Override
    public float getAgeScale() {
        return this.isBaby() ? 0.2375f : 1.0f;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return IS_FOOD.test(var0);
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        if (var0 == EnumItemSlot.BODY) {
            return this.isAlive() && !this.isBaby();
        }
        return super.canUseSlot(var0);
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EnumItemSlot var0) {
        return var0 == EnumItemSlot.BODY;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        EnumInteractionResult var3;
        if (this.isBaby()) {
            return super.mobInteract(var0, var1);
        }
        ItemStack var2 = var0.getItemInHand(var1);
        if (!var2.isEmpty() && (var3 = var2.interactLivingEntity(var0, this, var1)).consumesAction()) {
            return var3;
        }
        if (this.isWearingBodyArmor() && !var0.isSecondaryUseActive()) {
            this.doPlayerRide(var0);
            return EnumInteractionResult.SUCCESS;
        }
        return super.mobInteract(var0, var1);
    }

    private void doPlayerRide(EntityHuman var0) {
        if (!this.level().isClientSide()) {
            var0.startRiding(this);
        }
    }

    @Override
    protected void addPassenger(Entity var0) {
        if (!this.isVehicle()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.HARNESS_GOGGLES_DOWN, this.getSoundSource(), 1.0f, 1.0f);
        }
        super.addPassenger(var0);
        if (!this.level().isClientSide()) {
            if (!this.scanPlayerAboveGhast()) {
                this.setServerStillTimeout(0);
            } else if (this.serverStillTimeout > 10) {
                this.setServerStillTimeout(10);
            }
        }
    }

    @Override
    protected void removePassenger(Entity var0) {
        super.removePassenger(var0);
        if (!this.level().isClientSide()) {
            this.setServerStillTimeout(10);
        }
        if (!this.isVehicle()) {
            this.clearHome();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.HARNESS_GOGGLES_UP, this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return this.getPassengers().size() < 4;
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        Entity var0 = this.getFirstPassenger();
        if (this.isWearingBodyArmor() && !this.isOnStillTimeout() && var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            return var1;
        }
        return super.getControllingPassenger();
    }

    @Override
    protected Vec3D getRiddenInput(EntityHuman var0, Vec3D var1) {
        float var2 = var0.xxa;
        float var3 = 0.0f;
        float var4 = 0.0f;
        if (var0.zza != 0.0f) {
            float var5 = MathHelper.cos(var0.getXRot() * ((float)Math.PI / 180));
            float var6 = -MathHelper.sin(var0.getXRot() * ((float)Math.PI / 180));
            if (var0.zza < 0.0f) {
                var5 *= -0.5f;
                var6 *= -0.5f;
            }
            var4 = var6;
            var3 = var5;
        }
        if (var0.isJumping()) {
            var4 += 0.5f;
        }
        return new Vec3D(var2, var4, var3).scale((double)3.9f * this.getAttributeValue(GenericAttributes.FLYING_SPEED));
    }

    protected Vec2F getRiddenRotation(EntityLiving var0) {
        return new Vec2F(var0.getXRot() * 0.5f, var0.getYRot());
    }

    @Override
    protected void tickRidden(EntityHuman var0, Vec3D var1) {
        super.tickRidden(var0, var1);
        Vec2F var2 = this.getRiddenRotation(var0);
        float var3 = this.getYRot();
        float var4 = MathHelper.wrapDegrees(var2.y - var3);
        float var5 = 0.08f;
        this.setRot(var3 += var4 * 0.08f, var2.x);
        this.yBodyRot = this.yHeadRot = var3;
        this.yRotO = this.yHeadRot;
    }

    protected BehaviorController.b<HappyGhast> brainProvider() {
        return HappyGhastAi.brainProvider();
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return HappyGhastAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        if (this.isBaby()) {
            GameProfilerFiller var1 = Profiler.get();
            var1.push("happyGhastBrain");
            this.brain.tick(var0, this);
            var1.pop();
            var1.push("happyGhastActivityUpdate");
            HappyGhastAi.updateActivity(this);
            var1.pop();
        }
        this.checkRestriction();
        super.customServerAiStep(var0);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        if (this.leashHolderTime > 0) {
            --this.leashHolderTime;
        }
        this.setLeashHolder(this.leashHolderTime > 0);
        if (this.serverStillTimeout > 0) {
            if (this.tickCount > 60) {
                --this.serverStillTimeout;
            }
            this.setServerStillTimeout(this.serverStillTimeout);
        }
        if (this.scanPlayerAboveGhast()) {
            this.setServerStillTimeout(10);
        }
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide()) {
            this.setRequiresPrecisePosition(this.isOnStillTimeout());
        }
        super.aiStep();
        this.continuousHeal();
    }

    private int getHappyGhastRestrictionRadius() {
        if (!this.isBaby() && this.getItemBySlot(EnumItemSlot.BODY).isEmpty()) {
            return 64;
        }
        return 32;
    }

    private void checkRestriction() {
        if (this.isLeashed() || this.isVehicle()) {
            return;
        }
        int var0 = this.getHappyGhastRestrictionRadius();
        if (this.hasHome() && this.getHomePosition().closerThan(this.blockPosition(), var0 + 16) && var0 == this.getHomeRadius()) {
            return;
        }
        this.setHomeTo(this.blockPosition(), var0);
    }

    private void continuousHeal() {
        WorldServer var0;
        block5: {
            block4: {
                World world = this.level();
                if (!(world instanceof WorldServer)) break block4;
                var0 = (WorldServer)world;
                if (this.isAlive() && this.deathTime == 0 && this.getMaxHealth() != this.getHealth()) break block5;
            }
            return;
        }
        boolean var1 = var0.dimensionType().natural() && (this.isInClouds() || var0.precipitationAt(this.blockPosition()) != BiomeBase.Precipitation.NONE);
        if (this.tickCount % (var1 ? 20 : 600) == 0) {
            this.heal(1.0f);
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(IS_LEASH_HOLDER, false);
        var0.define(STAYS_STILL, false);
    }

    private void setLeashHolder(boolean var0) {
        this.entityData.set(IS_LEASH_HOLDER, var0);
    }

    public boolean isLeashHolder() {
        return this.entityData.get(IS_LEASH_HOLDER);
    }

    private void syncStayStillFlag() {
        this.entityData.set(STAYS_STILL, this.serverStillTimeout > 0);
    }

    public boolean staysStill() {
        return this.entityData.get(STAYS_STILL);
    }

    @Override
    public boolean supportQuadLeashAsHolder() {
        return true;
    }

    @Override
    public Vec3D[] getQuadLeashHolderOffsets() {
        return Leashable.createQuadLeashOffsets(this, -0.03125, 0.4375, 0.46875, 0.03125);
    }

    @Override
    public Vec3D getLeashOffset() {
        return Vec3D.ZERO;
    }

    @Override
    public double leashElasticDistance() {
        return 10.0;
    }

    @Override
    public double leashSnapDistance() {
        return 16.0;
    }

    @Override
    public void onElasticLeashPull() {
        super.onElasticLeashPull();
        this.getMoveControl().setWait();
    }

    @Override
    public void notifyLeashHolder(Leashable var0) {
        if (var0.supportQuadLeash()) {
            this.leashHolderTime = 5;
        }
    }

    @Override
    public void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("still_timeout", this.serverStillTimeout);
    }

    @Override
    public void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setServerStillTimeout(var0.getIntOr("still_timeout", 0));
    }

    public boolean isOnStillTimeout() {
        return this.staysStill() || this.serverStillTimeout > 0;
    }

    private boolean scanPlayerAboveGhast() {
        AxisAlignedBB var0 = this.getBoundingBox();
        AxisAlignedBB var1 = new AxisAlignedBB(var0.minX - 1.0, var0.maxY - (double)1.0E-5f, var0.minZ - 1.0, var0.maxX + 1.0, var0.maxY + var0.getYsize() / 2.0, var0.maxZ + 1.0);
        for (EntityHuman entityHuman : this.level().players()) {
            Entity var4;
            if (entityHuman.isSpectator() || (var4 = entityHuman.getRootVehicle()) instanceof HappyGhast || !var1.contains(var4.position())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected EntityAIBodyControl createBodyControl() {
        return new b();
    }

    @Override
    public boolean canBeCollidedWith(@Nullable Entity var0) {
        if (this.isBaby() || !this.isAlive()) {
            return false;
        }
        if (this.level().isClientSide() && var0 instanceof EntityHuman && var0.position().y >= this.getBoundingBox().maxY) {
            return true;
        }
        if (this.isVehicle() && var0 instanceof HappyGhast) {
            return true;
        }
        return this.isOnStillTimeout();
    }

    @Override
    public boolean isFlyingVehicle() {
        return !this.isBaby();
    }

    class d
    extends ControllerLook {
        d() {
            super(HappyGhast.this);
        }

        @Override
        public void tick() {
            if (HappyGhast.this.isOnStillTimeout()) {
                float var0 = d.wrapDegrees90(HappyGhast.this.getYRot());
                HappyGhast.this.setYRot(HappyGhast.this.getYRot() - var0);
                HappyGhast.this.setYHeadRot(HappyGhast.this.getYRot());
                return;
            }
            if (this.lookAtCooldown > 0) {
                --this.lookAtCooldown;
                double var0 = this.wantedX - HappyGhast.this.getX();
                double var2 = this.wantedZ - HappyGhast.this.getZ();
                HappyGhast.this.setYRot(-((float)MathHelper.atan2(var0, var2)) * 57.295776f);
                HappyGhast.this.yHeadRot = HappyGhast.this.yBodyRot = HappyGhast.this.getYRot();
                return;
            }
            EntityGhast.faceMovementDirection(this.mob);
        }

        public static float wrapDegrees90(float var0) {
            float var1 = var0 % 90.0f;
            if (var1 >= 45.0f) {
                var1 -= 90.0f;
            }
            if (var1 < -45.0f) {
                var1 += 90.0f;
            }
            return var1;
        }
    }

    static class a
    extends NavigationFlying {
        public a(HappyGhast var0, World var1) {
            super(var0, var1);
            this.setCanOpenDoors(false);
            this.setCanFloat(true);
            this.setRequiredPathLength(48.0f);
        }

        @Override
        protected boolean canMoveDirectly(Vec3D var0, Vec3D var1) {
            return a.isClearForMovementBetween(this.mob, var0, var1, false);
        }
    }

    class c
    extends PathfinderGoalFloat {
        public c() {
            super(HappyGhast.this);
        }

        @Override
        public boolean canUse() {
            return !HappyGhast.this.isOnStillTimeout() && super.canUse();
        }
    }

    class b
    extends EntityAIBodyControl {
        public b() {
            super(HappyGhast.this);
        }

        @Override
        public void clientTick() {
            if (HappyGhast.this.isVehicle()) {
                HappyGhast.this.yBodyRot = HappyGhast.this.yHeadRot = HappyGhast.this.getYRot();
            }
            super.clientTick();
        }
    }
}

