/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;

public abstract class EntityWaterAnimal
extends EntityCreature {
    public static final int AMBIENT_SOUND_INTERVAL = 120;

    protected EntityWaterAnimal(EntityTypes<? extends EntityWaterAnimal> var0, World var1) {
        super((EntityTypes<? extends EntityCreature>)var0, var1);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this);
    }

    @Override
    public int getAmbientSoundInterval() {
        return 120;
    }

    @Override
    protected int getBaseExperienceReward(WorldServer var0) {
        return 1 + this.random.nextInt(3);
    }

    protected void handleAirSupply(WorldServer var0, int var1) {
        if (this.isAlive() && !this.isInWater()) {
            this.setAirSupply(var1 - 1);
            if (this.shouldTakeDrowningDamage()) {
                this.setAirSupply(0);
                this.hurtServer(var0, this.damageSources().drown(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    @Override
    public void baseTick() {
        int var0 = this.getAirSupply();
        super.baseTick();
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            this.handleAirSupply(var1, var0);
        }
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public boolean canBeLeashed() {
        return false;
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityTypes<? extends EntityWaterAnimal> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        int var5 = var1.getSeaLevel();
        int var6 = var5 - 13;
        return var3.getY() >= var6 && var3.getY() <= var5 && var1.getFluidState(var3.below()).is(TagsFluid.WATER) && var1.getBlockState(var3.above()).is(Blocks.WATER);
    }
}

