/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityPig
extends EntityAnimal
implements ISteerable {
    private static final DataWatcherObject<Integer> DATA_BOOST_TIME = DataWatcher.defineId(EntityPig.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Holder<PigVariant>> DATA_VARIANT_ID = DataWatcher.defineId(EntityPig.class, DataWatcherRegistry.PIG_VARIANT);
    public final SaddleStorage steering;

    public EntityPig(EntityTypes<? extends EntityPig> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.steering = new SaddleStorage(this.entityData, DATA_BOOST_TIME);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 1.25));
        this.goalSelector.addGoal(3, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.addGoal(4, new PathfinderGoalTempt(this, 1.2, var0 -> var0.is(Items.CARROT_ON_A_STICK), false));
        this.goalSelector.addGoal(4, new PathfinderGoalTempt(this, 1.2, var0 -> var0.is(TagsItem.PIG_FOOD), false));
        this.goalSelector.addGoal(5, new PathfinderGoalFollowParent(this, 1.1));
        this.goalSelector.addGoal(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    @Nullable
    public EntityLiving getControllingPassenger() {
        EntityHuman var0;
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof EntityHuman && (var0 = (EntityHuman)entity).isHolding(Items.CARROT_ON_A_STICK)) {
            return var0;
        }
        return super.getControllingPassenger();
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_BOOST_TIME.equals(var0) && this.level().isClientSide()) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_BOOST_TIME, 0);
        var0.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), PigVariants.DEFAULT));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        VariantUtils.writeVariant(var0, this.getVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        VariantUtils.readVariant(var0, Registries.PIG_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.PIG_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.PIG_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PIG_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.PIG_STEP, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        boolean var2 = this.isFood(var0.getItemInHand(var1));
        if (!var2 && this.isSaddled() && !this.isVehicle() && !var0.isSecondaryUseActive()) {
            if (!this.level().isClientSide()) {
                var0.startRiding(this);
            }
            return EnumInteractionResult.SUCCESS;
        }
        EnumInteractionResult var3 = super.mobInteract(var0, var1);
        if (!var3.consumesAction()) {
            ItemStack var4 = var0.getItemInHand(var1);
            if (this.isEquippableInSlot(var4, EnumItemSlot.SADDLE)) {
                return var4.interactLivingEntity(var0, this, var1);
            }
            return EnumInteractionResult.PASS;
        }
        return var3;
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        if (var0 == EnumItemSlot.SADDLE) {
            return this.isAlive() && !this.isBaby();
        }
        return super.canUseSlot(var0);
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EnumItemSlot var0) {
        return var0 == EnumItemSlot.SADDLE || super.canDispenserEquipIntoSlot(var0);
    }

    @Override
    protected Holder<SoundEffect> getEquipSound(EnumItemSlot var0, ItemStack var1, Equippable var2) {
        if (var0 == EnumItemSlot.SADDLE) {
            return SoundEffects.PIG_SADDLE;
        }
        return super.getEquipSound(var0, var1, var2);
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving var0) {
        EnumDirection var1 = this.getMotionDirection();
        if (var1.getAxis() == EnumDirection.EnumAxis.Y) {
            return super.getDismountLocationForPassenger(var0);
        }
        int[][] var2 = DismountUtil.offsetsForDirection(var1);
        BlockPosition var3 = this.blockPosition();
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (EntityPose var6 : var0.getDismountPoses()) {
            AxisAlignedBB var7 = var0.getLocalBoundsForPose(var6);
            for (int[] var11 : var2) {
                var4.set(var3.getX() + var11[0], var3.getY(), var3.getZ() + var11[1]);
                double var12 = this.level().getBlockFloorHeight(var4);
                if (!DismountUtil.isBlockFloorValid(var12)) continue;
                Vec3D var14 = Vec3D.upFromBottomCenterOf(var4, var12);
                if (!DismountUtil.canDismountTo(this.level(), var0, var7.move(var14))) continue;
                var0.setPose(var6);
                return var14;
            }
        }
        return super.getDismountLocationForPassenger(var0);
    }

    @Override
    public void thunderHit(WorldServer var02, EntityLightning var1) {
        if (var02.getDifficulty() != EnumDifficulty.PEACEFUL) {
            EntityPigZombie var2 = this.convertTo(EntityTypes.ZOMBIFIED_PIGLIN, ConversionParams.single(this, false, true), var0 -> {
                if (this.getMainHandItem().isEmpty()) {
                    var0.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.GOLDEN_SWORD));
                }
                var0.setPersistenceRequired();
            });
            if (var2 == null) {
                super.thunderHit(var02, var1);
            }
        } else {
            super.thunderHit(var02, var1);
        }
    }

    @Override
    protected void tickRidden(EntityHuman var0, Vec3D var1) {
        super.tickRidden(var0, var1);
        this.setRot(var0.getYRot(), var0.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.steering.tickBoost();
    }

    @Override
    protected Vec3D getRiddenInput(EntityHuman var0, Vec3D var1) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float getRiddenSpeed(EntityHuman var0) {
        return (float)(this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) * 0.225 * (double)this.steering.boostFactor());
    }

    @Override
    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Override
    @Nullable
    public EntityPig getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityPig var2 = EntityTypes.PIG.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null && var1 instanceof EntityPig) {
            EntityPig var3 = (EntityPig)var1;
            var2.setVariant(this.random.nextBoolean() ? this.getVariant() : var3.getVariant());
        }
        return var2;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.PIG_FOOD);
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public void setVariant(Holder<PigVariant> var0) {
        this.entityData.set(DATA_VARIANT_ID, var0);
    }

    public Holder<PigVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.PIG_VARIANT) {
            return EntityPig.castComponentValue(var0, this.getVariant());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.PIG_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.PIG_VARIANT) {
            this.setVariant(EntityPig.castComponentValue(DataComponents.PIG_VARIANT, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        VariantUtils.selectVariantToSpawn(SpawnContext.create(var0, this.blockPosition()), Registries.PIG_VARIANT).ifPresent(this::setVariant);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

