/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class AxolotlAttackablesSensor
extends NearestVisibleLivingEntitySensor {
    public static final float TARGET_DETECTION_DISTANCE = 8.0f;

    @Override
    protected boolean isMatchingEntity(WorldServer var0, EntityLiving var1, EntityLiving var2) {
        return this.isClose(var1, var2) && var2.isInWater() && (this.isHostileTarget(var2) || this.isHuntTarget(var1, var2)) && Sensor.isEntityAttackable(var0, var1, var2);
    }

    private boolean isHuntTarget(EntityLiving var0, EntityLiving var1) {
        return !var0.getBrain().hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN) && var1.getType().is(TagsEntity.AXOLOTL_HUNT_TARGETS);
    }

    private boolean isHostileTarget(EntityLiving var0) {
        return var0.getType().is(TagsEntity.AXOLOTL_ALWAYS_HOSTILES);
    }

    private boolean isClose(EntityLiving var0, EntityLiving var1) {
        return var1.distanceToSqr(var0) <= 64.0;
    }

    @Override
    protected MemoryModuleType<EntityLiving> getMemory() {
        return MemoryModuleType.NEAREST_ATTACKABLE;
    }
}

