/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.LongJumpToRandomPos;
import net.minecraft.world.level.block.Block;

public class LongJumpToPreferredBlock<E extends EntityInsentient>
extends LongJumpToRandomPos<E> {
    private final TagKey<Block> preferredBlockTag;
    private final float preferredBlocksChance;
    private final List<LongJumpToRandomPos.a> notPrefferedJumpCandidates = new ArrayList<LongJumpToRandomPos.a>();
    private boolean currentlyWantingPreferredOnes;

    public LongJumpToPreferredBlock(UniformInt var0, int var1, int var2, float var3, Function<E, SoundEffect> var4, TagKey<Block> var5, float var6, BiPredicate<E, BlockPosition> var7) {
        super(var0, var1, var2, var3, var4, var7);
        this.preferredBlockTag = var5;
        this.preferredBlocksChance = var6;
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        super.start(var0, var1, var2);
        this.notPrefferedJumpCandidates.clear();
        this.currentlyWantingPreferredOnes = ((Entity)var1).getRandom().nextFloat() < this.preferredBlocksChance;
    }

    @Override
    protected Optional<LongJumpToRandomPos.a> getJumpCandidate(WorldServer var0) {
        if (!this.currentlyWantingPreferredOnes) {
            return super.getJumpCandidate(var0);
        }
        BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
        while (!this.jumpCandidates.isEmpty()) {
            Optional<LongJumpToRandomPos.a> var2 = super.getJumpCandidate(var0);
            if (!var2.isPresent()) continue;
            LongJumpToRandomPos.a var3 = var2.get();
            if (var0.getBlockState(var1.setWithOffset((BaseBlockPosition)var3.targetPos(), EnumDirection.DOWN)).is(this.preferredBlockTag)) {
                return var2;
            }
            this.notPrefferedJumpCandidates.add(var3);
        }
        if (!this.notPrefferedJumpCandidates.isEmpty()) {
            return Optional.of(this.notPrefferedJumpCandidates.remove(0));
        }
        return Optional.empty();
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (E)((EntityInsentient)entityLiving), l2);
    }
}

