/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface IEntityAngerable {
    public static final String TAG_ANGER_TIME = "AngerTime";
    public static final String TAG_ANGRY_AT = "AngryAt";

    public int getRemainingPersistentAngerTime();

    public void setRemainingPersistentAngerTime(int var1);

    @Nullable
    public UUID getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable UUID var1);

    public void startPersistentAngerTimer();

    default public void addPersistentAngerSaveData(ValueOutput var0) {
        var0.putInt(TAG_ANGER_TIME, this.getRemainingPersistentAngerTime());
        var0.storeNullable(TAG_ANGRY_AT, UUIDUtil.CODEC, this.getPersistentAngerTarget());
    }

    default public void readPersistentAngerSaveData(World var0, ValueInput var1) {
        Entity var4;
        this.setRemainingPersistentAngerTime(var1.getIntOr(TAG_ANGER_TIME, 0));
        if (!(var0 instanceof WorldServer)) {
            return;
        }
        WorldServer var2 = (WorldServer)var0;
        UUID var3 = var1.read(TAG_ANGRY_AT, UUIDUtil.CODEC).orElse(null);
        this.setPersistentAngerTarget(var3);
        Entity entity = var4 = var3 != null ? var2.getEntity(var3) : null;
        if (var4 instanceof EntityLiving) {
            EntityLiving var5 = (EntityLiving)var4;
            this.setTarget(var5);
        }
    }

    default public void updatePersistentAnger(WorldServer var0, boolean var1) {
        EntityLiving var2 = this.getTarget();
        UUID var3 = this.getPersistentAngerTarget();
        if ((var2 == null || var2.isDeadOrDying()) && var3 != null && var0.getEntity(var3) instanceof EntityInsentient) {
            this.stopBeingAngry();
            return;
        }
        if (var2 != null && !Objects.equals(var3, var2.getUUID())) {
            this.setPersistentAngerTarget(var2.getUUID());
            this.startPersistentAngerTimer();
        }
        if (!(this.getRemainingPersistentAngerTime() <= 0 || var2 != null && var2.getType() == EntityTypes.PLAYER && var1)) {
            this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
            if (this.getRemainingPersistentAngerTime() == 0) {
                this.stopBeingAngry();
            }
        }
    }

    default public boolean isAngryAt(EntityLiving var0, WorldServer var1) {
        if (!this.canAttack(var0)) {
            return false;
        }
        if (var0.getType() == EntityTypes.PLAYER && this.isAngryAtAllPlayers(var1)) {
            return true;
        }
        return var0.getUUID().equals(this.getPersistentAngerTarget());
    }

    default public boolean isAngryAtAllPlayers(WorldServer var0) {
        return var0.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    default public void playerDied(WorldServer var0, EntityHuman var1) {
        if (!var0.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            return;
        }
        if (!var1.getUUID().equals(this.getPersistentAngerTarget())) {
            return;
        }
        this.stopBeingAngry();
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null);
        this.setRemainingPersistentAngerTime(0);
    }

    @Nullable
    public EntityLiving getLastHurtByMob();

    public void setLastHurtByMob(@Nullable EntityLiving var1);

    public void setTarget(@Nullable EntityLiving var1);

    public boolean canAttack(EntityLiving var1);

    @Nullable
    public EntityLiving getTarget();
}

