/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.TaskScheduler;
import org.slf4j.Logger;

public abstract class AbstractConsecutiveExecutor<T extends Runnable>
implements ProfilerMeasured,
TaskScheduler<T>,
Runnable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AtomicReference<a> status = new AtomicReference<a>(a.SLEEPING);
    private final PairedQueue<T> queue;
    private final Executor executor;
    private final String name;

    public AbstractConsecutiveExecutor(PairedQueue<T> var0, Executor var1, String var2) {
        this.executor = var1;
        this.queue = var0;
        this.name = var2;
        MetricsRegistry.INSTANCE.add(this);
    }

    private boolean canBeScheduled() {
        return !this.isClosed() && !this.queue.isEmpty();
    }

    @Override
    public void close() {
        this.status.set(a.CLOSED);
    }

    private boolean pollTask() {
        if (!this.isRunning()) {
            return false;
        }
        Runnable var0 = this.queue.pop();
        if (var0 == null) {
            return false;
        }
        SystemUtils.runNamed(var0, this.name);
        return true;
    }

    @Override
    public void run() {
        try {
            this.pollTask();
        }
        finally {
            this.setSleeping();
            this.registerForExecution();
        }
    }

    public void runAll() {
        try {
            while (this.pollTask()) {
            }
        }
        finally {
            this.setSleeping();
            this.registerForExecution();
        }
    }

    @Override
    public void schedule(T var0) {
        this.queue.push(var0);
        this.registerForExecution();
    }

    private void registerForExecution() {
        if (this.canBeScheduled() && this.setRunning()) {
            try {
                this.executor.execute(this);
            }
            catch (RejectedExecutionException var0) {
                try {
                    this.executor.execute(this);
                }
                catch (RejectedExecutionException var1) {
                    LOGGER.error("Could not schedule ConsecutiveExecutor", (Throwable)var1);
                }
            }
        }
    }

    public int size() {
        return this.queue.size();
    }

    public boolean hasWork() {
        return this.isRunning() && !this.queue.isEmpty();
    }

    public String toString() {
        return this.name + " " + String.valueOf((Object)this.status.get()) + " " + this.queue.isEmpty();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<MetricSampler> profiledMetrics() {
        return ImmutableList.of((Object)MetricSampler.create(this.name + "-queue-size", MetricCategory.CONSECUTIVE_EXECUTORS, this::size));
    }

    private boolean setRunning() {
        return this.status.compareAndSet(a.SLEEPING, a.RUNNING);
    }

    private void setSleeping() {
        this.status.compareAndSet(a.RUNNING, a.SLEEPING);
    }

    private boolean isRunning() {
        return this.status.get() == a.RUNNING;
    }

    private boolean isClosed() {
        return this.status.get() == a.CLOSED;
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a SLEEPING = new a();
        public static final /* enum */ a RUNNING = new a();
        public static final /* enum */ a CLOSED = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{SLEEPING, RUNNING, CLOSED};
        }

        static {
            d = a.a();
        }
    }
}

