/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.slf4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    public static final String RECIPE_BOOK_TAG = "recipeBook";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final a displayResolver;
    @VisibleForTesting
    public final Set<ResourceKey<IRecipe<?>>> known = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<IRecipe<?>>> highlight = Sets.newIdentityHashSet();

    public RecipeBookServer(a var0) {
        this.displayResolver = var0;
    }

    public void add(ResourceKey<IRecipe<?>> var0) {
        this.known.add(var0);
    }

    public boolean contains(ResourceKey<IRecipe<?>> var0) {
        return this.known.contains(var0);
    }

    public void remove(ResourceKey<IRecipe<?>> var0) {
        this.known.remove(var0);
        this.highlight.remove(var0);
    }

    public void removeHighlight(ResourceKey<IRecipe<?>> var0) {
        this.highlight.remove(var0);
    }

    private void addHighlight(ResourceKey<IRecipe<?>> var0) {
        this.highlight.add(var0);
    }

    public int addRecipes(Collection<RecipeHolder<?>> var0, EntityPlayer var1) {
        ArrayList<ClientboundRecipeBookAddPacket.a> var22 = new ArrayList<ClientboundRecipeBookAddPacket.a>();
        for (RecipeHolder<?> var4 : var0) {
            ResourceKey<IRecipe<?>> var5 = var4.id();
            if (this.known.contains(var5) || var4.value().isSpecial()) continue;
            this.add(var5);
            this.addHighlight(var5);
            this.displayResolver.displaysForRecipe(var5, var2 -> var22.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)var2, var4.value().showNotification(), true)));
            CriterionTriggers.RECIPE_UNLOCKED.trigger(var1, var4);
        }
        if (!var22.isEmpty()) {
            var1.connection.send(new ClientboundRecipeBookAddPacket(var22, false));
        }
        return var22.size();
    }

    public int removeRecipes(Collection<RecipeHolder<?>> var0, EntityPlayer var12) {
        ArrayList var2 = Lists.newArrayList();
        for (RecipeHolder<?> var4 : var0) {
            ResourceKey<IRecipe<?>> var5 = var4.id();
            if (!this.known.contains(var5)) continue;
            this.remove(var5);
            this.displayResolver.displaysForRecipe(var5, var1 -> var2.add(var1.id()));
        }
        if (!var2.isEmpty()) {
            var12.connection.send(new ClientboundRecipeBookRemovePacket(var2));
        }
        return var2.size();
    }

    private void loadRecipes(List<ResourceKey<IRecipe<?>>> var0, Consumer<ResourceKey<IRecipe<?>>> var1, Predicate<ResourceKey<IRecipe<?>>> var2) {
        for (ResourceKey<IRecipe<?>> var4 : var0) {
            if (!var2.test(var4)) {
                LOGGER.error("Tried to load unrecognized recipe: {} removed now.", var4);
                continue;
            }
            var1.accept(var4);
        }
    }

    public void sendInitialRecipeBook(EntityPlayer var0) {
        var0.connection.send(new ClientboundRecipeBookSettingsPacket(this.getBookSettings().copy()));
        ArrayList<ClientboundRecipeBookAddPacket.a> var1 = new ArrayList<ClientboundRecipeBookAddPacket.a>(this.known.size());
        for (ResourceKey<IRecipe<?>> var3 : this.known) {
            this.displayResolver.displaysForRecipe(var3, var2 -> var1.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)var2, false, this.highlight.contains(var3))));
        }
        var0.connection.send(new ClientboundRecipeBookAddPacket(var1, true));
    }

    public void copyOverData(RecipeBookServer var0) {
        this.apply(var0.pack());
    }

    public b pack() {
        return new b(this.bookSettings.copy(), List.copyOf(this.known), List.copyOf(this.highlight));
    }

    private void apply(b var0) {
        this.known.clear();
        this.highlight.clear();
        this.bookSettings.replaceFrom(var0.settings);
        this.known.addAll(var0.known);
        this.highlight.addAll(var0.highlight);
    }

    public void loadUntrusted(b var0, Predicate<ResourceKey<IRecipe<?>>> var1) {
        this.bookSettings.replaceFrom(var0.settings);
        this.loadRecipes(var0.known, this.known::add, var1);
        this.loadRecipes(var0.highlight, this.highlight::add, var1);
    }

    @FunctionalInterface
    public static interface a {
        public void displaysForRecipe(ResourceKey<IRecipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }

    public static final class b
    extends Record {
        final RecipeBookSettings settings;
        final List<ResourceKey<IRecipe<?>>> known;
        final List<ResourceKey<IRecipe<?>>> highlight;
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RecipeBookSettings.MAP_CODEC.forGetter(b::settings), (App)IRecipe.KEY_CODEC.listOf().fieldOf("recipes").forGetter(b::known), (App)IRecipe.KEY_CODEC.listOf().fieldOf("toBeDisplayed").forGetter(b::highlight)).apply((Applicative)var0, b::new));

        public b(RecipeBookSettings var0, List<ResourceKey<IRecipe<?>>> var1, List<ResourceKey<IRecipe<?>>> var2) {
            this.settings = var0;
            this.known = var1;
            this.highlight = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "settings;known;highlight", "settings", "known", "highlight"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "settings;known;highlight", "settings", "known", "highlight"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "settings;known;highlight", "settings", "known", "highlight"}, this, var0);
        }

        public RecipeBookSettings settings() {
            return this.settings;
        }

        public List<ResourceKey<IRecipe<?>>> known() {
            return this.known;
        }

        public List<ResourceKey<IRecipe<?>>> highlight() {
            return this.highlight;
        }
    }
}

