/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.waypoints;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointManager;
import net.minecraft.world.waypoints.WaypointTransmitter;

public class ServerWaypointManager
implements WaypointManager<WaypointTransmitter> {
    private final Set<WaypointTransmitter> waypoints = new HashSet<WaypointTransmitter>();
    private final Set<EntityPlayer> players = new HashSet<EntityPlayer>();
    private final Table<EntityPlayer, WaypointTransmitter, WaypointTransmitter.c> connections = HashBasedTable.create();

    @Override
    public void trackWaypoint(WaypointTransmitter var0) {
        this.waypoints.add(var0);
        for (EntityPlayer var2 : this.players) {
            this.createConnection(var2, var0);
        }
    }

    @Override
    public void updateWaypoint(WaypointTransmitter var0) {
        if (!this.waypoints.contains(var0)) {
            return;
        }
        Map var1 = Tables.transpose(this.connections).row((Object)var0);
        Sets.SetView var2 = Sets.difference(this.players, var1.keySet());
        for (Object var4 : ImmutableSet.copyOf(var1.entrySet())) {
            this.updateConnection((EntityPlayer)var4.getKey(), var0, (WaypointTransmitter.c)var4.getValue());
        }
        for (Object var4 : var2) {
            this.createConnection((EntityPlayer)var4, var0);
        }
    }

    @Override
    public void untrackWaypoint(WaypointTransmitter var02) {
        this.connections.column((Object)var02).forEach((var0, var1) -> var1.disconnect());
        Tables.transpose(this.connections).row((Object)var02).clear();
        this.waypoints.remove(var02);
    }

    public void addPlayer(EntityPlayer var0) {
        this.players.add(var0);
        for (WaypointTransmitter var2 : this.waypoints) {
            this.createConnection(var0, var2);
        }
        if (var0.isTransmittingWaypoint()) {
            this.trackWaypoint(var0);
        }
    }

    public void updatePlayer(EntityPlayer var0) {
        Map var1 = this.connections.row((Object)var0);
        Sets.SetView var2 = Sets.difference(this.waypoints, var1.keySet());
        for (Object var4 : ImmutableSet.copyOf(var1.entrySet())) {
            this.updateConnection(var0, (WaypointTransmitter)var4.getKey(), (WaypointTransmitter.c)var4.getValue());
        }
        for (Object var4 : var2) {
            this.createConnection(var0, (WaypointTransmitter)var4);
        }
    }

    public void removePlayer(EntityPlayer var02) {
        this.connections.row((Object)var02).values().removeIf(var0 -> {
            var0.disconnect();
            return true;
        });
        this.untrackWaypoint(var02);
        this.players.remove(var02);
    }

    public void breakAllConnections() {
        this.connections.values().forEach(WaypointTransmitter.c::disconnect);
        this.connections.clear();
    }

    public void remakeConnections(WaypointTransmitter var0) {
        for (EntityPlayer var2 : this.players) {
            this.createConnection(var2, var0);
        }
    }

    public Set<WaypointTransmitter> transmitters() {
        return this.waypoints;
    }

    private static boolean isLocatorBarEnabledFor(EntityPlayer var0) {
        return var0.level().getServer().getGameRules().getBoolean(GameRules.RULE_LOCATOR_BAR);
    }

    private void createConnection(EntityPlayer var0, WaypointTransmitter var1) {
        if (var0 == var1) {
            return;
        }
        if (!ServerWaypointManager.isLocatorBarEnabledFor(var0)) {
            return;
        }
        var1.makeWaypointConnectionWith(var0).ifPresentOrElse(var2 -> {
            this.connections.put((Object)var0, (Object)var1, var2);
            var2.connect();
        }, () -> {
            WaypointTransmitter.c var2 = (WaypointTransmitter.c)this.connections.remove((Object)var0, (Object)var1);
            if (var2 != null) {
                var2.disconnect();
            }
        });
    }

    private void updateConnection(EntityPlayer var0, WaypointTransmitter var1, WaypointTransmitter.c var22) {
        if (var0 == var1) {
            return;
        }
        if (!ServerWaypointManager.isLocatorBarEnabledFor(var0)) {
            return;
        }
        if (!var22.isBroken()) {
            var22.update();
            return;
        }
        var1.makeWaypointConnectionWith(var0).ifPresentOrElse(var2 -> {
            var2.connect();
            this.connections.put((Object)var0, (Object)var1, var2);
        }, () -> {
            var22.disconnect();
            this.connections.remove((Object)var0, (Object)var1);
        });
    }

    @Override
    public /* synthetic */ void untrackWaypoint(Waypoint waypoint) {
        this.untrackWaypoint((WaypointTransmitter)waypoint);
    }

    @Override
    public /* synthetic */ void trackWaypoint(Waypoint waypoint) {
        this.trackWaypoint((WaypointTransmitter)waypoint);
    }
}

