/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.metadata.pack;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public record PackFormat(int major, int minor) implements Comparable<PackFormat>
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<PackFormat> BOTTOM_CODEC = PackFormat.fullCodec(0);
    public static final Codec<PackFormat> TOP_CODEC = PackFormat.fullCodec(Integer.MAX_VALUE);

    private static Codec<PackFormat> fullCodec(int var0) {
        return ExtraCodecs.compactListCodec(ExtraCodecs.NON_NEGATIVE_INT, ExtraCodecs.NON_NEGATIVE_INT.listOf(1, 256)).xmap(var1 -> var1.size() > 1 ? PackFormat.of((Integer)var1.getFirst(), (Integer)var1.get(1)) : PackFormat.of((Integer)var1.getFirst(), var0), var1 -> var1.minor != var0 ? List.of(Integer.valueOf(var1.major()), Integer.valueOf(var1.minor())) : List.of(Integer.valueOf(var1.major())));
    }

    public static <ResultType, HolderType extends b> DataResult<List<ResultType>> validateHolderList(List<HolderType> var0, int var1, BiFunction<HolderType, InclusiveRange<PackFormat>, ResultType> var2) {
        int var3 = var0.stream().map(b::format).mapToInt(a::effectiveMinMajorVersion).min().orElse(Integer.MAX_VALUE);
        ArrayList<ResultType> var4 = new ArrayList<ResultType>(var0.size());
        for (b var6 : var0) {
            a var7 = var6.format();
            if (var7.min().isEmpty() && var7.max().isEmpty() && var7.supported().isEmpty()) {
                LOGGER.warn("Unknown or broken overlay entry " + String.valueOf(var6));
                continue;
            }
            DataResult<InclusiveRange<PackFormat>> var8 = var7.validate(var1, false, var3 <= var1, "Overlay \"" + String.valueOf(var6) + "\"", "formats");
            if (var8.isSuccess()) {
                var4.add(var2.apply(var6, (InclusiveRange)var8.getOrThrow()));
                continue;
            }
            return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)var8.error().get())).message());
        }
        return DataResult.success(List.copyOf(var4));
    }

    @VisibleForTesting
    public static int lastPreMinorVersion(EnumResourcePackType var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumResourcePackType.CLIENT_RESOURCES -> 64;
            case EnumResourcePackType.SERVER_DATA -> 81;
        };
    }

    public static MapCodec<InclusiveRange<PackFormat>> packCodec(EnumResourcePackType var0) {
        int var12 = PackFormat.lastPreMinorVersion(var0);
        return a.PACK_CODEC.flatXmap(var1 -> var1.validate(var12, true, false, "Pack", "supported_formats"), var1 -> DataResult.success((Object)a.fromRange(var1, var12)));
    }

    public static PackFormat of(int var0, int var1) {
        return new PackFormat(var0, var1);
    }

    public static PackFormat of(int var0) {
        return new PackFormat(var0, 0);
    }

    public InclusiveRange<PackFormat> minorRange() {
        return new InclusiveRange<PackFormat>(this, PackFormat.of(this.major, Integer.MAX_VALUE));
    }

    @Override
    public int compareTo(PackFormat var0) {
        int var1 = Integer.compare(this.major(), var0.major());
        if (var1 != 0) {
            return var1;
        }
        return Integer.compare(this.minor(), var0.minor());
    }

    @Override
    public String toString() {
        if (this.minor == Integer.MAX_VALUE) {
            return String.format(Locale.ROOT, "%d.*", this.major());
        }
        return String.format(Locale.ROOT, "%d.%d", this.major(), this.minor());
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((PackFormat)object);
    }

    public static interface b {
        public a format();
    }

    public record a(Optional<PackFormat> min, Optional<PackFormat> max, Optional<Integer> format, Optional<InclusiveRange<Integer>> supported) {
        static final MapCodec<a> PACK_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BOTTOM_CODEC.optionalFieldOf("min_format").forGetter(a::min), (App)TOP_CODEC.optionalFieldOf("max_format").forGetter(a::max), (App)Codec.INT.optionalFieldOf("pack_format").forGetter(a::format), (App)InclusiveRange.codec(Codec.INT).optionalFieldOf("supported_formats").forGetter(a::supported)).apply((Applicative)var0, a::new));
        public static final MapCodec<a> OVERLAY_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BOTTOM_CODEC.optionalFieldOf("min_format").forGetter(a::min), (App)TOP_CODEC.optionalFieldOf("max_format").forGetter(a::max), (App)InclusiveRange.codec(Codec.INT).optionalFieldOf("formats").forGetter(a::supported)).apply((Applicative)var02, (var0, var1, var2) -> new a((Optional<PackFormat>)var0, (Optional<PackFormat>)var1, var0.map(PackFormat::major), (Optional<InclusiveRange<Integer>>)var2)));

        public static a fromRange(InclusiveRange<PackFormat> var0, int var1) {
            InclusiveRange<Integer> var2 = var0.map(PackFormat::major);
            return new a(Optional.of(var0.minInclusive()), Optional.of(var0.maxInclusive()), var2.isValueInRange(var1) ? Optional.of(var2.minInclusive()) : Optional.empty(), var2.isValueInRange(var1) ? Optional.of(new InclusiveRange<Integer>(var2.minInclusive(), var2.maxInclusive())) : Optional.empty());
        }

        public int effectiveMinMajorVersion() {
            if (this.min.isPresent()) {
                if (this.supported.isPresent()) {
                    return Math.min(this.min.get().major(), this.supported.get().minInclusive());
                }
                return this.min.get().major();
            }
            if (this.supported.isPresent()) {
                return this.supported.get().minInclusive();
            }
            return Integer.MAX_VALUE;
        }

        public DataResult<InclusiveRange<PackFormat>> validate(int var0, boolean var1, boolean var2, String var3, String var4) {
            if (this.min.isPresent() != this.max.isPresent()) {
                return DataResult.error(() -> var3 + " missing field, must declare both min_format and max_format");
            }
            if (var2 && this.supported.isEmpty()) {
                return DataResult.error(() -> var3 + " missing required field " + var4 + ", must be present in all overlays for any overlays to work across game versions");
            }
            if (this.min.isPresent()) {
                return this.validateNewFormat(var0, var1, var2, var3, var4);
            }
            if (this.supported.isPresent()) {
                return this.validateOldFormat(var0, var1, var3, var4);
            }
            if (var1 && this.format.isPresent()) {
                int var5 = this.format.get();
                if (var5 > var0) {
                    return DataResult.error(() -> var3 + " declares support for version newer than " + var0 + ", but is missing mandatory fields min_format and max_format");
                }
                return DataResult.success(new InclusiveRange<PackFormat>(PackFormat.of(var5)));
            }
            return DataResult.error(() -> var3 + " could not be parsed, missing format version information");
        }

        private DataResult<InclusiveRange<PackFormat>> validateNewFormat(int var0, boolean var1, boolean var2, String var3, String var4) {
            int var5 = this.min.get().major();
            int var6 = this.max.get().major();
            if (this.min.get().compareTo(this.max.get()) > 0) {
                return DataResult.error(() -> var3 + " min_format (" + String.valueOf(this.min.get()) + ") is greater than max_format (" + String.valueOf(this.max.get()) + ")");
            }
            if (var5 > var0 && !var2) {
                String var7;
                if (this.supported.isPresent()) {
                    return DataResult.error(() -> var3 + " key " + var4 + " is deprecated starting from pack format " + (var0 + 1) + ". Remove " + var4 + " from your pack.mcmeta.");
                }
                if (var1 && this.format.isPresent() && (var7 = this.validatePackFormatForRange(var5, var6)) != null) {
                    return DataResult.error(() -> var7);
                }
            } else {
                Object var7;
                if (this.supported.isPresent()) {
                    var7 = this.supported.get();
                    if (((InclusiveRange)var7).minInclusive() != var5) {
                        return DataResult.error(() -> var3 + " version declaration mismatch between " + var4 + " (from " + String.valueOf(var7.minInclusive()) + ") and min_format (" + String.valueOf(this.min.get()) + ")");
                    }
                    if (((InclusiveRange)var7).maxInclusive() != var6 && ((InclusiveRange)var7).maxInclusive() != var0) {
                        return DataResult.error(() -> var3 + " version declaration mismatch between " + var4 + " (up to " + String.valueOf(var7.maxInclusive()) + ") and max_format (" + String.valueOf(this.max.get()) + ")");
                    }
                } else {
                    return DataResult.error(() -> var3 + " declares support for format " + var5 + ", but game versions supporting formats 17 to " + var0 + " require a " + var4 + " field. Add \"" + var4 + "\": [" + var5 + ", " + var0 + "] or require a version greater or equal to " + (var0 + 1) + ".0.");
                }
                if (var1) {
                    if (this.format.isPresent()) {
                        var7 = this.validatePackFormatForRange(var5, var6);
                        if (var7 != null) {
                            return DataResult.error(() -> a.b((String)var7));
                        }
                    } else {
                        return DataResult.error(() -> var3 + " declares support for formats up to " + var0 + ", but game versions supporting formats 17 to " + var0 + " require a pack_format field. Add \"pack_format\": " + var5 + " or require a version greater or equal to " + (var0 + 1) + ".0.");
                    }
                }
            }
            return DataResult.success(new InclusiveRange<PackFormat>(this.min.get(), this.max.get()));
        }

        private DataResult<InclusiveRange<PackFormat>> validateOldFormat(int var0, boolean var1, String var2, String var3) {
            InclusiveRange<Integer> var4 = this.supported.get();
            int var5 = var4.minInclusive();
            int var6 = var4.maxInclusive();
            if (var6 > var0) {
                return DataResult.error(() -> var2 + " declares support for version newer than " + var0 + ", but is missing mandatory fields min_format and max_format");
            }
            if (var1) {
                if (this.format.isPresent()) {
                    String var7 = this.validatePackFormatForRange(var5, var6);
                    if (var7 != null) {
                        return DataResult.error(() -> var7);
                    }
                } else {
                    return DataResult.error(() -> var2 + " declares support for formats up to " + var0 + ", but game versions supporting formats 17 to " + var0 + " require a pack_format field. Add \"pack_format\": " + var5 + " or require a version greater or equal to " + (var0 + 1) + ".0.");
                }
            }
            return DataResult.success(new InclusiveRange<Integer>(var5, var6).map(PackFormat::of));
        }

        @Nullable
        private String validatePackFormatForRange(int var0, int var1) {
            int var2 = this.format.get();
            if (var2 < var0 || var2 > var1) {
                return "Pack declared support for versions " + var0 + " to " + var1 + " but declared main format is " + var2;
            }
            if (var2 < 15) {
                return "Multi-version packs cannot support minimum version of less than 15, since this will leave versions in range unable to load pack.";
            }
            return null;
        }

        private static /* synthetic */ String b(String var0) {
            return var0;
        }
    }
}

