/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.notifications;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.world.level.GameRules;

public class NotificationManager
implements NotificationService {
    private final List<NotificationService> notificationServices = Lists.newArrayList();

    public void registerService(NotificationService var0) {
        this.notificationServices.add(var0);
    }

    @Override
    public void playerJoined(EntityPlayer var0) {
        this.notificationServices.forEach(var1 -> var1.playerJoined(var0));
    }

    @Override
    public void playerLeft(EntityPlayer var0) {
        this.notificationServices.forEach(var1 -> var1.playerLeft(var0));
    }

    @Override
    public void serverStarted() {
        this.notificationServices.forEach(NotificationService::serverStarted);
    }

    @Override
    public void serverShuttingDown() {
        this.notificationServices.forEach(NotificationService::serverShuttingDown);
    }

    @Override
    public void serverSaveStarted() {
        this.notificationServices.forEach(NotificationService::serverSaveStarted);
    }

    @Override
    public void serverSaveCompleted() {
        this.notificationServices.forEach(NotificationService::serverSaveCompleted);
    }

    @Override
    public void playerOped(OpListEntry var0) {
        this.notificationServices.forEach(var1 -> var1.playerOped(var0));
    }

    @Override
    public void playerDeoped(OpListEntry var0) {
        this.notificationServices.forEach(var1 -> var1.playerDeoped(var0));
    }

    @Override
    public void playerAddedToAllowlist(NameAndId var0) {
        this.notificationServices.forEach(var1 -> var1.playerAddedToAllowlist(var0));
    }

    @Override
    public void playerRemovedFromAllowlist(NameAndId var0) {
        this.notificationServices.forEach(var1 -> var1.playerRemovedFromAllowlist(var0));
    }

    @Override
    public void ipBanned(IpBanEntry var0) {
        this.notificationServices.forEach(var1 -> var1.ipBanned(var0));
    }

    @Override
    public void ipUnbanned(String var0) {
        this.notificationServices.forEach(var1 -> var1.ipUnbanned(var0));
    }

    @Override
    public void playerBanned(GameProfileBanEntry var0) {
        this.notificationServices.forEach(var1 -> var1.playerBanned(var0));
    }

    @Override
    public void playerUnbanned(NameAndId var0) {
        this.notificationServices.forEach(var1 -> var1.playerUnbanned(var0));
    }

    @Override
    public void onGameRuleChanged(String var0, GameRules.GameRuleValue<?> var1) {
        this.notificationServices.forEach(var2 -> var2.onGameRuleChanged(var0, var1));
    }

    @Override
    public void statusHeartbeat() {
        this.notificationServices.forEach(NotificationService::statusHeartbeat);
    }
}

