/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level.progress;

import com.mojang.logging.LogUtils;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.level.progress.LevelLoadProgressTracker;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import org.slf4j.Logger;

public class LoggingLevelLoadListener
implements LevelLoadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final boolean includePlayerChunks;
    private final LevelLoadProgressTracker progressTracker;
    private boolean closed;
    private long startTime = Long.MAX_VALUE;
    private long nextLogTime = Long.MAX_VALUE;

    public LoggingLevelLoadListener(boolean var0) {
        this.includePlayerChunks = var0;
        this.progressTracker = new LevelLoadProgressTracker(var0);
    }

    public static LoggingLevelLoadListener forDedicatedServer() {
        return new LoggingLevelLoadListener(false);
    }

    public static LoggingLevelLoadListener forSingleplayer() {
        return new LoggingLevelLoadListener(true);
    }

    @Override
    public void start(LevelLoadListener.a var0, int var1) {
        if (this.closed) {
            return;
        }
        if (this.startTime == Long.MAX_VALUE) {
            long var2;
            this.startTime = var2 = SystemUtils.getMillis();
            this.nextLogTime = var2;
        }
        this.progressTracker.start(var0, var1);
        switch (var0) {
            case PREPARE_GLOBAL_SPAWN: {
                LOGGER.info("Selecting global world spawn...");
                break;
            }
            case LOAD_INITIAL_CHUNKS: {
                LOGGER.info("Loading {} persistent chunks...", (Object)var1);
                break;
            }
            case LOAD_PLAYER_CHUNKS: {
                LOGGER.info("Loading {} chunks for player spawn...", (Object)var1);
            }
        }
    }

    @Override
    public void update(LevelLoadListener.a var0, int var1, int var2) {
        if (this.closed) {
            return;
        }
        this.progressTracker.update(var0, var1, var2);
        if (SystemUtils.getMillis() > this.nextLogTime) {
            this.nextLogTime += 500L;
            int var3 = MathHelper.floor(this.progressTracker.get() * 100.0f);
            LOGGER.info(IChatBaseComponent.translatable("menu.preparingSpawn", var3).getString());
        }
    }

    @Override
    public void finish(LevelLoadListener.a var0) {
        LevelLoadListener.a var1;
        if (this.closed) {
            return;
        }
        this.progressTracker.finish(var0);
        LevelLoadListener.a a2 = var1 = this.includePlayerChunks ? LevelLoadListener.a.LOAD_PLAYER_CHUNKS : LevelLoadListener.a.LOAD_INITIAL_CHUNKS;
        if (var0 == var1) {
            LOGGER.info("Time elapsed: {} ms", (Object)(SystemUtils.getMillis() - this.startTime));
            this.nextLogTime = Long.MAX_VALUE;
            this.closed = true;
        }
    }

    @Override
    public void updateFocus(ResourceKey<World> var0, ChunkCoordIntPair var1) {
    }
}

