/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;

public class PlayerSpawnFinder {
    private static final EntitySize PLAYER_DIMENSIONS = EntityTypes.PLAYER.getDimensions();
    private static final int ABSOLUTE_MAX_ATTEMPTS = 1024;
    private final WorldServer level;
    private final BlockPosition spawnSuggestion;
    private final int radius;
    private final int candidateCount;
    private final int coprime;
    private final int offset;
    private int nextCandidateIndex;
    private final CompletableFuture<Vec3D> finishedFuture = new CompletableFuture();

    private PlayerSpawnFinder(WorldServer var0, BlockPosition var1, int var2) {
        this.level = var0;
        this.spawnSuggestion = var1;
        this.radius = var2;
        long var3 = (long)var2 * 2L + 1L;
        this.candidateCount = (int)Math.min(1024L, var3 * var3);
        this.coprime = PlayerSpawnFinder.getCoprime(this.candidateCount);
        this.offset = RandomSource.create().nextInt(this.candidateCount);
    }

    public static CompletableFuture<Vec3D> findSpawn(WorldServer var0, BlockPosition var1) {
        if (!var0.dimensionType().hasSkyLight() || var0.getServer().getWorldData().getGameType() == EnumGamemode.ADVENTURE) {
            return CompletableFuture.completedFuture(PlayerSpawnFinder.fixupSpawnHeight(var0, var1));
        }
        int var2 = Math.max(0, var0.getGameRules().getInt(GameRules.RULE_SPAWN_RADIUS));
        int var3 = MathHelper.floor(var0.getWorldBorder().getDistanceToBorder(var1.getX(), var1.getZ()));
        if (var3 < var2) {
            var2 = var3;
        }
        if (var3 <= 1) {
            var2 = 1;
        }
        PlayerSpawnFinder var4 = new PlayerSpawnFinder(var0, var1, var2);
        var4.scheduleNext();
        return var4.finishedFuture;
    }

    private void scheduleNext() {
        int var0;
        if ((var0 = this.nextCandidateIndex++) < this.candidateCount) {
            int var1 = (this.offset + this.coprime * var0) % this.candidateCount;
            int var2 = var1 % (this.radius * 2 + 1);
            int var3 = var1 / (this.radius * 2 + 1);
            int var4 = this.spawnSuggestion.getX() + var2 - this.radius;
            int var5 = this.spawnSuggestion.getZ() + var3 - this.radius;
            this.scheduleCandidate(var4, var5, var0, () -> {
                BlockPosition var2 = PlayerSpawnFinder.getOverworldRespawnPos(this.level, var4, var5);
                if (var2 != null && PlayerSpawnFinder.noCollisionNoLiquid(this.level, var2)) {
                    return Optional.of(Vec3D.atBottomCenterOf(var2));
                }
                return Optional.empty();
            });
        } else {
            this.scheduleCandidate(this.spawnSuggestion.getX(), this.spawnSuggestion.getZ(), var0, () -> Optional.of(PlayerSpawnFinder.fixupSpawnHeight(this.level, this.spawnSuggestion)));
        }
    }

    private static Vec3D fixupSpawnHeight(ICollisionAccess var0, BlockPosition var1) {
        BlockPosition.MutableBlockPosition var2 = var1.mutable();
        while (!PlayerSpawnFinder.noCollisionNoLiquid(var0, var2) && var2.getY() < var0.getMaxY()) {
            var2.move(EnumDirection.UP);
        }
        var2.move(EnumDirection.DOWN);
        while (PlayerSpawnFinder.noCollisionNoLiquid(var0, var2) && var2.getY() > var0.getMinY()) {
            var2.move(EnumDirection.DOWN);
        }
        var2.move(EnumDirection.UP);
        return Vec3D.atBottomCenterOf(var2);
    }

    private static boolean noCollisionNoLiquid(ICollisionAccess var0, BlockPosition var1) {
        return var0.noCollision(null, PLAYER_DIMENSIONS.makeBoundingBox(var1.getBottomCenter()), true);
    }

    private static int getCoprime(int var0) {
        return var0 <= 16 ? var0 - 1 : 17;
    }

    private void scheduleCandidate(int var0, int var1, int var2, Supplier<Optional<Vec3D>> var3) {
        if (this.finishedFuture.isDone()) {
            return;
        }
        int var42 = SectionPosition.blockToSectionCoord(var0);
        int var52 = SectionPosition.blockToSectionCoord(var1);
        this.level.getChunkSource().addTicketAndLoadWithRadius(TicketType.SPAWN_SEARCH, new ChunkCoordIntPair(var42, var52), 0).whenCompleteAsync((var4, var5) -> {
            Object var6;
            if (var5 == null) {
                try {
                    var6 = (Optional)var3.get();
                    if (((Optional)var6).isPresent()) {
                        this.finishedFuture.complete((Vec3D)((Optional)var6).get());
                    } else {
                        this.scheduleNext();
                    }
                }
                catch (Exception var62) {
                    var5 = var62;
                }
            }
            if (var5 != null) {
                var6 = CrashReport.forThrowable(var5, "Searching for spawn");
                CrashReportSystemDetails var7 = ((CrashReport)var6).addCategory("Spawn Lookup");
                var7.setDetail("Origin", this.spawnSuggestion::toString);
                var7.setDetail("Radius", () -> Integer.toString(this.radius));
                var7.setDetail("Candidate", () -> "[" + var0 + "," + var1 + "]");
                var7.setDetail("Progress", () -> var2 + " out of " + this.candidateCount);
                this.finishedFuture.completeExceptionally(new ReportedException((CrashReport)var6));
            }
        }, (Executor)this.level.getServer());
    }

    @Nullable
    protected static BlockPosition getOverworldRespawnPos(WorldServer var0, int var1, int var2) {
        int var5;
        boolean var3 = var0.dimensionType().hasCeiling();
        Chunk var4 = var0.getChunk(SectionPosition.blockToSectionCoord(var1), SectionPosition.blockToSectionCoord(var2));
        int n2 = var5 = var3 ? var0.getChunkSource().getGenerator().getSpawnHeight(var0) : var4.getHeight(HeightMap.Type.MOTION_BLOCKING, var1 & 0xF, var2 & 0xF);
        if (var5 < var0.getMinY()) {
            return null;
        }
        int var6 = var4.getHeight(HeightMap.Type.WORLD_SURFACE, var1 & 0xF, var2 & 0xF);
        if (var6 <= var5 && var6 > var4.getHeight(HeightMap.Type.OCEAN_FLOOR, var1 & 0xF, var2 & 0xF)) {
            return null;
        }
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        for (int var8 = var5 + 1; var8 >= var0.getMinY(); --var8) {
            var7.set(var1, var8, var2);
            IBlockData var9 = var0.getBlockState(var7);
            if (!var9.getFluidState().isEmpty()) break;
            if (!Block.isFaceFull(var9.getCollisionShape(var0, var7), EnumDirection.UP)) continue;
            return ((BlockPosition)var7.above()).immutable();
        }
        return null;
    }

    @Nullable
    public static BlockPosition getSpawnPosInChunk(WorldServer var0, ChunkCoordIntPair var1) {
        if (SharedConstants.debugVoidTerrain(var1)) {
            return null;
        }
        for (int var2 = var1.getMinBlockX(); var2 <= var1.getMaxBlockX(); ++var2) {
            for (int var3 = var1.getMinBlockZ(); var3 <= var1.getMaxBlockZ(); ++var3) {
                BlockPosition var4 = PlayerSpawnFinder.getOverworldRespawnPos(var0, var2, var3);
                if (var4 == null) continue;
                return var4;
            }
        }
        return null;
    }
}

