/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.TriState;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.b,
GeneratingChunkMap {
    private static final ChunkResult<List<IChunkAccess>> UNLOADED_CHUNK_LIST_RESULT = ChunkResult.error("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<IChunkAccess>>> UNLOADED_CHUNK_LIST_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK_LIST_RESULT);
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    private static final int MAX_ACTIVE_CHUNK_WRITES = 128;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int FORCED_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    public final Long2ObjectLinkedOpenHashMap<PlayerChunk> updatingChunkMap = new Long2ObjectLinkedOpenHashMap();
    public volatile Long2ObjectLinkedOpenHashMap<PlayerChunk> visibleChunkMap = this.updatingChunkMap.clone();
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> pendingUnloads = new Long2ObjectLinkedOpenHashMap();
    private final List<ChunkGenerationTask> pendingGenerationTasks = new ArrayList<ChunkGenerationTask>();
    public final WorldServer level;
    private final LightEngineThreaded lightEngine;
    private final IAsyncTaskHandler<Runnable> mainThreadExecutor;
    private final RandomState randomState;
    private final ChunkGeneratorStructureState chunkGeneratorState;
    private final Supplier<WorldPersistentData> overworldDataStorage;
    private final TicketStorage ticketStorage;
    private final VillagePlace poiManager;
    public final LongSet toDrop = new LongOpenHashSet();
    private boolean modified;
    private final ChunkTaskDispatcher worldgenTaskDispatcher;
    private final ChunkTaskDispatcher lightTaskDispatcher;
    private final ChunkStatusUpdateListener chunkStatusListener;
    public final a distanceManager;
    private final String storageName;
    private final PlayerMap playerMap = new PlayerMap();
    public final Int2ObjectMap<EntityTracker> entityMap = new Int2ObjectOpenHashMap();
    private final Long2ByteMap chunkTypeCache = new Long2ByteOpenHashMap();
    private final Long2LongMap nextChunkSaveTime = new Long2LongOpenHashMap();
    private final LongSet chunksToEagerlySave = new LongLinkedOpenHashSet();
    private final Queue<Runnable> unloadQueue = Queues.newConcurrentLinkedQueue();
    private final AtomicInteger activeChunkWrites = new AtomicInteger();
    public int serverViewDistance;
    private final WorldGenContext worldGenContext;

    public PlayerChunkMap(WorldServer var0, Convertable.ConversionSession var1, DataFixer var2, StructureTemplateManager var3, Executor var4, IAsyncTaskHandler<Runnable> var5, ILightAccess var6, ChunkGenerator var7, ChunkStatusUpdateListener var8, Supplier<WorldPersistentData> var9, TicketStorage var10, int var11, boolean var12) {
        super(new RegionStorageInfo(var1.getLevelId(), var0.dimension(), "chunk"), var1.getDimensionPath(var0.dimension()).resolve("region"), var2, var12);
        Object var17;
        Path var13 = var1.getDimensionPath(var0.dimension());
        this.storageName = var13.getFileName().toString();
        this.level = var0;
        IRegistryCustom var14 = var0.registryAccess();
        long var15 = var0.getSeed();
        if (var7 instanceof ChunkGeneratorAbstract) {
            var17 = (ChunkGeneratorAbstract)var7;
            this.randomState = RandomState.create(((ChunkGeneratorAbstract)var17).generatorSettings().value(), var14.lookupOrThrow(Registries.NOISE), var15);
        } else {
            this.randomState = RandomState.create(GeneratorSettingBase.dummy(), var14.lookupOrThrow(Registries.NOISE), var15);
        }
        this.chunkGeneratorState = var7.createState(var14.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, var15);
        this.mainThreadExecutor = var5;
        var17 = new ConsecutiveExecutor(var4, "worldgen");
        this.chunkStatusListener = var8;
        ConsecutiveExecutor var18 = new ConsecutiveExecutor(var4, "light");
        this.worldgenTaskDispatcher = new ChunkTaskDispatcher((TaskScheduler<Runnable>)var17, var4);
        this.lightTaskDispatcher = new ChunkTaskDispatcher(var18, var4);
        this.lightEngine = new LightEngineThreaded(var6, this, this.level.dimensionType().hasSkyLight(), var18, this.lightTaskDispatcher);
        this.distanceManager = new a(var10, var4, var5);
        this.overworldDataStorage = var9;
        this.ticketStorage = var10;
        this.poiManager = new VillagePlace(new RegionStorageInfo(var1.getLevelId(), var0.dimension(), "poi"), var13.resolve("poi"), var2, var12, var14, var0.getServer(), var0);
        this.setServerViewDistance(var11);
        this.worldGenContext = new WorldGenContext(var0, var7, var3, this.lightEngine, var5, this::setChunkUnsaved);
    }

    private void setChunkUnsaved(ChunkCoordIntPair var0) {
        this.chunksToEagerlySave.add(var0.toLong());
    }

    protected ChunkGenerator generator() {
        return this.worldGenContext.generator();
    }

    protected ChunkGeneratorStructureState generatorState() {
        return this.chunkGeneratorState;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    public boolean isChunkTracked(EntityPlayer var0, int var1, int var2) {
        return var0.getChunkTrackingView().contains(var1, var2) && !var0.connection.chunkSender.isPending(ChunkCoordIntPair.asLong(var1, var2));
    }

    private boolean isChunkOnTrackedBorder(EntityPlayer var0, int var1, int var2) {
        if (!this.isChunkTracked(var0, var1, var2)) {
            return false;
        }
        for (int var3 = -1; var3 <= 1; ++var3) {
            for (int var4 = -1; var4 <= 1; ++var4) {
                if (var3 == 0 && var4 == 0 || this.isChunkTracked(var0, var1 + var3, var2 + var4)) continue;
                return true;
            }
        }
        return false;
    }

    protected LightEngineThreaded getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    public PlayerChunk getUpdatingChunkIfPresent(long var0) {
        return (PlayerChunk)this.updatingChunkMap.get(var0);
    }

    @Nullable
    protected PlayerChunk getVisibleChunkIfPresent(long var0) {
        return (PlayerChunk)this.visibleChunkMap.get(var0);
    }

    @Nullable
    public ChunkStatus getLatestStatus(long var0) {
        PlayerChunk var2 = this.getVisibleChunkIfPresent(var0);
        return var2 != null ? var2.getLatestStatus() : null;
    }

    protected IntSupplier getChunkQueueLevel(long var0) {
        return () -> {
            PlayerChunk var2 = this.getVisibleChunkIfPresent(var0);
            if (var2 == null) {
                return ChunkTaskQueue.PRIORITY_LEVEL_COUNT - 1;
            }
            return Math.min(var2.getQueueLevel(), ChunkTaskQueue.PRIORITY_LEVEL_COUNT - 1);
        };
    }

    public String getChunkDebugData(ChunkCoordIntPair var0) {
        PlayerChunk var1 = this.getVisibleChunkIfPresent(var0.toLong());
        if (var1 == null) {
            return "null";
        }
        String var2 = var1.getTicketLevel() + "\n";
        ChunkStatus var3 = var1.getLatestStatus();
        IChunkAccess var4 = var1.getLatestChunk();
        if (var3 != null) {
            var2 = var2 + "St: \u00a7" + var3.getIndex() + String.valueOf(var3) + "\u00a7r\n";
        }
        if (var4 != null) {
            var2 = var2 + "Ch: \u00a7" + var4.getPersistedStatus().getIndex() + String.valueOf(var4.getPersistedStatus()) + "\u00a7r\n";
        }
        FullChunkStatus var5 = var1.getFullStatus();
        var2 = var2 + String.valueOf('\u00a7') + var5.ordinal() + String.valueOf((Object)var5);
        return var2 + "\u00a7r";
    }

    CompletableFuture<ChunkResult<List<IChunkAccess>>> getChunkRangeFuture(PlayerChunk var02, int var1, IntFunction<ChunkStatus> var2) {
        if (var1 == 0) {
            ChunkStatus var3 = var2.apply(0);
            return var02.scheduleChunkGenerationTask(var3, this).thenApply(var0 -> var0.map(List::of));
        }
        int var3 = MathHelper.square(var1 * 2 + 1);
        ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>> var4 = new ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>>(var3);
        ChunkCoordIntPair var5 = var02.getPos();
        for (int var6 = -var1; var6 <= var1; ++var6) {
            for (int var7 = -var1; var7 <= var1; ++var7) {
                int var8 = Math.max(Math.abs(var7), Math.abs(var6));
                long var9 = ChunkCoordIntPair.asLong(var5.x + var7, var5.z + var6);
                PlayerChunk var11 = this.getUpdatingChunkIfPresent(var9);
                if (var11 == null) {
                    return UNLOADED_CHUNK_LIST_FUTURE;
                }
                ChunkStatus var12 = var2.apply(var8);
                var4.add(var11.scheduleChunkGenerationTask(var12, this));
            }
        }
        return SystemUtils.sequence(var4).thenApply(var0 -> {
            ArrayList<IChunkAccess> var1 = new ArrayList<IChunkAccess>(var0.size());
            for (ChunkResult var3 : var0) {
                if (var3 == null) {
                    throw this.debugFuturesAndCreateReportedException(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                IChunkAccess var4 = var3.orElse(null);
                if (var4 == null) {
                    return UNLOADED_CHUNK_LIST_RESULT;
                }
                var1.add(var4);
            }
            return ChunkResult.of(var1);
        });
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException var0, String var12) {
        StringBuilder var2 = new StringBuilder();
        Consumer<PlayerChunk> var3 = var1 -> var1.getAllFutures().forEach(var2 -> {
            ChunkStatus var3 = (ChunkStatus)var2.getFirst();
            CompletableFuture var4 = (CompletableFuture)var2.getSecond();
            if (var4 != null && var4.isDone() && var4.join() == null) {
                var2.append(var1.getPos()).append(" - status: ").append(var3).append(" future: ").append(var4).append(System.lineSeparator());
            }
        });
        var2.append("Updating:").append(System.lineSeparator());
        this.updatingChunkMap.values().forEach(var3);
        var2.append("Visible:").append(System.lineSeparator());
        this.visibleChunkMap.values().forEach(var3);
        CrashReport var4 = CrashReport.forThrowable(var0, "Chunk loading");
        CrashReportSystemDetails var5 = var4.addCategory("Chunk loading");
        var5.setDetail("Details", var12);
        var5.setDetail("Futures", var2);
        return new ReportedException(var4);
    }

    public CompletableFuture<ChunkResult<Chunk>> prepareEntityTickingChunk(PlayerChunk var03) {
        return this.getChunkRangeFuture(var03, 2, var0 -> ChunkStatus.FULL).thenApply(var02 -> var02.map(var0 -> (Chunk)var0.get(var0.size() / 2)));
    }

    @Nullable
    PlayerChunk updateChunkScheduling(long var0, int var2, @Nullable PlayerChunk var3, int var4) {
        if (!ChunkLevel.isLoaded(var4) && !ChunkLevel.isLoaded(var2)) {
            return var3;
        }
        if (var3 != null) {
            var3.setTicketLevel(var2);
        }
        if (var3 != null) {
            if (!ChunkLevel.isLoaded(var2)) {
                this.toDrop.add(var0);
            } else {
                this.toDrop.remove(var0);
            }
        }
        if (ChunkLevel.isLoaded(var2) && var3 == null) {
            var3 = (PlayerChunk)this.pendingUnloads.remove(var0);
            if (var3 != null) {
                var3.setTicketLevel(var2);
            } else {
                var3 = new PlayerChunk(new ChunkCoordIntPair(var0), var2, this.level, this.lightEngine, this::onLevelChange, this);
            }
            this.updatingChunkMap.put(var0, (Object)var3);
            this.modified = true;
        }
        return var3;
    }

    private void onLevelChange(ChunkCoordIntPair var0, IntSupplier var1, int var2, IntConsumer var3) {
        this.worldgenTaskDispatcher.onLevelChange(var0, var1, var2, var3);
        this.lightTaskDispatcher.onLevelChange(var0, var1, var2, var3);
    }

    @Override
    public void close() throws IOException {
        try {
            this.worldgenTaskDispatcher.close();
            this.lightTaskDispatcher.close();
            this.poiManager.close();
        }
        finally {
            super.close();
        }
    }

    protected void saveAllChunks(boolean var02) {
        if (var02) {
            List<PlayerChunk> var12 = this.visibleChunkMap.values().stream().filter(PlayerChunk::wasAccessibleSinceLastSave).peek(PlayerChunk::refreshAccessibility).toList();
            MutableBoolean var2 = new MutableBoolean();
            do {
                var2.setFalse();
                var12.stream().map(var0 -> {
                    this.mainThreadExecutor.managedBlock(var0::isReadyForSaving);
                    return var0.getLatestChunk();
                }).filter(var0 -> var0 instanceof ProtoChunkExtension || var0 instanceof Chunk).filter(this::save).forEach(var1 -> var2.setTrue());
            } while (var2.isTrue());
            this.poiManager.flushAll();
            this.processUnloads(() -> true);
            this.flushWorker();
        } else {
            this.nextChunkSaveTime.clear();
            long var13 = SystemUtils.getMillis();
            for (PlayerChunk var4 : this.visibleChunkMap.values()) {
                this.saveChunkIfNeeded(var4, var13);
            }
        }
    }

    protected void tick(BooleanSupplier var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("poi");
        this.poiManager.tick(var0);
        var1.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads(var0);
        }
        var1.pop();
    }

    public boolean hasWork() {
        return this.lightEngine.hasLightWork() || !this.pendingUnloads.isEmpty() || !this.updatingChunkMap.isEmpty() || this.poiManager.hasWork() || !this.toDrop.isEmpty() || !this.unloadQueue.isEmpty() || this.worldgenTaskDispatcher.hasWork() || this.lightTaskDispatcher.hasWork() || this.distanceManager.hasTickets();
    }

    private void processUnloads(BooleanSupplier var0) {
        Runnable var2;
        LongIterator var1 = this.toDrop.iterator();
        while (var1.hasNext()) {
            long var22 = var1.nextLong();
            PlayerChunk var4 = (PlayerChunk)this.updatingChunkMap.get(var22);
            if (var4 != null) {
                this.updatingChunkMap.remove(var22);
                this.pendingUnloads.put(var22, (Object)var4);
                this.modified = true;
                this.scheduleUnload(var22, var4);
            }
            var1.remove();
        }
        for (int var3 = Math.max(0, this.unloadQueue.size() - 2000); (var3 > 0 || var0.getAsBoolean()) && (var2 = this.unloadQueue.poll()) != null; --var3) {
            var2.run();
        }
        this.saveChunksEagerly(var0);
    }

    private void saveChunksEagerly(BooleanSupplier var0) {
        long var1 = SystemUtils.getMillis();
        int var3 = 0;
        LongIterator var4 = this.chunksToEagerlySave.iterator();
        while (var3 < 20 && this.activeChunkWrites.get() < 128 && var0.getAsBoolean() && var4.hasNext()) {
            IChunkAccess var8;
            long var5 = var4.nextLong();
            PlayerChunk var7 = (PlayerChunk)this.visibleChunkMap.get(var5);
            IChunkAccess iChunkAccess = var8 = var7 != null ? var7.getLatestChunk() : null;
            if (var8 == null || !var8.isUnsaved()) {
                var4.remove();
                continue;
            }
            if (!this.saveChunkIfNeeded(var7, var1)) continue;
            ++var3;
            var4.remove();
        }
    }

    private void scheduleUnload(long var0, PlayerChunk var22) {
        CompletableFuture<?> var3 = var22.getSaveSyncFuture();
        ((CompletableFuture)var3.thenRunAsync(() -> {
            CompletableFuture<?> var4 = var22.getSaveSyncFuture();
            if (var4 != var3) {
                this.scheduleUnload(var0, var22);
                return;
            }
            IChunkAccess var5 = var22.getLatestChunk();
            if (this.pendingUnloads.remove(var0, (Object)var22) && var5 != null) {
                Chunk var6;
                if (var5 instanceof Chunk) {
                    var6 = (Chunk)var5;
                    var6.setLoaded(false);
                }
                this.save(var5);
                if (var5 instanceof Chunk) {
                    var6 = (Chunk)var5;
                    this.level.unload(var6);
                }
                this.lightEngine.updateChunkStatus(var5.getPos());
                this.lightEngine.tryScheduleUpdate();
                this.nextChunkSaveTime.remove(var5.getPos().toLong());
            }
        }, this.unloadQueue::add)).whenComplete((var1, var2) -> {
            if (var2 != null) {
                LOGGER.error("Failed to save chunk {}", (Object)var22.getPos(), var2);
            }
        });
    }

    protected boolean promoteChunkMap() {
        if (!this.modified) {
            return false;
        }
        this.visibleChunkMap = this.updatingChunkMap.clone();
        this.modified = false;
        return true;
    }

    private CompletableFuture<IChunkAccess> scheduleChunkLoad(ChunkCoordIntPair var02) {
        CompletionStage var13 = this.readChunk(var02).thenApplyAsync(var12 -> var12.map(var1 -> {
            SerializableChunkData var2 = SerializableChunkData.parse(this.level, this.level.palettedContainerFactory(), var1);
            if (var2 == null) {
                LOGGER.error("Chunk file at {} is missing level data, skipping", (Object)var02);
            }
            return var2;
        }), SystemUtils.backgroundExecutor().forName("parseChunk"));
        CompletableFuture<?> var2 = this.poiManager.prefetch(var02);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)var13).thenCombine(var2, (var0, var1) -> var0)).thenApplyAsync(var1 -> {
            Profiler.get().incrementCounter("chunkLoad");
            if (var1.isPresent()) {
                ProtoChunk var2 = ((SerializableChunkData)var1.get()).read(this.level, this.poiManager, this.storageInfo(), var02);
                this.markPosition(var02, ((IChunkAccess)var2).getPersistedStatus().getChunkType());
                return var2;
            }
            return this.createEmptyChunk(var02);
        }, (Executor)this.mainThreadExecutor)).exceptionallyAsync(var1 -> this.handleChunkLoadFailure((Throwable)var1, var02), (Executor)this.mainThreadExecutor);
    }

    private IChunkAccess handleChunkLoadFailure(Throwable var0, ChunkCoordIntPair var1) {
        boolean var5;
        Throwable throwable;
        Throwable var2;
        Throwable var3;
        if (var0 instanceof CompletionException) {
            var3 = (CompletionException)var0;
            v0 = var3.getCause();
        } else {
            v0 = var2 = var0;
        }
        if (var2 instanceof ReportedException) {
            ReportedException var4 = (ReportedException)var2;
            throwable = var4.getCause();
        } else {
            throwable = var2;
        }
        var3 = throwable;
        boolean var4 = var3 instanceof Error;
        boolean bl = var5 = var3 instanceof IOException || var3 instanceof NbtException;
        if (!var4) {
            if (!var5) {
                // empty if block
            }
        } else {
            CrashReport var6 = CrashReport.forThrowable(var0, "Exception loading chunk");
            CrashReportSystemDetails var7 = var6.addCategory("Chunk being loaded");
            var7.setDetail("pos", var1);
            this.markPositionReplaceable(var1);
            throw new ReportedException(var6);
        }
        this.level.getServer().reportChunkLoadFailure(var3, this.storageInfo(), var1);
        return this.createEmptyChunk(var1);
    }

    private IChunkAccess createEmptyChunk(ChunkCoordIntPair var0) {
        this.markPositionReplaceable(var0);
        return new ProtoChunk(var0, ChunkConverter.EMPTY, this.level, this.level.palettedContainerFactory(), null);
    }

    private void markPositionReplaceable(ChunkCoordIntPair var0) {
        this.chunkTypeCache.put(var0.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkCoordIntPair var0, ChunkType var1) {
        return this.chunkTypeCache.put(var0.toLong(), var1 == ChunkType.PROTOCHUNK ? (byte)-1 : 1);
    }

    @Override
    public GenerationChunkHolder acquireGeneration(long var0) {
        PlayerChunk var2 = (PlayerChunk)this.updatingChunkMap.get(var0);
        var2.increaseGenerationRefCount();
        return var2;
    }

    @Override
    public void releaseGeneration(GenerationChunkHolder var0) {
        var0.decreaseGenerationRefCount();
    }

    @Override
    public CompletableFuture<IChunkAccess> applyStep(GenerationChunkHolder var0, ChunkStep var1, StaticCache2D<GenerationChunkHolder> var2) {
        ChunkCoordIntPair var3 = var0.getPos();
        if (var1.targetStatus() == ChunkStatus.EMPTY) {
            return this.scheduleChunkLoad(var3);
        }
        try {
            GenerationChunkHolder var4 = var2.get(var3.x, var3.z);
            IChunkAccess var5 = var4.getChunkIfPresentUnchecked(var1.targetStatus().getParent());
            if (var5 == null) {
                throw new IllegalStateException("Parent chunk missing");
            }
            return var1.apply(this.worldGenContext, var2, var5);
        }
        catch (Exception var4) {
            var4.getStackTrace();
            CrashReport var5 = CrashReport.forThrowable(var4, "Exception generating new chunk");
            CrashReportSystemDetails var6 = var5.addCategory("Chunk to be generated");
            var6.setDetail("Status being generated", () -> var1.targetStatus().getName());
            var6.setDetail("Location", String.format(Locale.ROOT, "%d,%d", var3.x, var3.z));
            var6.setDetail("Position hash", ChunkCoordIntPair.asLong(var3.x, var3.z));
            var6.setDetail("Generator", this.generator());
            this.mainThreadExecutor.execute(() -> {
                throw new ReportedException(var5);
            });
            throw new ReportedException(var5);
        }
    }

    @Override
    public ChunkGenerationTask scheduleGenerationTask(ChunkStatus var0, ChunkCoordIntPair var1) {
        ChunkGenerationTask var2 = ChunkGenerationTask.create(this, var0, var1);
        this.pendingGenerationTasks.add(var2);
        return var2;
    }

    private void runGenerationTask(ChunkGenerationTask var0) {
        GenerationChunkHolder var1 = var0.getCenter();
        this.worldgenTaskDispatcher.submit(() -> {
            CompletableFuture<?> var1 = var0.runUntilWait();
            if (var1 == null) {
                return;
            }
            var1.thenRun(() -> this.runGenerationTask(var0));
        }, var1.getPos().toLong(), var1::getQueueLevel);
    }

    @Override
    public void runGenerationTasks() {
        this.pendingGenerationTasks.forEach(this::runGenerationTask);
        this.pendingGenerationTasks.clear();
    }

    public CompletableFuture<ChunkResult<Chunk>> prepareTickingChunk(PlayerChunk var02) {
        CompletableFuture<ChunkResult<List<IChunkAccess>>> var1 = this.getChunkRangeFuture(var02, 1, var0 -> ChunkStatus.FULL);
        return var1.thenApplyAsync(var12 -> var12.map(var1 -> {
            Chunk var22 = (Chunk)var1.get(var1.size() / 2);
            var22.postProcessGeneration(this.level);
            this.level.startTickingChunk(var22);
            CompletableFuture<?> var3 = var02.getSendSyncFuture();
            if (var3.isDone()) {
                this.onChunkReadyToSend(var02, var22);
            } else {
                var3.thenAcceptAsync(var2 -> this.onChunkReadyToSend(var02, var22), (Executor)this.mainThreadExecutor);
            }
            return var22;
        }), (Executor)this.mainThreadExecutor);
    }

    private void onChunkReadyToSend(PlayerChunk var0, Chunk var1) {
        ChunkCoordIntPair var2 = var1.getPos();
        for (EntityPlayer var4 : this.playerMap.getAllPlayers()) {
            if (!var4.getChunkTrackingView().contains(var2)) continue;
            PlayerChunkMap.markChunkPendingToSend(var4, var1);
        }
        this.level.getChunkSource().onChunkReadyToSend(var0);
        this.level.debugSynchronizers().registerChunk(var1);
    }

    public CompletableFuture<ChunkResult<Chunk>> prepareAccessibleChunk(PlayerChunk var0) {
        return this.getChunkRangeFuture(var0, 1, ChunkLevel::getStatusAroundFullChunk).thenApply(var02 -> var02.map(var0 -> (Chunk)var0.get(var0.size() / 2)));
    }

    Stream<PlayerChunk> allChunksWithAtLeastStatus(ChunkStatus var0) {
        int var12 = ChunkLevel.byStatus(var0);
        return this.visibleChunkMap.values().stream().filter(var1 -> var1.getTicketLevel() <= var12);
    }

    private boolean saveChunkIfNeeded(PlayerChunk var0, long var1) {
        if (!var0.wasAccessibleSinceLastSave() || !var0.isReadyForSaving()) {
            return false;
        }
        IChunkAccess var3 = var0.getLatestChunk();
        if (var3 instanceof ProtoChunkExtension || var3 instanceof Chunk) {
            if (!var3.isUnsaved()) {
                return false;
            }
            long var4 = var3.getPos().toLong();
            long var6 = this.nextChunkSaveTime.getOrDefault(var4, -1L);
            if (var1 < var6) {
                return false;
            }
            boolean var8 = this.save(var3);
            var0.refreshAccessibility();
            if (var8) {
                this.nextChunkSaveTime.put(var4, var1 + 10000L);
            }
            return var8;
        }
        return false;
    }

    public boolean save(IChunkAccess var0) {
        this.poiManager.flush(var0.getPos());
        if (!var0.tryMarkSaved()) {
            return false;
        }
        ChunkCoordIntPair var12 = var0.getPos();
        try {
            ChunkStatus var22 = var0.getPersistedStatus();
            if (var22.getChunkType() != ChunkType.LEVELCHUNK) {
                if (this.isExistingChunkFull(var12)) {
                    return false;
                }
                if (var22 == ChunkStatus.EMPTY && var0.getAllStarts().values().stream().noneMatch(StructureStart::isValid)) {
                    return false;
                }
            }
            Profiler.get().incrementCounter("chunkSave");
            this.activeChunkWrites.incrementAndGet();
            SerializableChunkData var3 = SerializableChunkData.copyOf(this.level, var0);
            CompletableFuture<NBTTagCompound> var4 = CompletableFuture.supplyAsync(var3::write, SystemUtils.backgroundExecutor());
            this.write(var12, var4::join).handle((var1, var2) -> {
                if (var2 != null) {
                    this.level.getServer().reportChunkSaveFailure((Throwable)var2, this.storageInfo(), var12);
                }
                this.activeChunkWrites.decrementAndGet();
                return null;
            });
            this.markPosition(var12, var22.getChunkType());
            return true;
        }
        catch (Exception var23) {
            this.level.getServer().reportChunkSaveFailure(var23, this.storageInfo(), var12);
            return false;
        }
    }

    private boolean isExistingChunkFull(ChunkCoordIntPair var0) {
        NBTTagCompound var2;
        byte var1 = this.chunkTypeCache.get(var0.toLong());
        if (var1 != 0) {
            return var1 == 1;
        }
        try {
            var2 = this.readChunk(var0).join().orElse(null);
            if (var2 == null) {
                this.markPositionReplaceable(var0);
                return false;
            }
        }
        catch (Exception var3) {
            LOGGER.error("Failed to read chunk {}", (Object)var0, (Object)var3);
            this.markPositionReplaceable(var0);
            return false;
        }
        ChunkType var3 = SerializableChunkData.getChunkStatusFromTag(var2).getChunkType();
        return this.markPosition(var0, var3) == 1;
    }

    protected void setServerViewDistance(int var0) {
        int var1 = MathHelper.clamp(var0, 2, 32);
        if (var1 != this.serverViewDistance) {
            this.serverViewDistance = var1;
            this.distanceManager.updatePlayerTickets(this.serverViewDistance);
            for (EntityPlayer var3 : this.playerMap.getAllPlayers()) {
                this.updateChunkTracking(var3);
            }
        }
    }

    int getPlayerViewDistance(EntityPlayer var0) {
        return MathHelper.clamp(var0.requestedViewDistance(), 2, this.serverViewDistance);
    }

    private void markChunkPendingToSend(EntityPlayer var0, ChunkCoordIntPair var1) {
        Chunk var2 = this.getChunkToSend(var1.toLong());
        if (var2 != null) {
            PlayerChunkMap.markChunkPendingToSend(var0, var2);
        }
    }

    private static void markChunkPendingToSend(EntityPlayer var0, Chunk var1) {
        var0.connection.chunkSender.markChunkPendingToSend(var1);
    }

    private static void dropChunk(EntityPlayer var0, ChunkCoordIntPair var1) {
        var0.connection.chunkSender.dropChunk(var0, var1);
    }

    @Nullable
    public Chunk getChunkToSend(long var0) {
        PlayerChunk var2 = this.getVisibleChunkIfPresent(var0);
        if (var2 == null) {
            return null;
        }
        return var2.getChunkToSend();
    }

    public int size() {
        return this.visibleChunkMap.size();
    }

    public ChunkMapDistance getDistanceManager() {
        return this.distanceManager;
    }

    void dumpChunks(Writer var02) throws IOException {
        CSVWriter var1 = CSVWriter.builder().addColumn("x").addColumn("z").addColumn("level").addColumn("in_memory").addColumn("status").addColumn("full_status").addColumn("accessible_ready").addColumn("ticking_ready").addColumn("entity_ticking_ready").addColumn("ticket").addColumn("spawning").addColumn("block_entity_count").addColumn("ticking_ticket").addColumn("ticking_level").addColumn("block_ticks").addColumn("fluid_ticks").build(var02);
        for (Long2ObjectMap.Entry var3 : this.visibleChunkMap.long2ObjectEntrySet()) {
            long var4 = var3.getLongKey();
            ChunkCoordIntPair var6 = new ChunkCoordIntPair(var4);
            PlayerChunk var7 = (PlayerChunk)var3.getValue();
            Optional<IChunkAccess> var8 = Optional.ofNullable(var7.getLatestChunk());
            Optional<Object> var9 = var8.flatMap(var0 -> var0 instanceof Chunk ? Optional.of((Chunk)var0) : Optional.empty());
            var1.writeRow(var6.x, var6.z, var7.getTicketLevel(), var8.isPresent(), var8.map(IChunkAccess::getPersistedStatus).orElse(null), var9.map(Chunk::getFullStatus).orElse(null), PlayerChunkMap.printFuture(var7.getFullChunkFuture()), PlayerChunkMap.printFuture(var7.getTickingChunkFuture()), PlayerChunkMap.printFuture(var7.getEntityTickingChunkFuture()), this.ticketStorage.getTicketDebugString(var4, false), this.anyPlayerCloseEnoughForSpawning(var6), var9.map(var0 -> var0.getBlockEntities().size()).orElse(0), this.ticketStorage.getTicketDebugString(var4, true), this.distanceManager.getChunkLevel(var4, true), var9.map(var0 -> var0.getBlockTicks().count()).orElse(0), var9.map(var0 -> var0.getFluidTicks().count()).orElse(0));
        }
    }

    private static String printFuture(CompletableFuture<ChunkResult<Chunk>> var0) {
        try {
            ChunkResult var1 = var0.getNow(null);
            if (var1 != null) {
                return var1.isSuccess() ? "done" : "unloaded";
            }
            return "not completed";
        }
        catch (CompletionException var1) {
            return "failed " + var1.getCause().getMessage();
        }
        catch (CancellationException var1) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> readChunk(ChunkCoordIntPair var02) {
        return this.read(var02).thenApplyAsync(var0 -> var0.map(this::upgradeChunkTag), SystemUtils.backgroundExecutor().forName("upgradeChunk"));
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound var0) {
        return this.upgradeChunkTag(this.level.dimension(), this.overworldDataStorage, var0, this.generator().getTypeNameForDataFixer());
    }

    void collectSpawningChunks(List<Chunk> var0) {
        LongIterator var1 = this.distanceManager.getSpawnCandidateChunks();
        while (var1.hasNext()) {
            Chunk var3;
            PlayerChunk var2 = (PlayerChunk)this.visibleChunkMap.get(var1.nextLong());
            if (var2 == null || (var3 = var2.getTickingChunk()) == null || !this.anyPlayerCloseEnoughForSpawningInternal(var2.getPos())) continue;
            var0.add(var3);
        }
    }

    void forEachBlockTickingChunk(Consumer<Chunk> var0) {
        this.distanceManager.forEachEntityTickingChunk(var1 -> {
            PlayerChunk var3 = (PlayerChunk)this.visibleChunkMap.get(var1);
            if (var3 == null) {
                return;
            }
            Chunk var4 = var3.getTickingChunk();
            if (var4 == null) {
                return;
            }
            var0.accept(var4);
        });
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair var0) {
        TriState var1 = this.distanceManager.hasPlayersNearby(var0.toLong());
        if (var1 == TriState.DEFAULT) {
            return this.anyPlayerCloseEnoughForSpawningInternal(var0);
        }
        return var1.toBoolean(true);
    }

    private boolean anyPlayerCloseEnoughForSpawningInternal(ChunkCoordIntPair var0) {
        for (EntityPlayer var2 : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning(var2, var0)) continue;
            return true;
        }
        return false;
    }

    public List<EntityPlayer> getPlayersCloseForSpawning(ChunkCoordIntPair var0) {
        long var1 = var0.toLong();
        if (!this.distanceManager.hasPlayersNearby(var1).toBoolean(true)) {
            return List.of();
        }
        ImmutableList.Builder var3 = ImmutableList.builder();
        for (EntityPlayer var5 : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning(var5, var0)) continue;
            var3.add((Object)var5);
        }
        return var3.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer var0, ChunkCoordIntPair var1) {
        if (var0.isSpectator()) {
            return false;
        }
        double var2 = PlayerChunkMap.euclideanDistanceSquared(var1, var0.position());
        return var2 < 16384.0;
    }

    private static double euclideanDistanceSquared(ChunkCoordIntPair var0, Vec3D var1) {
        double var2 = SectionPosition.sectionToBlockCoord(var0.x, 8);
        double var4 = SectionPosition.sectionToBlockCoord(var0.z, 8);
        double var6 = var2 - var1.x;
        double var8 = var4 - var1.z;
        return var6 * var6 + var8 * var8;
    }

    private boolean skipPlayer(EntityPlayer var0) {
        return var0.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
    }

    void updatePlayerStatus(EntityPlayer var0, boolean var1) {
        boolean var2 = this.skipPlayer(var0);
        boolean var3 = this.playerMap.ignoredOrUnknown(var0);
        if (var1) {
            this.playerMap.addPlayer(var0, var2);
            this.updatePlayerPos(var0);
            if (!var2) {
                this.distanceManager.addPlayer(SectionPosition.of(var0), var0);
            }
            var0.setChunkTrackingView(ChunkTrackingView.EMPTY);
            this.updateChunkTracking(var0);
        } else {
            SectionPosition var4 = var0.getLastSectionPos();
            this.playerMap.removePlayer(var0);
            if (!var3) {
                this.distanceManager.removePlayer(var4, var0);
            }
            this.applyChunkTrackingView(var0, ChunkTrackingView.EMPTY);
        }
    }

    private void updatePlayerPos(EntityPlayer var0) {
        SectionPosition var1 = SectionPosition.of(var0);
        var0.setLastSectionPos(var1);
    }

    public void move(EntityPlayer var0) {
        boolean var5;
        Object var22;
        for (Object var22 : this.entityMap.values()) {
            if (((EntityTracker)var22).entity == var0) {
                ((EntityTracker)var22).updatePlayers(this.level.players());
                continue;
            }
            ((EntityTracker)var22).updatePlayer(var0);
        }
        SectionPosition var1 = var0.getLastSectionPos();
        var22 = SectionPosition.of(var0);
        boolean var3 = this.playerMap.ignored(var0);
        boolean var4 = this.skipPlayer(var0);
        boolean bl = var5 = var1.asLong() != ((SectionPosition)var22).asLong();
        if (var5 || var3 != var4) {
            this.updatePlayerPos(var0);
            if (!var3) {
                this.distanceManager.removePlayer(var1, var0);
            }
            if (!var4) {
                this.distanceManager.addPlayer((SectionPosition)var22, var0);
            }
            if (!var3 && var4) {
                this.playerMap.ignorePlayer(var0);
            }
            if (var3 && !var4) {
                this.playerMap.unIgnorePlayer(var0);
            }
            this.updateChunkTracking(var0);
        }
    }

    private void updateChunkTracking(EntityPlayer var0) {
        ChunkTrackingView.a var3;
        ChunkCoordIntPair var1 = var0.chunkPosition();
        int var2 = this.getPlayerViewDistance(var0);
        ChunkTrackingView chunkTrackingView = var0.getChunkTrackingView();
        if (chunkTrackingView instanceof ChunkTrackingView.a && (var3 = (ChunkTrackingView.a)chunkTrackingView).center().equals(var1) && var3.viewDistance() == var2) {
            return;
        }
        this.applyChunkTrackingView(var0, ChunkTrackingView.of(var1, var2));
    }

    private void applyChunkTrackingView(EntityPlayer var0, ChunkTrackingView var12) {
        if (var0.level() != this.level) {
            return;
        }
        ChunkTrackingView var2 = var0.getChunkTrackingView();
        if (var12 instanceof ChunkTrackingView.a) {
            ChunkTrackingView.a var4;
            ChunkTrackingView.a var3 = (ChunkTrackingView.a)var12;
            if (!(var2 instanceof ChunkTrackingView.a) || !(var4 = (ChunkTrackingView.a)var2).center().equals(var3.center())) {
                var0.connection.send(new PacketPlayOutViewCentre(var3.center().x, var3.center().z));
            }
        }
        ChunkTrackingView.difference(var2, var12, var1 -> this.markChunkPendingToSend(var0, (ChunkCoordIntPair)var1), var1 -> PlayerChunkMap.dropChunk(var0, var1));
        var0.setChunkTrackingView(var12);
    }

    @Override
    public List<EntityPlayer> getPlayers(ChunkCoordIntPair var0, boolean var1) {
        Set<EntityPlayer> var2 = this.playerMap.getAllPlayers();
        ImmutableList.Builder var3 = ImmutableList.builder();
        for (EntityPlayer var5 : var2) {
            if ((!var1 || !this.isChunkOnTrackedBorder(var5, var0.x, var0.z)) && (var1 || !this.isChunkTracked(var5, var0.x, var0.z))) continue;
            var3.add((Object)var5);
        }
        return var3.build();
    }

    protected void addEntity(Entity var0) {
        if (var0 instanceof EntityComplexPart) {
            return;
        }
        EntityTypes<?> var1 = var0.getType();
        int var2 = var1.clientTrackingRange() * 16;
        if (var2 == 0) {
            return;
        }
        int var3 = var1.updateInterval();
        if (this.entityMap.containsKey(var0.getId())) {
            throw SystemUtils.pauseInIde(new IllegalStateException("Entity is already tracked!"));
        }
        EntityTracker var4 = new EntityTracker(var0, var2, var3, var1.trackDeltas());
        this.entityMap.put(var0.getId(), (Object)var4);
        var4.updatePlayers(this.level.players());
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var5 = (EntityPlayer)var0;
            this.updatePlayerStatus(var5, true);
            for (EntityTracker var7 : this.entityMap.values()) {
                if (var7.entity == var5) continue;
                var7.updatePlayer(var5);
            }
        }
    }

    protected void removeEntity(Entity var0) {
        Object var1;
        if (var0 instanceof EntityPlayer) {
            var1 = (EntityPlayer)var0;
            this.updatePlayerStatus((EntityPlayer)var1, false);
            for (EntityTracker var3 : this.entityMap.values()) {
                var3.removePlayer((EntityPlayer)var1);
            }
        }
        if ((var1 = (EntityTracker)this.entityMap.remove(var0.getId())) != null) {
            ((EntityTracker)var1).broadcastRemoved();
        }
    }

    protected void tick() {
        for (EntityPlayer entityPlayer : this.playerMap.getAllPlayers()) {
            this.updateChunkTracking(entityPlayer);
        }
        ArrayList var0 = Lists.newArrayList();
        List<EntityPlayer> list = this.level.players();
        for (EntityTracker var3 : this.entityMap.values()) {
            boolean var6;
            SectionPosition var4 = var3.lastSectionPos;
            SectionPosition var5 = SectionPosition.of(var3.entity);
            boolean bl = var6 = !Objects.equals(var4, var5);
            if (var6) {
                var3.updatePlayers(list);
                Entity var7 = var3.entity;
                if (var7 instanceof EntityPlayer) {
                    var0.add((EntityPlayer)var7);
                }
                var3.lastSectionPos = var5;
            }
            if (!var6 && !this.distanceManager.inEntityTickingRange(var5.chunk().toLong())) continue;
            var3.serverEntity.sendChanges();
        }
        if (!var0.isEmpty()) {
            for (EntityTracker var3 : this.entityMap.values()) {
                var3.updatePlayers(var0);
            }
        }
    }

    public void sendToTrackingPlayers(Entity var0, Packet<? super PacketListenerPlayOut> var1) {
        EntityTracker var2 = (EntityTracker)this.entityMap.get(var0.getId());
        if (var2 != null) {
            var2.sendToTrackingPlayers(var1);
        }
    }

    public void sendToTrackingPlayersFiltered(Entity var0, Packet<? super PacketListenerPlayOut> var1, Predicate<EntityPlayer> var2) {
        EntityTracker var3 = (EntityTracker)this.entityMap.get(var0.getId());
        if (var3 != null) {
            var3.sendToTrackingPlayersFiltered(var1, var2);
        }
    }

    protected void sendToTrackingPlayersAndSelf(Entity var0, Packet<? super PacketListenerPlayOut> var1) {
        EntityTracker var2 = (EntityTracker)this.entityMap.get(var0.getId());
        if (var2 != null) {
            var2.sendToTrackingPlayersAndSelf(var1);
        }
    }

    public boolean isTrackedByAnyPlayer(Entity var0) {
        EntityTracker var1 = (EntityTracker)this.entityMap.get(var0.getId());
        if (var1 != null) {
            return !var1.seenBy.isEmpty();
        }
        return false;
    }

    public void forEachEntityTrackedBy(EntityPlayer var0, Consumer<Entity> var1) {
        for (EntityTracker var3 : this.entityMap.values()) {
            if (!var3.seenBy.contains(var0.connection)) continue;
            var1.accept(var3.entity);
        }
    }

    public void resendBiomesForChunks(List<IChunkAccess> var02) {
        HashMap<EntityPlayer, List> var12 = new HashMap<EntityPlayer, List>();
        for (IChunkAccess var3 : var02) {
            Chunk var6;
            ChunkCoordIntPair var4 = var3.getPos();
            Chunk var5 = var3 instanceof Chunk ? (var6 = (Chunk)var3) : this.level.getChunk(var4.x, var4.z);
            for (EntityPlayer var7 : this.getPlayers(var4, false)) {
                var12.computeIfAbsent(var7, var0 -> new ArrayList()).add(var5);
            }
        }
        var12.forEach((var0, var1) -> var0.connection.send(ClientboundChunksBiomesPacket.forChunks(var1)));
    }

    protected VillagePlace getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkCoordIntPair var0, FullChunkStatus var1) {
        this.chunkStatusListener.onChunkStatusChange(var0, var1);
    }

    public void waitForLightBeforeSending(ChunkCoordIntPair var02, int var1) {
        int var2 = var1 + 1;
        ChunkCoordIntPair.rangeClosed(var02, var2).forEach(var0 -> {
            PlayerChunk var1 = this.getVisibleChunkIfPresent(var0.toLong());
            if (var1 != null) {
                var1.addSendDependency(this.lightEngine.waitForPendingTasks(var0.x, var0.z));
            }
        });
    }

    public void forEachReadyToSendChunk(Consumer<Chunk> var0) {
        for (PlayerChunk var2 : this.visibleChunkMap.values()) {
            Chunk var3 = var2.getChunkToSend();
            if (var3 == null) continue;
            var0.accept(var3);
        }
    }

    class a
    extends ChunkMapDistance {
        protected a(TicketStorage var1, Executor var2, Executor var3) {
            super(var1, var2, var3);
        }

        @Override
        protected boolean isChunkToRemove(long var0) {
            return PlayerChunkMap.this.toDrop.contains(var0);
        }

        @Override
        @Nullable
        protected PlayerChunk getChunk(long var0) {
            return PlayerChunkMap.this.getUpdatingChunkIfPresent(var0);
        }

        @Override
        @Nullable
        protected PlayerChunk updateChunkScheduling(long var0, int var2, @Nullable PlayerChunk var3, int var4) {
            return PlayerChunkMap.this.updateChunkScheduling(var0, var2, var3, var4);
        }
    }

    public class EntityTracker
    implements EntityTrackerEntry.a {
        public final EntityTrackerEntry serverEntity;
        final Entity entity;
        private final int range;
        SectionPosition lastSectionPos;
        public final Set<ServerPlayerConnection> seenBy = Sets.newIdentityHashSet();

        public EntityTracker(Entity var1, int var2, int var3, boolean var4) {
            this.serverEntity = new EntityTrackerEntry(PlayerChunkMap.this.level, var1, var3, var4, this);
            this.entity = var1;
            this.range = var2;
            this.lastSectionPos = SectionPosition.of(var1);
        }

        public boolean equals(Object var0) {
            if (var0 instanceof EntityTracker) {
                return ((EntityTracker)var0).entity.getId() == this.entity.getId();
            }
            return false;
        }

        public int hashCode() {
            return this.entity.getId();
        }

        @Override
        public void sendToTrackingPlayers(Packet<? super PacketListenerPlayOut> var0) {
            for (ServerPlayerConnection var2 : this.seenBy) {
                var2.send(var0);
            }
        }

        @Override
        public void sendToTrackingPlayersAndSelf(Packet<? super PacketListenerPlayOut> var0) {
            this.sendToTrackingPlayers(var0);
            Entity entity = this.entity;
            if (entity instanceof EntityPlayer) {
                EntityPlayer var1 = (EntityPlayer)entity;
                var1.connection.send(var0);
            }
        }

        @Override
        public void sendToTrackingPlayersFiltered(Packet<? super PacketListenerPlayOut> var0, Predicate<EntityPlayer> var1) {
            for (ServerPlayerConnection var3 : this.seenBy) {
                if (!var1.test(var3.getPlayer())) continue;
                var3.send(var0);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection var1 : this.seenBy) {
                this.serverEntity.removePairing(var1.getPlayer());
            }
        }

        public void removePlayer(EntityPlayer var0) {
            if (this.seenBy.remove(var0.connection)) {
                this.serverEntity.removePairing(var0);
                if (this.seenBy.isEmpty()) {
                    PlayerChunkMap.this.level.debugSynchronizers().dropEntity(this.entity);
                }
            }
        }

        public void updatePlayer(EntityPlayer var0) {
            boolean var9;
            if (var0 == this.entity) {
                return;
            }
            Vec3D var1 = var0.position().subtract(this.entity.position());
            int var2 = PlayerChunkMap.this.getPlayerViewDistance(var0);
            double var5 = var1.x * var1.x + var1.z * var1.z;
            double var3 = Math.min(this.getEffectiveRange(), var2 * 16);
            double var7 = var3 * var3;
            boolean bl = var9 = var5 <= var7 && this.entity.broadcastToPlayer(var0) && PlayerChunkMap.this.isChunkTracked(var0, this.entity.chunkPosition().x, this.entity.chunkPosition().z);
            if (var9) {
                if (this.seenBy.add(var0.connection)) {
                    this.serverEntity.addPairing(var0);
                    if (this.seenBy.size() == 1) {
                        PlayerChunkMap.this.level.debugSynchronizers().registerEntity(this.entity);
                    }
                    PlayerChunkMap.this.level.debugSynchronizers().startTrackingEntity(var0, this.entity);
                }
            } else {
                this.removePlayer(var0);
            }
        }

        private int scaledRange(int var0) {
            return PlayerChunkMap.this.level.getServer().getScaledTrackingDistance(var0);
        }

        private int getEffectiveRange() {
            int var0 = this.range;
            for (Entity var2 : this.entity.getIndirectPassengers()) {
                int var3 = var2.getType().clientTrackingRange() * 16;
                if (var3 <= var0) continue;
                var0 = var3;
            }
            return this.scaledRange(var0);
        }

        public void updatePlayers(List<EntityPlayer> var0) {
            for (EntityPlayer var2 : var0) {
                this.updatePlayer(var2);
            }
        }
    }
}

