/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.slf4j.Logger;

public class DedicatedServerProperties
extends PropertyManager<DedicatedServerProperties> {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults();
    public static final String MANAGEMENT_SERVER_TLS_ENABLED_KEY = "management-server-tls-enabled";
    public static final String MANAGEMENT_SERVER_TLS_KEYSTORE_KEY = "management-server-tls-keystore";
    public static final String MANAGEMENT_SERVER_TLS_KEYSTORE_PASSWORD_KEY = "management-server-tls-keystore-password";
    public final boolean onlineMode = this.get("online-mode", true);
    public final boolean preventProxyConnections = this.get("prevent-proxy-connections", false);
    public final String serverIp = this.get("server-ip", "");
    public final PropertyManager.EditableProperty<Boolean> allowFlight = this.getMutable("allow-flight", false);
    public final PropertyManager.EditableProperty<String> motd = this.getMutable("motd", "A Minecraft Server");
    public final boolean codeOfConduct = this.get("enable-code-of-conduct", false);
    public final String bugReportLink = this.get("bug-report-link", "");
    public final PropertyManager.EditableProperty<Boolean> forceGameMode = this.getMutable("force-gamemode", false);
    public final PropertyManager.EditableProperty<Boolean> enforceWhitelist = this.getMutable("enforce-whitelist", false);
    public final PropertyManager.EditableProperty<EnumDifficulty> difficulty = this.getMutable("difficulty", DedicatedServerProperties.dispatchNumberOrString(EnumDifficulty::byId, EnumDifficulty::byName), EnumDifficulty::getKey, EnumDifficulty.EASY);
    public final PropertyManager.EditableProperty<EnumGamemode> gameMode = this.getMutable("gamemode", DedicatedServerProperties.dispatchNumberOrString(EnumGamemode::byId, EnumGamemode::byName), EnumGamemode::getName, EnumGamemode.SURVIVAL);
    public final String levelName = this.get("level-name", "world");
    public final int serverPort = this.get("server-port", 25565);
    public final boolean managementServerEnabled = this.get("management-server-enabled", false);
    public final String managementServerHost = this.get("management-server-host", "localhost");
    public final int managementServerPort = this.get("management-server-port", 0);
    public final String managementServerSecret = this.get("management-server-secret", SecurityConfig.generateSecretKey());
    public final boolean managementServerTlsEnabled = this.get("management-server-tls-enabled", true);
    public final String managementServerTlsKeystore = this.get("management-server-tls-keystore", "");
    public final String managementServerTlsKeystorePassword = this.get("management-server-tls-keystore-password", "");
    @Nullable
    public final Boolean announcePlayerAchievements = this.getLegacyBoolean("announce-player-achievements");
    public final boolean enableQuery = this.get("enable-query", false);
    public final int queryPort = this.get("query.port", 25565);
    public final boolean enableRcon = this.get("enable-rcon", false);
    public final int rconPort = this.get("rcon.port", 25575);
    public final String rconPassword = this.get("rcon.password", "");
    public final boolean hardcore = this.get("hardcore", false);
    public final boolean useNativeTransport = this.get("use-native-transport", true);
    public final PropertyManager.EditableProperty<Integer> spawnProtection = this.getMutable("spawn-protection", 16);
    public final PropertyManager.EditableProperty<Integer> opPermissionLevel = this.getMutable("op-permission-level", 4);
    public final int functionPermissionLevel = this.get("function-permission-level", 2);
    public final long maxTickTime = this.get("max-tick-time", TimeUnit.MINUTES.toMillis(1L));
    public final int maxChainedNeighborUpdates = this.get("max-chained-neighbor-updates", 1000000);
    public final int rateLimitPacketsPerSecond = this.get("rate-limit", 0);
    public final PropertyManager.EditableProperty<Integer> viewDistance = this.getMutable("view-distance", 10);
    public final PropertyManager.EditableProperty<Integer> simulationDistance = this.getMutable("simulation-distance", 10);
    public final PropertyManager.EditableProperty<Integer> maxPlayers = this.getMutable("max-players", 20);
    public final int networkCompressionThreshold = this.get("network-compression-threshold", 256);
    public final boolean broadcastRconToOps = this.get("broadcast-rcon-to-ops", true);
    public final boolean broadcastConsoleToOps = this.get("broadcast-console-to-ops", true);
    public final int maxWorldSize = this.get("max-world-size", var0 -> MathHelper.clamp(var0, 1, 29999984), 29999984);
    public final boolean syncChunkWrites = this.get("sync-chunk-writes", true);
    public final String regionFileComression = this.get("region-file-compression", "deflate");
    public final boolean enableJmxMonitoring = this.get("enable-jmx-monitoring", false);
    public final PropertyManager.EditableProperty<Boolean> enableStatus = this.getMutable("enable-status", true);
    public final PropertyManager.EditableProperty<Boolean> hideOnlinePlayers = this.getMutable("hide-online-players", false);
    public final PropertyManager.EditableProperty<Integer> entityBroadcastRangePercentage = this.getMutable("entity-broadcast-range-percentage", var0 -> MathHelper.clamp(Integer.parseInt(var0), 10, 1000), 100);
    public final String textFilteringConfig = this.get("text-filtering-config", "");
    public final int textFilteringVersion = this.get("text-filtering-version", 0);
    public final Optional<MinecraftServer.ServerResourcePackInfo> serverResourcePackInfo;
    public final DataPackConfiguration initialDataPackConfiguration;
    public final PropertyManager.EditableProperty<Integer> playerIdleTimeout = this.getMutable("player-idle-timeout", 0);
    public final PropertyManager.EditableProperty<Integer> statusHeartbeatInterval = this.getMutable("status-heartbeat-interval", 0);
    public final PropertyManager.EditableProperty<Boolean> whiteList = this.getMutable("white-list", false);
    public final boolean enforceSecureProfile = this.get("enforce-secure-profile", true);
    public final boolean logIPs = this.get("log-ips", true);
    public final PropertyManager.EditableProperty<Integer> pauseWhenEmptySeconds = this.getMutable("pause-when-empty-seconds", 60);
    private final WorldDimensionData worldDimensionData;
    public final WorldOptions worldOptions;
    public PropertyManager.EditableProperty<Boolean> acceptsTransfers = this.getMutable("accepts-transfers", false);

    public DedicatedServerProperties(Properties var02) {
        super(var02);
        String var1 = this.get("level-seed", "");
        boolean var2 = this.get("generate-structures", true);
        long var3 = WorldOptions.parseSeed(var1).orElse(WorldOptions.randomSeed());
        this.worldOptions = new WorldOptions(var3, var2, false);
        this.worldDimensionData = new WorldDimensionData(this.get("generator-settings", (String var0) -> ChatDeserializer.parse(!var0.isEmpty() ? var0 : "{}"), new JsonObject()), this.get("level-type", (String var0) -> var0.toLowerCase(Locale.ROOT), WorldPresets.NORMAL.location().toString()));
        this.serverResourcePackInfo = DedicatedServerProperties.getServerPackInfo(this.get("resource-pack-id", ""), this.get("resource-pack", ""), this.get("resource-pack-sha1", ""), this.getLegacyString("resource-pack-hash"), this.get("require-resource-pack", false), this.get("resource-pack-prompt", ""));
        this.initialDataPackConfiguration = DedicatedServerProperties.getDatapackConfig(this.get("initial-enabled-packs", String.join((CharSequence)",", WorldDataConfiguration.DEFAULT.dataPacks().getEnabled())), this.get("initial-disabled-packs", String.join((CharSequence)",", WorldDataConfiguration.DEFAULT.dataPacks().getDisabled())));
    }

    public static DedicatedServerProperties fromFile(Path var0) {
        return new DedicatedServerProperties(DedicatedServerProperties.loadFromFile(var0));
    }

    @Override
    protected DedicatedServerProperties reload(IRegistryCustom var0, Properties var1) {
        return new DedicatedServerProperties(var1);
    }

    @Nullable
    private static IChatBaseComponent parseResourcePackPrompt(String var0) {
        if (!Strings.isNullOrEmpty((String)var0)) {
            try {
                JsonElement var12 = StrictJsonParser.parse(var0);
                return ComponentSerialization.CODEC.parse(IRegistryCustom.EMPTY.createSerializationContext(JsonOps.INSTANCE), (Object)var12).resultOrPartial(var1 -> LOGGER.warn("Failed to parse resource pack prompt '{}': {}", (Object)var0, var1)).orElse(null);
            }
            catch (Exception var13) {
                LOGGER.warn("Failed to parse resource pack prompt '{}'", (Object)var0, (Object)var13);
            }
        }
        return null;
    }

    private static Optional<MinecraftServer.ServerResourcePackInfo> getServerPackInfo(String var0, String var1, String var2, @Nullable String var3, boolean var4, String var5) {
        UUID var8;
        String var6;
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        if (!var2.isEmpty()) {
            var6 = var2;
            if (!Strings.isNullOrEmpty((String)var3)) {
                LOGGER.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)var3)) {
            LOGGER.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            var6 = var3;
        } else {
            var6 = "";
        }
        if (var6.isEmpty()) {
            LOGGER.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        } else if (!SHA1.matcher(var6).matches()) {
            LOGGER.warn("Invalid sha1 for resource-pack-sha1");
        }
        IChatBaseComponent var7 = DedicatedServerProperties.parseResourcePackPrompt(var5);
        if (var0.isEmpty()) {
            var8 = UUID.nameUUIDFromBytes(var1.getBytes(StandardCharsets.UTF_8));
            LOGGER.warn("resource-pack-id missing, using default of {}", (Object)var8);
        } else {
            try {
                var8 = UUID.fromString(var0);
            }
            catch (IllegalArgumentException var9) {
                LOGGER.warn("Failed to parse '{}' into UUID", (Object)var0);
                return Optional.empty();
            }
        }
        return Optional.of(new MinecraftServer.ServerResourcePackInfo(var8, var1, var6, var4, var7));
    }

    private static DataPackConfiguration getDatapackConfig(String var0, String var1) {
        List var2 = COMMA_SPLITTER.splitToList((CharSequence)var0);
        List var3 = COMMA_SPLITTER.splitToList((CharSequence)var1);
        return new DataPackConfiguration(var2, var3);
    }

    public WorldDimensions createDimensions(HolderLookup.a var0) {
        return this.worldDimensionData.create(var0);
    }

    @Override
    protected /* synthetic */ PropertyManager reload(IRegistryCustom iRegistryCustom, Properties properties) {
        return this.reload(iRegistryCustom, properties);
    }

    public record WorldDimensionData(JsonObject generatorSettings, String levelType) {
        private static final Map<String, ResourceKey<WorldPreset>> LEGACY_PRESET_NAMES = Map.of("default", WorldPresets.NORMAL, "largebiomes", WorldPresets.LARGE_BIOMES);

        public WorldDimensions create(HolderLookup.a var02) {
            HolderGetter var1 = var02.lookupOrThrow(Registries.WORLD_PRESET);
            Holder.c<WorldPreset> var2 = var1.get(WorldPresets.NORMAL).or(() -> WorldDimensionData.a((HolderLookup)var1)).orElseThrow(() -> new IllegalStateException("Invalid datapack contents: can't find default preset"));
            Holder var3 = Optional.ofNullable(MinecraftKey.tryParse(this.levelType)).map(var0 -> ResourceKey.create(Registries.WORLD_PRESET, var0)).or(() -> Optional.ofNullable(LEGACY_PRESET_NAMES.get(this.levelType))).flatMap(((HolderLookup)var1)::get).orElseGet(() -> {
                LOGGER.warn("Failed to parse level-type {}, defaulting to {}", (Object)this.levelType, (Object)var2.key().location());
                return var2;
            });
            WorldDimensions var4 = ((WorldPreset)var3.value()).createWorldDimensions();
            if (var3.is(WorldPresets.FLAT)) {
                RegistryOps var5 = var02.createSerializationContext(JsonOps.INSTANCE);
                Optional var6 = GeneratorSettingsFlat.CODEC.parse(new Dynamic(var5, (Object)this.generatorSettings())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
                if (var6.isPresent()) {
                    return var4.replaceOverworldGenerator(var02, new ChunkProviderFlat((GeneratorSettingsFlat)var6.get()));
                }
            }
            return var4;
        }

        private static /* synthetic */ Optional a(HolderLookup var0) {
            return var0.listElements().findAny();
        }
    }
}

