/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class CommandTrigger {
    private static final SimpleCommandExceptionType ERROR_NOT_PRIMED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.trigger.failed.unprimed"));
    private static final SimpleCommandExceptionType ERROR_INVALID_OBJECTIVE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.trigger.failed.invalid"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("trigger").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).suggests((var0, var1) -> CommandTrigger.suggestObjectives((CommandListenerWrapper)var0.getSource(), var1)).executes(var0 -> CommandTrigger.simpleTrigger((CommandListenerWrapper)var0.getSource(), ((CommandListenerWrapper)var0.getSource()).getPlayerOrException(), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective")))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("value", IntegerArgumentType.integer()).executes(var0 -> CommandTrigger.addValue((CommandListenerWrapper)var0.getSource(), ((CommandListenerWrapper)var0.getSource()).getPlayerOrException(), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"value")))))).then(net.minecraft.commands.CommandDispatcher.literal("set").then(net.minecraft.commands.CommandDispatcher.argument("value", IntegerArgumentType.integer()).executes(var0 -> CommandTrigger.setValue((CommandListenerWrapper)var0.getSource(), ((CommandListenerWrapper)var0.getSource()).getPlayerOrException(), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"value")))))));
    }

    public static CompletableFuture<Suggestions> suggestObjectives(CommandListenerWrapper var0, SuggestionsBuilder var1) {
        Entity var2 = var0.getEntity();
        ArrayList var3 = Lists.newArrayList();
        if (var2 != null) {
            ScoreboardServer var4 = var0.getServer().getScoreboard();
            for (ScoreboardObjective var6 : var4.getObjectives()) {
                ReadOnlyScoreInfo var7;
                if (var6.getCriteria() != IScoreboardCriteria.TRIGGER || (var7 = var4.getPlayerScoreInfo(var2, var6)) == null || var7.isLocked()) continue;
                var3.add(var6.getName());
            }
        }
        return ICompletionProvider.suggest(var3, var1);
    }

    private static int addValue(CommandListenerWrapper var0, EntityPlayer var1, ScoreboardObjective var2, int var3) throws CommandSyntaxException {
        ScoreAccess var4 = CommandTrigger.getScore(var0.getServer().getScoreboard(), var1, var2);
        int var5 = var4.add(var3);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.trigger.add.success", var2.getFormattedDisplayName(), var3), true);
        return var5;
    }

    private static int setValue(CommandListenerWrapper var0, EntityPlayer var1, ScoreboardObjective var2, int var3) throws CommandSyntaxException {
        ScoreAccess var4 = CommandTrigger.getScore(var0.getServer().getScoreboard(), var1, var2);
        var4.set(var3);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.trigger.set.success", var2.getFormattedDisplayName(), var3), true);
        return var3;
    }

    private static int simpleTrigger(CommandListenerWrapper var0, EntityPlayer var1, ScoreboardObjective var2) throws CommandSyntaxException {
        ScoreAccess var3 = CommandTrigger.getScore(var0.getServer().getScoreboard(), var1, var2);
        int var4 = var3.add(1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.trigger.simple.success", var2.getFormattedDisplayName()), true);
        return var4;
    }

    private static ScoreAccess getScore(Scoreboard var0, ScoreHolder var1, ScoreboardObjective var2) throws CommandSyntaxException {
        if (var2.getCriteria() != IScoreboardCriteria.TRIGGER) {
            throw ERROR_INVALID_OBJECTIVE.create();
        }
        ReadOnlyScoreInfo var3 = var0.getPlayerScoreInfo(var1, var2);
        if (var3 == null || var3.isLocked()) {
            throw ERROR_NOT_PRIMED.create();
        }
        ScoreAccess var4 = var0.getOrCreatePlayerScore(var1, var2);
        var4.lock();
        return var4;
    }
}

