/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.scores.ScoreboardTeam;

public class CommandSpreadPlayers {
    private static final int MAX_ITERATION_COUNT = 10000;
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_TEAMS = new Dynamic4CommandExceptionType((var0, var1, var2, var3) -> IChatBaseComponent.translatableEscape("commands.spreadplayers.failed.teams", var0, var1, var2, var3));
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_ENTITIES = new Dynamic4CommandExceptionType((var0, var1, var2, var3) -> IChatBaseComponent.translatableEscape("commands.spreadplayers.failed.entities", var0, var1, var2, var3));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_MAX_HEIGHT = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.spreadplayers.failed.invalid.height", var0, var1));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("spreadplayers").requires(net.minecraft.commands.CommandDispatcher.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("center", ArgumentVec2.vec2()).then(net.minecraft.commands.CommandDispatcher.argument("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(net.minecraft.commands.CommandDispatcher.argument("respectTeams", BoolArgumentType.bool()).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).executes(var0 -> CommandSpreadPlayers.spreadPlayers((CommandListenerWrapper)var0.getSource(), ArgumentVec2.getVec2((CommandContext<CommandListenerWrapper>)var0, "center"), FloatArgumentType.getFloat((CommandContext)var0, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)var0, (String)"maxRange"), ((CommandListenerWrapper)var0.getSource()).getLevel().getMaxY() + 1, BoolArgumentType.getBool((CommandContext)var0, (String)"respectTeams"), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets")))))).then(net.minecraft.commands.CommandDispatcher.literal("under").then(net.minecraft.commands.CommandDispatcher.argument("maxHeight", IntegerArgumentType.integer()).then(net.minecraft.commands.CommandDispatcher.argument("respectTeams", BoolArgumentType.bool()).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).executes(var0 -> CommandSpreadPlayers.spreadPlayers((CommandListenerWrapper)var0.getSource(), ArgumentVec2.getVec2((CommandContext<CommandListenerWrapper>)var0, "center"), FloatArgumentType.getFloat((CommandContext)var0, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)var0, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)var0, (String)"respectTeams"), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets")))))))))));
    }

    private static int spreadPlayers(CommandListenerWrapper var0, Vec2F var1, float var2, float var3, int var4, boolean var5, Collection<? extends Entity> var6) throws CommandSyntaxException {
        WorldServer var7 = var0.getLevel();
        int var8 = var7.getMinY();
        if (var4 < var8) {
            throw ERROR_INVALID_MAX_HEIGHT.create((Object)var4, (Object)var8);
        }
        RandomSource var9 = RandomSource.create();
        double var10 = var1.x - var3;
        double var12 = var1.y - var3;
        double var14 = var1.x + var3;
        double var16 = var1.y + var3;
        a[] var18 = CommandSpreadPlayers.createInitialPositions(var9, var5 ? CommandSpreadPlayers.getNumberOfTeams(var6) : var6.size(), var10, var12, var14, var16);
        CommandSpreadPlayers.spreadPositions(var1, var2, var7, var9, var10, var12, var14, var16, var4, var18, var5);
        double var19 = CommandSpreadPlayers.setPlayerPositions(var6, var7, var18, var4, var5);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.spreadplayers.success." + (var5 ? "teams" : "entities"), var18.length, Float.valueOf(var2.x), Float.valueOf(var2.y), String.format(Locale.ROOT, "%.2f", var19)), true);
        return var18.length;
    }

    private static int getNumberOfTeams(Collection<? extends Entity> var0) {
        HashSet var1 = Sets.newHashSet();
        for (Entity entity : var0) {
            if (entity instanceof EntityHuman) {
                var1.add(entity.getTeam());
                continue;
            }
            var1.add(null);
        }
        return var1.size();
    }

    private static void spreadPositions(Vec2F var0, double var1, WorldServer var3, RandomSource var4, double var5, double var7, double var9, double var11, int var13, a[] var14, boolean var15) throws CommandSyntaxException {
        int var17;
        boolean var16 = true;
        double var18 = 3.4028234663852886E38;
        for (var17 = 0; var17 < 10000 && var16; ++var17) {
            var16 = false;
            var18 = 3.4028234663852886E38;
            for (int var20 = 0; var20 < var14.length; ++var20) {
                a var21 = var14[var20];
                int var22 = 0;
                a var23 = new a();
                for (int var24 = 0; var24 < var14.length; ++var24) {
                    if (var20 == var24) continue;
                    a var25 = var14[var24];
                    double var26 = var21.dist(var25);
                    var18 = Math.min(var26, var18);
                    if (!(var26 < var1)) continue;
                    ++var22;
                    var23.x += var25.x - var21.x;
                    var23.z += var25.z - var21.z;
                }
                if (var22 > 0) {
                    var23.x /= (double)var22;
                    var23.z /= (double)var22;
                    double var24 = var23.getLength();
                    if (var24 > 0.0) {
                        var23.normalize();
                        var21.moveAway(var23);
                    } else {
                        var21.randomize(var4, var5, var7, var9, var11);
                    }
                    var16 = true;
                }
                if (!var21.clamp(var5, var7, var9, var11)) continue;
                var16 = true;
            }
            if (var16) continue;
            for (a var23 : var14) {
                if (var23.isSafe(var3, var13)) continue;
                var23.randomize(var4, var5, var7, var9, var11);
                var16 = true;
            }
        }
        if (var18 == 3.4028234663852886E38) {
            var18 = 0.0;
        }
        if (var17 >= 10000) {
            if (var15) {
                throw ERROR_FAILED_TO_SPREAD_TEAMS.create((Object)var14.length, (Object)Float.valueOf(var0.x), (Object)Float.valueOf(var0.y), (Object)String.format(Locale.ROOT, "%.2f", var18));
            }
            throw ERROR_FAILED_TO_SPREAD_ENTITIES.create((Object)var14.length, (Object)Float.valueOf(var0.x), (Object)Float.valueOf(var0.y), (Object)String.format(Locale.ROOT, "%.2f", var18));
        }
    }

    private static double setPlayerPositions(Collection<? extends Entity> var0, WorldServer var1, a[] var2, int var3, boolean var4) {
        double var5 = 0.0;
        int var7 = 0;
        HashMap var8 = Maps.newHashMap();
        for (Entity entity : var0) {
            a var11;
            if (var4) {
                ScoreboardTeam var12;
                ScoreboardTeam scoreboardTeam = var12 = entity instanceof EntityHuman ? entity.getTeam() : null;
                if (!var8.containsKey(var12)) {
                    var8.put(var12, var2[var7++]);
                }
                var11 = (a)var8.get(var12);
            } else {
                var11 = var2[var7++];
            }
            entity.teleportTo(var1, (double)MathHelper.floor(var11.x) + 0.5, var11.getSpawnY(var1, var3), (double)MathHelper.floor(var11.z) + 0.5, Set.of(), entity.getYRot(), entity.getXRot(), true);
            double var12 = Double.MAX_VALUE;
            for (a var17 : var2) {
                if (var11 == var17) continue;
                double var18 = var11.dist(var17);
                var12 = Math.min(var18, var12);
            }
            var5 += var12;
        }
        if (var0.size() < 2) {
            return 0.0;
        }
        return var5 /= (double)var0.size();
    }

    private static a[] createInitialPositions(RandomSource var0, int var1, double var2, double var4, double var6, double var8) {
        a[] var10 = new a[var1];
        for (int var11 = 0; var11 < var10.length; ++var11) {
            a var12 = new a();
            var12.randomize(var0, var2, var4, var6, var8);
            var10[var11] = var12;
        }
        return var10;
    }

    static class a {
        double x;
        double z;

        a() {
        }

        double dist(a var0) {
            double var1 = this.x - var0.x;
            double var3 = this.z - var0.z;
            return Math.sqrt(var1 * var1 + var3 * var3);
        }

        void normalize() {
            double var0 = this.getLength();
            this.x /= var0;
            this.z /= var0;
        }

        double getLength() {
            return Math.sqrt(this.x * this.x + this.z * this.z);
        }

        public void moveAway(a var0) {
            this.x -= var0.x;
            this.z -= var0.z;
        }

        public boolean clamp(double var0, double var2, double var4, double var6) {
            boolean var8 = false;
            if (this.x < var0) {
                this.x = var0;
                var8 = true;
            } else if (this.x > var4) {
                this.x = var4;
                var8 = true;
            }
            if (this.z < var2) {
                this.z = var2;
                var8 = true;
            } else if (this.z > var6) {
                this.z = var6;
                var8 = true;
            }
            return var8;
        }

        public int getSpawnY(IBlockAccess var0, int var1) {
            BlockPosition.MutableBlockPosition var2 = new BlockPosition.MutableBlockPosition(this.x, (double)(var1 + 1), this.z);
            boolean var3 = var0.getBlockState(var2).isAir();
            var2.move(EnumDirection.DOWN);
            boolean var4 = var0.getBlockState(var2).isAir();
            while (var2.getY() > var0.getMinY()) {
                var2.move(EnumDirection.DOWN);
                boolean var5 = var0.getBlockState(var2).isAir();
                if (!var5 && var4 && var3) {
                    return var2.getY() + 1;
                }
                var3 = var4;
                var4 = var5;
            }
            return var1 + 1;
        }

        public boolean isSafe(IBlockAccess var0, int var1) {
            BlockPosition var2 = BlockPosition.containing(this.x, this.getSpawnY(var0, var1) - 1, this.z);
            IBlockData var3 = var0.getBlockState(var2);
            return var2.getY() < var1 && !var3.liquid() && !var3.is(TagsBlock.FIRE);
        }

        public void randomize(RandomSource var0, double var1, double var3, double var5, double var7) {
            this.x = MathHelper.nextDouble(var0, var1, var5);
            this.z = MathHelper.nextDouble(var0, var3, var7);
        }
    }
}

