/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.HttpUtilities;
import net.minecraft.world.level.EnumGamemode;

public class CommandPublish {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.publish.failed"));
    private static final DynamicCommandExceptionType ERROR_ALREADY_PUBLISHED = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.publish.alreadyPublished", var0));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("publish").requires(net.minecraft.commands.CommandDispatcher.hasPermission(4))).executes(var0 -> CommandPublish.publish((CommandListenerWrapper)var0.getSource(), HttpUtilities.getAvailablePort(), false, null))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("allowCommands", BoolArgumentType.bool()).executes(var0 -> CommandPublish.publish((CommandListenerWrapper)var0.getSource(), HttpUtilities.getAvailablePort(), BoolArgumentType.getBool((CommandContext)var0, (String)"allowCommands"), null))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("gamemode", GameModeArgument.gameMode()).executes(var0 -> CommandPublish.publish((CommandListenerWrapper)var0.getSource(), HttpUtilities.getAvailablePort(), BoolArgumentType.getBool((CommandContext)var0, (String)"allowCommands"), GameModeArgument.getGameMode((CommandContext<CommandListenerWrapper>)var0, "gamemode")))).then(net.minecraft.commands.CommandDispatcher.argument("port", IntegerArgumentType.integer((int)0, (int)65535)).executes(var0 -> CommandPublish.publish((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"port"), BoolArgumentType.getBool((CommandContext)var0, (String)"allowCommands"), GameModeArgument.getGameMode((CommandContext<CommandListenerWrapper>)var0, "gamemode")))))));
    }

    private static int publish(CommandListenerWrapper var0, int var1, boolean var2, @Nullable EnumGamemode var3) throws CommandSyntaxException {
        if (var0.getServer().isPublished()) {
            throw ERROR_ALREADY_PUBLISHED.create((Object)var0.getServer().getPort());
        }
        if (!var0.getServer().publishServer(var3, var2, var1)) {
            throw ERROR_FAILED.create();
        }
        var0.sendSuccess(() -> CommandPublish.getSuccessMessage(var1), true);
        return var1;
    }

    public static IChatMutableComponent getSuccessMessage(int var0) {
        IChatMutableComponent var1 = ChatComponentUtils.copyOnClickText(String.valueOf(var0));
        return IChatBaseComponent.translatable("commands.publish.started", var1);
    }
}

