/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;

public class CommandGive {
    public static final int MAX_ALLOWED_ITEMSTACKS = 100;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("give").requires(net.minecraft.commands.CommandDispatcher.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("item", ArgumentItemStack.item(var1)).executes(var0 -> CommandGive.giveItem((CommandListenerWrapper)var0.getSource(), ArgumentItemStack.getItem(var0, "item"), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), 1))).then(net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)1)).executes(var0 -> CommandGive.giveItem((CommandListenerWrapper)var0.getSource(), ArgumentItemStack.getItem(var0, "item"), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count")))))));
    }

    private static int giveItem(CommandListenerWrapper var0, ArgumentPredicateItemStack var1, Collection<EntityPlayer> var2, int var3) throws CommandSyntaxException {
        ItemStack var4 = var1.createItemStack(1, false);
        int var5 = var4.getMaxStackSize();
        int var6 = var5 * 100;
        if (var3 > var6) {
            var0.sendFailure(IChatBaseComponent.translatable("commands.give.failed.toomanyitems", var6, var4.getDisplayName()));
            return 0;
        }
        for (EntityPlayer var8 : var2) {
            int var9 = var3;
            while (var9 > 0) {
                EntityItem var13;
                int var10 = Math.min(var5, var9);
                var9 -= var10;
                ItemStack var11 = var1.createItemStack(var10, false);
                boolean var12 = var8.getInventory().add(var11);
                if (!var12 || !var11.isEmpty()) {
                    var13 = var8.drop(var11, false);
                    if (var13 == null) continue;
                    var13.setNoPickUpDelay();
                    var13.setTarget(var8.getUUID());
                    continue;
                }
                var13 = var8.drop(var4, false);
                if (var13 != null) {
                    var13.makeFakeItem();
                }
                var8.level().playSound(null, var8.getX(), var8.getY(), var8.getZ(), SoundEffects.ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((var8.getRandom().nextFloat() - var8.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                var8.containerMenu.broadcastChanges();
            }
        }
        if (var2.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.give.success.single", var3, var4.getDisplayName(), ((EntityPlayer)var2.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.give.success.single", var3, var4.getDisplayName(), var2.size()), true);
        }
        return var2.size();
    }
}

