/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.chase.ChaseClient;
import net.minecraft.server.chase.ChaseServer;
import net.minecraft.world.level.World;
import org.slf4j.Logger;

public class ChaseCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DEFAULT_CONNECT_HOST = "localhost";
    private static final String DEFAULT_BIND_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_PORT = 10000;
    private static final int BROADCAST_INTERVAL_MS = 100;
    public static BiMap<String, ResourceKey<World>> DIMENSION_NAMES = ImmutableBiMap.of((Object)"o", World.OVERWORLD, (Object)"n", World.NETHER, (Object)"e", World.END);
    @Nullable
    private static ChaseServer chaseServer;
    @Nullable
    private static ChaseClient chaseClient;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("chase").then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("follow").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("host", StringArgumentType.string()).executes(var0 -> ChaseCommand.follow((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"host"), 10000))).then(net.minecraft.commands.CommandDispatcher.argument("port", IntegerArgumentType.integer((int)1, (int)65535)).executes(var0 -> ChaseCommand.follow((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"host"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"port")))))).executes(var0 -> ChaseCommand.follow((CommandListenerWrapper)var0.getSource(), DEFAULT_CONNECT_HOST, 10000)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("lead").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("bind_address", StringArgumentType.string()).executes(var0 -> ChaseCommand.lead((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"bind_address"), 10000))).then(net.minecraft.commands.CommandDispatcher.argument("port", IntegerArgumentType.integer((int)1024, (int)65535)).executes(var0 -> ChaseCommand.lead((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"bind_address"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"port")))))).executes(var0 -> ChaseCommand.lead((CommandListenerWrapper)var0.getSource(), DEFAULT_BIND_ADDRESS, 10000)))).then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> ChaseCommand.stop((CommandListenerWrapper)var0.getSource()))));
    }

    private static int stop(CommandListenerWrapper var0) {
        if (chaseClient != null) {
            chaseClient.stop();
            var0.sendSuccess(() -> IChatBaseComponent.literal("You have now stopped chasing"), false);
            chaseClient = null;
        }
        if (chaseServer != null) {
            chaseServer.stop();
            var0.sendSuccess(() -> IChatBaseComponent.literal("You are no longer being chased"), false);
            chaseServer = null;
        }
        return 0;
    }

    private static boolean alreadyRunning(CommandListenerWrapper var0) {
        if (chaseServer != null) {
            var0.sendFailure(IChatBaseComponent.literal("Chase server is already running. Stop it using /chase stop"));
            return true;
        }
        if (chaseClient != null) {
            var0.sendFailure(IChatBaseComponent.literal("You are already chasing someone. Stop it using /chase stop"));
            return true;
        }
        return false;
    }

    private static int lead(CommandListenerWrapper var0, String var1, int var2) {
        if (ChaseCommand.alreadyRunning(var0)) {
            return 0;
        }
        chaseServer = new ChaseServer(var1, var2, var0.getServer().getPlayerList(), 100);
        try {
            chaseServer.start();
            var0.sendSuccess(() -> IChatBaseComponent.literal("Chase server is now running on port " + var2 + ". Clients can follow you using /chase follow <ip> <port>"), false);
        }
        catch (IOException var3) {
            LOGGER.error("Failed to start chase server", (Throwable)var3);
            var0.sendFailure(IChatBaseComponent.literal("Failed to start chase server on port " + var2));
            chaseServer = null;
        }
        return 0;
    }

    private static int follow(CommandListenerWrapper var0, String var1, int var2) {
        if (ChaseCommand.alreadyRunning(var0)) {
            return 0;
        }
        chaseClient = new ChaseClient(var1, var2, var0.getServer());
        chaseClient.start();
        var0.sendSuccess(() -> IChatBaseComponent.literal("You are now chasing " + var1 + ":" + var2 + ". If that server does '/chase lead' then you will automatically go to the same position. Use '/chase stop' to stop chasing."), false);
        return 0;
    }
}

